/**************************************************************************
 *
 *  PORTINTF.C
 *
 *  This file contains the 16-bit function interface to the 16-bit IOPL
 *  assembler code.  It is possible that this layer is unnecessary, but
 *  it is included to simplify the coding.  These routines are not
 *  needed from a 16-bit application.
 *
 *  This file was compiled with the MicroSoft C6.00AX compiler using the
 *  following flags:
 *
 *    /MT /W3 /Alfu /Gt64 /G2s /FPi87 /c
 *_________________________________________________________________________
 *
 *  Copyright (c) 1992 by ASH Software, Inc.
 *
 **************************************************************************/

//
// Assembler prototypes
//

extern int  far pascal ioplinp (unsigned int portaddress);
extern int  far pascal ioplinpw(unsigned int portaddress);
extern void far pascal ioplout (unsigned int portaddress,
  unsigned char outputbyte);
extern void far pascal ioploutw(unsigned int portaddress,
  unsigned int outputword);

//
// About a single byte to the port
//

void far pascal PortOutByte(unsigned int uiPortAddress,unsigned char bParam)
{
ioplout(uiPortAddress,bParam);
return;
}

//
// About a 2 bytes (a word) to the port
//

void far pascal PortOutWord(unsigned int uiPortAddress,unsigned int wParam)
{
ioploutw(uiPortAddress,wParam);
return;
}

//
// Return a single byte from the port
//

unsigned int far pascal PortInpByte(unsigned int uiPortAddress)
{
return(ioplinp(uiPortAddress));
}

//
// Return two bytes (a word) from the port
//

unsigned int far pascal PortInpWord(unsigned int uiPortAddress)
{
return(ioplinpw(uiPortAddress));
}
