/**************************************************************************
 *
 *  COMMOS2.HPP
 *
 *  This file provides the headers for the IOPL and basic serial services
 *  provided by this library.
 *_________________________________________________________________________
 *
 *  Copyright (c) 1992 by ASH Software, Inc.
 *
 *  Update History
 *
 *    11/28/1992 - Module created
 *
 **************************************************************************/

#if !defined(COMMOS2__HPP)
  #define COMMOS2__HPP

  //
  // Basic definitions
  //

  #define TIMEOUT_INDEFINITE          -1L

  #define PARITY_NONE                  0
  #define PARITY_ODD                   1
  #define PARITY_EVEN                  2
  #define PARITY_MARK                  3
  #define PARITY_SPACE                 4

  #define STOPBITS_1                   0
  #define STOPBITS_1_POINT_5           1
  #define STOPBITS_2                   2

  #define TRANSMIT_BREAK               0x01
  #define TRANSMIT_NO_BREAK            0x00

  //
  // Comm Mode definitions
  //

  #define COMM_MODE_NOTSTARTED                     0ul
  #define COMM_MODE_OPEN                           1ul
  #define COMM_MODE_WRITE                          2ul
  #define COMM_MODE_READ                           3ul
  #define COMM_MODE_READTIMEOUT                    4ul
  #define COMM_MODE_READUNTILBYTE                  5ul
  #define COMM_MODE_SETBAUD                        6ul
  #define COMM_MODE_SETLINECNTRL                   7ul
  #define COMM_MODE_CLEARTXBUFFER                  8ul
  #define COMM_MODE_CLEARRXBUFFER                  9ul
  #define COMM_MODE_QUERYRXCOUNT                  10ul
  #define COMM_MODE_QUERYRXBUFSIZE                11ul
  #define COMM_MODE_QUERYTXCOUNT                  12ul
  #define COMM_MODE_QUERYTXBUFSIZE                13ul

  //
  // Comm Error Codes
  //

  #define COMM_ERROR_NOERROR                       0ul
  #define COMM_ERROR_SYSINITFAILED                 1ul
  #define COMM_ERROR_INVALIDMAXPORTS               2ul
  #define COMM_ERROR_ALREADYINITIALIZED            3ul
  #define COMM_ERROR_MAXPORTSEXCEEDED              4ul
  #define COMM_ERROR_OPENFAILED                    5ul
  #define COMM_ERROR_PORTNOTFOUND                  6ul
  #define COMM_ERROR_WRITEFAILED                   7ul
  #define COMM_ERROR_READFAILED                    8ul
  #define COMM_ERROR_IOCTLFAILED                   9ul
  #define COMM_ERROR_TIMEOUTEXCEEDED              10ul
  #define COMM_ERROR_BAUDFAILED                   11ul
  #define COMM_ERROR_LINECNTRLFAILED              12ul
  #define COMM_ERROR_CLEARBUFFERFAILED            13ul

  //
  // IOPL 16-bit interface function prototypes to be called by
  // 32-bit applications
  //

  VOID APIENTRY16 PortOutByte(USHORT usPortAddress,BYTE bParam);
  VOID APIENTRY16 PortOutWord(USHORT usPortAddress,USHORT usParam);
  APIRET16 APIENTRY16 PortInpByte(USHORT usPortAddress);
  APIRET16 APIENTRY16 PortInpWord(USHORT usPortAddress);

/*------------------------------------------------------------------------*
 *  class CommPort
 *
 *  This class provides support for serial communications under OS/2 2.x.
 *  This class assumes the presence of an appropriate device driver for
 *  the serial port(s) which will be addressed as the class uses Dos...
 *  APIs to provide the port access.
 *
 *  All methods return COMM_ERROR_NOERROR (which is defined to be 0) if
 *  successful or the CommPort class error number if a failure occurred.
 *
 *  Public Methods
 *
 *    CommPort(VOID)
 *      This constructor initializes the class.  There are no arguments.
 *
 *    ~CommPort(VOID)
 *      This destructor destroys the class.  There are no arguments.
 *
 *    ULONG Open(INT iCommPort)
 *      This method opens the port.  The argument is the port number
 *      which must be 1 <= iCommPort <= number of ports.
 *
 *    ULONG GetLastError(PULONG pulCommError,PULONG pulDosError,
 *                       PULONG pulCommMode)
 *      This method returns the last error generated inside the class.
 *      If successful, on return pulCommError will contain the class
 *      error code, pulDosError will contain the Dos error code, and
 *      pulCommMode will contain the mode which was active when the
 *      error occurred.
 *
 *    ULONG Initialize(USHORT usBaudRate = 9600,
 *                     USHORT usParity   = PARITY_NONE,
 *                     USHORT usDataBits = 8,
 *                     USHORT usStopBits = STOPBITS_1,
 *                     USHORT usTxBreak  = TRANSMIT_NO_BREAK)
 *      This method initializes a comm port.  The arguments are the
 *      baud rate, the parity, the number of data bits, the number of
 *      stop bits, and the transmit break flag.
 *
 *    ULONG ClearBuffers(VOID)
 *      This method clears both the transmit and receive buffers.  There
 *      are no arguments.
 *
 *    ULONG ClearTxBuffer(VOID)
 *      This method clears the transmit buffer.  There are no arguments.
 *
 *    ULONG ClearRxBuffer(VOID)
 *      This method clears the receive buffer.  There are no arguments.
 *
 *    ULONG Write(PUCHAR pucDataArea,ULONG ulDataAreaSize,
 *                PULONG pulWritten)
 *      This method writes the data stored in pucDataArea to the comm
 *      port.  The number of characters to be written is passed in
 *      ulDataAreaSize and the number of characters actually written
 *      are returned in pulWritten.
 *
 *    ULONG Read(PUCHAR pucDataArea,ULONG ulDataAreaSize,
 *               PULONG pulRead);
 *      This method reads data from the comm port and stores the data
 *      in the buffer pointed to by pucDataArea.  The size of the buffer
 *      is passed in ulDataAreaSize and the number of characters read
 *      is placed in the location pointed to by pulRead.  This routine
 *      does not wait for characters to arrive and returns only those
 *      characters which are available when the method is invoked.
 *
 *    ULONG ReadTimeOut(PUCHAR pucDataArea,ULONG ulDataAreaSize,
 *                      PULONG pulRead,LONG lTimeOutmSec);
 *      This method reads data from the comm port and stores the data
 *      in the buffer pointed to by pucDataArea.  The size of the buffer
 *      is passed in ulDataAreaSize and the number of characters read
 *      is placed in the location pointed to by pulRead.  This routine
 *      returns when the number of characters specified are available
 *      or the number of milliseconds specified in lTimeOutmSec has
 *      elapsed.  If a time out occurs, no characters are read from the
 *      port.
 *
 *    ULONG ReadUntilByte(PUCHAR pucDataArea,ULONG ulDataAreaSize,
 *                        PULONG pulRead,UCHAR ucWaitByte,
 *                        LONG lTimeOutmSec);
 *      This method reads data from the comm port and stores the data
 *      in the buffer pointed to by pucDataArea.  The size of the buffer
 *      is passed in ulDataAreaSize and the number of characters read
 *      is placed in the location pointed to by pulRead.  This routine
 *      returns when the number of characters specified are available,
 *      or the specified byte is received, or the number of milliseconds
 *      specified in lTimeOutmSec has elapsed.  If a time out occurs, 
 *      all characters read until that time are returned.
 *
 *    ULONG QueryRxCount(PULONG pulCount)
 *      This method returns the number of characters in the receive 
 *      buffer in pulCount.
 *
 *    ULONG QueryRxBufferSize(PULONG pulSize)
 *      This method returns the size of the receive buffer in pulSize.
 *
 *    ULONG QueryTxCount(PULONG pulCount)
 *      This method returns the number of characters in the transmit
 *      buffer in pulCount.
 *
 *    ULONG QueryTxBufferSize(PULONG pulSize)
 *      This method returns the size of the transmit buffer in pulSize.
 *
 *    ULONG Close(VOID)
 *      This method closes the comm port.  The class can then be used
 *      to open the same port or another port at a later time.  There
 *      are no arguments.
 *    
 *------------------------------------------------------------------------*/

  class CommPort
    {
    private:

      HFILE
        hCommPort;

      INT
        fPortOpen,
        fPortOpened;

      ULONG
        ulCommError,
        ulDosError,
        ulCommMode;

      ULONG QueryQueue(USHORT usMode,PULONG pulValue);

    public:

      CommPort(VOID);
      ~CommPort(VOID);
      ULONG Open(INT iCommPort);
      ULONG GetLastError(PULONG pulCommError,PULONG pulDosError,
                         PULONG pulCommMode);
      ULONG Initialize(USHORT usBaudRate = 9600,
                       USHORT usParity   = PARITY_NONE,
                       USHORT usDataBits = 8,
                       USHORT usStopBits = STOPBITS_1,
                       USHORT usTxBreak  = TRANSMIT_NO_BREAK);
      ULONG ClearBuffers(VOID);
      ULONG ClearTxBuffer(VOID);
      ULONG ClearRxBuffer(VOID);
      ULONG Write(PUCHAR pucDataArea,ULONG ulDataAreaSize,
                  PULONG pulWritten);
      ULONG Read(PUCHAR pucDataArea,ULONG ulDataAreaSize,
                 PULONG pulRead);
      ULONG ReadTimeOut(PUCHAR pucDataArea,ULONG ulDataAreaSize,
                        PULONG pulRead,LONG lTimeOutmSec);
      ULONG ReadUntilByte(PUCHAR pucDataArea,ULONG ulDataAreaSize,
                          PULONG pulRead,UCHAR ucWaitByte,
                          LONG lTimeOutmSec);
      ULONG QueryRxCount(PULONG pulCount);
      ULONG QueryRxBufferSize(PULONG pulSize);
      ULONG QueryTxCount(PULONG pulCount);
      ULONG QueryTxBufferSize(PULONG pulSize);
      ULONG Close(VOID);
    };
  typedef CommPort *pCommPort;

#endif
