/******************************************************************************\
*                                                                              *
*           Build All or Outdated Components in any Active Project             *
*            Copyright (C) 1993, The Masterpiece Software Company              *
*                                                                              *
\******************************************************************************/


cMentor:                                /* Project Directory Build . . .      */


Signal on NotReady name Abend;          /* Initiate global error handling.    */
Signal on Failure name Abend;
Signal on Syntax name Abend;

'@ATTRIB +H ' || Word(Arg(1),1) || '\project.log';   /* Hide project.log.     */

Call Prologue Arg(1);                   /* Execute initial house-keeping.     */


Call PreProcess;                        /* Execute any required pre-processor.*/

Call Translator;                        /* Compile / Assemble to .OBJ files.  */

Call LinkEditor;                        /* Link Edit, create import library.  */

Call CompLinker;                        /* Compile any .src directly to .EXE. */


'ATTRIB -H project.log';                /* Unveil the system build log . . .  */

Exit 0;                                 /* Terminate the builder process . . .*/


Abend:                                  /* Global abnormal termination . . .  */

Say  ;
Say  '====>' Date('O') Time() Condition('C') 'trap at line no.' sigl;
Say  'The process has been terminated . . .';

'ATTRIB -H project.log';                /* Unveil the system build log . . .  */

Exit RC;                                /* Terminate the current process . . .*/
/***/
Prologue:                               /* Program Initialization Functions.  */

'@ECHO OFF';

Say  '====> cMent 2.0:  Copyright (C) 1993, The Masterpiece Software Company.';

pp = Translate(Word(Arg(1),1));         /* Get/set Project folder to be built.*/
If   pp \= ''
Then Do;
     pp = Translate(Directory(pp));
     If   pp \= Translate(Word(Arg(1),1));
     Then Do;
          Say '====>' Date('O') Time() 'Invalid Project Directory:' Arg(1);
          Exit;
          End;
     End;
Else pp = Translate(Directory());


Say  '====>' Date('O') Time() 'Building' pp Word(Arg(1),2) '. . .';


'CALL cMentSet.cmd';                    /* Execute global setup commands.     */

Call SysFileTree 'PROJECT.SET','dirl';  /* Execute local PROJECT.SET commands.*/
If   dirl.0 \= 0
Then Do;
     Call LineIn,'PROJECT.SET',1,0;
     Do   While Lines('PROJECT.SET');
          Interpret LineIn('PROJECT.SET');
          End;
     End;

err = Value(TMP,,OS2ENVIRONMENT);       /* Get names of Temporary Data Files. */
rsp = err;
err = Translate(err)||'\STANDARD.ERR';
rsp = Translate(rsp)||'\RESPONSE.FIL';

src = Value(SOURCE,,OS2ENVIRONMENT);    /* Set list of source file extensions.*/
If   src \= ''
Then src = Translate(Translate(src),,'.,:;/\');
Else src = 'CCC CPP C HPP H ASM INC MAC RC';

bld = Value(TARGET,,OS2ENVIRONMENT);    /* Set list of component ext builders.*/
If   bld \= ''
Then bld = Translate(Translate(bld),,'.,:;/\');
Else bld = 'RC2RES C2OBJ CPP2OBJ ASM2OBJ CCC2EXE';

all = Word(Arg(1),2);                   /* Set build type to 'all' or 'old'.  */
all = Translate(Substr(all,1,1));

Return;
/***/
PreProcess:                             /* Build pre-processor output files.  */

Call SysFileTree '*.*','dirl','FT';     /* Load project folder file directory.*/

If   dirl.0 = 0  Then Return;           /* Exit if no source files to process.*/


Do   ii = 1 to dirl.0;                  /* Process all candidate sources . . .*/

     file = Translate(Word(dirl.ii,4)); /* Get file specification and stamp.  */
     last = Word(dirl.ii,1);

     If   LastPos('.',file) = 0         /* Get extension of the current file. */
     Then Iterate;
     Else ext = Substr(file,LastPos('.',file)+1);

     If   WordPos(ext,src) = 0          /* Bypass if extension is not listed. */
     Then Iterate;

     mkr = Pos(ext||'2',bld)            /* Get matching maker for extension.  */
     If   mkr = 0
     Then Iterate;
     Else mkr = Word(Substr(bld,mkr),1);

     If   Pos('2OBJ',mkr) = 0,          /* If not x2OBJ, x2W, x2EXE or x2DLL */
      &   Pos('2W',mkr)   = 0,
      &   Pos('2EXE',mkr) = 0,
      &   Pos('2DLL',mkr) = 0,
      &   Pos('2DRV',mkr) = 0

     Then If   all = 'A',               /* Then process to old/missing target.*/
           |   last > TargAge(),
           |   last < InclAge()
          Then 'CALL' mkr file;

End;

Return;
/***/
Translator:                             /* Compile/Assemble Source to object. */

Call SysFileTree '*.*','dirl','FT';     /* Load project folder file directory.*/

If   dirl.0 = 0  Then Return;           /* Exit if no source files to process.*/


Do   ii = 1 to dirl.0;                  /* Process all candidate sources . . .*/

     file = Translate(Word(dirl.ii,4)); /* Get file specification and stamp.  */
     last = Word(dirl.ii,1);

     If   LastPos('.',file) = 0         /* Get extension of the current file. */
     Then Iterate;
     Else ext = Substr(file,LastPos('.',file)+1);

     If   WordPos(ext,src) = 0          /* Bypass if extension is not listed. */
     Then Iterate;

     mkr = Pos(ext||'2',bld)            /* Get matching maker for extension.  */
     If   mkr = 0
     Then Iterate
     Else mkr = Word(Substr(bld,mkr),1);

     If   Pos('2OBJ',mkr) \= 0,         /* If compiling to .OBJ or .W . . .   */
      |   Pos('2W',mkr) \= 0

     Then If   all = 'A',               /* Then compile to old/missing object.*/
           |   last > TargAge(),
           |   last < InclAge()
          Then 'CALL' mkr file;

End;

Return;
/***/
LinkEditor:                             /* Link Edit, create Import Library.  */

Call SysFileTree '*.*','dirl','FT';     /* Load project folder file directory,*/
If   dirl.0 = 0  Then Return;           /* exit if no object files to process.*/


objl = '';  objt = '00/00/00/00/00';    /* Clear OBJ file list and time stamp.*/


Do   ii = 1 to dirl.0;                  /* Insert any located .W files . . .  */
     dirl.ii = Translate(dirl.ii);
     If   LastPos('.',dirl.ii) = 0,
      |   Substr(dirl.ii,LastPos('.',dirl.ii)) \= '.W'
     Then Iterate;
     Else Do;
          file = Word(dirl.ii,4);
          file = Substr(file,LastPos('\',file)+1);
          If   Word(dirl.ii,1) > objt
          Then objt = Word(dirl.ii,1);
          objl = objl || ' ' || file;
          End;
End;


Do   ii = 1 to dirl.0;                  /* Append any dissimilar .OBJ files.  */
     If   LastPos('.',dirl.ii) = 0,
      |   Substr(dirl.ii,LastPos('.',dirl.ii)) \= '.OBJ'
     Then Iterate;
     Else Do;
          file = Word(dirl.ii,4);
          file = Substr(file,LastPos('\',file)+1);
          If   Pos(Left(file,LastPos('.',file)),objl) \= 0
          Then Iterate;
          If   Word(dirl.ii,1) > objt
          Then objt = Word(dirl.ii,1);
          objl = objl || ' ' || file;
          End;
End;


If   objl = '' Then Return;             /* Exit if no .OBJects located . . .  */
/***/
targ = ''; tdef = ''; tres = '';        /* Search for target, .DEF and .RES   */
last = '00/00/00/00/00'; deft = last;


Do   ii = 1 to dirl.0;                  /* . . . within existing directory.   */

     file = Word(dirl.ii,4);            /* Get separated name and extension.  */
     If   LastPos('.',file) = 0
     Then Iterate;
     Else Do;
          file = Substr(file,LastPos('\',file)+1);
          ext = Substr(file,LastPos('.',file)+1);
          file = Left(file,LastPos('.',file));
          End;

     If   Pos(file,objl) \= 0           /* For files in the object list . . . */
     Then Do;
          If   Pos(ext,'EXE DLL DRV') \= 0
          Then Do;
               targ = file;
               ttyp = ext;
               last = Word(dirl.ii,1);
               End;
          Else If   ext = 'DEF'
               Then Do;
                    tdef = file;
                    deft = Word(dirl.ii,1);
                    End;
               Else If   ext = 'RES'
                    Then Do;
                         tres = file;
                         rest = Word(dirl.ii,1);
                         End;
          End;
End;

If   targ = '' Then Return;             /* Exit if no target identified.      */

targ = Word(Substr(objl,Pos(targ,objl)),1);
objl = targ || ' ' || DelWord(objl,WordPos(targ,objl),1);


Select;                                 /* Select command for target type.    */

When ttyp = 'EXE' Then lnk = Value(EXE,,OS2ENVIRONMENT);
When ttyp = 'DLL' Then lnk = Value(DLL,,OS2ENVIRONMENT);
When ttyp = 'DRV' Then lnk = Value(DRV,,OS2ENVIRONMENT);
End;

If   lnk  = '';
Then lnk  = 'LINK386';
Else lnk  = Translate(lnk);
lib       = '';
/***/
Do   ii = 2 to Words(lnk);              /* Extract additional .OBJ and .LIB.  */
     If   Pos('.OBJ',Word(lnk,ii)) \= 0,
      |   Pos('.W',Word(lnk,ii)) \= 0
     Then objl = objl || ' ' || Word(lnk,ii);
     Else If   Pos('.LIB',Word(lnk,ii)) \=0
          Then lib = lib || ' ' || Word(lnk,ii);
End;


If   Pos('LINK',Word(lnk,1)) \= 0       /* Complete compiler/link argument.   */
Then Do;
     objl = objl || ',,,' || lib;
     If   tdef \= '' Then objl = objl || ',' || tdef || 'DEF';
     objl = objl || ';';
     End;
Else Do;
     objl = objl || ' ' || lib;
     If   tdef \= '' Then objl = objl || ' ' || tdef || 'DEF';
     End;


If   all='A' | objt>last | deft>last    /* Link edit old/missing target file. */
Then Do;
     Say  ;
     Say  '====>' Date('O') Time() 'Linking' objl '. . .';
     Call SysFileDelete rsp;
     Call LineOut rsp, SubWord(lnk,2);
     Do   ii = 2 to Words(lnk);
          If   Substr(Word(lnk,ii),1) = '/',
           |   Substr(Word(lnk,ii),1) = '-'
          Then Call LineOut rsp, Word(lnk,ii);
     End;
     Do   ii = 1 to Words(objl);
          Call LineOut rsp, Word(objl,ii);
     End;
     Call LineOut rsp;
     Word(lnk,1) '@'||rsp '2>' err;
     'TYPE' err '2> NUL';
     last = '00/00/00/00/00';
     End;


targ = Left(targ,Pos('.',targ));        /* Determine successful target info.  */
Call SysFileTree targ||ttyp,'dirl','FT';
If   Dirl.0 = 0 Then Return;
Else tart = Word(dirl.1,1);
/***/
If   tres \= '' & rest > last           /* Add target resources, if required. */
Then Do;
     Say  ;
     Say  '====>' Date('O') Time() 'Adding' targ||'RES to' targ||ttyp '. . .';
     'RC -x'targ||'RES' targ||ttyp '2>' err;
     'TYPE' err '2> NUL';
     End;


If   ttyp = 'DLL'                       /* Build old/missing import library.  */
Then Do;

     Call SysFileTree targ||'LIB','dirl','FT';

     If   dirl.0 = 0 | tart > Word(dirl.1,1)
     Then Do;
          Say  ;
          Say  '====>' Date('O') Time() 'Building' targ||'LIB . . .';
          If   tdef = ''
          Then 'IMPLIB /NOL /NOI' targ||'LIB' targ||'DLL 2>' err;
          Else 'IMPLIB /NOL /NOI' targ||'LIB' targ||'DEF 2>' err;
          'TYPE' err '2> NUL';
          End;
     End;


Return;
/***/
CompLinker:                             /* Compile .src directly to an .EXE   */

Call SysFileTree '*.*','dirl','FT';     /* Load project folder file directory.*/

If   dirl.0 = 0  Then Return;           /* Exit if no source files to process.*/


Do   ii = 1 to dirl.0;                  /* Process all candidate sources . . .*/

     file = Translate(Word(dirl.ii,4)); /* Get file specification and stamp.  */
     last = Word(dirl.ii,1);

     If   LastPos('.',file) = 0         /* Get extension of the current file. */
     Then Iterate;
     Else ext = Substr(file,LastPos('.',file)+1);

     If   WordPos(ext,src) = 0          /* Bypass if extension is not listed. */
     Then Iterate;

     mkr = Pos(ext||'2',bld)            /* Get matching maker for extension.  */
     If   mkr = 0
     Then Iterate
     Else mkr = Word(Substr(bld,mkr),1);

     If   Pos('2EXE',mkr) \= 0          /* If compiling to .EXE file . . .    */

     Then If   all = 'A',               /* Then compile to old/missing object.*/
           |   last > TargAge(),
           |   last < InclAge(),
           |   last < LibsAge()
          Then Do;
                    Do   jj = 1 to dirl.0;
                         If   Pos('.LIB',Translate(Word(dirl.jj,4))) \= 0
                         Then file = file || ' ' || Translate(Word(dirl.jj,4));
                    End;
                    'CALL' mkr file;
               End;

End;


file = Substr(file,LastPos('.',file));  /* Delete any persisting object file. */
Call SysFileTree file||'OBJ','dirl','F';
If   dirl.0 \= 0
Then Call SysFileDelete file||'OBJ';


Return;
/***/
TargAge:                                /* Return age (time-stamp) of Target. */

trgt = Left(file,Pos('.',file));        /* Determine output target file name. */
trgt = trgt||Substr(mkr,Pos('2',mkr)+1);

Call SysFileTree trgt,'ntry','FT';      /* Search for target by complete spec.*/

If   ntry.0 = 0                         /* Set default zero stamp if missing. */
Then Return '00/00/00/00/00';
Else Return Word(ntry.1,1);





LibsAge:                                /* Return age of newest library file. */

lage = '00/00/00/00/00';                /* Default to zero (missing) age.     */
If   dirl.0 = 0
Then Return lage;

Do   jj = 1 to dirl.0;                  /* Determine age of newest .LIB file. */

     If   Pos('.LIB',Translate(Word(dirl.jj,4))) \= 0,
      &   Word(dirl.jj,1) > lage
     Then lage = Word(dirl.jj,1);

End;

Return lage;                            /* Return newest age discovered . . . */
/***/
InclAge:                                /* Return age of newest include file. */

Call SysFileSearch 'INCLUDE ',file,'line';


If   line.0 = 0                         /* Return zero stamp if no 'includes'.*/
Then Return '00/00/00/00/00';


Do   kk = 1 to line.0;                  /* Check each include file date . . . */

     ifil = Translate(line.kk);
     ifil = Word(Substr(ifil,Pos('INCLUDE',ifil)),2);
     ityp = Substr(ifil,1,1);

     If   ityp = '<' Then Iterate;      /* Ignore <system> level includes.    */

     If   ityp = '"' | ityp = "'"       /* Eliminate file string enclosure.   */
     Then
          ifil = Substr(ifil,2,Length(ifil)-2);



     Call SysFileTree ifil,'ntry','FT'; /* Search current or specific first.  */

     If   ntry.0 \= 0 & Word(ntry.1,1) > last
     Then Return Word(ntry.1,1);


     ifil=SysSearchPath('INCLUDE',ifil);/* Then search the INCLUDE file path. */

     If   ifil \= ''
     Then Do;
          Call SysFileTree ifil,'ntry','FT';
          If   Word(ntry.1,1) > last
          Then Return Word(ntry.1,1);
          End;

End;

Return    '00/00/00/00/00';             /* Return zero stamp if all older.    */
