/* CFIT.CMD -- OS/2 2.0 ONLY */

/*

   Invoke with "cfit filespec targetdrive"

   filespec can be any valid filespec, with wildcards as desired.  
     It will default to "*.*"

   targetdrive would normally be A: or B: but could, I suppose, be
     a hard drive - it will default to 'A:'

   For example, to copy all zip files from the current directory to
   the A: drive, enter
                 "cfit *.zip a:"
   cfit will fit as many zip files on a diskette as possible,
   then pause to allow you to insert a new one.


   Copies files from the current directory to a target drive, 
   presumably a diskette, and allows user to switch volumes when
   there is no more room on the target.  I always felt the native
   copy command should have enough smarts to do this, but it don't.
   Currently, CFIT just copies the files in the order returned by
   the DIR command, with no attempt at a "best fit" kinda thing.
   Maybe later.
   This is just an attempt to introduce a little convenience.  Use
   it if you cfit (sorry).

   Author: Walt Herridge
   CIS:    71045,1651
   GEnie:  W.HERRIDGE
*/

'@echo off'
parse upper arg fileSpec drive trace
if fileSpec = '' then
  fileSpec = '*.*'
if drive = '' then
  drive = 'A:' 

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

if trace = 'T' then
  trace ?i

if LENGTH(drive) > 2 then
  do
    say drive 'is not a valid drive specification.'
    exit
  end
if LENGTH(drive) > 1 then
  do
    parse var drive driveLetter ':' colon +1
    if colon \= ':' then
      do
        say drive 'is not a valid drive specification.'
        exit
      end
  end
else
  driveLetter = drive
drive = driveLetter || ':'
if \DATATYPE(driveLetter, 'U') then
do
  say drive 'is not a valid drive specification.'
  exit
end


map = SysDriveMap('A:')

if WORDPOS(drive, map) = 0 then
  do
    say drive 'is not a valid drive specification.'
    exit
  end

queueName = rxqueue('Create')	/* use our own queue */
call rxqueue 'Set', queueName

'@DIR' fileSpec '/N | RXQUEUE' queueName '/FIFO'
do 5				/* discard header lines */
  pull .
end

restart = 0

do queued() - 2
  if \restart then
    parse pull . . size eaSize name .
  restart = 0
  if size = '<DIR>' then
    iterate
  if eaSize > 0 then
    tSize = size + eaSize + 500 	/* guess at ea overhead */
  else
    tSize = size
  parse value SysDriveInfo(drive) with drive free total label
  if tSize > total then
    do
      say 'File' name 'will not fit on target medium - skipped.'
      iterate
    end
  if tSize > free then
    do
      freq = 262
      do 2
        call Beep freq,150
        freq = 294
      end
      say 'No more files will fit on' drive 'drive.'
      say 'Insert new disk and press any key when ready.'    
      parse value SysGetKey('NOECHO') with .
      restart = 1 
      iterate
    end
  say 'Copying' name 'to' drive
  '@COPY' name drive
end

call rxqueue 'Delete', queueName
exit
