/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *          Filename : LISTICO.C                                           *
 *	     Version : 1.0                                                 *
 *	     Project : Windows 3.0 Icons                                   *
 *	      Author : Philippe Rabergeau                                  *
 *	   Copyright : (C) 1990 by Philippe Rabergeau                      *
 *          Compiler : Borland Turbo C Version 2.0 			   *
 *     Creation date : 07/18/90                                            *
 * Modification date : 08/24/90                                            *
 *	 Description : List Windows 3.0 icons                              *
 *          Comments : Not for Commercial Use                              *
 *   									   *
 * Please inform the author of any development in association		   *
 * with this source code. You are authorized to use this source code       *
 * ONLY if you send me your collection of original WINDOWS 3.0 icons!      *
 *                                                                         *
 *=========================================================================*
 * WARNING: Memory model must be LARGE                                     *
 *=========================================================================*
 * This source code is not very clean, if I received a lot of support      *
 * I promise to clean up the code and add more stuff.  			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <dir.h>
#include <mem.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>

#define		ICON_MAX	2048

typedef struct {
		char name[9];
		unsigned long crc;
		} icon_struct;

icon_struct icon[ICON_MAX];
int icon_total;

int opt_video;
char opt_str[64];
int opt_fname;
int opt_sort;

int icon_nb_screen[3]={55,39,89};
int icon_nb_width[3]={8,8,10};
char icon_videomode[3]={0x12,0x10,0x54};
char icon_videowidth[3]={80,80,100};

unsigned char vga_row=1;
unsigned char vga_col=0;

char far *vga_font;

unsigned char palette_icon[17]={0x00,0x04,0x02,0x06,0x01,0x05,0x03,0x38
				,0x07,0x24,0x12,0x36,0x09,0x2D,0x1B,0x3F,0x00};

unsigned char bufico[512];

int rowico=0;

int colico=0;
int icon_nb=0;

unsigned char vgaplane[4]={0x01,0x02,0x04,0x08};

void vga_clrscr(int type)
{
unsigned int c,nb;
int byte;
  if (type==2)
  {
    nb=60000u;
    for(c=0;c<4;c++)
    {
      disable();
      outportb(*(unsigned far *)MK_FP(0xC000, 0x10), 0xB2);
      byte = (inportb(*(unsigned far *)MK_FP(0xC000, 0x10) + 1) & 0xE1) | (c << 1);
      outport(*(unsigned far *)MK_FP(0xC000, 0x10), (byte << 8) | 0xB2);
      enable();
      outportb(0x3C4,2);
      outportb(0x3C5,vgaplane[c]);
      setmem(MK_FP(0xA000,0),nb, 0xFF);
    }
  }
  else
  {
    if (type==0) nb=38400u;
    else nb=28000;
    outportb( 0x3C4, 2 );
    outportb( 0x3C5, 0x0F);
    setmem(MK_FP(0xA000,0),nb, 0xFF);
  }
}

void vga_putico(void)
{
unsigned char ScreenByte;
int i, j,m, k,c,r;
unsigned int Offset, Bit,val;
int byte;
  rowico=((icon_nb/icon_nb_width[opt_video])*64)+16;
  colico=(((icon_nb%icon_nb_width[opt_video]))*10)+5;
  for(c=0;c<4;c++)
  {
    if (opt_video==2)
    {
      disable();
      outportb(*(unsigned far *)MK_FP(0xC000, 0x10), 0xB2);
      byte = (inportb(*(unsigned far *)MK_FP(0xC000, 0x10) + 1) & 0xE1) | (c << 1);
      outport(*(unsigned far *)MK_FP(0xC000, 0x10), (byte << 8) | 0xB2);
      enable();
    }
    outportb(0x3C4,2);
    outportb(0x3C5,vgaplane[c]);
    r=rowico;
    k=511;
    for(m=0;m<32;m++)
    {
      Offset = (r*icon_videowidth[opt_video])+colico;
      for (i=0; i<4; i++)
      {
	ScreenByte=0;
	Bit = 0x01;
	for (j=0; j<4; j++)
	{
	  val = (unsigned int)(bufico[k] & 0x0F);
	  if ((val&vgaplane[c]) != 0) ScreenByte |= Bit;
	  Bit <<= 1;
	  val = (unsigned int)(bufico[k] >> 4) & 0x0F;
	  if ((val&vgaplane[c]) != 0) ScreenByte |= Bit;
	  Bit <<= 1;
	  k--;
	}
	pokeb(0xA000,Offset--,ScreenByte);
      }
      r++;
    }
  }
}

void palette_set(unsigned char *s)
{
struct SREGS sregs;
union REGS regs;
  regs.x.ax=0x1002;
  regs.x.dx=FP_OFF(s);
  sregs.es =FP_SEG(s);
  int86x(0x10,&regs,&regs,&sregs);
}

void vga_font_load(void)
{
struct REGPACK preg;
  preg.r_ax=0x1130;
  preg.r_bx=0x0300;
  intr(0x10,&preg);
  vga_font=MK_FP(preg.r_es,preg.r_bp);
}

void vga_putchar(unsigned char buff)
{
int i;
char far *base;
char far *set;
int byte,c=0x01;
  if (opt_video==2)
  {
    disable();
    outportb(*(unsigned far *)MK_FP(0xC000, 0x10), 0xB2);
    byte = (inportb(*(unsigned far *)MK_FP(0xC000, 0x10) + 1) & 0xE1) | (c << 1);
    outport(*(unsigned far *)MK_FP(0xC000, 0x10), (byte << 8) | 0xB2);
    enable();
  }
  outportb(0x03C4,0x02);
  outportb(0x03C5,0x0F);
  base=MK_FP(0xA000,(vga_row*8*icon_videowidth[opt_video])+vga_col);
  set=(char far *)(vga_font+(buff*8));
  for ( i = 0; i <8; i++ )
  {
    *base=~*set;
    base+=icon_videowidth[opt_video];
    set++;
  }
  ++vga_col;
}

void vga_putstr(char *st)
{
int i;
  vga_col=1+((icon_nb%icon_nb_width[opt_video])*10);
  vga_row=7+((icon_nb/icon_nb_width[opt_video])*8);
  for(i=0;st[i]!=0;i++) vga_putchar(st[i]);
}

void strcenter(char *s,int nb)
{
char st[100];
int i,n;
  n=(nb-strlen(s))/2;
  for (i=0;i<n;i++) st[i]=' ';
  st[i]=0;
  strcat(st,s);
  strcpy(s,st);
}

int listico(char *fname)
{
int fp;
char filename[64];
  strcpy(filename,fname);
  strcat(filename,".ICO");
  fp=open(filename,O_RDONLY|O_BINARY);
  lseek(fp,126L,SEEK_SET);
  read(fp,bufico,512);
  close(fp);
  vga_putico();
  if (opt_fname)
  {
    strcenter(fname,8);
    vga_putstr(fname);
  }
  return(1);
}

int get_screenmode(void)
{
union REGS regs;
  regs.h.al = 0;
  regs.h.ah = 15;
  int86(0x10,&regs,&regs);
  return(regs.h.al & 0x7f);
}

void set_screenmode(int mode)
{
union REGS regs;
  regs.h.al = mode;
  regs.h.ah = 0;
  int86(0x10,&regs,&regs);
}

int dir_sort_long(const void *s1,const void *s2)
{
  if (((icon_struct *)s1)->crc==((icon_struct *)s2)->crc) return(0);
  else if (((icon_struct *)s1)->crc>((icon_struct *)s2)->crc) return(1);
  else return(-1);
}

int dir_ico(void)
{
int done;
struct ffblk ffblk;
  icon_total=0;
  if ((done=findfirst(opt_str,&ffblk,FA_ARCH))<0) return(0);
  while (!done)
  {
    ffblk.ff_name[strlen(ffblk.ff_name)-4]=0;
    icon[icon_total].crc=(long)icon_total;
    strcpy(icon[icon_total++].name,ffblk.ff_name);
    done = findnext(&ffblk);
  }
  qsort((char *)icon,icon_total,sizeof(icon_struct),strcmp);
  return(1);
}

static unsigned long crc_32_tab[] = {
0x00000000L,0x77073096L,0xEE0E612CL,0x990951BAL,0x076DC419L,0x706AF48FL,0xE963A535L,0x9E6495A3L,
0x0EDB8832L,0x79DCB8A4L,0xE0D5E91EL,0x97D2D988L,0x09B64C2BL,0x7EB17CBDL,0xE7B82D07L,0x90BF1D91L,
0x1DB71064L,0x6AB020F2L,0xF3B97148L,0x84BE41DEL,0x1ADAD47DL,0x6DDDE4EBL,0xF4D4B551L,0x83D385C7L,
0x136C9856L,0x646BA8C0L,0xFD62F97AL,0x8A65C9ECL,0x14015C4FL,0x63066CD9L,0xFA0F3D63L,0x8D080DF5L,
0x3B6E20C8L,0x4C69105EL,0xD56041E4L,0xA2677172L,0x3C03E4D1L,0x4B04D447L,0xD20D85FDL,0xA50AB56BL,
0x35B5A8FAL,0x42B2986CL,0xDBBBC9D6L,0xACBCF940L,0x32D86CE3L,0x45DF5C75L,0xDCD60DCFL,0xABD13D59L,
0x26D930ACL,0x51DE003AL,0xC8D75180L,0xBFD06116L,0x21B4F4B5L,0x56B3C423L,0xCFBA9599L,0xB8BDA50FL,
0x2802B89EL,0x5F058808L,0xC60CD9B2L,0xB10BE924L,0x2F6F7C87L,0x58684C11L,0xC1611DABL,0xB6662D3DL,
0x76DC4190L,0x01DB7106L,0x98D220BCL,0xEFD5102AL,0x71B18589L,0x06B6B51FL,0x9FBFE4A5L,0xE8B8D433L,
0x7807C9A2L,0x0F00F934L,0x9609A88EL,0xE10E9818L,0x7F6A0DBBL,0x086D3D2DL,0x91646C97L,0xE6635C01L,
0x6B6B51F4L,0x1C6C6162L,0x856530D8L,0xF262004EL,0x6C0695EDL,0x1B01A57BL,0x8208F4C1L,0xF50FC457L,
0x65B0D9C6L,0x12B7E950L,0x8BBEB8EAL,0xFCB9887CL,0x62DD1DDFL,0x15DA2D49L,0x8CD37CF3L,0xFBD44C65L,
0x4DB26158L,0x3AB551CEL,0xA3BC0074L,0xD4BB30E2L,0x4ADFA541L,0x3DD895D7L,0xA4D1C46DL,0xD3D6F4FBL,
0x4369E96AL,0x346ED9FCL,0xAD678846L,0xDA60B8D0L,0x44042D73L,0x33031DE5L,0xAA0A4C5FL,0xDD0D7CC9L,
0x5005713CL,0x270241AAL,0xBE0B1010L,0xC90C2086L,0x5768B525L,0x206F85B3L,0xB966D409L,0xCE61E49FL,
0x5EDEF90EL,0x29D9C998L,0xB0D09822L,0xC7D7A8B4L,0x59B33D17L,0x2EB40D81L,0xB7BD5C3BL,0xC0BA6CADL,
0xEDB88320L,0x9ABFB3B6L,0x03B6E20CL,0x74B1D29AL,0xEAD54739L,0x9DD277AFL,0x04DB2615L,0x73DC1683L,
0xE3630B12L,0x94643B84L,0x0D6D6A3EL,0x7A6A5AA8L,0xE40ECF0BL,0x9309FF9DL,0x0A00AE27L,0x7D079EB1L,
0xF00F9344L,0x8708A3D2L,0x1E01F268L,0x6906C2FEL,0xF762575DL,0x806567CBL,0x196C3671L,0x6E6B06E7L,
0xFED41B76L,0x89D32BE0L,0x10DA7A5AL,0x67DD4ACCL,0xF9B9DF6FL,0x8EBEEFF9L,0x17B7BE43L,0x60B08ED5L,
0xD6D6A3E8L,0xA1D1937EL,0x38D8C2C4L,0x4FDFF252L,0xD1BB67F1L,0xA6BC5767L,0x3FB506DDL,0x48B2364BL,
0xD80D2BDAL,0xAF0A1B4CL,0x36034AF6L,0x41047A60L,0xDF60EFC3L,0xA867DF55L,0x316E8EEFL,0x4669BE79L,
0xCB61B38CL,0xBC66831AL,0x256FD2A0L,0x5268E236L,0xCC0C7795L,0xBB0B4703L,0x220216B9L,0x5505262FL,
0xC5BA3BBEL,0xB2BD0B28L,0x2BB45A92L,0x5CB36A04L,0xC2D7FFA7L,0xB5D0CF31L,0x2CD99E8BL,0x5BDEAE1DL,
0x9B64C2B0L,0xEC63F226L,0x756AA39CL,0x026D930AL,0x9C0906A9L,0xEB0E363FL,0x72076785L,0x05005713L,
0x95BF4A82L,0xE2B87A14L,0x7BB12BAEL,0x0CB61B38L,0x92D28E9BL,0xE5D5BE0DL,0x7CDCEFB7L,0x0BDBDF21L,
0x86D3D2D4L,0xF1D4E242L,0x68DDB3F8L,0x1FDA836EL,0x81BE16CDL,0xF6B9265BL,0x6FB077E1L,0x18B74777L,
0x88085AE6L,0xFF0F6A70L,0x66063BCAL,0x11010B5CL,0x8F659EFFL,0xF862AE69L,0x616BFFD3L,0x166CCF45L,
0xA00AE278L,0xD70DD2EEL,0x4E048354L,0x3903B3C2L,0xA7672661L,0xD06016F7L,0x4969474DL,0x3E6E77DBL,
0xAED16A4AL,0xD9D65ADCL,0x40DF0B66L,0x37D83BF0L,0xA9BCAE53L,0xDEBB9EC5L,0x47B2CF7FL,0x30B5FFE9L,
0xBDBDF21CL,0xCABAC28AL,0x53B39330L,0x24B4A3A6L,0xBAD03605L,0xCDD70693L,0x54DE5729L,0x23D967BFL,
0xB3667A2EL,0xC4614AB8L,0x5D681B02L,0x2A6F2B94L,0xB40BBE37L,0xC30C8EA1L,0x5A05DF1BL,0x2D02EF8DL
};

#define CRC32(octet, crc) (crc_32_tab[((crc) ^ (octet)) & 0xff] ^ ((crc) >> 8))

unsigned long crc32file(char *fname)
{
FILE *fp;
unsigned long crc32;
unsigned long crc;
int c;
  crc=0L;
  crc32 = 0xFFFFFFFFL;
  if ((fp=fopen(fname, "rb"))!=NULL)
  {
    while ((c=getc(fp))!=EOF)
    {
      crc32 = CRC32(c, crc32);
    }
    fclose(fp);
    crc = ~crc32;
  }
  return(crc);
}

void dir_crc(void)
{
int i;
char s[64];
  for(i=0;i<icon_total;i++)
  {
    strcpy(s,icon[i].name);
    strcat(s,".ICO");
    icon[i].crc=crc32file(s);
  }
}

void dir_ico_dpy(void)
{
int i;
  for(i=0;i<icon_total;i++)
  {
    printf("%-8s   %08lX",icon[i].name,icon[i].crc);
    if ((opt_sort==2)&&(i!=0))
    {
      if (icon[i-1].crc==icon[i].crc) printf(" <---");
    }
    printf("\n");
  }
  printf("\n%d file(s) %ld bytes\n",icon_total,(long)icon_total*766L);
}

/*--------------------------------------------------------------*/

void main(int argc,char *argv[])
{
int ch,i,lastmode=0;
  opt_sort=0;
  opt_fname=0;
  opt_str[0]=0;
  opt_video=0;
  for (i=1;i<argc;i++)
  {
    if ((argv[i][0]=='/')||(argv[i][0]=='\\')||(argv[i][0]=='-'))
    {
      if (toupper(argv[i][1])=='E') opt_video=1;
      else if (toupper(argv[i][1])=='S') opt_video=2;
      else if (toupper(argv[i][1])=='F') opt_fname=1;
      else if (toupper(argv[i][1])=='D') opt_sort=1;
      else if (toupper(argv[i][1])=='C') opt_sort=2;
      else
      {
	printf(" Usage: LISTICO [option] filename\n\n");
	printf("Option:		/E .... EGA  640x350x16\n");
	printf("		/S .... SVGA 800x600x16 (ATI Wonder only)\n");
	printf("		/F .... Filename included\n");
	printf("		/D .... Directory sort by Filename\n");
	printf("		/C .... Directory sort by CRC value\n");
	exit(0);
      }
    }
    else if (opt_str[0]==0) strcpy(opt_str,argv[i]);
  }
  if (opt_str[0]==0) strcpy(opt_str,"*");
  if (strchr(opt_str,'.')==NULL) strcat(opt_str,".ICO");
  if (dir_ico()!=0)
  {
    if (opt_sort!=0)
    {
      dir_crc();
      if (opt_sort==2) qsort((char *)icon,icon_total,sizeof(icon_struct),dir_sort_long);
      dir_ico_dpy();
    }
    else
    {
      lastmode=get_screenmode();
      set_screenmode(icon_videomode[opt_video]);
      palette_set(palette_icon);
      vga_clrscr(opt_video);
      vga_font_load();
      icon_nb=0;
      ch=0;
      for(i=0;i<icon_total;i++)
      {
	ch=0;
	listico(icon[i].name);
	icon_nb++;
	if (icon_nb>icon_nb_screen[opt_video])
	{
	  if ((ch=getch())==0x1B) break;
	  if (ch==' ')
	  {
	    i-=icon_nb_screen[opt_video];
	    i--;
	    if (opt_fname==0) opt_fname=1;
	    else opt_fname=0;
	  }
	  vga_clrscr(opt_video);
	  icon_nb=0;
	}
      }
      if (ch==0) getch();
      set_screenmode(lastmode);
    }
    printf("\nThank you for using LISTICO! - FREE program from Philippe Rabergeau - V 1.0\n");
  }
  else
  {
    printf("No WINDOWS 3.0 ICON File\n");
  }
  exit(0);
}
