ECHO ON
BAT /N
BAT * FILE NAME: CPM2ARC.BAT.  DATE: 7/10/89.
BAT * CONVERTS CP/M FILES TO DOS ARCHIVE FILES (.ARC).
BAT * WRITTEN BY BARRY KAUFMAN, PINE BROOK, NJ.  PHONE (201)-575-5880.
BAT * THIS PROGRAM IS PUBLIC DOMAIN.
BAT * SEE CPM2ARC.DOC WHICH MUST ACCOMPANY THIS PROGRAM.
BAT RAM | TRACE.OFF | STACK.ON
BAT COLOR 0E | CLS | LOCATE 1 22
BAT READ Type 'S' to start or 'H' for help ? %9
BAT IF %9 = H THEN GOTO -HELP1
BAT IF %9 = S THEN GOTO -START1
BAT -HELP1 | CLS | BEGTYPE

     This program written in Extended Batch Language (EXBAT) will
convert each library (.LBR), squeezed file (.?Q?) crunched file (.?Z?)
and plain file, to an archive (.ARC).  Squeezed and crunched files within
a library will be made plain before archiving.  Four directories
must exist on C: - \\CPMUTIL, \\ARC, \\HOLDING and \\TEMP.   The
following DOS utilities must be in \\CPMUTIL: - PKPAK.EXE, 22NICE.COM
and TOUCH.COM.  The following CP/M utilities must be in \\CPMUTIL: -
NULU.CPM, USQ.CPM and UNCR.CPM.  BAT.COM and this program (CPM2ARC.BAT)
must be on C:\\ and in the path.

     Before doing the conversion, a drive letter alias must be assigned
to each of the directories, using the DOS 3.X utility SUBST.EXE.  That
is: SUBST J: \\CPMUTIL, SUBST K: C:\\ARC, SUBST L: C:\\HOLDING, and
SUBST M: C:\\TEMP.  Also, 22NICE header files will need to be created
for the CP/M utilities.  These header files must reside in \\CPMUTIL.

     First, load above utilities into J:.  Empty K:, L: and M:.  Copy
all files to be converted to L:.  Log into C:\\ and start this program.




END
BAT TYPE Type 'C' to continue ?;
BAT -HELP2 | STACK.PURGE
BAT INKEY %9
BAT IF %9 <> C THEN GOTO -HELP2
BAT CLS | BEGTYPE

     Each library will be extracted to M:, then deleted from L:  Each
squeezed and crunched member on M: will be made plain.  The squeezed
and crunched originals will be deleted.  All files on M: will then be
archived to K: with the same archive name as the original library name.

     All member files on M: will then be deleted and the next library
on L: will be processed in the same manner as above.

     When all libraries have been converted, then all squeezed files on
L: will be made plain.  The squeezed originals will be deleted.  All
crunched files on L: will then be made plain and their crunched originals
will be deleted.  Now only plain files remain on L: consisting of those
that were never squeezed or crunched and those that were unsqueezed and
uncrunched by this program.

     Each of these plain files on L: will then be converted to an
archive on K:.  Each plain file will be deleted from L: after conversion.
The archive name will be the same as that of its predecessor plain file,
except that its file extent will be .ARC.  Copy archives from K: to the
final destination disk and then delete all archives on K:.


END
BAT TYPE Type 'C' to continue ?;
BAT -HELP3 | STACK.PURGE
BAT INKEY %9
BAT IF %9 <> C THEN GOTO -HELP3
BAT CLS | BEGTYPE

     Use 22DISK to move CP/M files from a CP/M format to the DOS format.
22DISK will change / + \\ | and other forbidden file name characters
to # which DOS will accept.  22NICE will do the same for file name
characters that appear while extracting, unsqueezing or uncrunching.

     Since CP/M files have no date/time, the process will stamp them with
current date and time.  22NICE is a TSR.  Run it before calling this
program to load it.  See CPM2ARC.DOC for more information.

     This program will make the needed directories, remove them
when you are finished converting and it will make alias drives
with the DOS utility SUBST.  Put LASTDRIVE=M in your CONFIG.SYS.






END
BAT GOTO -START2
BAT -START1 | CLS | LOCATE 1 16
BAT -START2
BAT TYPE 1 = Start converting.    
BAT TYPE 2 = Make needed directories.
BAT TYPE 3 = Remove directories.  
BAT TYPE 4 = Make alias drives with DOS SUBST.
BAT READ 5 = Exit - - ? %9
BAT CLS
BAT IF %9 = 1 THEN GOTO -CHKUTL
BAT IF %9 = 2 THEN GOTO -MDIR
BAT IF %9 = 3 THEN GOTO -RDIR
BAT IF %9 = 4 THEN GOTO -SUBS
BAT IF %9 = 5 THEN GOTO -GETOUT
BAT GOTO -START1
BAT -SUBS | * alias J:, K:, L: & M: = working subdirectories
BAT SHELL C:
BAT SHELL CD \
BAT SHELL SUBST J: C:\CPMUTIL
BAT SHELL SUBST K: C:\ARC
BAT SHELL SUBST L: C:\HOLDING
BAT SHELL SUBST M: C:\TEMP
BAT SHELL SUBST
BAT GOTO -GETOUT 
BAT -MDIR | * make needed directories
BAT SHELL C:
BAT SHELL CD \
BAT SHELL MD \CPMUTIL
BAT SHELL MD \ARC
BAT SHELL MD \HOLDING
BAT SHELL MD \TEMP
BAT GOTO -GETOUT
BAT -RDIR | * remove needed directories
BAT SHELL C:
BAT SHELL CD \
BAT SHELL RD \CPMUTIL
BAT SHELL RD \ARC
BAT SHELL RD \HOLDING
BAT SHELL RD \TEMP
BAT GOTO -GETOUT
BAT -CHKUTL | * check that utilities are on J:
BAT SHELL J:
BAT %9 = PKPAK.EXE | STATEOF %9
BAT IF %R <> 0 THEN GOTO -ERR1
BAT %9 = 22NICE.COM | STATEOF %9
BAT IF %R <> 0 THEN GOTO -ERR1
BAT %9 = TOUCH.COM | STATEOF %9
BAT IF %R <> 0 THEN GOTO -ERR1
BAT %9 = NULU.CPM | STATEOF %9
BAT IF %R <> 0 THEN GOTO -ERR1
BAT %9 = NULU.COM | STATEOF %9
BAT IF %R <> 0 THEN GOTO -ERR1
BAT %9 = USQ.CPM | STATEOF %9
BAT IF %R <> 0 THEN GOTO -ERR1
BAT %9 = USQ.COM | STATEOF %9
BAT IF %R <> 0 THEN GOTO -ERR1
BAT %9 = UNCR.CPM | STATEOF %9
BAT IF %R <> 0 THEN GOTO -ERR1
BAT %9 = UNCR.COM | STATEOF %9
BAT IF %R <> 0 THEN GOTO -ERR1
BAT -LBR1 | * delete old files in \TEMP
BAT %9 = M:*.* | STATEOF %9
BAT IF %R <> 0 THEN GOTO -LBR2
BAT TYPE Now deleting files on M:
BAT STACK.PURGE
BAT BEGSTACK
\FF\10Y
END
BAT SHELL DEL M:*.*
BAT -LBR2 | * look for a library on \HOLDING
BAT %8 = L:*.LBR | STATEOF %8
BAT IF %R <> 0 THEN GOTO -SING
BAT * extract library members to \TEMP
BAT TYPE Now extracting from %8 to M:
BAT SHELL NULU -O %8 -E M:*.* -X
BAT SHELL DEL %8
BAT * unsqueeze then delete ?Q? members
BAT %9 = M:*.?Q? | STATEOF %9
BAT IF %R <> 0 THEN GOTO -LBR3
BAT TYPE Now unsqueezing %8 members on M:
BAT SHELL USQ M:*.?Q? M:
BAT SHELL DEL M:*.?Q?
BAT -LBR3 | * uncrunch then delete ?Z? members
BAT %9 = M:*.?Z? | STATEOF %9
BAT IF %R <> 0 THEN GOTO -LBR4
BAT TYPE Now uncrunching %8 members on M:
BAT SHELL UNCR M:*.?Z? M:
BAT SHELL DEL M:*.?Z?
BAT -LBR4 | * Change .OBJ's to .CPM
BAT * %9 = M:*.OBJ | * STATEOF %9
BAT * IF %R <> 0 THEN GOTO -LBR5
BAT * TYPE Now changing OBJ files to CPM on M:
BAT * SHELL REN M:*.OBJ *.CPM
BAT -LBR5 | * Stamp all files with current date/time
BAT TYPE Now stamping files with current date/time.
BAT SHELL TOUCH M:*.*
BAT * Archive all members to \ARC
BAT %A = 2 | * look for '.' starting @ 3rd char.
BAT -LBR6
BAT %A = %A + 1
BAT %B = %8 $ %A 1 | * look for 1 char.
BAT IF %B <> . THEN GOTO -LBR6 | * if not '.' then loop
BAT %A = %A - 3
BAT %7 = %8 $ 3 %A | * 7 is NAME less L: & .LBR
BAT TYPE Now Archiving members of %8 to K:%7.ARC
BAT SHELL PKPAK -A K:%7 M:*.*
BAT GOTO -LBR1 | * look for another .LBR on \HOLDING
BAT -SING
BAT * see if there are single (stand-alone) files on \HOLDING
BAT %9 = L:*.* | STATEOF %9
BAT IF %R <> 0 THEN GOTO -NOMOR
BAT * see if squeezed files on \HOLDING
BAT %9 = L:*.?Q? | STATEOF %9
BAT IF %R <> 0 THEN GOTO -UNC1
BAT * unsqueeze, delete squeezed files
BAT TYPE Now unsqueezing stand-alone files on L:
BAT SHELL USQ L:*.?Q? L:
BAT SHELL DEL L:*.?Q?
BAT -UNC1 | * see if crunched files on \HOLDING
BAT %9 = L:*.?Z? | STATEOF %9
BAT IF %R <> 0 THEN GOTO -STAMP
BAT * uncrunch, delete crunched files
BAT TYPE Now uncrunching stand-alone files on L:
BAT SHELL UNCR L:*.?Z? L:
BAT SHELL DEL L:*.?Z?
BAT -STAMP | * Stamp files with current date/time
BAT TYPE Now stamping files with current date/time.
BAT SHELL TOUCH L:*.*
BAT -ARCR1 | * Archive each regular file over to \ARC
BAT %9 = L:*.* | STATEOF %9
BAT IF %R <> 0 THEN GOTO -NOMOR
BAT * setup .ARC file name
BAT %A = 2 | * look for '.' starting @ 3rd char.
BAT -ARCR2
BAT %A = %A + 1
BAT %B = %9 $ %A 1 | * look for 1 char.
BAT IF %B <> . THEN GOTO -ARCR2 | * if not '.' then loop
BAT %A = %A - 3
BAT %5 = %9 $ 3 %A | * 5 is NAME less L: & .EXT
BAT %6 = %9 $ 3 | * 6 is NAME.EXT less L:
BAT TYPE Now Archiving %9 to K:%5.ARC
BAT SHELL PKPAK -A K:%5 L:%6
BAT SHELL DEL %9
BAT GOTO -ARCR1 | * look for another file to .ARC
BAT -NOMOR | BEEP | BEGTYPE


     Each library has now been turned into an archive.  Each free
standing squeezed, crunched and plain file has been turned into an
archive.  All new archives should be on K:  Both L: and M: should now
be empty.  Be sure to check the new archives before erasing the original
files.

END
BAT GOTO -GETOUT
BAT -ERR1 | BEEP | BEGTYPE


     Conversion of files to archives is being terminated because
utilities on J: may be missing.



END
BAT -GETOUT | COLOR 07
BAT SHELL C:
BAT SHELL CD \

