; Ŀ
;          V E R T  1.0        
;       Copyright (c) 1992      
;       by Kurtis J. Jones      
; ٱ
;  
;
; VERT allows you to easily draw vertical highway alignments in AutoCAD.
; To use VERT, simply pick or enter the desired location of the beginning
; of the project (BOP), and enter the station and elevation for the BOP.
; Then, enter the station, elevation, and length of vertical curve for each 
; vertical point of intersection (PIVC) along the profile in increasing
; station order for the length of the project.  Simply press [Enter] after
; the final point (EOP) along the project has been entered.
;
; VERT will construct and label a complete highway centerline alignment.
; All layers used by VERT are generated by the program.  VERT uses the
; current text style; however, it must change the current text style height
; to "0" in order to perform the required text functions.  The following is
; a list of the layers that VERT creates:
;
;     Layers:                      
;     -------                      
;        PROFILE  (Blue, Continuos)   
;        TANGENT  (Red, Dashed)    
;        CLTEXT   (White, Continuous)
;        LBLTEXT  (Green, Continuous)
;
; VERT makes no attempt to recognize "impossible" alignment designs
; (ie: overlapping vertical curves).  You, the user, assume all
; responsibility and liability associated with it's use.
;
; If you have any questions or comments concerning VERT, I may be reached
; via THE SPECTRUM BBS  (501) 521-5639
;
;------------------------------------------------------------------------------
; * ERROR trapping *
;
;(defun *ERROR* ()
;   (eop)
;)
;------------------------------------------------------------------------------
; * End of program *
;
(defun EOP ()
   (setvar "CMDECHO" VERT_CE)
   (princ)
)
;------------------------------------------------------------------------------
; * Convert degrees to radians *
;
(defun DTR (A)
   (* pi (/ A 180.0))
)
;------------------------------------------------------------------------------
; * Convert radians to degrees *
;
(defun RTD (A)
   (* 180.0 (/ A pi))
)
;------------------------------------------------------------------------------
; * This routine converts angle labels "d" to "%%d" *
;
(defun DX (ANGL)
   (setq DC 2)
   (while (/= (substr ANGL DC 1) "d")
      (setq DC (1+ DC))
   )
    (setq ANGL (strcat (substr ANGL 1 (- DC 1)) "%%" (substr ANGL DC)))
)
;------------------------------------------------------------------------------
; * This routine converts the stations to "+" format *
;
(defun STAPLUS (STA)
   (setq STA1 (rtos (fix (/ STA 100)) 2 0))
   (setq LSTA1 (+ (strlen STA1) (if (=  STA1 "0") 0 1)))
   (setq STA2 (substr (rtos STA 2 2) LSTA1))
   (setq STA (strcat STA1 "+" STA2))
)
;------------------------------------------------------------------------------
; * Make required layers/styles *
;
(defun MLAYER (LTS)
   (command
      "LAYER"
         "M" "CLTEXT" "C" "WHITE" ""
         "M" "LBLTEXT" "C" "GREEN" ""
         "M" "PROFILE" "C" "BLUE" ""
         "M" "TANGENT" "C" "RED" "" "L" "DASHED" ""
      ""
   )
)
;------------------------------------------------------------------------------
; * This routine finds the insertion point for text above/below a line *
;
(defun TXTINS (P2 P3 LTS)
   (setq DIST (/ (distance P2 P3) 2))   ;The mid point between P2 & P3
   (setq ANGL (angle P2 P3))
   (setq TEMP (polar P2 ANGL DIST))
   (setq TXTP (polar TEMP (+ ANGL (dtr 90)) (* 0.18 LTS)))   ;0.18 is text ht.
)
;------------------------------------------------------------------------------
; * Get degree of curve and draw alignment/curve *
;
(defun DRWCURVE (P1 P2 P3 LTS VEXAG TLAST P2x P2y GRADE1 GRADE2)
   (setq L (getreal "\Enter length of vertical curve: "))
   (setq A1 (angle P1 P2))
   (setq A2 (angle P2 P3))
   (setq T (/ L 2.0))
   (setq T1x (- (car P2) T))
   (setq T1y (- (cadr P2) (* VEXAG (/ (* GRADE1 T) 100.0))))
   (setq T2x (+ (car P2) T))
   (setq T2y (+ (cadr P2) (* VEXAG (/ (* GRADE2 T) 100.0))))
   (setq T1 (list T1x T1y))
   (setq T2 (list T2x T2y))
;
; * Calculate "K" for the vertical curve"
;
   (setq K (/ L (abs (- GRADE2 GRADE1))))
;
; * Calculate PCVC/PTVC stations/elevations *
;
   (setq STAPC (- P2x T))
   (setq STAPT (+ P2x T))
   (setq ELEVPC (- P2y (/ (* GRADE1 T) 100.0)))
   (setq ELEVPT (+ P2y (/ (* GRADE2 T) 100.0)))
;
; * Calculate PIVC elevation (on the vertical curve) *
;
   (setq ELEVPIVC
      (+ ELEVPC
         (* (* (- P2x STAPC) (- P2x STAPC)) (/ (- GRADE2 GRADE1) (* L 200.0)))
         (* (/ GRADE1 100.0) (- P2x STAPC))
      )
   )
;
; * Draw/label alignment
;
   (txtins P2 P3 LTS)   ;Gets the INSERT point for the alignment bearings
   (command
      "LAYER" "S" "TANGENT" ""
      "LINE" P2 P3 ""
      "CIRCLE" T1 (* LTS 0.05)
      "CIRCLE" T2 (* LTS 0.05)
      "POLYGON" 3 P2 "I" (* LTS 0.075)
      "LAYER" "S" "PROFILE" ""
      "ARC" T1 "E" T2 "D" P2
      "LINE" TLAST T1 ""
      "LAYER" "S" "CLTEXT" ""
      "TEXT" "C" TXTP (* LTS 0.10) (rtd A2) (strcat SIGN (rtos GRADE2 2 2) "%")
      "LAYER" "S" "LBLTEXT" ""
      "TEXT" T1 (* LTS 0.10) 90 (strcat "     PCVC STA " (staplus STAPC))
      "TEXT" T1 (* LTS 0.10) 90 (strcat "\n     ELEV = " (rtos ELEVPC 2 2)) 
      "TEXT" P2 (* LTS 0.10) 90 (strcat "         PIVC STA " (staplus P2x))
      "TEXT" P2 (* LTS 0.10) 90 (strcat "\n         ELEV = " (rtos P2y 2 2))
      "TEXT" P2 (* LTS 0.10) 90 (strcat "\n\n         CL GRADE = " (rtos ELEVPIVC 2 2))
      "TEXT" "C" (polar P2 (dtr 270) (* 1.0 LTS)) (* LTS 0.10) 0 (strcat (rtos L 2 1) " VC")
      "TEXT" "C" (polar P2 (dtr 270) (* 1.0 LTS)) (* LTS 0.10) 0 (strcat "\nK =" (rtos K 2 1))
      "TEXT" T2 (* LTS 0.10) 90 (strcat "     PTVC STA " (staplus STAPT))
      "TEXT" T2 (* LTS 0.10) 90 (strcat "\n     ELEV = " (rtos ELEVPT 2 2))
   )
)
;------------------------------------------------------------------------------
; * Main program *
;
(defun C:VERT ()
   (setq VERT_CE (getvar "CMDECHO"))
   (setvar "CMDECHO" 0)
   (setq LTS (getvar "LTSCALE"))
   (setq STALAST nil)
   (prompt "\n ")
   (prompt "\nV E R T  v1.0 -- Copyright (c) 1992 by Kurtis J. Jones")
   (prompt "\n ")
   (if (/= VERT_RUN 1) (mlayer LTS))
   (setq VERT_RUN 1)
   (command
      "LAYER" "S" "TANGENT" ""
      "STYLE" "" "" 0 "" "" "" "" ""
   )
   (setq VSCALE (getreal "\nEnter vertical scale: "))
   (setq VEXAG (/ LTS VSCALE))
   (setq BOP (getpoint "\nEnter BOP: "))
   (setq P1 BOP)
   (setq X1 (car BOP))
   (setq Y1 (cadr BOP))
   (setq STABOP (getreal "\nEnter BOP station: "))
   (setq ELEVBOP (getreal "\nEnter BOP elevation: "))
   (setq P1x STABOP)
   (setq P1y ELEVBOP)
   (setq P2x (getreal "\nEnter next PIVC station: "))
   (setq P2y (getreal "\nEnter next PIVC elevation: "))
   (setq DELTAx (- P2x P1x))
   (setq DELTAy (- P2y P1y))
   (setq GRADE1 (* 100 (/ DELTAy DELTAx)))
   (if (> GRADE1 0) (setq SIGN "+") (setq SIGN ""))
   (setq Y1 (+ Y1 (* VEXAG DELTAy))) 
   (setq X1 (+ X1 DELTAx))
   (setq P2 (list X1 Y1))
   (txtins P1 P2 LTS)
   (command
      "LINE" P1 P2 ""
      "LAYER" "S" "CLTEXT" ""
      "TEXT" "C" TXTP (* LTS 0.10) (rtd ANGL) (strcat SIGN (rtos GRADE1 2 2) "%")
   )
   (setq BOPANGL ANGL)   ;Save angle of first tangent
   (setq TLAST BOP)
   (setq P3x P2x)   ;Make sure P3x is <> "nil" the first time through
   (while (/= P3x nil)
      (setq P3x (getreal "\nEnter next PIVC station: "))
      (setq P3y (getreal "\nEnter next PIVC elevation: "))
      (if (/= P3x nil)
         (progn
            (setq DELTAx (- P3x P2x))
            (setq DELTAy (- P3y P2y))
            (setq GRADE2 (* 100 (/ DELTAy DELTAx)))
            (if (> GRADE2 0) (setq SIGN "+") (setq SIGN ""))
            (setq Y1 (+ Y1 (* VEXAG DELTAy))) 
            (setq X1 (+ X1 DELTAx))
            (setq P3 (list X1 Y1))
            (drwcurve P1 P2 P3 LTS VEXAG TLAST P2x P2y GRADE1 GRADE2)
            (setq P2x P3x)
            (setq P2y P3y)
            (setq P1 P2)
            (setq P2 P3)
            (setq GRADE1 GRADE2)
            (setq TLAST T2)
         )
      )
   )
;
; * Draw/label last tangent section *
;
   (setq STAEOP P2x)
   (setq ELEVEOP P2y)
   (command
      "LAYER" "S" "PROFILE" ""
      "LINE" T2 P2 ""
      "LAYER" "S" "TANGENT" ""
      "CIRCLE" BOP (* LTS 0.05)
      "CIRCLE" P2 (* LTS 0.05)
      "LAYER" "S" "LBLTEXT" ""
      "TEXT" BOP (* LTS 0.10) 90 (strcat "     BOP STA " (staplus STABOP))
      "TEXT" BOP (* LTS 0.10) 90 (strcat "\n     ELEV = " (rtos ELEVBOP 2 2)) 
      "TEXT" P2 (* LTS 0.10) 90 (strcat "     EOP STA " (staplus STAEOP))
      "TEXT" P2 (* LTS 0.10) 90 (strcat "\n     ELEV = " (rtos ELEVEOP 2 2)) 
   )
   (eop)
)