
;(defun *error* () 
;   (if (/= msg "Function cancelled") 
;     (if (= msg "quit / exit abort") 
;	(princ) 
;       (princ (strcat "\nError: " msg))
;  ) 
; (princ)
;)
;)
;;;********************************************
;;;Program to Insert Components and break lines
;;;********************************************
(defun c:brline () 

(setq cmdvar (getvar "cmdecho"))
(setq osnapvar (getvar "osmode"))


   (setvar "cmdecho" 0)
    (setq b_selected (entsel "Pick point: "))
    (setq b_point (cdr b_selected))
    (setq b_entity (car b_selected))

;set entity list to examine direction

    (setq b_entity_list (entget (car b_selected)))
    (setq start (CDR (assoc 10 b_entity_list)))
    (setq end (CDR (assoc 11 b_entity_list)))

;b_angle - angle of line in radians

    (setq b_angle (angle start end))

;b_point_mod - point for block insertion

    (setq b_point_mod (osnap (car b_point) "nea"))

    ;;  ent_group - predefined entity group i.e. valve
    ;;  ent_insert - insert entity name ( appended suffix )
    ;;  ent_suffix - 1=0&180, 2=30&210, 3=90&270, 4=150&330
    ;;  ent_scale - global scale for component insertion
    ;;  types of entity groups :
    ;;  V - valve ,             distance=5
    ;;  VF - valve flanged ,    distance=7
    ;;  VES - valve ESV,        distance=7
    ;;  VC - valve flow control,        distance=7
    ;;  VG - valve check,       distance=7
    ;;  R - reducer,            distance=3
    ;;  O - oriface-meter run,  distance=2
    ;;  F - flange,             distance=1
    ;;  P - pumps,              distance=19

    (if (= ent_group nil) 
	(PROGN
	    (alert "Component type not selected") 
	    (EXIT)
	)
    )

;       assign distances for different entity groups

    (if (= ent_group "C") 
	(setq dist_nominal 16.0)
    (if (= ent_group "VE") 
	(setq dist_nominal 7)
    (if (= ent_group "V") 
	(setq dist_nominal 5)
	(if (= ent_group "VF") 
	    (setq dist_nominal 7)
	    (if (= ent_group "VES") 
		(setq dist_nominal 7)
		(if (= ent_group "VC") 
		    (setq dist_nominal 7)
		    (if (= ent_group "VG") 
			(setq dist_nominal 7)
			(if (= ent_group "R") 
			    (setq dist_nominal 3)
			    (if (= ent_group "O") 
				(setq dist_nominal 2)
				(if (= ent_group "F") 
				    (setq dist_nominal 1)
				    (if (= ent_group "P") 
					(setq dist_nominal 19)
				    )
				)
			    )
			)
		    )
		)
	    )
	)
    )
)
)
;Set real distance

    (if (= 0 (getvar "userr5")) 
	(setq dist_real dist_nominal)
	(setq dist_real (* dist_nominal (getvar "userr5")))
    )

;Converting angle to degrees with 0 decimal places

    (setq d_angle (angtos b_angle))  ;(princ d_angle)

    ;;Reset suffix to nil

    (setq ent_suffix nil)

    (if (= "0" d_angle) 
	(setq ent_suffix "1")
	(if (= "180" d_angle) 
	    (setq ent_suffix "1")
	    (if (= "30" d_angle) 
		(setq ent_suffix "2")
		(if (= "210" d_angle) 
		    (setq ent_suffix "2")
		    (if (= "90" d_angle) 
			(setq ent_suffix "3")
			(if (= "270" d_angle) 
			    (setq ent_suffix "3")
			    (if (= "150" d_angle) 
				(setq ent_suffix "4")
				(if (= "330" d_angle) 
				    (setq ent_suffix "4")
				    (progn
					(alert "Line Is not at any\nof the following angles\n0, 30, 90, 150, 180, 210, 270") 
					(exit)
				    )
				)
			    )
			)
		    )
		)
	    )
	)
    )
    ;;  check for double type blocks (same orientation two variations)
    ;;  uses dialog box with two "image_button" tiles and (ent_orient),
    ;;  (ent_orient) returns ent_tile set to "left" for left tile and "right"
    ;;  for right tile. 
    (if (= ent_group "VG") 
	(progn
	    (ent_orient) 
	    (if (= ent_tile "right") 
		(setq ent_group "VGM")
	    )
	)
    ) 
    (if (= ent_group "P") 
	(progn
	    (ent_orient) 
	    (if (= ent_tile "right") 
		(setq ent_group "PM")
	    )
	)
    )
    (if (= ent_group "EC") 
	(progn
	    (ent_orient) 
	    (if (= ent_tile "right") 
		(setq ent_group "ECM")
	    )
	)
    )
    (if (= ent_group "ECF") 
	(progn
	    (ent_orient) 
	    (if (= ent_tile "right") 
		(setq ent_group "ECFM")
	    )
	)
    )
    (if (= ent_group "A") 
	(progn
	    (ent_orient) 
	    (if (= ent_tile "right") 
		(setq ent_group "AM")
	    )
	)
    )
    (if (= ent_group "CA") 
	(progn
	    (ent_orient) 
	    (if (= ent_tile "right") 
		(setq ent_group "CAM")
	    )
	)
    )

;append suffix and check if block exist

    (setq ent_insert (strcat ent_group ent_suffix)) 

; reset ent_group to previous state if modified by ent_orient
(IF(= ent_group "VGM")
	 (setq ent_group "VG")
)
	(IF(= ent_group "PM") (setq ent_group "P"))
	(IF(= ent_group "ECM") (setq ent_group "EC"))
	(IF(= ent_group "ECFM") (setq ent_group "ECF"))
	(IF(= ent_group "CAM") (setq ent_group "CA"))
	(IF(= ent_group "AM") (setq ent_group "A"))
	
    
    (if (not (tblsearch "block" ent_insert)) 
	(if (not (findfile (strcat ent_insert ".dwg"))) 
	    (progn       (alert "Cannot find specified block") (exit))
	)
    )

;(IF (= 0.0 (GETVAR "USERR5"))
;(SETQ ent_scale 1.0)
;(setq ent_scale (getvar "userr5"))
	    
(IF(= ent_group "A") 
	(PROGN
	
	(command "insert" ent_insert b_point_mod "" "" "")
	(exit)
	)
)
(IF(= ent_group "ECF") 
	(PROGN
	
	(command "insert" ent_insert b_point_mod "" "" "")
	(exit)
	)
)
(IF(= ent_group "EC") 
	(PROGN
	
	(command "insert" ent_insert b_point_mod "" "" "")
	(exit)
	)
)

(IF(= ent_group "CA") 
	(PROGN
	
	(command "insert" ent_insert b_point_mod "" "" "")
	(exit)
	)
)
	 

(setq dist_half_p (/ dist_real 2.0))
    (setq dist_half_n (/ dist_real -2.0))
    (setq break1 (polar b_point_mod b_angle dist_half_p))
    (setq break2 (polar b_point_mod b_angle dist_half_n))
    (setvar "osmode" 0)
    (command "break" b_entity break1 break2)


    (if (= 0 (getvar "userr5")) 
		(command "insert" ent_insert b_point_mod "" "" "") 
		(progn
	    (setq ent_scale (getvar "userr5"))
	    (command "insert" ent_insert b_point_mod ent_scale "" "")
		)
    )
  (setvar "cmdecho" 1)
 
)


;;;**********************************************************************
;;;     Component direction set
;;;**********************************************************************
(defun ent_orient (/ dcl_id) 
    (setq dcl_id (load_dialog "orient.dcl"))
    (if (not (new_dialog "vg" dcl_id)) 
	(exit)
    ) 
    (setq image1 (strcat "visions" "(" ent_group ent_suffix ")"))
    (setq image2 (strcat "visions" "(" ent_group "M" ent_suffix ")"))
    (setq img_wdth (dimx_tile "left"))
    (setq img_lgth (dimy_tile "left"))
    (start_image "left") 
    (slide_image 0 0 img_wdth img_lgth image1) 
    (end_image) 
    (start_image "right") 
    (slide_image 0 0 img_wdth img_lgth image2) 
    (end_image) 
    (action_tile "left" "(progn (setq ent_tile $key)(done_dialog))") 
    (action_tile "right" "(progn (setq ent_tile $key)(done_dialog))") 
    (action_tile "cancel" "(exit)") 
    (start_dialog) 
    (unload_dialog dcl_id)
)
(defun c:co ()
(menucmd "I=visions_components")
(menucmd "I=*")
)
