; PROP.LSP
; 1/10/87
; Tony Tanzillo
;
; Do you often forget the names of layers and linetypes, or
; What elevation or thickness you were drawing at half an hour ago?
;
; PROP.LSP contains macro fuctions that can take the place of keyboard
; entered properties such as LAYER, COLOR, LINETYPE, THICKNESS,
; and ELEVATION. They can be used _WHENEVER_ AutoCAD is requesting
; input of one of those properties, Simply type in the appropriate
; function name, and select an object, the appropriate property of
; that object is supplied to AutoCAD just as if You had entered
; it manually from the keyboard, or picked it from a tablet.
;
; There is an underlying and very basic concept that is critical
; to the way that Humans interact with a computer of any kind.
; That basic concept is that it is EASIER TO POINT to something that
; has a logical association with what it is your trying to tell the
; computer.
; These fuctions borrow on this concept by taking the approach of
; TREATING THE OBJECTS ON THE DISPLAY AS IF THEY WERE A KIND OF MENU.
; They all posses the 5 basic entity properties (LAYER COLOR LINETYPE
; ELEVATION and THICKNESS) and, therefore, when AutoCAD is asking YOU
; for the NAME that you gave one of those properties, You can tell it
; where to look for something, knowing that there it will be found.
;
; Examples of useage
; ------------------
;
;  ( [<] represents a Carriage return, user input is in cap's)
;
;  Example 1
;  ---------
;  Command: COLOR <
;  New entity color <BYLAYER>: (color) <
;  Select object: <do so>
;  Command:
;
;  <The color of the selected object becomes the new current color>
;   (it get's better)
;
;  Example 2
;  ---------
;
;  Command: LINETYPE <
;  ?/Create/Load/Set: S <
;  New entity linetype (or ?) <HIDDEN>: (LINETYPE) <
;  Select object: <Do so!>
;  ?/Create/Load/Set: <
;  Command:
;
;  <the linetype of the selected object becomes the new current linetype>
;
;  Example 3
;  ---------
;
;  Command: LAYER
;  ?/Make/Set/New/ON/OFF/Color/Ltype/Freeze/Thaw: S <
;  New current layer <WOOD>: (LAYER) <
;  Select object: <do so>
;  ?/Make/Set/New/ON/OFF/Color/Ltype/Freeze/Thaw: <
;  Command:
;
;     <sets the layer of the selected object to the current layer>
;
;  Example 4
;  ---------
;
;  Command: LAYER <
;  ?/Make/Set/New/ON/OFF/Color/Ltype/Freeze/Thaw: OFF <
;  Layer name(s) to turn Off: (layers) <
;  Select objects: C <
;  First corner: Other corner: 7 found.
;  Select objects: <
;  ?/Make/Set/New/ON/OFF/Color/Ltype/Freeze/Thaw: <
;
;  <ALL layers on which the selected objects reside are turned off>
;
;  Other valid uses
;  ----------------
;
;  1. Any property response to the CHANGE command's properties option.
;
;  2. Any LAYER sub command except ON, THAW, MAKE, & NEW (not applicable)
;
;  * Note:  Use (layerS) ONLY when multiple comma-delimited
;           layer names are a valid response to the prompt, as
;           in LAYER FREEZE layr1,layr2,layr3... (actually
;           the only real uses of (layerS) is LAYER OFF or
;           LAYER FREEZE since you cannot select objects on
;           layers that are off or frozen).
;
;           Use (layer) for prompts which accept only a single
;           layer name.
;
;  3. The COLOR Command (as shown above)
;
;  4. The LINETYPE Command (as shown above)
;
;  5. The ELEV Command (elev. & thickness)
;
;   There may be other uses ..........
;
;  Notes.....
;  Objects with UNDEFINED elvation and thickness, as well as
;  color and linetype properties which are defined as "BYLAYER"
;  do not apply to any of these functions, If you select an object
;  of this type, the fuction will return a carriage return, which
;  in most cases, signals acceptance of the default value of the prompt
;  which is displyed in brackets thusly; <DEFAULT>, and nothing
;  will happen.
;
;  Most of these commands are also good as a "quick inquiry"
;  for one particular property from the Command: prompt, example:
;
;  Command: (layer)
;  Select object: <do so> "LAYERNAME" <layer of selected object is displayed>
;  Command:
;
;
;                                           Tony Tanzillo, 70307,2556
;
;  support functions


(defun pfetch(e p)                 ; general purpose property fetcher
  (cond
    ((atom p)
       (cdr
         (assoc p
           (entget (cond ((eq (type e) 'ENAME) e) ((car e))))
         )
       )
    )
    ((mapcar '(lambda(x) (pfetch e x )) p))
  )
)

(defun sslist (ss / elst i s)                ; returns a list of enames
  (setq elst '() i -1 s (sslength ss))       ; from a pickset
  (while (< (setq i (1+ i)) s)

    (setq elst (cons (ssname ss i) elst))
  )
)

(defun orr(l) (eval (cons 'cond (mapcar 'list l)))) ; Common Lisp


; Keyword option fuctions.... Can be entered at the appropriate prompt
; ---------------------------------------------------------------------

(defun layer()         ; use anytime AutoCAD asks for the name of 1 LAYER
  (pfetch (entsel) 8)
)

(defun color()                     ; use anytime AutoCAD asks for a color.
  (orr '((pfetch (entsel) 62) "BYLAYER "))
)


(defun linetype()                  ; use anytime AutoCAD asks for a linetype.
  (orr '((pfetch (entsel) 6) ""))
)

(defun elev()                      ; use anytime AutoCAD asks for an elev.
  (orr '((pfetch (entsel) 38) ""))
)

(defun thick()                     ; get the picture?
  (orr '((pfetch (entsel) 39) ""))
)

; Note the (layers) function will supply a string containing the
; names of multiple layers which are all the layer properties of
; the objects you select in response to "Select Objects:".
;
; Don't select too many objects, and try to avoid selecting more than
; one object with the same layer property. This is because the input
; string returned by (layers) cannot be more than 80 bytes.
;
; The only practicle uses for this one are LAYER OFF and LAYER FREEZE.

(defun layers(/ a b)
  (setq a (mapcar '(lambda (x) (pfetch x 8)) (sslist (ssget))))
  (strcat (car a)
    (apply 'strcat
      (mapcar '(lambda (l c) (strcat c l ))
        (cdr a)
        (mapcar '(lambda (x) ",") (cdr a))
      )
    )
  )
)

    