; ---------------------------------------------------------------------
;   PLDIST                               Kramer Consulting, Inc.
;                                        August 1986   W.Kramer
;   Polyline Distance Calculations.
;
;   User selects a polyline (or group of polylines) and the distance
;   is calculated for each polyline selected.
;   The polyline being calculated is "highlighted".
; ----------------------------------------------------------------------
(defun c:pldist ()
   (setvar "CMDECHO" 0)
   (setq ss (ssget))
   (setq sl (sslength ss))
   (setq inx -1)
   (repeat sl
      (setq penam (ssname ss (setq inx (1+ inx)))) 
      (setq elst (entget penam))
      (cond ((= (cdr (assoc 0 elst)) "POLYLINE")
              (redraw penam 3)
              (setq enam (entnext (cdr (assoc -1 elst))))
              (setq olst (entget enam))
              (setq d 0.0)(setq p1 (cdr (assoc 10 olst)))
              (setq enam (entnext (cdr (assoc -1 olst))))
              (setq elst (entget enam))
              (while (= (cdr (assoc 0 elst)) "VERTEX")
                  (cond 
                   ((zerop (cdr (assoc 42 olst))) 
                     (setq d (+ d (distance p1 (cdr (assoc 10 elst))))))
                   (t  
                     (setq theta (* (atan (abs (cdr (assoc 42 olst)))) 4.0))
                     (if (<= theta pi) 
                        (setq phi (* 0.5 theta))
                        (setq phi (* 0.5 (- (* 2.0 pi) theta))))
                     (setq rad (/ (distance p1 (cdr (assoc 10 elst)))
                                  (sin phi) 2.0)) 
                     (setq d (+ d (* theta rad)))))
                  (setq p1 (cdr (assoc 10 elst))) 
                  (setq olst elst)
                  (setq enam (entnext (cdr (assoc -1 elst))))
                  (setq elst (entget enam)))
              (prompt (strcat "\nPolyline distance:" (rtos d 2 5) "  ")) 
              (redraw penam 4)))))
