;
;   PRETTY-TYPE By Lex Luther
;   Output a function list to display or file 
;
;   Parameters:
;        FunctName     Name of function to output.
;        FileHandle       File pointer for output, nil if to screen.
;
;   For example, to see the PRETTY-TYPE macro on the screen.
;       (pretty-type pretty-type nil 0)
;
(defun pretty-type (FunctName FileHandle Tab)
  (if (atom FunctName) 
     (if FileHandle (prin1 FunctName FileHandle) (prin1 FunctName))
     (progn
       (if FileHandle 
         (progn  
           (write-char 10 FileHandle)
           (repeat (* 3 Tab) (write-char 32 FileHandle))
           (write-char 40 FileHandle))
         (progn (print) (repeat (* 3 tab) (write-char 32)) (write-char 40)))
           (foreach x FunctName
               (pretty-type x FileHandle (1+ tab)) 
               (if FileHandle (write-char 32 FileHandle) (write-char 32)))
   (if FileHandle (write-char 41 FileHandle) (write-char 41)))))
;