;**********************************************************************
;                    AUTOCAD COMMAND PCIRLCE
;  Simplifies the use of Pline to draw 'doughnuts' and filled circles.
;  User specifies circle by center and radius. Width of pline is
;  specified by a width or by an inner radius. If user presses ENTER
;  instead of entering an inner radius, a solid circle is drawn.
;        K. Funk           Version 1.0           April 23,1986.
;**********************************************************************

(setvar "CMDECHO" 0)

;FUNCTION *error* - action to take on lisp error.
(defun *error* (st)
   (princ "error: ")
   (princ st)
   (terpri)
) ; END of *error*

 defun C:PCIRCLE ()
   (setq Cen nil OutR nil InR nil Width nil)
   (While (NULL Cen) (setq Cen (getpoint "\nCenter of Circle: ")))
   (While (NULL OutR) (setq OutR (getdist Cen "\nRadius: ")))
   (setq Width (getreal "\nLine Width or Enter for Radius: "))
   (cond ((NOT (NULL Width))
            (setq InR (- OutR Width)))
         (T
            (setq InR (getdist Cen "\nInner Radius or Enter for Solid: "))
            (If (NULL InR) (setq InR 0.0))
            (setq Width (- OutR InR)))
   ) ;end cond
   (setq Start (list (+ (car Cen) (/ (+ InR OutR) 2.0)) (cadr Cen)))
   (Command "Pline" Start "W" Width "" "Arc" "CE" Cen "Angle" "180" "Close")
) ;END of PCIRCLE

