##########################################################################
#  Template make file for ADS Applications
#
#     will compile ADS applications for BORLAND and WATCOM90
#
#    -- -- -- To be used with Borland's Make Utility
#
##########################################################################
##
##
##########################################################################
#                                                                        #
#  Brought to you by:                                                    #
#                                                                        #
#     Nemesis Software, Inc.           Al Dass       [72723,1435]        #
#     233 Oakwood Lane                 Eric Sattler                      #
#     Bloomingdale, IL 60108                                             #
#                                                                        #
#     (708) 629-5943                                                     #
#                                                                        #
##########################################################################
##
##
##########################################################################
#                                                                        #
#  (C) Copyright 1993 by Nemesis Software, Inc.                          #
#  Permission to use, copy, modify, and distribute this software and its #
#  documentation for any purpose and without fee is hereby granted.      #
#  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY #
#  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF   #
#  MERCHANTABILITY ARE HEREBY DISCLAIMED.                                #
#                                                                        #
##########################################################################
##
##
# ---- This section defines what you want to be built


## Put the name of your ads app here (lower case is a MUST)

DEXE     =  geomcal

## Put all your source files here (lower case is a MUST)

DSRCS    =  cal.c       \
            calerr.c    \
            calexpr.c   \
            callex.c    \
            calmngf.c   \
            calstdf.c   \
            calusrf.c   \
            util.c

# Don't touch the 12 line below

DSRCS    =  $(DSRCS: =)
DSRCS    =  $(DSRCS: =)
DSRCS    =  $(DSRCS: =)
DSRCS    =  $(DSRCS: =)
DSRCS    =  $(DSRCS: =)
DSRCS    =  $(DSRCS:.c=.c )
DSRCS    =  $(DSRCS:.C=.c )
DOBJS    =  $(DSRCS:.c=.obj)
DEXE     =  $(DEXE:.exe=)
DEXE     =  $(DEXE:.exp=)
DEXE     =  $(DEXE:.EXE=)
DEXE     =  $(DEXE:.EXP=)

# ---- end section

# ---- This section defines the compiler options for each compiler
# ---- and its linker

# -------------------------------------------------------------------------

!if   $(COMPR) == BORLAND

CC       =  bcc
CL       =  tlink

CFLAGS   =  -I$(LIBPATH) -AT -1 -ml -f287 -N- -G -ml -DTURBOC -DPROTOTYPES=1 -DRMADS -DADS -c
LFLAGS   =  /x /d /c /Tde
LIBS     =  tbcads3 fp87 mathl cl

!if   $(DEBUG) == ON
CFLAGS   = $(CFLAGS) -v
LFLAGS   = $(LFLAGS) /v
!endif

.c.obj   :
   $(CC) $(CFLAGS) $<

$(DEXE).exe  :  $(DOBJS)

   @$(CL) @&&!
   $(LFLAGS) c0fl.obj $(DOBJS),$(DEXE),,$(LIBS)
!

   @type &&!

   .   -------------------------------------------------------------------
   .   ------- If you are going to DEBUG your app... ---------------------
   .   -------------------------------------------------------------------
   .   Don't forget to set the EXEDEBUG environment var i.e.
   .   ....set exedebug=c:\bcpp\bin\td286.exe -vg -ds -vp
   .
   .   Also don't forget to set the PharLap switches in ACAD.EXE i.e.
   .   ....cfig386 acad -maxvcpi xxxxx -saver -maxe 0 -maxx 0
   .   where xxxxx is the max amount of memory (in bytes); typically
   .   2 meg less than the total amount of RAM on systems with 16 meg
   .   or more and 1 meg for systems with less than 16 meg.
   .
   .   (optionally you may set the DOS environment var DOSX
   .   with the same params i.e.)
   .   ....set dosx=-maxvcpi xxxxx -saver -maxe 0 -maxx 0
   .   (but I don't do it this way... hint, hint)
   .   -------------------------------------------------------------------
!
# -------------------------------------------------------------------------
!endif
# -------------------------------------------------------------------------

!if $(COMPR) == WATCOM90

CC       =  wcc386p
CL       =  wlinkp

CFLAGS   =  -fpi287 -3s -s -oailt -zq
LFLAGS   =  system ads
LIBS     =  library wcads90

!if   $(DEBUG) == ON
CFLAGS   = $(CFLAGS) -d2
LFLAGS   = debug all $(LFLAGS)
#if you want to use the .sym file for debugging uncomment the next line
#LFLAGS   = debug all option symf file $(D $(DEXE)) $(LFLAGS)
!endif

LNK      = $(DEXE).LNK

.c.obj   :
   $(CC) $< $(CFLAGS)

$(DEXE).exp  :  $(DOBJS)

   @if exist $(LNK) del $(LNK)
   @echo $(LFLAGS)        >> $(LNK)
   @&echo file $**        >> $(LNK)
   @echo $(LIBS)          >> $(LNK)
   @echo name $(DEXE)     >> $(LNK)
   @echo option quiet     >> $(LNK)

   $(CL) @$(LNK)

   @if exist $(LNK) del $(LNK)   

   @echo -------------------------------------------------------------------
   @echo ------- If any errors occur look at $(DEXE).err
   @echo -------------------------------------------------------------------
   @echo. 
   @echo -------------------------------------------------------------------
   @echo ------- If you are going to DEBUG your app... ---------------------
   @echo -------------------------------------------------------------------
   @echo Don't forget to set the WVIDEO environment var i.e.
   @echo ....set wvideo=/trap*ads /swap /vga50
   @echo.(replace the '*' with a 'pound' sign. can't show it here
   @echo.because the make utility thinks is a comment)
   @echo. 
   @echo Also the set the DOSX environment var i.e.
   @echo ....set dosx=-priv
   @echo. 
   @echo Make sure that ADSHELP.EXP has been XLOADed either through the
   @echo ACAD.ADS file or manually i.e.
   @echo ....(XLOAD "C:\\WATCOM\\BIN\\ADSHELP)
   @echo. 
   @echo run WVIDEO. At the DBG prompt type ads $(DEXE).exp
   @echo. 
   @echo Note: you will not get the DBG prompt from WVIDEO if ADSHELP.EXP
   @echo is not loaded
   @echo -------------------------------------------------------------------

# -------------------------------------------------------------------------
!endif
# -------------------------------------------------------------------------

!if ! $d(CFLAGS)
dummy:

   @echo -------------------------------------------------------------------
   @echo Brought to you by:
   @echo ..
   @echo ..Nemesis Software, Inc.           Al Dass       [72723,1435]
   @echo ..233 Oakwood Lane                 Eric Sattler
   @echo ..Bloomingdale, IL 60108
   @echo ..(708) 629-5943
   @echo -------------------------------------------------------------------
   @echo -------------------------------------------------------------------
   @echo To be used with Borland Make Utility:
   @echo ..switches:
   @echo .....COMPR=BORLAND
   @echo .....COMPR=WATCOM90
   @echo .....DEBUG=ON
   @echo ..examples:
   @echo .....make COMPR=BORLAND -f ads.mak
   @echo .....make DEBUG=ON COMPR=WATCOM90 -f ads.mak
   @echo .
   @echo Note: This make file assumes you have properly setup your
   @echo ......compiler environment for finding all of its libraries.
   @echo ......This has not been tested with Microsoft's NMAKE.
   @echo -------------------------------------------------------------------

!endif

# ---- end section
