(defun C:IN ()
   (setq p1 (getdist "\nIndicate Dimension in Inches: "))
   (setq p2 (* p1 25.4))
   (setq p3 (rtos p1 2 4))
   (setq p4 (rtos p2 2 4))
   (princ p3)
   (princ " Inches = ")
   (princ p4)
   (princ " Millimeters")
   (terpri)
)
(defun C:MM ()
   (setq p1 (getdist "\nIndicate Dimension in MM: "))
   (setq p2 (/ p1 25.4))
   (setq p3 (rtos p1 2 4))
   (setq p4 (rtos p2 2 4))
   (princ p3)
   (princ " Millimeters = ")
   (princ p4)
   (princ " Inches")
   (terpri)
)
(defun C:CHGCOLOR ()
   (setvar "cmdecho" 0)
   (setq sel (ssget))
   (if (= sel nil)(setq sel (ssget)))
   (if (= sel nil)(*error*))
   (textscr)
   (prompt "\n           1 2 3 4 5 6 7 8 9     ")
   (prompt "\n         B   Y G     M W     B   ")
   (prompt "\n         Y   E R C B G H G   Y   ")
   (prompt "\n         L R L E Y L N I R T B   ")
   (prompt "\n         Y E O E A U T T A A L   ")
   (prompt "\n         R D W N N E A E Y N K   ")
   (setq clr (getstring T "\nSelect: "))
   (if (= clr " ")(command "change" sel "" "p" "c" "bylayer" ""))
   (if (= clr "   ")(command "change" sel "" "p" "c" "red" ""))
   (if (= clr "     ")(command "change" sel "" "p" "c" "yellow" ""))
   (if (= clr "       ")(command "change" sel "" "p" "c" "green" ""))
   (if (= clr "         ")(command "change" sel "" "p" "c" "cyan" ""))
   (if (= clr "           ")(command "change" sel "" "p" "c" "blue" ""))
   (if (= clr "             ")(command "change" sel "" "p" "c" "magenta" ""))
   (if (= clr "               ")(command "change" sel "" "p" "c" "white" ""))
   (if (= clr "                 ")(command "change" sel "" "p" "c" "8" ""))
   (if (= clr "                   ")(command "change" sel "" "p" "c" "9" ""))
   (if (= clr "                     ")(command "change" sel "" "p" "c" "byblock" ""))
   (graphscr)
)
(defun C:PARALINE ()
   (setvar "cmdecho" 0)
   (setq pt1 (getpoint "\nIndicate Side: "))
   (setq pt2 (getpoint "\nIndicate Line: "))
   (setq an (angle pt1 (osnap pt2 "per")))
   (setq pt3 (osnap pt2 "mid"))
   (setq pt4 (osnap pt3 "end"))
   (setq dist (distance pt4 pt3))
   (setq la (angle pt4 pt3))
   (repeat 50
      (prompt "\nCurrent Distance:  ")
      (princ len)
      (setq len (getdist "\nIndicate New Distance: "))
      (setq pt5 (polar pt4 an len))
      (setq pt6 (polar pt5 la (* dist 2.0)))
      (command "line" pt5 pt6 ""))
)
(defun C:PCIRCF ()
   (setq p1 (getpoint "\nIndicate First Point: "))
   (setq p2 (getpoint "\nIndicate Second Point, CCW From First Point: "))
   (setvar "cmdecho" 0)
   (setq p3 (getpoint "\nIndicate Circle Center: "))
   (setq p4 (getpoint "\nEnter Text Start: "))
   (setvar "blipmode" 0)
   (if (/= p4 nil) (setq p5 (polar p4 (+ pi (/ pi 2.0)) 0.250)))
   (if (/= p4 nil) (setq p6 (polar p4 (+ pi (/ pi 2.0)) 0.500)))
   (if (/= p4 nil) (setq p7 (polar p4 (+ pi (/ pi 2.0)) 0.750)))
   (if (/= p4 nil) (setq p8 (polar p4 (+ pi (/ pi 2.0)) 1.000)))
   (if (/= p4 nil) (setq p9 (polar p4 (+ pi (/ pi 2.0)) 1.250)))
   (setq acr1 (angle p3 p1))
   (setq acr2 (angle p3 p2))
   (setq rad1 (distance p3 p1))
   (setq rad2 (* rad1 2.0))
   (setq fcir (* pi rad1 2.0))
   (if (> acr2 acr1) (setq tang (- acr2 acr1)))
   (if (> acr1 acr2) (setq tang (+ (- (* pi 2.0) acr1) acr2)))
   (setq acr1x (* (/ acr1 (* pi 2.0)) 360))
   (setq acr2x (* (/ acr2 (* pi 2.0)) 360))
   (setq tangx (* (/ tang (* pi 2.0)) 360))
   (setq ans (* (/ fcir (* pi 2.0)) tang))
   (print rad2)
   (prompt "Circle Dia.")
   (print acr1x)
   (prompt "Start Angle")
   (print acr2x)
   (prompt "End Angle")
   (print tangx)
   (prompt "Included Angle")
   (print ans)
   (prompt "Length of Arc")
   (if (/= p4 nil) (command "text" p4 "0.14" "0" "LENGTH OF ARC:"))
   (if (/= p4 nil) (command "text" p5 "0.14" "0" (print ans)))
   (if (/= p4 nil) (command "text" p6 "0.14" "0" "CIRCLE DIA.:"))
   (if (/= p4 nil) (command "text" p7 "0.14" "0" (print rad2)))
   (if (/= p4 nil) (command "text" p8 "0.14" "0" "INCLUDED ANGLE:"))
   (if (/= p4 nil) (command "text" p9 "0.14" "0" (print tangx)))
   (setvar "blipmode" 1)
)
(defun C:TPDHOLE ()
   (setvar "cmdecho" 0)
   (prompt "\nCurrent Tapped Hole Dia.: ")
   (print bw)
   (setq bwx (getdist "\nIndicate New Tapped Hole Dia.: "))
   (if (= bwx nil) (setq bw bw) (setq bw bwx))
   (repeat 50
      (princ "\nTapped Hole Dia: ")
      (princ bw)
      (setq cp1 (getpoint "\nIndicate Hole Center: "))
      (setq ltp (getvar "celtype"))
      (command "linetype" "S" "continuous")
      (command "")
      (command "circle" cp1 "D" (* bw 0.75))
      (command "linetype" "S" "hidden")
      (command "")
      (command "circle" cp1 "D" bw)
      (command "change" "L")
      (command "")
      (command "P" "C" 1)
      (command "")
      (command "linetype" "S" ltp)
      (command ""))
)
(defun C:TPDHOLES ()
   (setvar "cmdecho" 0)
   (prompt "\nCurrent Tapped Hole Dia.: ")
   (print bw)
   (setq bwx (getdist "\nIndicate New Tapped Hole Dia.: "))
   (if (= bwx nil) (setq bw bw) (setq bw bwx))
   (prompt "\nCurrent Thread Depth:")
   (print thd)
   (setq thdx (getdist "\nIndicate New Thread Depth: "))
   (if (= thdx nil) (setq thd thd) (setq thd thdx))
   (prompt "\nCurrent Angle:")
   (print a2)
   (setq a1x (getangle "\nIndicate New Angle: "))
   (if (= a1x nil) (setq a1 a1) (setq a1 a1x))
   (setq a2 (* (/ a1 (* pi 2.0)) 360))
   (repeat 50
      (setq ip (getpoint "\nIndicate Insertion Point: "))
      (setq ltp (getvar "celtype"))
      (setvar "blipmode" 0)
      (command "linetype" "S" "hidden")
      (command "")
      (setq ch (* bw 0.12))
      (setq extr (* bw 0.50))
      (if (<= bw 0.520) (setq extr 0.625))
      (if (<= bw 0.450) (setq extr 0.643))
      (if (<= bw 0.390) (setq extr 0.666))
      (if (<= bw 0.340) (setq extr 0.698))
      (if (<= bw 0.270) (setq extr 0.750))
      (setq ext (* bw extr))
      (if (<= bw 0.195) (setq ext 0.125))
      (setq p1 (polar ip (+ a1 pi (/ pi 2.0)) (/ bw 2.0)))
      (setq p2 (polar ip (+ a1 pi (/ pi 2.0)) (- (/ bw 2.0) ch)))
      (setq p3 (polar ip (+ a1 (/ pi 2.0)) (/ bw 2.0)))
      (setq p4 (polar ip (+ a1 (/ pi 2.0)) (- (/ bw 2.0) ch)))
      (setq p5 (polar p1 a1 thd))
      (setq p6 (polar p3 a1 thd))
      (setq p7 (polar p2 a1 (+ thd ext)))
      (setq p8 (polar p4 a1 (+ thd ext)))
      (setq p9 (polar ip a1 (+ thd ext (* ext 0.25))))
      (command "line" p1 p5 p6 p3)
      (command "")
      (command "line" p2 p7 p9 p8 p4)
      (command "")
      (command "line" p7 p8)
      (command "")
      (command "linetype" "S" ltp)
      (command "")
      (setvar "blipmode" 1))
)
(defun C:INCANG ()
   (setvar "cmdecho" 0)
   (setq ina1 (getangle "\nIndicate First Angle: "))
   (setq ina1x (* (/ ina1 (* pi 2.0)) 360))
   (prompt "\n    First Angle is: ")
   (princ ina1x)
   (setq ina2 (getangle "\nIndicate Second Angle: "))
   (setq ina2x (* (/ ina2 (* pi 2.0)) 360))
   (prompt "\n    Second Angle is: ")
   (princ ina2x)
   (if (> ina2 ina1) (setq inans (- ina2 ina1)))
   (if (> ina1 ina2) (setq inans (+ (- (* pi 2.0) ina1) ina2)))
   (setq inanx (* (/ inans (* pi 2.0)) 360))
   (if (= ina1 ina2) (setq inanx 0.0))
   (prompt "\nIncluded Angle is: ")
   (princ inanx)
   (terpri)
)
(defun C:WEIGHT ()
   (setq mat (strcase (getstring "\nAluminum, Steel or Other? <A/S/O> ")))
   (if (= mat "O") (setq nwt (getdist "\nEnter Weight per Cubic Inch: ")))
   (prompt "\nCurrent Area: ")
   (princ in2)
   (setq in2x (getdist "\nIndicate New Area or RETURN to Accept: "))
   (if (= in2x nil) (setq in2 in2) (setq in2 in2x))
   (prompt "\nCurrent Thickness: ")
   (princ inth)
   (setq inthx (getdist "\nIndicate New Thickness or RETURN to Accept: "))
   (if (= inthx nil) (setq inth inth) (setq inth inthx))
   (setq in3 (* in2 inth))
   (if (= mat "O") (setq wt (* in3 nwt)))
   (if (= mat "A") (setq wt (* in3 0.0975)))
   (if (= mat "S") (setq wt (* in3 0.28333)))
   (prompt "\nCubic Inches:  ")
   (princ in3)
   (prompt "\nWeight:  ")
   (princ wt)
   (terpri)
)
                                        