; File : MECH.LSP       8/19/88
; Author : Steve Westbrook
;
;        These are a few routines I use with mechanical drawings. As
;        I am still in the learning stages of AutoLisp, please excuse
;        the form. For some of these to work, you will need to have a
;        layer named "cenlin" with the line type of center and a layer
;        named "hidlin" with the line type of hidden. If you have any
;        suggestions or comments, please contact me on this BBS or on
;        CompuServe [76167,3410].
;
(vmon)
;
;   Draws a drilled hole
;
(defun C:dhole ()
  (setvar "cmdecho" 0)
  (setq blipsave (getvar "blipmode"))
  (initget (+ 1 2))
  (setq cl (getpoint "\nHole starting point: "))
  (initget (+ 1 2 4))
  (setq dia (getdist cl "\nDiameter of hole: "))
  (initget (+ 1 2 4))
  (setq depth (getdist cl "\nDepth of hole: "))
  (initget 1)
  (setq ang (getangle cl "\nRotation: "))
  (setvar "blipmode" 0)
  (setq rad (/ dia 2.0)
        uang   (+ ang (/ pi 2.0))
        lang   (+ ang pi)
        dang   (+ ang (* pi 1.5))
        pango  (+ dang (/ pi 6.0))
        pangi  (- dang (/ pi 6.0))
        ptdist (/ rad 0.866025)
        a      (polar cl uang rad)
        b      (polar a ang depth)
        c      (polar b pango ptdist)
        d      (polar c pangi ptdist)
        e      (polar d lang depth)
        f      (polar cl lang 0.0625)
        g      (polar c ang 0.0625))
  (command "line" a b c d e "")
  (command "line" b d "")
  (command "line" f g "")
  (command "change" "l" "" "p" "la" "cenlin" "")
  (setvar "blipmode" blipsave)
  (setvar "cmdecho" 1)
  (prin1)
)
;
;     Draws a drilled and tapped hole
;
(defun C:thole ()
  (setvar "cmdecho" 0)
  (setq blipsave (getvar "blipmode"))
  (initget (+ 1 2))
  (setq cl (getpoint "\nTapped hole starting point: "))
  (initget (+ 1 2 4))
  (setq dia (getdist cl "\nOutside diameter of threads: "))
  (initget (+ 1 2 4))
  (setq depth (getdist cl "\nDepth of drill: "))
  (initget 1)
  (setq ang (getangle cl "\nRotation: "))
  (setvar "blipmode" 0)
  (setq rad    (/ dia 2.0)
        ddia   (* dia 0.84)
        drad   (/ ddia 2.0)
        tdepth (- depth 0.0625)
        uang   (+ ang (/ pi 2.0))
        lang   (+ ang pi)
        dang   (+ ang (* pi 1.5))
        pango  (+ dang (/ pi 6.0))
        pangi  (- dang (/ pi 6.0))
        ptdist (/ drad 0.866025)
        a      (polar cl uang drad)
        b      (polar a ang depth)
        c      (polar b pango ptdist)
        d      (polar c pangi ptdist)
        e      (polar d lang depth)
        f      (polar cl uang rad)
        g      (polar f ang tdepth)
        h      (polar g dang dia)
        i      (polar h lang tdepth)
        j      (polar cl lang 0.0625)
        k      (polar c ang 0.0625))
  (command "line" a b c d e "")
  (command "line" b d "")
  (command "pline" f g h i "")
  (command "change" "l" "" "p" "la" "hidlin" "")
  (command "explode" "l")
  (command "line" j k "")
  (command "change" "l" "" "p" "la" "cenlin" "")
  (setvar "blipmode" blipsave)
  (setvar "cmdecho" 1)
)
;
;     Draws the front view of tapped hole
;
(defun C:vthole ()
  (setvar "cmdecho" 0)
  (setq blipsave (getvar "blipmode"))
  (initget (+ 1 2))
  (setq cl (getpoint "\nCenter of tapped hole: "))
  (initget (+ 1 2 4))
  (setq dia (getdist cl "\nDiameter of tap: "))
  (setvar "blipmode" 0)
  (setq rad  (/ dia 2.0)
        drad (/ (* dia 0.84) 2.0))
  (command "circle" cl drad)
  (command "circle" cl rad)
  (command "change" "l" "" "p" "la" "hidlin" "")
  (setvar "blipmode" blipsave)
  (setvar "cmdecho" 1)
  (prin1)
)
;
;     Draw any size dowel pin
;
(defun C:dowel ()
  (setvar "cmdecho" 0)
  (setq blipsave (getvar "blipmode"))
  (initget (+ 1 2))
  (setq cl (getpoint "\nStarting point of dowel pin: "))
  (initget (+ 1 2 4))
  (setq dia (getdist cl "\nDiameter of dowel pin: "))
  (initget (+ 1 2 4))
  (setq length (getdist cl "\nLength of dowel pin: "))
  (initget 1)
  (setq ang (getangle cl "\nRotation: "))
  (setvar "blipmode" 0)
  (setq rad (/ dia 2.0)
        cdist 0.015)
  (if (>= dia 0.3125) (setq cdist 0.03))
  (setq dist  (- length (* cdist 2.0))
        bdist (/ cdist 0.906308)
        ddist (- rad (* cdist 0.466308))
        uang  (+ ang (/ pi 2.0))
        dang  (+ ang (* pi 1.5))
        lang  (+ ang pi)
        canga (- ang (/ pi 7.2))
        cangb (+ lang (/ pi 7.2))
        cangc (- lang (/ pi 7.2))
        cangd (+ ang (/ pi 7.2))
        a     (polar cl uang ddist)
        b     (polar a cangd bdist)
        c     (polar b ang dist)
        d     (polar c canga bdist)
        e     (polar d dang (* ddist 2.0))
        f     (polar e cangb bdist)
        g     (polar f lang dist)
        h     (polar g cangc bdist))
  (command "line" a b c d e f g h a "")
  (command "line" b g "")
  (command "line" c f "")
  (setvar "blipmode" blipsave)
  (setvar "cmdecho" 1)
  (prin1)
)
;
;     Draw drilled hole with counterbore
;
(defun C:dholecb ()
  (setvar "cmdecho" 0)
  (setq blipsave (getvar "blipmode"))
  (initget (+ 1 2))
  (setq cl (getpoint "\nCounterbore starting point: "))
  (initget (+ 1 2 4))
  (setq cbdia (getdist cl "\nDiameter of counterbore: "))
  (initget (+ 1 2 4))
  (setq cbdepth (getdist cl "\nDepth of counterbore: "))
  (initget (+ 1 2 4))
  (setq dia (getdist  "\nDiameter of drill: "))
  (initget (+ 1 2 4))
  (setq depth (getdist cl "\nDepth of drill: "))
  (initget 1)
  (setq ang (getangle cl "\nRotation: "))
  (setvar "blipmode" 0)
  (setq rad    (/ dia 2.0)
        cbrad  (/ cbdia 2.0)
        depth  (- depth cbdepth)
        uang   (+ ang (/ pi 2.0))
        lang   (+ ang pi)
        dang   (+ ang (* pi 1.5))
        pango  (+ dang (/ pi 6.0))
        pangi  (- dang (/ pi 6.0))
        ptdist (/ rad 0.866025)
        j      (polar cl ang cbdepth)
        a      (polar j uang rad)
        b      (polar a ang depth)
        c      (polar b pango ptdist)
        d      (polar c pangi ptdist)
        e      (polar d lang depth)
        f      (polar cl uang cbrad)
        g      (polar f ang cbdepth)
        h      (polar g dang cbdia)
        i      (polar h lang cbdepth)
        k      (polar c ang 0.0625)
        l      (polar cl lang 0.0625))
  (command "line" f g a b c d e h i "")
  (command "line" a e "")
  (command "line" b d "")
  (command "line" l k "")
  (command "change" "l" "" "p" "la" "cenlin" "")
  (setvar "blipmode" blipsave)
  (setvar "cmdecho" 1)
  (prin1)
)
;
;     Draw drilled hole with counterdrill
;
(defun C:dholecd ()
  (setvar "cmdecho" 0)
  (setq blipsave (getvar "blipmode"))
  (initget (+ 1 2))
  (setq cl (getpoint "\nDrill starting point: "))
  (initget (+ 1 2 4))
  (setq cddia (getdist cl "\nDiameter of counterdrill: "))
  (initget (+ 1 2 4))
  (setq cddepth (getdist cl "\nDepth of counterdrill: "))
  (initget (+ 1 2 4))
  (setq dia (getdist  cl "\nDiameter of drill: "))
  (initget (+ 1 2 4))
  (setq depth (getdist cl "\nDepth of drill: "))
  (initget 1)
  (setq ang (getangle cl "\nRotation: "))
  (setvar "blipmode" 0)
  (setq rad    (/ dia 2.0)
        cdrad  (/ cddia 2.0)
        depth  (- depth cddepth)
        uang   (+ ang (/ pi 2.0))
        lang   (+ ang pi)
        dang   (+ ang (* pi 1.5))
        pango  (+ dang (/ pi 6.0))
        pangi  (- dang (/ pi 6.0))
        ptdist (/ rad 0.866025)
        cddist (/ (- cdrad rad) 0.866025)
        ddepth (- depth (/ cddist 2.0))
        a      (polar cl uang cdrad)
        b      (polar a ang cddepth)
        c      (polar b pango cddist)
        d      (polar c ang ddepth)
        e      (polar d pango ptdist)
        f      (polar e pangi ptdist)
        g      (polar f lang ddepth)
        h      (polar g pangi cddist)
        i      (polar h lang cddepth)
        j      (polar e ang 0.0625)
        k      (polar cl lang 0.0625))
  (command "line"  a b c d e f g h i "")
  (command "line" b h "")
  (command "line" c g "")
  (command "line" d f "")
  (command "line" j k "")
  (command "change" "l" "" "p" "la" "cenlin" "")
  (setvar "blipmode" blipsave)
  (setvar "cmdecho" 1)
  (prin1)
)
;
;     Draw finish mark with surface roughness
;
(defun C:fmark ()
  (setvar "cmdecho" 0)
  (setq blipsave (getvar "blipmode"))
  (initget (+ 1 2))
  (setq cl (getpoint "\nInsertion point: "))
  (initget 1)
  (setq ang (getangle cl "\nRotation: "))
  (setq temp (getstring T "\nMaximum surface roughness: "))
  (setvar "blipmode" 0)
  (setq uang   (+ ang (/ pi 2.0))
        rang   (+ ang (/ pi 3.0))
        lang   (+ rang (/ pi 3.0))
        a      (polar cl lang 0.0808)
        b      (polar cl rang 0.2425)
        c      (polar a uang 0.035)
        angdeg (* ang 57.29578))
  (command "line" a cl b "")
  (command "text" "c" c "0.07" angdeg temp)
  (setvar "blipmode" blipsave)
  (setvar "cmdecho" 1)
  (prin1)
)
;
;     Draw Section Arrows in any rotation
;
(defun C:secarr ()
  (setvar "cmdecho" 0)
  (setq blipsave (getvar "blipmode"))
  (initget (+ 1 2))
  (setq cl (getpoint "\nInsertion point: "))
  (initget 1)
  (setq ang (getangle cl "\nDirection of leader: "))
  (initget 1)
  (setq a (polar cl ang 0.25))
  (setq sang (getangle a "\nDirection of arrowhead: "))
  (setvar "blipmode" 0)
  (setq b (polar a sang 0.125))
  (setq c (polar b sang 0.21875))
  (command "trace" "0.03" cl a b "")
  (command "insert" "arrow" c "2" "2.5" a)
  (setvar "blipmode" blipsave)
  (setvar "cmdecho" 1)
  (prin1)
)
;
;     Import ascii files into AutoCad
;
(defun C:txtin (/ AF)
;
(defun dotxt ()
  (setq styl (getstring "\nStyle name <STANDARD>: "))
  (if (= styl "") (setq styl "STANDARD"))
  (setq s (strcase(getstring "Locate text at <L>eft/Center/Middle/Right: ")))
  (if (= s "") (setq s "L"))
  (cond
    ((= s "L") (setq spoint (getpoint "\nStarting point: ")))
    ((= s "C") (setq spoint (getpoint "\nCenter point: ")))
    ((= s "M") (setq spoint (getpoint "\nMiddle point: ")))
    ((= s "R") (setq spoint (getpoint "\nEnd point: ")))
  )
  (setq ht (getdist spoint
    (strcat "\n Height <"
    (rtos (getvar "TEXTSIZE") (getvar "LUNITS") (getvar "LUPREC")) ">: ")))
  (if (= ht nil) (setq ht (getvar "TEXTSIZE")))
  (setq rot (getangle spoint "\nRotation angle <0>: "))
  (if (= rot nil) (setq rot 0.0))
  (setvar "cmdecho" 0)
  (setq blipsave (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq txt (read-line AF))
  (if (= s "L") (command "TEXT" "S" styl spoint ht rot txt)
                (command "TEXT" "S" styl s spoint ht rot txt))
  (while (/= txt nil)
    (setq txt (read-line AF))
    (setq spoint (polar spoint (+ rot (* 1.5 pi)) (* (/ 5.0 3.0) ht)))
    (if (= s "L") (command "TEXT" spoint ht rot txt)
                  (command "TEXT" s spoint ht rot txt))
  )
  (close AF)
  (setvar "blipmode" blipsave)
  (setvar "cmdecho" 1)
)
;
;
;
  (setq AF (open (getstring "\nName of Ascii file to insert: ") "r"))
  (if (/= AF nil) (dotxt) (prompt "File not found!"))
  (prin1)
)
;
;     Edit exsisting Text entities
;
(defun C:chgtxt ()
;
;
(defun swap (key tval /)
  (setq tv2 (assoc key te)
        tv4 (cons key tv1)
        te (subst tv4 tv2 te))
)
;
;
  (setq tset (ssget))
  (setq len (sslength tset))
  (setq c 0)
  (setvar "cmdecho" 0)
  (if (> len 0)
    (progn
      (setq cmd (strcase
        (getstring "Change Height/X-scale/Style/<V>alue: ")))
      (cond
        ((OR (= cmd "V") (= cmd ""))
          (setq tv1 (getstring T "Enter new text string: "))
          (setq key 1))
        ((= cmd "H")
          (setq tv1 (getreal "Enter new text height: "))
          (setq key 40))
        ((= cmd "X")
          (setq tv1 (getreal "Enter new X-scale factor: "))
          (setq key 41))
        ((= cmd "S")
          (setq tv1 (getstring "Enter new text style: "))
          (setq key 7))
        (T (setq key 0))
      )
      (if (> key 0)
        (progn
          (while (< c len)
            (setq ename (ssname tset c))
            (setq te (entget ename))
            (if (= (cdr (assoc 0 te)) "TEXT") (swap key tv1))
            (entmod te)
            (setq c (1+ c))
          )    ;while
        )      ; progn
      )        ; if
    )          ; progn
  )            ; if
  (setvar "cmdecho" 1)
  (prin1)
)
;
