;; **********************************************************************
;;                             DIM LEADER
;;
;; This program draws a leader at 60,120,240,320 degree angles so that 
;; you don't have to try to eyeball them. This program was writtem on R11
;; so it should work for everybody.  Explanations have been provided within
;; the code for easy manipulation.
;;
;;    Comments/Suggestions to:
;;
;;    Author:  Dwayne Smith
;;    Date:    Jan. 6, 1995
;;    Compsrv: 74230,1106
;; **********************************************************************
;;

(DeFun Terminate (S)
   (if (/= s "Function Cancelled")
       (princ (strcat "\nError: " s))
   )
   (if omd (setvar "osmode" omd))
   (if cmd (setvar "cmdecho" cmd))
   (SetQ *Error* olderr omd nil cmd nil)
   (Princ)
)

(defun c:ld ( / st lay pt1 pt2 pt3 pt4 e1 e2 x1 y1 x2 y2 x3 y3 x4 y4 b c a 
                x2b flag sz otmd)    ;;draws leader on a certain angle
   (setq olderr *error* *error* terminate otmd (getvar "orthomode")
         omd (getvar "osmode") cmd (getvar "cmdecho"))
   (setvar "orthomode" 0)
   (setvar "osmode" 0)
   (setvar "cmdecho" 0)
   (command "undo" "m")
   (princ "\n<LD> - Dim Leader . . .")
   (setq pt1 (getpoint "\nPoint 1:") pt (osnap pt1 "nea"))
   (if (/= pt nil) (setq pt1 pt))
   (setq pt2 (getpoint pt1 "\nPoint 2:")  
         x1 (car pt1) y1 (car (cdr pt1))  ;;get x & y values for pt1 & pt2
         x2 (car pt2) y2 (car (cdr pt2)))
   (if (> x2 x1) (progn               ;;check for sector
    (if (> y2 y1) (progn              ;;find the y-value dependent on sector
       (setq b (- y2 y1) c (/ b (sin 1.04179755))
             a (sqrt (- (expt c 2) (expt b 2))) x2b (+ x1 a)
             pt2 (list x2b y2 0) flag 1))
       (progn
       (setq b (- y2 y1) c (/ b (sin 5.235987756))
             a (sqrt (- (expt c 2) (expt b 2)))
             x2b (+ x1 a) pt2 (list x2b y2 0) flag 1)))))
   (if (< x2 x1) (progn
    (if (> y2 y1) (progn
       (setq b (- y2 y1) c (/ b (sin 2.094395102))
             a (sqrt (- (expt c 2) (expt b 2))) x2b (- x1 a)
             pt2 (list x2b y2 0) flag 0))
       (progn
       (setq b (- y2 y1) c (/ b (sin 4.188790205))
             a (sqrt (- (expt c 2) (expt b 2))) x2b (- x1 a)
             pt2 (list x2b y2 0) flag 0)))))
   (princ "\nPress <Enter> to use only two points.")
   (command "dim" "leader" pt1 pt2 ^c ^c)
   (setvar "orthomode" 1)
   (setq pt3 (getpoint pt2 "\nPoint 3:"))
   (if (/= pt3 nil) (progn
     (command "line" pt2 pt3 "")           ;;draw line to pt3
     (setq x3 (car pt3) y3 (car (cdr pt3)) ;;get pt3 X & Y values
           lay (getvar "clayer")
           st (getvar "textstyle"))
     (princ "\nCurrent Text Style is Now - \"") (princ st) (princ "\" ")
     (princ "On Layer: ") (princ lay)))
   (setvar "orthomode" otmd)
   (if (= flag 1) (progn        ;;select placement/insertion point of text
     (setq sz (/ (getvar "textsize") 2) x4 (+ x3 sz) y4 (- y3 sz)
           pt4 (list x4 y4 0))
     (command "dtext" pt4))     ;;write left justified text
   (progn
     (setq sz (/ (getvar "textsize") 2) x4 (- x3 sz) y4 (- y3 sz)
           pt4 (list x4 y4 0))    ;;select placement/insertion point of text    
     (command "dtext" "j" "r" pt4))) ;;write right justified text
   (setq *error* olderr)
   (setvar "osmode" omd)
   (setvar "cmdecho" cmd)
(princ)
);end defun
(princ "\nType 'LD' to Run.") (princ)
