

; ===========================================================
;
;   AutoLISP Concepts                    April 1987
;   Bill Kramer
;
;   AutoLISP Programmer I/O Utilities
;
; ===========================================================
;
;   Listing 1.  Experiments with GRREAD.
;
(defun c:Exper1 ()
   (setq Exit nil)
   (while (null Exit)
      (print
        (grread))))
;
(defun c:Exper2 ()
   (setq Exit nil Track 1)
   (while (null Exit)
      (print
         (grread Track))))
;
;
;  Listing 2.  Utility for Menulist I/O.
;
(defun Menu (Menu-list)
   (while (< (length Menu-list) 20)
      (setq Menu-list (append Menu-list (list ""))))
   (setq NN 0)
   (while (< NN 20)
     (grtext NN (nth NN Menu-list))
     (setq NN (1+ NN))) 
   (setq NN nil)
   (while (null NN)
     (setq TT (grread))
     (cond
       ((and (= (car TT) 2) (= (cadr TT) 13))
          (setq NN ""))
       ((= (car TT) 4)
          (setq NN
             (nth
               (cadr TT) Menu-list))))))
;
;  Listing 3. Generic Input of Standard Types with Default Values.
;
(defun getinput (Prmpt Dflt)
  (setq S
    (cond
      ((= (type Dflt) 'REAL)
        (getreal (strcat Prmpt " <" (rtos Dflt) "> ")))
      ((= (type Dflt) 'INT)
        (getint (strcat Prmpt " <" (itoa Dflt) "> ")))
      ((= (type Dflt) 'STR)
        (getstring (strcat Prmpt " <" Dflt "> ")))))
  (cond
    ((or (null S) (= S "")) Dflt)
    (t S)))
;
;  Listing 4. Read Only Workstation Control
;
(defun C:ROWSC ()
   (setvar "CMDECHO" 0)
   (setq Finished nil)
   (while (not Finished)
      (prompt "\nCommand> ")
      (setq Option (Menu '("  Read" "  Only" "   W/S" "--------" ""
                           "Window" "" "See All" "" "Exit")))
      (cond
        ((= Option "Exit") (command "QUIT" "Y"))
        ((= Option "See All") (prompt "See all") (command "ZOOM" "E"))
        ((= Option "Window")
            (setq P1 (getpoint "Show Window point 1: ")) 
            (prompt "  Show other corner: ")
            (setq Exit nil CON -1 Oldp P1)
            (while (null Exit)
               (setq P2 (grread 1))           
               (cond
                ((and (= (car P2) 5) (> (distance Oldp (cadr P2)) 0.001)) 
                    (grbox P1 oldp CON)
                    (grbox P1 (setq P2 (cadr P2)) CON) 
                    (setq Oldp P2))
                ((= (car P2) 3)
                    (grbox P1 Oldp CON)
                    (setq P2 (cadr P2)
                          Exit 1))))
            (command "ZOOM" "W" P1 P2))))) 
(defun grbox (P1 P2 Color)
   (grdraw P1 (list (car P1) (cadr P2)) Color)
   (grdraw (list (car P2) (cadr P1)) P1 Color)
)
                                     