;;; File inside.lsp      olasov@cs.columbia.edu Ben Olasov 1993
(defun c:inside ()
       (setq user-pt (getpoint "\nPick a point: "))
       (setq pline (user_ent "POLYLINE" "\nPick a polyline boundary: "))
       (if (and user-pt pline)
           (if (inside user-pt (collect_vertices pline))
                'inside 'outside)
            'invalid))

(defun collect_vertices (polyln / __ent *polyln* ##pt ##pts)
       (if (= (cdr (assoc 0 (setq *polyln* (entget polyln)))) "POLYLINE")
           (progn (setq __ent (entnext polyln))
                  (while (setq *ent* (entget __ent)
                               ##pt (cdr (assoc 10 *ent*)))
                         (setq ##pts (cons (trans ##pt polyln 1) ##pts)
                               __ent (entnext __ent)))
                         (if (not (equal (car ##pts) (last ##pts)))
                             (setq ##pts (reverse (cons (car ##pts) (reverse ##pts))))))
           (princ "\ncollect_vertices: not a POLYLINE."))
       ##pts)

(defun user_ent (ent_type_lst _prm / __ent)
      (while (not (member (extract_value 0 
                                        (setq __ent (car (entsel _prm))))
                ent_type_lst))) __ent)

(defun inside (p_ vtx_lst / ints i max_x max_y)
       (setq ints 0
             i 0
             num_vtx (length vtx_lst)
             max_x (apply 'max (mapcar 'car vtx_lst))
             max_y (apply 'max (mapcar 'cadr vtx_lst))
             exterior_pt (list (* max_x 2.0) (* max_y 2.0)))
       (repeat (1- num_vtx)
               (if (= i (1- num_vtx))
                   (setq vt1 (nth i vtx_lst)
                         vt2 (nth 0 vtx_lst))
                   (setq vt1 (nth i vtx_lst)
                         vt2 (nth (1+ i) vtx_lst)))
               (if (inters p_ exterior_pt vt1 vt2)
                   (setq ints (1+ ints)))
               (setq i (1+ i)))
       (if (= (rem ints 2) 0)
           nil 'T))

(defun user_ent (_ent_type _prm / __ent)
      (while (not (equal (extract_value 0 
                                        (setq __ent (car (entsel _prm))))
                _ent_type))) __ent)

(defun extract_value (key enm) 
       (if enm (cdr (assoc key (entget enm)))))

