(VMON)
(DEFUN JMP (Y)
  (REPEAT Y (TERPRI))
)

(DEFUN SCREEN1 ()
(TEXTSCR) (SETVAR "CMDECHO" 0) (SETQ X 0) (JMP 25)
(PROMPT "Welcome to the [7mFOUNDATION GENERATOR[0m demonstration script!  The purpose of this")
(PROMPT "\nrun is to show you how simple the FOUNDATION GENERATOR is to use and to sample")
(PROMPT "\nits wide capabilites.  To pause this Autocad script file at anytime, press the")
(PROMPT "\nthe CONTROL-NUM LOCK keys and to resume processing press any key.")
(JMP 19) (PAUSE 2000)

(PROMPT "\nBefore we begin drawing footings we need to take care of a few items. I find")
(PROMPT "\nit easiest to draw footings when the columns are located on a grid, so the")
(PROMPT "\nfirst thing is to draw column center lines with the program [7mGRIDLINE[0m.")
(PROMPT "\n\nGRIDLINE is included with the Foundation Generator program.")
(JMP 18) (PAUSE 2000)

(PROMPT "\nLet's assume the column bays are spaced at 20', 30', 30', and  20' across the")
(PROMPT "\ntop and at 25' running top to bottom.  Also, let's include grid line bubbles")
(PROMPT "\non either side of our centerlines.  Along the top our column lines will be")
(PROMPT "\nnamed A, B, C, D & E.")
(JMP 19) (PAUSE 2000)

(PROMPT "\nYes, I will shut up soon and actually begin drawing something . . . .")
(PROMPT "\n\nBut first let me note that I am going to establish my units and set my drawing")
(PROMPT "\nlimits for a 24 X 36 inch sheet at 1/8 inch scale (288'-0  X 192'-0).")
(PROMPT "\n\n                    O.K. - HERE WE GO . . . .")
(JMP 17) (PAUSE 1000)
)

(DEFUN PAUSE ( P )
  (PROMPT (STRCAT "This screen will scroll past in about "
   (ITOA (/ (ABS P) 100)) " seconds."))
  (IF (> P 0) (TERPRI))
  (COMMAND "DELAY" (* (ABS P) 10))
)

(DEFUN SCREEN3 ()
  (GRAPHSCR) (SETQ X 1) (JMP 25)
  (PROMPT "Remember, if stuff flies by too fast, you can pause the action with")
  (PROMPT "\nthe CONTROL-NUM LOCK keys.\n")
  (PAUSE -500)
)


(DEFUN SCREEN4 ()
  (TEXTSCR) (JMP 24)
  (PROMPT "Well that was easy.  (At least I thought so.)  Next we will draw the")
  (PROMPT "\nhorizontal grid lines and name them 1, 2, 3 & 4.  Then we will be ready")
  (PROMPT "\nto draw our spread and continuous wall footings.")
  (JMP 18)
)

(DEFUN SCREEN5 ()
(TEXTSCR) (JMP 25)
(PROMPT "The lettering may be to small to see so let's zoom in on the upper left")
(PROMPT "\ncorner for a better view and meanwhile I'll load in the foundation program.")
(JMP 18)
(PAUSE 500)
)

(DEFUN SCREEN10A ()
  (JMP 24) (TEXTSCR)
  (PROMPT "FG requires some basic data.  It needs to know at which column to start")
  (PROMPT "\ndrawing, and the location of the previous column along the foundation wall.") 
  (JMP 21) (PAUSE 1000)
 
  (PROMPT "\nFG also needs to know the wall thickness, pier width, distance from")
  (PROMPT "\nthe column centerline to the exterior face of wall and pier, and")
  (PROMPT "\nhow much the wall footing will stick out on each side of the wall.")
  (PROMPT "\n\nFor demonstration purposes we'll use the following values in inches:")
  (TERPRI) (TERPRI)
  (PROMPT "       Wall thickness                     =  12") (TERPRI)
  (PROMPT "       Column CL to exterior face of WALL =   8.5") (TERPRI)
  (PROMPT "       Wall lip on the exterior side      =   6") (TERPRI)
  (PROMPT "       Wall lip on the interior side      =   6") (TERPRI)
  (PROMPT "       Pier width                         =  16") (TERPRI)
  (PROMPT "       Column CL to exterior face of PIER =   8.5") (TERPRI)
  (PROMPT "       Column CL to interior face of PIER =   8")
  (JMP 10) (PAUSE 2500)

  (PROMPT "\nWe will now enter all the size and location information and then draw")
  (PROMPT "\nour first section of wall . . . .") 
  (JMP  21) (PAUSE 700) 

)


(DEFUN SCREEN10 ()
  (SETQ TW 8 DCL 8.5 DCM 3.5 FCL 6 FCM 6 PL3 8.5 PL4 8.0
        PW 16 CNG "N" MAS "Y" FTGSIZE 48.0
        PTT (POLAR PT1 (/ PI 2.0) 24)
  )
  (WALLGET 12 8.5 6 6 16 8.5 8) 
  (WALL2)
)

(DEFUN SCREENF ( / FTG G)
  (JMP 24)
  (COND ((= H 1.0) (SCREENF1))
        ((= H 2.0) (SCREENF2))
        ((= H 3.0) (SCREENF3))
        ((= H 4.0) (SCREENF4))
        ((= H 5.0) (SCREENF5))
        ((= H 6.0) (SCREENF5))
        ((= H 7.0) (SCREENF7))
        ((= H 8.0) (SCREENF8))
        ((= H 9.0) (SCREENF8))
        ((= H 10.0) (SCREENF8))
        ((= H 11.0) (SCREENF11))
        ((= H 12.0) (SCREENF12))
        ((= H 13.0) (SCREENF13))
        ((= H 14.0) (SCREENF14))
  )
  (GRAPHSCR)
  (SETQ G (STRCAT "Enter footing size (square) <" (ITOA (FIX FTGSIZE)) 
                    ">: " (RTOS FTG))
        FTGSIZE FTG
  )
  (PRINC G) (TERPRI)
)

(DEFUN SCREENF1 ()
  (PROMPT "And so, as promised I have drawn the foundation wall, but what about")
  (PROMPT "\nthe footing?\n")
  (PAUSE -500)
  (TEXTSCR) (JMP 24)
  (PROMPT "FG next asks for the size of the spread footing to be drawn.")
  (PROMPT "\nThere are two choices:")
  (PROMPT "\n1.  Enter the footing size you want. (Always a good idea.)  Note that")
  (PROMPT "\n    if the footing size entered is very small FG automatically")
  (PROMPT "\n    enlarges it to provide a minimum lip around the pier.")
  (PROMPT "\n\n2.  Enter a value of zero and the footing will not be drawn.  This is")
  (PROMPT "\n    useful whenever rectangular or special footing sizes are required.")
  (PROMPT "\n\nLet's assume a footing size of 3'-6 square.")
  (JMP 13) (PAUSE 2500) (SETQ FTG 42.0) (JMP 3)
)

(DEFUN SCREENF2 ()
  (PROMPT "And quickly our second section of foundation wall is drawn.")
  (PROMPT "\nThis time let us draw a large footing of 10'-0 square.") (TERPRI)
  (PAUSE -700) (TERPRI)
  (SETQ FTG 120)
)

(DEFUN SCREENF3 ()
  (PROMPT "Let's direct FG to draw a 6'-0 square spread footing.\n")
  (PAUSE 500) (SETQ FTG 72)
)

(DEFUN SCREENF4 ()
  (PROMPT "Drawing spread footings at corners is simple with FG.  Let's use")
  (PROMPT "\na relatively small footing size of 2'-6 square.\n")
  (PAUSE -700) (TERPRI) (SETQ FTG 30)
)

(DEFUN SCREENF5 ()
  (PROMPT "And now for the footing (4'-6 square) . . . .\n")
  (SETQ FTG 54)
)

(DEFUN SCREENF7 ()
  (PROMPT "This time, let's draw the smallest footing possible.")
  (TERPRI) (PAUSE 500) (TEXTSCR) (JMP 24)
  (PROMPT "We'll enter a footing size of 1 inch and FG will automatically.")
  (PROMPT "\ndraw the spread footing at least as large as the adjacent wall")
  (PROMPT "\nfootings. ")
  (JMP 20)
  (PAUSE 1000) (SETQ FTG 1)
)

(DEFUN SCREENF8 ()
  (PROMPT "And now for the footing (4'-0 square) . . . . \n")
  (SETQ FTG 48)
)

(DEFUN SCREENF11 ()
  (PROMPT "At this corner let's try a 2'-0 square footing.\n")
  (PAUSE 500) (SETQ FTG 24)
)

(DEFUN SCREENF12 ()
  (PROMPT "Again, let's draw a 2'-0 square footing.\n")
  (PAUSE 500) (SETQ FTG 24)
)

(DEFUN SCREENF13 ()
  (PROMPT "FG will accept almost any size square footing.  Let's draw")
  (PROMPT "\na footing 4'-8 7/16 square.\n")
  (PAUSE -500) (TERPRI) (SETQ FTG 56.4375)
)

(DEFUN SCREENF14 ()
  (PAUSE 500) (TEXTSCR) (JMP 3)
  (PROMPT "For our final corner footing let's have FG draw a truly massive")
  (PROMPT "\nfooting.  We'll ask for a 16'-0 square footing.  In fact, the only limits")
  (PROMPT "\non footing size are that the footings be square and not be larger than the")
  (PROMPT "\nthe distance to adjacent columns.")
  (JMP 19) (PAUSE 1500) (SETQ FTG 192)
)
  
(DEFUN SCREENCNR () ;CORNER SCREENS
  (TEXTSCR) (JMP 24)
  (COND ((= H 4.0) (SCREENCA))
        ((= H 7.0) (SCREENCB))
        ((= H 11.0) (SCREENCD))
        ((= H 14.0) (SCREENCE))
  )
  (GRAPHSCR)
)

(DEFUN SCREENCA ()
  (PROMPT "We have reached a corner of the building.  One of the nice features")
  (PROMPT "\nof FG is its ability at corners to change wall and pier sizes ")
  (PROMPT "\nand also to change the relative location of walls and piers.")
  (PROMPT "\nIt's easier to see this happen than explain it.  Our current wall")
  (PROMPT "\nparameters will be changed as follows:" )
  (TERPRI) (TERPRI)
  (SCREENCC 8 6 16 6 16 6 7)
  (JMP 6) (PAUSE 2500) (TERPRI)
  (WALLGET 8 6 16 6 16 6 7)
)
  

(DEFUN SCREENCC (TWA DCLA FCLA FCMA PWA PLA PL2A / F G)
  (PROMPT "\n                  BEFORE CORNER TURNED          AFTER CORNER TURNED\n")
  (SETQ F "                       "
       G (STRCAT  "Wall thickness      " (ROTS TW) F "   " (ROTS TWA)))
  (PRINC G) (TERPRI)
  (SETQ G (STRCAT " -Col CL to ext. face  " (ROTS DCL) F  (ROTS DCLA)))
  (PRINC G) (TERPRI) (TERPRI)
  (SETQ G (STRCAT "Wall lip - exterior    " (ROTS FCL) F (ROTS FCLA)))
  (PRINC G) (TERPRI)
  (SETQ G (STRCAT "         - interior    " (ROTS FCM) F  (ROTS FCMA)))
  (PRINC G) (TERPRI) (TERPRI)
  (SETQ G (STRCAT "Pier size - width      " (ROTS PW)  F (ROTS PWA)))
  (PRINC G) (TERPRI)
  (SETQ G (STRCAT " -Col CL to exterior   " (ROTS PL) F (ROTS PLA)))
  (PRINC G) (TERPRI)
  (SETQ G (STRCAT " -Col CL to interior   " (ROTS PL2) F (ROTS PL2A)))
  (PRINC G) (TERPRI)
)

(DEFUN ROTS ( H / B C)
  (SETQ B (RTOS H 3 1) C (STRLEN B))
  (IF (= "0" (SUBSTR B (- C 1) 1))
     (SETQ B (STRCAT (SUBSTR B 1 (- C 3)) (CHR 34)) C (- C 2)))
  (STRCAT (SUBSTR F 1 (- 6 C)) B)
)

(DEFUN WALLGET (TWA DCLA FCLA FCMA PWA PL3A PL4A / G G1 G2 G3 G4 G5 G6)
  (SETQ G (STRCAT "Enter foundation wall thickness <" (RTOS TW) ">:" (RTOS TWA 3 0))
    G1 (STRCAT "Enter distance from column CL to the EXTERIOR face of wall <"
                (RTOS DCL) ">:" (RTOS DCLA 3 1))
 G2 (STRCAT "Enter foundation wall lip width on the EXTERIOR side of the wall <"
                (RTOS FCL) ">:" (RTOS FCLA 3 0))
    G3 (STRCAT "Enter wall lip width on the INTERIOR side of the wall <"
                (RTOS FCM) ">:" (RTOS FCMA 3 0))
    G4 (STRCAT "Enter pier width parallel to foundation wall <"
                (RTOS PW) ">:" (RTOS PWA 3 0))
    G5 (STRCAT "Enter distance from column CL to the EXTERIOR face of pier <"
                (RTOS PL3) ">:" (RTOS PL3A 3 1))
    G6 (STRCAT "Enter distance from column CL to the INTERIOR face of pier <"
                (RTOS PL4) ">:" (RTOS PL4A 3 1))
        TW2 TWA DCL2 DCLA FCL2 FCLA FCM2 FCMA DCM2 (- TW2 DCL2)
        PW  PWA PL3  PL3A PL4  PL4A
  )
 
  (IF (> H 0) (PROGN
    (PROMPT "Do you want to change the wall location or thickness after corner is turned?")
    (TERPRI)
    (PROMPT "Enter Y or N <N>: Y") (TERPRI) (COMMAND "DELAY" 700)
    )
  )
  (PRINC G ) (TERPRI) (COMMAND "DELAY" 700)
  (PRINC G1) (TERPRI) (COMMAND "DELAY" 700)
  (PRINC G2) (TERPRI) (COMMAND "DELAY" 700)
  (PRINC G3) (TERPRI) (COMMAND "DELAY" 700)
  (PRINC G4) (TERPRI) (COMMAND "DELAY" 700)
  (PRINC G5) (TERPRI) (COMMAND "DELAY" 700)
  (PRINC G6) (TERPRI)
)


(DEFUN WALL2 ()
  (SETQ TW TW2 DCL DCL2 DCM DCM2 FCL FCL2 FCM FCM2 PL PL3 PL2 PL4)
)

(DEFUN SCREENCB ()
  (PROMPT "Again let's change wall sizes and locations at corner column E4.")
  (PROMPT "\nItems will be changed as follows:")
  (TERPRI) (TERPRI)
  (SCREENCC 12 10.5 6 6 16 6 8)
  (JMP 9) (PAUSE 2500) (TERPRI)
  (WALLGET 12 10.5 6 6 16 6 8)
)

(DEFUN SCREENCD ()
  (PROMPT "At this corner we will not change wall size or location, but just")
  (PROMPT "\nget on with our drawing. . . .")
  (JMP 21) (PAUSE 700)
  (PROMPT "\nDo you want to change the wall location or thickness after corner is turned?")
  (PROMPT "\nEnter Y or N <N>:") (TERPRI) (COMMAND "DELAY" 300)
)

(DEFUN SCREENCE ()
  (PROMPT "We are at the final corner of the foundation plan!  We must change")
  (PROMPT "\na few wall parameters to make the wall meet the first section drawn.")
  (PROMPT "\nWall parameters will be changed as follows:\n\n")
  (SCREENCC 12 8.5 6 6 16 8.5 8)
  (JMP 8) (PAUSE 2500) (TERPRI)
  (WALLGET 12 8.5 6 6 16 8.5 8)
)



