(DEFUN SCREENNXT ()
  (JMP 24)
  (COND ((= H 1.0) (SCREENX1))
        ((= H 2.0) (SCREENX2))
        ((= H 3.0) (SCREENX3))
        ((= H 4.0) (SCREENX4))
        ((= H 6.0) (SCREENX6))
        ((= H 7.0) (SCREENX7))
        ((= H 8.0) (SCREENX8 576))
        ((= H 9.0) (SCREENX8 576))
        ((= H 10.0) (SCREENX10))
        ((= H 11.0) (SCREENX11))
        ((= H 12.0) (SCREENX8 612))
        ((= H 13.0) (SCREENX13))
        ((= H 14.0) (SCREENX14))       
                    (SETQ H H)
  )
)

(DEFUN SCREENX1 ()
  (PROMPT "And so, the first spread footing has been drawn along with")
  (PROMPT "\nthe wall footing on either side.\n")
  (PAUSE -300) (JMP 3)
  (PRINC "Let's zoom in closer for a better look . . . . ") (TERPRI)
  (PAUSE -300) (TERPRI)
  (COMMAND "ZOOM" "WINDOW" (LIST 552 1632) (LIST 1188 2100))
  (PAUSE 500) (TEXTSCR) (JMP 24)

  (PROMPT "Next, we will draw the foundation wall and footing surrounding")
  (PROMPT "\nthe adjacent column, which is column C1.")
  (PROMPT "\n\nBut, before we draw anything let's move the display window so it is")
  (PROMPT "\ncentered over column C1.")
  (JMP 18)
  (PAUSE 1000) (TERPRI)
  (COMMAND "ZOOM" "C" PT3 576)
)

(DEFUN SCREENX2 ()
  (PROMPT "The next column on our path is column D1.\n")
  (PAUSE 500)
  (COMMAND "ZOOM" "C" PT3 576)
)

(DEFUN SCREENX3 ()
  (PROMPT "Now we're cooking!  Three spread footings and adjacent walls are")
  (PROMPT "\ndrawn.  The next column centerline point we will choose is at")
  (PROMPT "\ncorner column E1.  ") 
  (PAUSE -800) 
  
  (PROMPT "\nLet's zoom over there and choose our point . . . . \n")
  (PAUSE 300) (TERPRI)
  (COMMAND "ZOOM" "W" (LIST 1164 1488) (LIST 1956 2076))
  (PAUSE 300)
)

(DEFUN SCREENX4 ()
  (PROMPT "So far so good . . . .\n") (PAUSE 300)

  (TEXTSCR) (JMP 24)
  (PROMPT "Next FG will draw the footings at columns E2 and E3 without")
  (PROMPT "\nany interruptions so you get an idea of its quickness.")
  (PROMPT "\n\nBoth spread footings will be drawn 4'-6 square.")
  (PROMPT "\n\nFirst, I'll zoom out a bit.")
  (JMP 17) (PAUSE 1000) (TERPRI)
  (COMMAND "ZOOM" "C" (LIST 1176 1380) 960)
)

(DEFUN SCREENX6 ()
  (PAUSE 300) (TEXTSCR)
  (PROMPT "\nAs you can see, FG can speed your drafting time tremendously.")
  (PROMPT "\nAnd all of the entities drawn except for the hatching are")
  (PROMPT "\ndrawn with lines so they are easy to modify should revisions")
  (PROMPT "\nbe necessary.")
  (PROMPT "\n\nThe next section to be drawn is around corner column E4.")
  (JMP 17) (PAUSE 1500) (TERPRI)
  (COMMAND "ZOOM" "C" PT3 600) (TERPRI)
)

(DEFUN SCREENX7 ()
  (PROMPT "Let's draw the next three column footings without interruption.")
  (PROMPT "\n4'-0 square footings will be drawn around each column.\n")
  (PAUSE -800) (SCREENX8 576)
)

(DEFUN SCREENX8 ( P )
  (TERPRI)
  (COMMAND "ZOOM" "C" PT3 P)
)

(DEFUN SCREENX10 ()
  (PROMPT "Let's zoom out and see what we just did.\n")
  (PAUSE 500) (TERPRI)
  (COMMAND "ZOOM" "W" (LIST 354 702) (LIST 1950 2046))
  (JMP 3)
  (PROMPT "Footings around D4, C4, and B4 are drawn and look beautiful.")
  (PROMPT "\nNext, we'll choose column A4.\n")
  (PAUSE -700)
  (SCREENX8 612)
)

(DEFUN SCREENX11 ()
  (PROMPT "We're almost done with our foundation plan, so let's move on to")
  (PROMPT "\ncolumns A3 and then A2.\n")
  (PAUSE -500)
  (SCREENX8 612)
)

(DEFUN SCREENX13 ()
  (JMP 3) (PAUSE 500)
  (SCREENX8 612)
)

(DEFUN SCREENX14 ()
  (PAUSE 300) 
  (COMMAND "ZOOM" "W" (LIST 354 702) (LIST 1950 2046)) (PAUSE 500)
  (TEXTSCR) (JMP 3)
  (PROMPT "                                  [5mWE ARE DONE![0m")
  (PROMPT "\n\nWe have in a matter of a few minutes drawn a foundation plan for")
  (PROMPT "\na small building.  I think you will agree that FOUNDATION GENERATOR")
  (PROMPT "\nfulfills the promise of a time saving drafting tool well worth its cost.")
  (PROMPT "\n\nTo exit from the program we tell it that the next column is located exactly")
  (PROMPT "\nwhere the last one was.  In other words we enter: @\n")
  (PROMPT "\nAfter exiting from FG I will display a few more chatty screens, then")
  (PROMPT "\nend the demo and allow you to inspect and modify the drawing yourself.")
  (JMP 11) (PAUSE 2500) (TERPRI) 
)
