/*      THIS MODULE IS THE MAIN START UP FOR RETREIVER
		COPYWRITE 1985,86,87,88
		PAN-DIMENSIONAL RESEARCH
		PO BOX 1439
		GUERNEVILLE, CALIFORNIA 95446
		(707) 869-0682

	NO DISCLOSURE WITHOUT AUTHORS WRITTEN PERMISSION
		MICHAEL ANDREW LISKA                                    */

/*  to create retriever.exe simply compile with turbo c large memory */



#include "retreive.h"    /* it took me 4 years to learn to spell retrieve correctly */
#define PAGE     0
#define HOME     0, 0, 0
#define RTOD(x)  180 *(x / M_PI)  /* radians to degrees don't you wish AutoLISP was this simple */
#define MAXIMUM  256              /* we have to put a program limit somewhere */

/* global variables */
char string_buf[MAXPATH];    /* useful when you want to split filenames */
char dwgname[15];            /* buffers to hold file names */
char indwg[15];
char outdwg[15];
FILE *dwgptr, *dxfout;       /* file pointers */
char *searchptr,*dxfptr;
long deleted;
OFFSETS offset;
char *laynames[MAXIMUM],*blcknames[MAXIMUM],*linenames[MAXIMUM],*stylenames[MAXIMUM];
int valid = 1;

/* function prototypes  */

void clear(), cur_pos(), main_menu(), clear_bottom(), what_know(),copywrite();
void translate(),file_menu(),file_text(),list_file(),clearlisting(),find_it();
void tables(),free_mem();
int write_head(), write_lines(),layers(),styles(),views(),blocks();
int verstop(),transmenu();
int getresponse(), scan(), chck_version(), verify(),scan_header();
long scan_entities();

/*  and away we go  */

void main()
	{
		what_know();           /* that's all there is to it the rest */
		exit(0);               /* of the code is just for grins      */
	}

/* puts a very well known looking menu on the screen */
/* and waits for orders */
void what_know()
	{
		char select;
		clear();
                cur_pos(HOME);
		copywrite();
                main_menu();
                while(valid){

		      select = getresponse(15, 17, 50);
                        switch(select){
				case 0:
					printf("\n\n\nEnd Retriever\n");
					exit(0);
				case 1:
					printf("\ncreate .dxf");
                                        if(verify())
                                           translate();
					break;
                                case 2:
					printf("\nfile utilities");
					file_menu();
	                                break;
				default:
					printf("\nerror :  getresponse");
					exit(1);}
                              }

	 }

/* clears any IBM bios compatable screen */

void clear()
	{
		union REGS inreg, outreg;
		inreg.h.ah = 6;
		inreg.h.al = 0;
		inreg.h.ch = 0;
		inreg.h.cl = 0;
		inreg.h.dh = 24;
		inreg.h.dl = 79;
		inreg.h.bh = 7;
		int86(0x10, &inreg, &outreg);
	}

/* puts the cursor where we want it */

void cur_pos(row, col, page)
unsigned char row, col, page;
	{
		 union REGS inreg, outreg;
		 inreg.h.ah = 2;
		 inreg.h.dh = row;
		 inreg.h.dl = col;
		 inreg.h.bh = page;
		 int86(0x10, &inreg, &outreg);
	}

/* finds out where the cursor is in case we forgot */

int get_cur()
	{
		union REGS inreg, outreg;
		inreg.h.ah = 3;
		inreg.h.bh = PAGE;
		int86(0x10, &inreg, &outreg);
		return(outreg.h.dh);
	}

/* a very familuar looking menu  */
/* the first few RETRIEVR's were shipped with this menu */
/* they were not amused */

void main_menu()
	{
		cur_pos(7,0,PAGE);
		cprintf("Main Menu\n");
              cprintf("\n  0.  Exit Retriever");
	      cprintf("\n  1.  Create .dxf File\n");
              cprintf("\n  2.  File Utilities\n\n");
	      cprintf("\nEnter selection: ");


	}
/* another familuar looking menu */
/* mine works better             */

void file_menu()
	{
		char select;
		int valid = 1;
		clear();
		cur_pos (HOME);
		copywrite();
		file_text();
		do {
			select = getresponse(16, 17, 52);
			 switch(select){
				case 0:
					what_know();
					break;

				case 1:
                        		cprintf("\nEnter drive or directory: ");
					gets(string_buf);
					list_file(0);
                			file_menu();
					break;

				case 2:
					cprintf("\nEnter search parameters: ");
					gets(string_buf);
					list_file(1);
					file_menu();
					break;

				case 3:
					cprintf("\nEnter file name to search for: ");
					gets(string_buf);
					find_it();
					file_menu();
					break;

				default:
					printf("\nerror : getresponse");
					exit(1);}

			} while(valid);

	}

/* no I never worked for them  */

void file_text()
	{
		cur_pos(7,0,PAGE);
		cprintf("File Utilities\n");
		cprintf("\n  0.  Main Menu");
		cprintf("\n  1.  List drawing files");
		cprintf("\n  2.  List user files\n");
		cprintf("\n  3.  Find file");
		cprintf("\n  4.  Copy file\n");
		cprintf("\nEnter selection: ");

	}

/* find out what the guy wants to do  */

int getresponse(x, y,menu)
unsigned char x, y;
int menu;
	{
         cur_pos(x, y,PAGE);
         strset(tmpstr, ' ');
	 cprintf("%s",tmpstr);
	 cur_pos(x, y,PAGE);
          while(1){
            gets(tmpstr);
             if( strlen(tmpstr) > 1 || toascii(tmpstr[0]) < 48 || toascii(tmpstr[0]) > menu)
		{   cur_pos(x,y,PAGE);
		    strset(tmpstr, ' ');
		    cprintf("%s", tmpstr);
                    cur_pos(x,y,PAGE);  }
		 else
		    return(atoi(tmpstr));
                    }
        }

/* which version of the .dxf file is wanted yes it does translate backwards */
/* be careful with your compilers boundry settings all structures should be */
/* byte aligned */
int transmenu(ver)
int ver;
	{       char select;
                int x = 1;
		if(ver == 103){
                    cur_pos(8,0,PAGE);
		    cprintf("Translate\n");
		    cprintf("\n  0.  Main Menu");
		    cprintf("\n  1.  Create 2.6x dxf file");
		    cprintf("\n\nEnter Selection: ");
                  while(x){
                            select = getresponse(13,17,49);
			     switch(select){
				  case 0:
				       what_know();
				       break;
				   case 1:
                                        return(103);
					 }}}
		else
		{
		    cur_pos(8,0,PAGE);
		    cprintf("Translate\n");
		    cprintf("\n  0.  Main Menu");
		    cprintf("\n  1.  Create 2.6x dxf file");
		    cprintf("\n  2.  Create Release 9 dxf file");
		    cprintf("\n\nEnter Selection: ");
		    while(x){
			     select = getresponse(14,17,50);
			     switch(select){
				    case 0:
				       what_know();
				       break;
				     case 1:
				       return(103);
				     case 2:
				       return(MAX_VARS);
				       }}}
         return(0);
	}

/* displays files in a nice format on the screen */

void list_file(x)
int x;
	{
	   struct dfree free;
	   struct ffblk ffblk;

	   char asci_drive[MAXDRIVE];
	   char dir[MAXDIR];
	   char file[MAXFILE];
	   char ext[MAXEXT];

           long free_space;

	   int done,count,drive,flag;

           clear();
	   cur_pos(HOME);
	   copywrite();
           cur_pos(6,0,PAGE);
         if(!x)
		 strcat(string_buf, "*.dwg");

         flag = fnsplit(string_buf,asci_drive,dir,file,ext);

      if(flag & DRIVE)
            drive = toupper(asci_drive[0]) - 64 ;
      else
	    drive = getdisk() + 1;

	   cprintf("Listing of %s \n\n",string_buf);
	   cprintf("        NAME              SIZE                DATE       TIME\n");
	   cprintf("        ----              ----                ----       ----");

           done = findfirst(string_buf, &ffblk, 0);
           count = 0;
	   while(!done) {
		    cprintf("\n%13s       ",ffblk.ff_name);
		    cprintf("%10ld          ",ffblk.ff_fsize);
		    cprintf("   %02d-%02d-%d",(ffblk.ff_fdate >> 5) & 0x0f,ffblk.ff_fdate & 0x1f,((ffblk.ff_fdate >> 9) & 0x03f) + 1980);
                    cprintf("    %02d:%02d",(ffblk.ff_ftime >> 11) & 0x01f,(ffblk.ff_ftime >> 5) & 0x03f);
		    count++;
		    if( get_cur() == 23){
		       cur_pos(24,0,PAGE);
		       cprintf("** MORE **");
		       getch();
		       clearlisting();
		       cur_pos(9,0,PAGE);}
                       done = findnext(&ffblk);
			}

          cur_pos(24,0,PAGE);
	  getdfree(drive,&free);
	  free_space = (long)free.df_sclus * (long)free.df_bsec * (long)free.df_avail;
	  cprintf("%d File(s) : %ld Bytes free : Press any key to continue ",count,(long)free_space);
	  getch();

	} /* end of list_file */

void find_it()
	{

          cprintf("\nYour turn to write something");

        } /* end of find_it */

int verify()
	{
		cur_pos(17,0,PAGE);
		cprintf("Enter NAME of drawing: ");
                 gets(dwgname);
                strcpy(indwg, dwgname);
		strcat(indwg, ".dwg");

   /* a company in Georgia caught me on this one, The drawing needs to be */
   /* on the main dos path somewhere  */

                 if((searchptr = searchpath(indwg)) != NULL)
			   valid--;
		   else
                       { cprintf("\n%s: File not found",indwg);
                         cprintf("\nPress any key to continue ");
			 getch();
			 clear_bottom();
			 return(0);
		       }
          return(1);

	}

/* don't you wish compiler makers would have these kinds of functions
   done for you   */

void clear_bottom()

	{
                union REGS inreg, outreg;
		inreg.h.ah = 6;
		inreg.h.al = 0;
		inreg.h.bh = 7;
		inreg.h.ch = 16;
		inreg.h.cl = 0;
		inreg.h.dh = 22;
		inreg.h.dl = 79;
		int86(0x10, &inreg, &outreg);
	}

void clearlisting()
	{
		union REGS inreg, outreg;
		inreg.h.ah = 6;
		inreg.h.al = 0;
		inreg.h.bh = 7;
		inreg.h.ch = 10;
		inreg.h.cl = 0;
		inreg.h.dh = 23;
		inreg.h.dl = 79;
		int86(0x10, &inreg, &outreg);
	}

/* this is the main control function it calls other functions in the correct
   order to build the .DXF file.     */

void translate()
	{
                int possible,y;
		clear();
		cur_pos(HOME);
		copywrite();
		cprintf("\nCurrent drawing: %s", searchptr);
                strcpy(outdwg,dwgname);
		strcat(outdwg, ".dxf");
                if(chck_version())

		      {  dxfout = fopen(outdwg, "w");

			 fread(&offset,sizeof(offset),1,dwgptr);
			 y = verstop();
                         possible = transmenu(y);
                         cur_pos(17,0,PAGE);
	        	 cprintf("** PHASE I **   : ");
                         write_head(possible,1);
                         cprintf(" HEADER ");
			 tables();
			 cprintf("\n** PHASE II **  : ");
                         write_lines();
			 cprintf(" LINETYPES ");
                         layers();
  			 cprintf(": LAYERS ");
                         styles();
			 cprintf(": STYLES ");
			 views();
			 cprintf(": VIEWS ");
                         fprintf(dxfout,"\n  0\nENDSEC");
                         blocks(1);
			 cprintf(": BLOCKS");
			 cprintf("\n** PHASE III ** :  Acad says %d entities : ",offset.numents);
                         fprintf(dxfout,"\n  0\nSECTION\n  2\nENTITIES\n  0");
		        scan_entities(offset.entstart,0);

			 fprintf(dxfout,"\n  0\nEOF");
                         fclose(dwgptr);
			 fclose(dxfout);
			 cprintf(" TRANSLATED");
			 cprintf(" : %ld DELETED",deleted);
	                 cprintf("\n\n%s created",outdwg);
                         cur_pos(23,0,PAGE);
                         cprintf("\nPress any key to continue ");
			 getch();
			 what_know();}



                   else
			{ cprintf("\n\nCannot go back beyond 2.5x ");
                          cprintf("\n\nPress any key to continue ");
                          getch();
			  valid = 1;
			  what_know(); }

	}

/* the following code started it's life in 1984 when I thought that
   fprinting was more fun than humans should have */
/* i'll let you figure out your own julian routine for the internal time variables */

int write_head(versionstop,recv)
int versionstop,recv;
	{
                long where,unknown;
                int x, in;
                char lnamebuff[37];
		char decodebuffer[20];  /* the shipping RETRIEVER has a slick */
		char inchar;            /* copy protection routine            */
		char type;
                struct {
			   double x;
			   double y;
			   double z;

		       } coords;
		fprintf(dxfout,"  0\nSECTION\n  2\nHEADER\n  9\n$ACADVER\n  1\n%s\n  9",version);
                fprintf(dxfout,"\n$INSBASE\n 10\n%lf\n 20\n%lf\n  9",offset.insbase_x,offset.insbase_y);
                for(x = 0; x < versionstop; x++){

                        strcpy(decodebuffer,head_vars[x]);
                        type = *(decodebuffer+0);

	switch(type){

          case 53:
	    fread(&coords,sizeof(coords),1,dwgptr);
            if(strchr(decodebuffer, '$'))
              fprintf(dxfout,"\n%s\n 10\n%6lf\n 20\n%6lf\n  9",&decodebuffer[1],coords.x,coords.y);
	    break;
	  case 51:
	    fread(&coords,sizeof(coords),1,dwgptr);
	    if(strchr(decodebuffer, '$'))
	      fprintf(dxfout,"\n%s\n 10\n%6lf\n 20\n%6lf\n 30\n%6lf\n  9",&decodebuffer[1],coords.x,coords.y,coords.z);
	    break;

          case 50:
	    fread(&coords, sizeof(double) * 2,1,dwgptr);
	    if(strchr(decodebuffer, '$'))
	      fprintf(dxfout,"\n%s\n 10\n%6lf\n 20\n%6lf\n  9",&decodebuffer[1],coords.x,coords.y);
	    break;

	  case 55:
	    fread(&in,sizeof(in),1,dwgptr);
	    if(strchr(decodebuffer, '$'))
	      fprintf(dxfout,"\n%s\n 70\n%6d\n  9",&decodebuffer[1],in);
	    break;

          case 65:
	    fread(&coords,sizeof(double),1,dwgptr);
	    if(strchr(decodebuffer, '$'))
	      fprintf(dxfout,"\n%s\n 50\n%.1lf\n  9",&decodebuffer[1],RTOD(coords.x));
	    break;

	  case 49:
	    fread(&coords,sizeof(double),1,dwgptr);
	    if(strchr(decodebuffer, '$'))
	      fprintf(dxfout,"\n%s\n 40\n%6lf\n  9",&decodebuffer[1],coords.x);
	    break;

	 case 67:
            fread(&inchar,sizeof(char),1,dwgptr);
            if(strchr(decodebuffer, '$'))
	    fprintf(dxfout,"\n%s\n 70\n%6d\n  9",&decodebuffer[1],(int)inchar);
	    break;

	 case 90:
	    fread(&inchar,sizeof(char),1,dwgptr);
	    fprintf(dxfout,"\n%s\n 70\n%6d",&decodebuffer[1],(int)inchar);
	    break;

	 case 88:
	    fread(&in,sizeof(in),1,dwgptr);
            fprintf(dxfout,"\n$CECOLOR\n 62\n%6d\n  9",in);
            break;

	 case 89:
	    fread(&in,sizeof(in),1,dwgptr);
	      switch(in) {
		case 0:
		 fprintf(dxfout,"\n$CELTYPE\n  6\nBYBLOCK\n  9");
		 break;
                case 256:
		 fprintf(dxfout,"\n$CELTYPE\n  6\nBYLAYER\n  9");
		 break;
		default:
                 if(recv == 1){
                 where = ftell(dwgptr);
		 fseek(dwgptr,offset.linetypes + (in * offset.linesize) + 1,0);
		 fscanf(dwgptr,"%s",&lnamebuff);
		 fprintf(dxfout,"\n$CELTYPE\n  6\n%s\n  9",lnamebuff);
		 fseek(dwgptr,where,0);}
		else
		 fprintf(dxfout,"\n$CELTYPE\n  6\nCONTINUOUS\n  9");
		 break;  }
            break;

         case 84:
	    fread(&in,sizeof(in),1,dwgptr);
           if(recv == 1){
	    where = ftell(dwgptr);
	    fseek(dwgptr,offset.txtstyles + (in * offset.txtstylesize) + 1, 0);
	    fscanf(dwgptr,"%s",&lnamebuff);
	    fprintf(dxfout,"\n%s\n  7\n%s\n  9",&decodebuffer[1],lnamebuff);
	    fseek(dwgptr,where,0);}
	    else
	    fprintf(dxfout,"\n%s\n  7\nSTANDARD\n  9",&decodebuffer[1]);
	    break;

         case 56:
            fread(&in,sizeof(in),1,dwgptr);
	  if(recv == 1){
	    where = ftell(dwgptr);
            fseek(dwgptr,offset.layers + (in * offset.laysize) + 1,0);
	    fscanf(dwgptr,"%s",&lnamebuff);
	    fprintf(dxfout,"\n%s\n  8\n%s\n  9",&decodebuffer[1],lnamebuff);
	    fseek(dwgptr,where,0);}
	    else
	    fprintf(dxfout,"\n%s\n  8\n0\n  9",&decodebuffer[1]);
	    break;

	 case 76:
	    fread(&unknown,sizeof(unknown),1,dwgptr);
	    break;

         case 77:
	    fread(&unknown,sizeof(unknown),1,dwgptr);
	    break;

	 case 70:
	    switch(*(decodebuffer+5)){
		 case 49:
		  fread(&MENU1,sizeof(MENU1),1,dwgptr);
		  break;

                 case 50:
		  fread(&MENU2,sizeof(MENU2),1,dwgptr);
		  fprintf(dxfout,"\n$MENU\n  1\n%s%s\n  9",MENU1,MENU2);
		  break;

		 case 87:
		  fread(&ARROW_BLK,sizeof(ARROW_BLK),1,dwgptr);
		  break;

		 case 66:
		  fread(&UNK_BUF,sizeof(UNK_BUF),1,dwgptr);
		  fprintf(dxfout,"\n$DIMBLK\n  1\n%s%s\n  9",ARROW_BLK,UNK_BUF);
		  break;

		 case 80:
		  fread(&DIMPOST,sizeof(DIMPOST),1,dwgptr);
		  fprintf(dxfout,"\n$DIMPOST\n  1\n%s\n  9",DIMPOST);
		  break;

                 case 65:
		  fread(&DIMAPOST,sizeof(DIMAPOST),1,dwgptr);
		  fprintf(dxfout,"\n$DIMAPOST\n  1\n%s\n  9",DIMAPOST);
		  break;

	  default:
	    break; }

            } /* end of main case */

           }  /* end of for  */
      if(versionstop == 103)
           fprintf(dxfout,"\n$USERR5\n 40\n0.0\n  0\nENDSEC");
        else
	   fprintf(dxfout,"\n  0\nENDSEC");

      return(1);
	}       /* end of write_head   */

void tables()
	{
		fprintf(dxfout,"\n  0\nSECTION\n  2\nTABLES");
	}

/* my free .dxf translator does the comments correctly   */

int write_lines()
	{



	      char picture[48];
              char flag;
	      char count;
	      double repeats;
              int x,y;

              fprintf(dxfout,"\n  0\nTABLE\n  2\nLTYPE\n 70\n%6d\n  0",offset.numltypes);

              for(x = 0; x < offset.numltypes; x++){
                  linenames[x] = (char *)calloc(1,33);
		    if(!linenames[x])
		       {printf("\nerror : memory request failed : linenames");
			exit(1);}
                  fprintf(dxfout,"\nLTYPE");
		  fseek(dwgptr,offset.linetypes + (x * offset.linesize) ,0);
		  fread(&flag,sizeof(flag),1,dwgptr);
                  fread(linenames[x],32,1,dwgptr);
		  strcat(linenames[x],"\0");
		  fread(&picture,sizeof(picture),1,dwgptr);
		  fprintf(dxfout,"\n  2\n%s\n 70\n%6d\n  3\n%s",linenames[x],flag,picture);
		  fread(&flag,sizeof(flag),1,dwgptr);
		  fread(&count,sizeof(count),1,dwgptr);
		  fprintf(dxfout,"\n 72\n%6d\n 73\n%6d",flag,count);
		  fread(&repeats,sizeof(repeats),1,dwgptr);
		  fprintf(dxfout,"\n 40\n%6lf",repeats);
		   for( y = 0; y < count; y++){
			fread(&repeats,sizeof(repeats),1,dwgptr);
			fprintf(dxfout,"\n 49\n%6lf",repeats);}
		  fprintf(dxfout,"\n  0");
		  }

         linenames[255] = (char *)calloc(1,32);
           if(!linenames[255])
	      {cprintf("\nerror : BYBLOCK"); exit(1);}
                strcpy(linenames[255],"BYBLOCK");
         fprintf(dxfout,"\nENDTAB");
         return(1);
	 } /* end of lines */


int layers()
	{
		char flag;
                int x,misc,color;
		fprintf(dxfout,"\n  0\nTABLE\n  2\nLAYER\n 70\n%6d\n  0",offset.numlayers);
                for(x = 0; x < offset.numlayers; x++){
                laynames[x] = (char *) calloc(1,33);
			if(!laynames[x]){
			    printf("\nerror : memory request failed : laynames");
			    exit(1);}
                        fprintf(dxfout,"\nLAYER\n  2");
			fseek(dwgptr,offset.layers + (x * offset.laysize),0);
                        fread(&flag,sizeof(flag),1,dwgptr);
			fread(laynames[x],32,1,dwgptr);
                        strcat(laynames[x],"\0");
			fread(&color,sizeof(color),1,dwgptr);
			fprintf(dxfout,"\n%s\n 70\n%6d\n 62\n%6d",laynames[x],flag,color);
                            fread(&misc,sizeof(misc),1,dwgptr);
			fprintf(dxfout,"\n  6\n%s\n  0",linenames[(int)misc]);

                  } /* end for */
		  fprintf(dxfout,"\nENDTAB");
		  return(1);
		} /* end layers */

int styles()
	{
	     int x;
	     char name[32];
	     char flag,flag2;
             double num;
             fprintf(dxfout,"\n  0\nTABLE\n  2\nSTYLE\n 70\n%6d\n  0",offset.numtxtstyles);
	     for(x = 0; x < offset.numtxtstyles; x++){
		stylenames[x] = (char *) calloc(1,32);
			if(!stylenames[x]){
			     printf("\nerror : memory request failed : stylenames");
			     exit(1);}
		   fseek(dwgptr,offset.txtstyles + (x * offset.txtstylesize), 0);
		   fread(&flag,sizeof(flag),1,dwgptr);
		   fread(stylenames[x],32,1,dwgptr);
		   fprintf(dxfout,"\nSTYLE\n  2\n%s\n 70\n%6d",stylenames[x],flag);
                   fread(&num,sizeof(num),1,dwgptr);
		   fprintf(dxfout,"\n 40\n%6lf",num);
		   fread(&num,sizeof(num),1,dwgptr);
		   fprintf(dxfout,"\n 41\n%6lf",num);
		   fread(&num,sizeof(num),1,dwgptr);
		   fprintf(dxfout,"\n 50\n%6lf",RTOD(num));
		   fread(&flag2,sizeof(flag2),1,dwgptr);
		   fprintf(dxfout,"\n 71\n%6d",flag2);
		   fread(&num,sizeof(num),1,dwgptr);
		   fprintf(dxfout,"\n 42\n%6lf",num);
		   fread(&name,sizeof(name),1,dwgptr);
		   fprintf(dxfout,"\n  3\n%s",name);
		   fread(&name,sizeof(name),1,dwgptr);
		   fprintf(dxfout,"\n  4\n%s\n  0",name);}
                fprintf(dxfout,"\nENDTAB");
		return(1);
	} /* end of styles */

int views()
	{
		int v;
		char flag;
		char name[32];
		struct {
			  double g40;
			  double g10;
			  double g20;
			  double g41;
			  double g11;
			  double g21;
			  double g31;
			} viewvals;

		fprintf(dxfout,"\n  0\nTABLE\n  2\nVIEW\n 70\n%6d\n  0",offset.numviews);
                for(v = 0; v < offset.numviews; v++){
                 fseek(dwgptr,offset.views + (v * offset.viewsize),0);
		 fread(&flag,sizeof(flag),1,dwgptr);
		 fread(&name,sizeof(name),1,dwgptr);
		 fprintf(dxfout,"\nVIEW\n  2\n%s\n 70\n%6d",name,flag);
		 fread(&viewvals,sizeof(viewvals),1,dwgptr);
		 fprintf(dxfout,"\n 40\n%6lf\n 10\n%6lf\n 20\n%6lf\n 41\n%6lf",viewvals.g40,viewvals.g10,viewvals.g20,viewvals.g41);
		 fprintf(dxfout,"\n 11\n%6lf\n 21\n%6lf\n 31\n%6lf\n  0",viewvals.g11,viewvals.g21,viewvals.g31);
                 }
               fprintf(dxfout,"\nENDTAB");
	       return(1);
	   } /* end views */

/* this program does not support deeply nested or real large blocks */

int blocks(transflag)
int transflag;
	{       char name[32];
		unsigned char bflag;
                int v,go,what;
		int bcount = 0;
                long  there;
                FLAGS flag;

		v = 0;
                fprintf(dxfout,"\n  0\nSECTION\n  2\nBLOCKS\n  0");
	     for(v = 0; v < offset.numblocks; v++){
		blcknames[v] = (char *)calloc(1,32);
		if(!blcknames[v]){
		   printf("\nerror : memory request failed : blcknames");
		   exit(1);}
		fseek(dwgptr,offset.blocktable + (v * offset.blocksize)+1,0);
		fread(blcknames[v],32,1,dwgptr);
		   if(! strnicmp(blcknames[v], "\*",1)){
		       itoa(bcount,name,10);
		       strcat(blcknames[v], name);
		       bcount++;}}

		for(v = 0; v < offset.numblocks; v++){
		 fseek(dwgptr,offset.blocktable + (v * offset.blocksize),0);
                 fread(&bflag,sizeof(bflag),1,dwgptr);
		 fread(&name,32,1,dwgptr);
		 fread(&go,sizeof(go),1,dwgptr);
		 fread(&what,sizeof(what),1,dwgptr);
                 fseek(dwgptr,offset.blockdefs + go,0);
                 fread(&flag,sizeof(FLAGS),1,dwgptr);
		 fprintf(dxfout,"\nBLOCK\n  8\n%s\n  2\n%s\n 70\n%6d",laynames[(int)flag.layer],blcknames[v],bflag);
                 there = offset.blockdefs + go;
                 scan_entities(there,transflag);
                 fprintf(dxfout,"\n  8\n%s\n  0",laynames[(int)flag.layer]);
              }
       fprintf(dxfout,"\nENDSEC");
      return(1);
	} /* end of blocks */




int chck_version()
	{

	     if((dwgptr = fopen(searchptr, "rb")) == NULL)
	       {cprintf("\n\nCannot open file %s",searchptr);
		cprintf("\nPress any key to continue");
		getch();
		return(0);
	        }

             else
		{ fread(&version, sizeof(version), 1 , dwgptr);
		  if (strnicmp((char *)&version, "AC1002", 6))
				 return(1);
		      else

				return(0);}

	}

/* this program really only works well with 2.6 and R9 AutoCAD */
/* if you want to go back further roll up your sleaves and go to work */

int verstop()
	{
                if(! strnicmp((char *)&version, "AC1003",6) ||
		   ! strnicmp((char *)&version, "AC1004",6)){

		if (strnicmp((char *)&version, "AC1004",6))
				return(103);
			  else
				return(MAX_VARS);   }
	 return(0);
	}


/* defines modified 3/27/86 mal  */

#define CHECK     1
#define COMP      0x02
#define NORMAL	  0x0
#define BYFLAG    0x03
#define ZFLAGS    0x0c
#define DELETED   0x80

#define ROTATION  0x01
#define GROUP51   0x04
#define GROUP41   0x02
#define FONTNAME  0x08
#define GROUP72   0x20
#define MIRROR    0x10

#define XSCALE    0x01
#define YSCALE    0x02
#define BLKROT    0x04
#define ZSCALE    0x08
#define COLUMN    0x10
#define ROW       0x20
#define COLCOORD  0x40
#define ROWCOORD  0x80

#define AMIRROR   0x20
#define ATROT     0x02
#define TXTJUST   0xc0
#define OBLIQ     0x08
#define ATFONT    0x10
#define AGROUP51  0x08
#define AGROUP41  0x04

#define PLSTARTW  0x01
#define PLENDW    0x02
#define BULGE     0x04

#define SROTATION 0x01
#define LASTBYTE  0x02
#define SGROUP41  0x04
#define SGROUP51  0x08

#define Z1        0x01
#define Z2        0x02
#define Z3        0x04
#define Z4        0x08

#define G1222     0x01
#define G70       0x02
#define G1        0x04
#define G1424     0x08
#define G1323     0x10
#define G1626     0x40
#define G1525     0x20
#define G50       0x01
#define G40       0x80

/* for this version of RETRIEVER a big case statement serves our purpose well */

long scan_entities(begin,how)
long begin;
int how;
	{
		struct {
			  double x;
			  double y;
			  double rx;
			  double stx;
			  double eny;
		       } floats;
                struct {
			  double elev;
			  double thick;
		       } zfloats;
		int numfloats,numchars,atribute,txtlen,row,column,x;
		char color,*text_buff;
		unsigned char shapename,line,font;
                FLAGS flag;
		BYNUMS bynums;
		long where, seqend,we_areat;
		deleted = 0;
                x = 1;
	where = fseek(dwgptr,begin,0);
    do {

         if(how == 0){
                cur_pos(19,48,PAGE);
                cprintf("%d",x++);  }
        color = NORMAL;
	line = NORMAL;
        we_areat = ftell(dwgptr);
	fread(&flag,sizeof(FLAGS),1,dwgptr);
           if((flag.name & DELETED) != DELETED){
                      switch(flag.bits & BYFLAG){
			   case 1:
				fread(&bynums,sizeof(char),1,dwgptr);
				color = (char)bynums.bytypes[0];
				numchars = 1;
				break;

			   case 2:
				fread(&bynums,sizeof(char),1,dwgptr);
				line = (char)bynums.bytypes[0];
				numchars = 2;
				break;

			   case 3:
				fread(&bynums,2 * sizeof(char),1,dwgptr);
				color = (char)bynums.bytypes[0];
				line = (char)bynums.bytypes[1];
				numchars = 3;
				break;

		           default:
			 	break;  };

			switch(flag.bits & ZFLAGS){

			   case 4:
                                fread(&zfloats,sizeof(double),1,dwgptr);
                                numfloats = 1;
				break;

			   case 8:
				fread(&zfloats,sizeof(double),1,dwgptr);
				numfloats = 2;
				break;

			   case 12:
				fread(&zfloats,sizeof(zfloats),1,dwgptr);
				numfloats = 3;
				break;

			   default :
				break;}

/* more cases for upper nyble */

			switch(flag.name){

/* LINE's */		   case 1:
                                fread(&floats,4 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\nLINE\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
                                if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf\n 11\n%lf\n 21\n%lf\n  0",floats.x,floats.y,floats.rx,floats.stx);
				break;

/* start of a block definition should never appear in entities section */

/* START BLOCK */         case 12:
                                if(how == 2){
				  fseek(dwgptr,flag.size - sizeof(FLAGS),1);
                                  continue;}
                                atribute = 1;
                                     /* fall through to next case clever huh */
                           case 2:
/* POINT */                    fread(&floats,2 * sizeof(double),1,dwgptr);
                                if(atribute == 0)
				   fprintf(dxfout,"\nPOINT\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf\n  0",floats.x,floats.y);
			        atribute = 0;
				break;

/* CIRCLE */                case 3:
				fread(&floats,3 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\nCIRCLE\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
                                if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf\n 40\n%lf\n  0",floats.x,floats.y,floats.rx);
				break;

/* you need to load the binary shape file into memory but I */
/* won't tell you how to do that yet */
/* HINT: use a grep type program and build an array of shape names */

/* SHAPE */                 case 4:
				fprintf(dxfout,"\nSHAPE\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fread(&floats, 3 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf\n 40\n%lf",floats.x,floats.y,floats.rx);
				fread(&shapename,sizeof(shapename),1,dwgptr);
				fprintf(dxfout,"\n  2\n%s","dip14");
                                if(flag.txtflags & SROTATION){
				  fread(&floats,sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 50\n%lf",RTOD(floats.x));};
				if(flag.txtflags  & SGROUP41){
				  fread(&floats,sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 41\n%lf",floats.x);};
				if(flag.txtflags & SGROUP51) {
				  fread(&floats,sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 51\n%lf",RTOD(floats.x));};
                               if(flag.txtflags & LASTBYTE){
				  fread(&font,sizeof(font),1,dwgptr);
                        	 /* printf("\n unknown dxf entity %d",font); */ };
				fprintf(dxfout,"\n  0");
				break;

/* TEXT */                 case 7:
				fprintf(dxfout,"\nTEXT\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fread(&floats,3 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf\n 40\n%lf",floats.x,floats.y,floats.rx);
				fread(&txtlen,sizeof(txtlen),1,dwgptr);
                                text_buff = (char *) calloc(1, (txtlen + 1));
				fread(text_buff,txtlen,1,dwgptr);
				fprintf(dxfout,"\n  1\n%s",text_buff);

                                if(flag.txtflags & ROTATION){
				   fread(&floats,1 * sizeof(double),1,dwgptr);
				   fprintf(dxfout,"\n 50\n%lf",RTOD(floats.x));};
                                if(flag.txtflags & GROUP41){
				   fread(&floats,1 * sizeof(double),1,dwgptr);
				   fprintf(dxfout,"\n 41\n%lf",floats.x);};
				if(flag.txtflags & GROUP51){
				   fread(&floats,1 * sizeof(double),1,dwgptr);
				   fprintf(dxfout,"\n 51\n%lf",RTOD(floats.x));};
                                   if(flag.txtflags & FONTNAME){
				   fread(&font,sizeof(font),1,dwgptr);
				   fprintf(dxfout,"\n  7\n%s",stylenames[font]);};
				if(flag.txtflags & MIRROR){
				   fread(&font,sizeof(font),1,dwgptr);
				   fprintf(dxfout,"\n 71\n%6d",font);};
				if(flag.txtflags & GROUP72){
				   fread(&font,sizeof(font),1,dwgptr);
				   fprintf(dxfout,"\n 72\n%6d",font);
				   fread(&floats, 2 * sizeof(double),1,dwgptr);

				   fprintf(dxfout,"\n 11\n%lf\n 21\n%lf",floats.x,floats.y);};
				fprintf(dxfout,"\n  0");
                                   break;

/* ARC */		    case 8:
				fread(&floats,sizeof(floats),1,dwgptr);
				fprintf(dxfout,"\nARC\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf\n 40\n%lf\n 50\n%lf\n 51\n%lf\n  0",floats.x,floats.y,floats.rx,RTOD(floats.stx),RTOD(floats.eny));
				break;

/* TRACE */		   case 9:
				fread(&floats,4 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\nTRACE\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf\n 11\n%lf\n 21\n%lf",floats.x,floats.y,floats.rx,floats.stx);
				fread(&floats,4 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 12\n%lf\n 22\n%lf\n 13\n%lf\n 23\n%lf\n  0",floats.x,floats.y,floats.rx,floats.stx);
				break;

/* SOLID */		   case 11:
				fread(&floats,4 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\nSOLID\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
                                if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf\n 11\n%lf\n 21\n%lf",floats.x,floats.y,floats.rx,floats.stx);
				fread(&floats,4 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 12\n%lf\n 22\n%lf\n 13\n%lf\n 23\n%lf\n  0",floats.x,floats.y,floats.rx,floats.stx);
				break;

/* does not take into account blocks with */
/* elevations or thicknesses again only found in block section */

/* ENDBLOCK */ 		   case 13:
                                if(how < 2){
                                fprintf(dxfout,"\nENDBLK");
				return(1);}
                                fseek(dwgptr,flag.size - sizeof(FLAGS),1);
				break;

/* INSERT */                case 14: /* watch your flag settings ACAD is real fussy */
				fprintf(dxfout,"\nINSERT\n  8\n%s",laynames[(int)flag.layer]);
				if(flag.bits & 0x80)
				  fprintf(dxfout,"\n 66\n      1");
                                if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
                                if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
                                fread(&font,sizeof(font),1,dwgptr);
				fprintf(dxfout,"\n  2\n%s",blcknames[(int)font]);
                                fread(&font,sizeof(font),1,dwgptr);
				fread(&floats,2 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf",floats.x,floats.y);
                                if(flag.txtflags & XSCALE){
				  fread(&floats, sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 41\n%lf",floats.x);};
				if(flag.txtflags & YSCALE){
				  fread(&floats,sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 42\n%lf",floats.x);};
				if(flag.txtflags & BLKROT){
				  fread(&floats,sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 50\n%lf",RTOD(floats.x));};
				if(flag.txtflags & ZSCALE){
				  fread(&floats,sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 43\n%lf",floats.x);};
                                if(flag.txtflags & COLUMN){
				  fread(&column,sizeof(column),1,dwgptr);
				  fprintf(dxfout,"\n 70\n%6d",column);};
				if(flag.txtflags & ROW){
				  fread(&row,sizeof(row),1,dwgptr);
				  fprintf(dxfout,"\n 71\n%6d",row);};
				if(flag.txtflags & COLCOORD){
				  fread(&floats, sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 44\n%lf",floats.x);};
				if(flag.txtflags & ROWCOORD){
				  fread(&floats,sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 45\n%lf",floats.x);};
				fprintf(dxfout,"\n  0");
                                break;

/* ATTRIBUTE'S and ATTDEF'S */
/* failing through  the case is the only way to go */

                            case 15:
                                atribute =  2;

			    case 16:
				fread(&floats,3 * sizeof(double),1,dwgptr);
                       if(atribute == 2)
				fprintf(dxfout,"\nATTDEF\n  8\n%s",laynames[(int)flag.layer]);
		       else
				fprintf(dxfout,"\nATTRIB\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf\n 40\n%lf",floats.x,floats.y,floats.rx);
				fread(&txtlen,sizeof(txtlen),1,dwgptr);
				text_buff = (char *) calloc(1, (txtlen + 1));
				fread(text_buff,txtlen,1,dwgptr);
				fprintf(dxfout,"\n  1\n%s",text_buff);
                         if(atribute == 2){
                                fread(&txtlen,sizeof(txtlen),1,dwgptr);
				text_buff = (char *) calloc(1, (txtlen + 1));
				fread(text_buff,txtlen,1,dwgptr);
				fprintf(dxfout,"\n  3\n%s",text_buff);};

				fread(&txtlen,sizeof(txtlen),1,dwgptr);
				text_buff = (char *) calloc(1, (txtlen + 1));
                                fread(text_buff,txtlen,1,dwgptr);
				fprintf(dxfout,"\n  2\n%s",text_buff);
                                fread(&font,sizeof(font),1,dwgptr);
				fprintf(dxfout,"\n 70\n%6d",font);
                                if(flag.txtflags & ATROT){
				   fread(&floats,sizeof(double),1,dwgptr);
				   fprintf(dxfout,"\n 50\n%lf",RTOD(floats.x));};
				if(flag.txtflags & AGROUP41){
				   fread(&floats,sizeof(double),1,dwgptr);
				   fprintf(dxfout,"\n 41\n%lf",floats.x);};
                                if(flag.txtflags & AGROUP51){
				  fread(&floats,sizeof(double),1,dwgptr);
				  fprintf(dxfout,"\n 51\n%lf",RTOD(floats.x));};
                                if(flag.txtflags & ATFONT){
				  fread(&font,sizeof(font),1,dwgptr);
				  fprintf(dxfout,"\n  7\n%s",stylenames[font]);};
                                if(flag.txtflags & AMIRROR){
				  fread(&font,sizeof(font),1,dwgptr);
				  fprintf(dxfout,"\n 71\n%6d",font);};
                                if(flag.txtflags & TXTJUST){
				   fread(&font,sizeof(char),1,dwgptr);
				   fread(&floats,2 * sizeof(double),1,dwgptr);
				   fprintf(dxfout,"\n 72\n%6d",font);
				   fprintf(dxfout,"\n 11\n%lf\n 21\n%lf",floats.x,floats.y);};
                                atribute = 0;
				fprintf(dxfout,"\n  0");
				break;

/* picture the way you would have to step through polylines with AutoLISP */
/* and the rest is easy */
/* SEQEND */		   case 17:
				 fread(&seqend,sizeof(seqend),1,dwgptr);
				 fprintf(dxfout,"\nSEQEND\n  8\n%s",laynames[(int)flag.layer]);
				 if(numchars == 1)
				   fprintf(dxfout,"\n 62\n%6d",color);
				 if(numchars == 2)
				   fprintf(dxfout,"\n  6\n%s",linenames[line]);
				 if(numchars == 3)
				   fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				 if(numfloats == 1)
				   fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				 if(numfloats == 2)
				   fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				 if(numfloats == 3)
				   fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				 fprintf(dxfout,"\n   0");
				 break;

/* psuedo entities will have to remain a trade */
/* secret for a while.  If the drawing is */
/* regened first you will have no trouble */
/* you could just fall through to case 19 and it will work with */
/* 9 out of 10 typical drawings */

/* PSUEDO */               case 18:
                                 fseek(dwgptr,flag.size - sizeof(FLAGS),1);
				 break;  /* Top secret */

/* POLYLINE */            case 19:
				 fprintf(dxfout,"\nPOLYLINE\n  8\n%s",laynames[(int)flag.layer]);
				 if(numchars == 1)
				   fprintf(dxfout,"\n 62\n%6d",color);
				 if(numchars == 2)
				   fprintf(dxfout,"\n  6\n%s",linenames[line]);
				 if(numchars == 3)
				   fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				 if(numfloats == 1)
				   fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				 if(numfloats == 2)
				   fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				 if(numfloats == 3)
				   fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				   fprintf(dxfout,"\n 66\n     1");
                                 if(flag.txtflags & 0x01){
                                   fread(&font,sizeof(font),1,dwgptr);
				   fprintf(dxfout,"\n 70\n%6d",font);};
				 if(flag.txtflags & 0x02){
				    fread(&floats,sizeof(double),1,dwgptr);
				    fprintf(dxfout,"\n 40\n%lf",floats.x);};
				 if(flag.txtflags & 0x04){
				    fread(&floats,sizeof(double),1,dwgptr);
				    fprintf(dxfout,"\n 41\n%lf",floats.x);};
				 if(flag.txtflags & 0x08){
				    fread(&floats,sizeof(double),1,dwgptr);
				    fprintf(dxfout,"\n 42\n%lf",floats.x);};
				 fprintf(dxfout,"\n  0");
				 break;

/* VERTEX */		   case 20:
				 fprintf(dxfout,"\nVERTEX\n  8\n%s",laynames[(int)flag.layer]);
				 if(numchars == 1)
				   fprintf(dxfout,"\n 62\n%6d",color);
				 if(numchars == 2)
				   fprintf(dxfout,"\n  6\n%s",linenames[line]);
				 if(numchars == 3)
				   fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				 if(numfloats == 1)
				   fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				 if(numfloats == 2)
				   fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				 if(numfloats == 3)
				   fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				 fread(&floats,2 * sizeof(double),1,dwgptr);
				 fprintf(dxfout,"\n 10\n%lf\n 20\n%lf",floats.x,floats.y);
                                 if(flag.txtflags & PLSTARTW){
				   fread(&floats,sizeof(double),1,dwgptr);
				   fprintf(dxfout,"\n 40\n%lf",floats.x);};
				 if(flag.txtflags & PLENDW){
				   fread(&floats,sizeof(double),1,dwgptr);
				   fprintf(dxfout,"\n 41\n%lf",floats.x);};
				 if(flag.txtflags & BULGE){
				   fread(&floats,sizeof(double),1,dwgptr);
				   fprintf(dxfout,"\n 42\n%lf",floats.x);};
                                 if(flag.txtflags & 0x08){
				    fread(&font,sizeof(font),1,dwgptr);
				    fprintf(dxfout,"\n 70\n%6d",font);};
				 if(flag.txtflags & 0x10){
				    fread(&floats,sizeof(double),1,dwgptr);
				    fprintf(dxfout,"\n 50\n%lf",RTOD(floats.x));};
				fprintf(dxfout,"\n  0");
                                break;

/* HINT: release 10 the more things change the more they stay the same */

/* 3dFACE's and 3dLINE's */ case 22:
				atribute = 1;
				fprintf(dxfout,"\n3DFACE\n  8\n%s",laynames[(int)flag.layer]);

			  case 21:

                                if(atribute == 0){
	 			   printf("\n3dLINE");
                                   fprintf(dxfout,"\n3DLINE\n  8\n%s",laynames[(int)flag.layer]);}
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
                                fread(&floats,2 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 10\n%lf\n 20\n%lf",floats.x,floats.y);
				if(flag.txtflags & Z1){
				        fread(&floats,sizeof(double),1,dwgptr);
				        fprintf(dxfout,"\n 30\n%lf",floats.x); }
				fread(&floats,2 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 11\n%lf\n 21\n%lf",floats.x,floats.y);
				if(flag.txtflags & Z2){
				        fread(&floats,sizeof(double),1,dwgptr);
				        fprintf(dxfout,"\n 31\n%lf",floats.x);}
                                 if(atribute == 1){
				     fread(&floats,2 * sizeof(double),1,dwgptr);
                                     fprintf(dxfout,"\n 12\n%lf\n 22\n%lf",floats.x,floats.y);
                                       if(flag.txtflags & Z3){
                                         fread(&floats,sizeof(double),1,dwgptr);
                                         fprintf(dxfout,"\n 32\n%lf",floats.x);}
                                     fread(&floats,2 * sizeof(double),1,dwgptr);
                                     fprintf(dxfout,"\n 13\n%lf\n 23\n%lf",floats.x,floats.y);
                                       if(flag.txtflags & Z4){
                                         fread(&floats,sizeof(double),1,dwgptr);
                                         fprintf(dxfout,"\n 33\n%lf",floats.x);}}
				atribute = 0;
				fprintf(dxfout,"\n  0");
				break;

/* DIMENSION's  only when associative dimensioning is turned on */

                          case 23:
                                fprintf(dxfout,"\nDIMENSION\n  8\n%s",laynames[(int)flag.layer]);
				if(numchars == 1)
				  fprintf(dxfout,"\n 62\n%6d",color);
				if(numchars == 2)
				  fprintf(dxfout,"\n  6\n%s",linenames[line]);
				if(numchars == 3)
				  fprintf(dxfout,"\n  6\n%s\n 62\n%6d",linenames[line],color);
				if(numfloats == 1)
				  fprintf(dxfout,"\n 38\n%lf",zfloats.elev);
				if(numfloats == 2)
				  fprintf(dxfout,"\n 39\n%lf",zfloats.elev);
				if(numfloats == 3)
				  fprintf(dxfout,"\n 38\n%lf\n 39\n%lf",zfloats.elev,zfloats.thick);
				fread(&txtlen,sizeof(txtlen),1,dwgptr);
				 fprintf(dxfout,"\n  2\n%s",blcknames[txtlen]);
				fread(&floats,2 * sizeof(double),1,dwgptr);
				 fprintf(dxfout,"\n 10\n%lf\n 20\n%lf",floats.x,floats.y);
				fread(&floats,2 * sizeof(double),1,dwgptr);
				 fprintf(dxfout,"\n 11\n%lf\n 21\n%lf",floats.x,floats.y);
			     if(flag.txtflags & G1222){
				fread(&floats,2 * sizeof(double),1,dwgptr);
				 fprintf(dxfout,"\n 12\n%lf\n 22\n%lf",floats.x,floats.y);}
			     if(flag.txtflags & G70){
				fread(&shapename,sizeof(shapename),1,dwgptr);
				 fprintf(dxfout,"\n 70\n%6d",shapename);}
			     if(flag.txtflags & G1){
				fread(&txtlen,sizeof(txtlen),1,dwgptr);
				text_buff = (char *)calloc(1,(txtlen + 1));
				fread(text_buff,txtlen,1,dwgptr);
				fprintf(dxfout,"\n  1\n%s",text_buff);}
			     if(flag.txtflags & G1323){
				fread(&floats,2 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 13\n%lf\n 23\n%lf",floats.x,floats.y);}
                             if(flag.txtflags & G1424){
				fread(&floats,2 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 14\n%lf\n 24\n%lf",floats.x,floats.y);}
			     if(flag.txtflags & G1525){
				fread(&floats,2 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 15\n%lf\n 25\n%lf",floats.x,floats.y);}
			     if(flag.txtflags & G1626){
				fread(&floats,2 * sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 16\n%lf\n 26\n%lf",floats.x,floats.y);}
                             if(flag.txtflags & G40){
				fread(&floats,sizeof(double),1,dwgptr);
                                fprintf(dxfout,"\n 40\n%lf",floats.x);}
			     if(flag.unk2 & G50){
				fread(&floats,sizeof(double),1,dwgptr);
				fprintf(dxfout,"\n 50\n%lf",RTOD(floats.x));}
                                fprintf(dxfout,"\n  0");
				break;
/* That's all folks */
/* some pretty impressive drawings are created */
/* with only a handful of entities */

			  default :
				cprintf("\n\n\nfatal error : in flag->name = %x at %lx ",flag.name,ftell(dwgptr));
				fprintf(dxfout,"\nENDSEC\n  0\nEOF");
                                if(how == 0){
				    cprintf(" : %lx\n\n",ftell(dwgptr));
                                    fclose(dwgptr);
				    fclose(dxfout);
				    cprintf("\nPartial dxf written");
				    exit(1);}
				  else
				    return(we_areat);
				break;}




                where = ftell(dwgptr);}
      else {

	 fseek(dwgptr,flag.size - sizeof(FLAGS),1);  /* skip over deleted entities */
         deleted++;}                                 /* a super undo would be fun  */
        } while(where != offset.blocktable );        /* the block table starts right after */
    fprintf(dxfout,"\nENDSEC");                      /* the entity section : if file recovery */
    return(where);                                   /* were only this simple */

      }   /* end of function definition  */


/*  I bet now you wish you never got involved with .dwg files  */



