; DLOG.LSP - Version 1.0
; By Jamie Clay
; For Release 9 and 10.
; This is a routine that demonstrates the usage of DDATTE to create
; custom dialogue boxes.  My goal with this program was to show a new way
; to enhance your lisp routine interface.  This example allows you to build
; a dialogue box for setting any number of system variables.
;
; Commands: DLOG and MAKEDLOG
;
; DLOG will look for a block in your drawing called $DIALOGUE$. If it
; fails to find it, DLOG will call the MAKEDLOG command.  If the block is
; in the drawing, DLOG will display the defined system variables in an
; EDIT ATTRIBUTE dialogue box.
;
; When you set the variables and click OK, DLOG will read the new settings and
; check to make sure you entered an acceptable value. If not DLOG will
; set the value to the current default.
;
; Because the DDATTE command must be called to perform this task, you can
; not use DLOG transparently.
;
; NOTE: Even if you hit CANCEL the routine checks the values. I welcome any
;       ideas on how to avoid this.
;
; MAKEDLOG will prompt you for the system variables you wish to have in the
; dialogue box. If $DIALOGUE$ is already in the drawing MAKEDLOG will erase
; the current block and redefine it to use whatever new system variables you
; would like to display.
; Command prompt:
; > System variable to include :
;
; Enter all the variables you like, a blank line will complete the process.
; After the new block is created, the routine will call the DLOG command with
; the default settings based on the current system variable values.
;
; HACKERS NOTES:
; DLOG is not designed to cover ALL the system variables and you will
; discover that READ ONLY, STRING and REAL NUMBER system variables will not
; bet set with the routine.  "Read Only Integers" will crash the routine. An
; example of a ROI is the system var HANDLES.
;
; Though I put a few error traps in this routine you can still give it goofy
; information.
;
; DLOG.lsp will not stay loaded if you don't have AUI display. That's life, it
; only works with AUI displays.
;
; Have fun.
;===========================================================================
;
; DLOG - This reads the block and edits the SysVars
(defun c:dlog (/ val dblk att sysvar attlist)
  (setvar "cmdecho" 0)
  (setq dblk (ssget "x" '((2 . "$DIALOGUE$")))) ; see if block exists
  (if dblk                                   ; If the block is, edit it.
    (progn
      (setq dblk (ssname dblk 0))            ; Take the block from the SSGET
      (command "ddatte" dblk)                ; DDATTE the block
      (setq att (entnext dblk))              ; Get the first attribute
      (while (= (getass 0 att) "ATTRIB")     ; Do while items are attributes
        (setq sysvar (getass 2 att))         ; Get variable to set
        (setq val (read (getass 1 att)))     ; Get new value
        (if (= (type val) 'INT)              ; Check and see if valid info
          (if (/= (getvar sysvar) val)       ; If no change don't reset
            (progn
              (setvar sysvar val)            ; Reset system variable
              (if (/= (getvar sysvar) val)   ; If display is different
                (update 0)                   ; Update the display
              )
            )
          )
          (progn
            (setq val (getvar sysvar))
            (update 1)                       ; Correct the display
          )
        )
        (setq att (entnext att))             ; On to the next attribute
      )
    )
    (c:makedlog)                             ; Make the block if not there
  )
  (setvar "cmdecho" 1)
  (princ)                                    ; All done
)

; MAKEDLOG - creates the block

(defun c:makedlog (/ syspair syslist val reject)
  (setvar "cmdecho" 0)
  (setq dblk (ssget "x" '((2 . "$DIALOGUE$"))))  ; See if block exists
  (if dblk (command "erase" dblk ""))            ; Erase it if it does
  (setq sysvar 1)
  (while sysvar
    (setq sysvar (getstring "\nSystem variable to include :"))
    (if (= sysvar "")
      (setq sysvar nil)
      (progn
        (if (setq val (getvar sysvar))           ; See if it is a SysVar
          (setq syspair (cons sysvar val))       ; Make a dotted pair
          (progn
            (Prompt (strcat "\n" (strcase sysvar) " is not recognized."))
            (setq reject 1)                      ; Set reject flag
          )
        )
        (if reject
          (setq reject nil)
          (if syslist                            ; Create a list of SysVars
            (if (not (member syspair syslist))   ; Check if redundant
              (setq syslist (append syslist (list syspair)))
              (prompt "\n<Duplicate>")
            )
            (setq syslist (list syspair))        ; Add pair to list
          )
        )
      )
    )
  )
  (setq count (length syslist))                   ; Determine how many
  (setvar "texteval" 1)                           ; Turn on text eval
  (setvar "attmode" 0)                            ; Turn off att display
  (setq num 0)
  (setq atts (ssadd))                             ; Create selection set
  (repeat count                                   ; Make the ATTs
    (setq prmpt (car (nth num syslist)))          ; set tag and prompt
    (setq num (1+ num))                           ; nth advance
    (setq value  (cdr (assoc prmpt syslist)))     ; set value
    (command "attdef" "" prmpt prmpt value "0,0" ".0001" "") ; Insert Att.
    (setq atts (ssadd (entlast) atts))            ; add to selection set
  )
  (if (tblsearch "block" "$DIALOGUE$")  ; See if the block has been defined
    (command "block" "$DIALOGUE$" "Y" "0,0" atts "") ; redefine block
    (command "block" "$DIALOGUE$" "0,0" atts "")     ; create block
  )
  (setq attset (getvar "attreq"))
  (setvar "attreq" 0)                            ; Turn Att prompt off
  (command "insert" "$dialogue$" "0,0" "" "" "") ; Insert block
  (setvar "attreq" attset)
  (c:dlog)                             ; Go back to DDSMODE
)

;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;
; Function to get an ASSoc of an entity
(defun getass (x y)
  (cdr (assoc x (entget y)))
)

; Update the value if not accepted by the system variable
(defun update (x)
  (if (= x 0)
    (setq attlist (subst (cons 1 (rtos (getvar sysvar)2 0))
                     (cons 1 (getass 1 att)) (entget att)))
    (setq attlist (subst (cons 1 (getvar sysvar))
           (cons 1 (getass 1 att)) (entget att)))
  )
  (entmod attlist)
)

; Goof trap
(defun *error* (x)
  (princ x)
  (if (= x  "AutoCAD rejected function")
    (prompt (strcat " - " (strcase sysvar) " is a ROI!"))
  )
  (princ)
)

; Shut down the show - No AUI no DLOG
(if (= (getvar "popups") 0)
  (progn
    (Prompt "\nSorry, \nDLOG only works with AUI displays.")
    (setq c:dlog nil c:makedlog nil)
  )
  (prompt "\nC:DLOG & C:MAKEDLOG - Loaded !")
)
(princ)