;*************************************************************************
;
;  DLEADERS.LSP          Copyright (c) 1994 - DesignTec
;  Version 1.2                               255 Celia St.
;                                            Boaz, AL 35957
;                                            (205) 593-7789
;
;  LAST REVISION:  12-28-94
;
;
;  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESSED OR IMPLIED
;  WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;  PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;
;*************************************************************************
;
;  DESCRIPTION
;
;  A user friendly dialog box based set of utilities to draw leader tags
;  with user definable text boxes and arrows.
;
;*************************************************************************
;
;  ACCOMPANYMENTS
;
;  The following slide files should be located in a directory that is in
;  the standard Autocad search path:
;
;  DLEADERS.SLB
;
;  The following blocks should be located in a directory that is in the
;  standard Autocad search path:
;
;  DLEADERS.DWG
;
;  The following dialog control language (*.DCL) file should be located in
;  a directory that is in the standard Autocad search path:
;                
;  DLEADERS.DCL
;
;*************************************************************************
;;
;;      SETUP ROUTINE
;;
(defun C:DL_SETUP ( / ARROW_T TXTBOX_T DIRECT_T)
  (alert "\n    DLEADERS Version 1.2\nUNREGISTERED EVALUATION COPY\n      Please Register!")
  (alert "\nDesignTec\n255 Celia St.\nBoaz, Alabama 35957\n205 593-7789")
  (dl_init_stuf)
  (setq DCL_ID (load_dialog "DLEADERS.DCL"))
  (if (not (new_dialog "DLEADERS" DCL_ID)) (exit))
  (dl_tile_setup)
  (dl_get_actions)
  (start_dialog)
  (unload_dialog DCL_ID)
  (princ)
)
;;
;;
(defun dl_init_stuf ()
  (setq what_next 5)
  (if (= (tblsearch "block" "dleaders") nil)
    (command "insert" "dleaders" "0,0" "" "" "")
  )
  (if (= ARROW nil) (setq ARROW "ar_none") (setq ARROW_T ARROW))
  (if (= TXTBOX nil) (setq TXTBOX "tx_none") (setq TXTBOX_T TXTBOX))
  (if (= DIRECT nil) (setq DIRECT "from_feat") (setq DIRECT_T DIRECT))
;  (setq AR_SIZE_T AR_SIZE)
;  (setq TX_SIZE_T TX_SIZE)
)
;;
;;
(defun dl_tile_setup ()
  (set_tile "arrow" ARROW)
  (set_tile "text_box" TXTBOX)
  (set_tile "direction" DIRECT)
  (setq X (dimx_tile "image"))
  (setq Y (dimy_tile "image"))

  (dl_show_slide)
;  (set_tile "ar_size" AR_SIZE)
;  (set_tile "tx_size" TX_SIZE)
)
;;
;;
(defun dl_get_actions ()
  (action_tile "arrow" "(setq ARROW $value) (dl_show_slide)")
  (action_tile "text_box" "(setq TXTBOX $value) (dl_show_slide)")
  (action_tile "direction" "(setq DIRECT $value) (dl_show_slide)")
;  (action_tile "ar_size" "(setq AR_SIZE $value) (dl_show_slide)")
;  (action_tile "tx_size" "(setq TX_SIZE $value) (dl_show_slide)")
  (action_tile "cancel" "(leader_abort)")
)         
;;
;;
(defun leader_abort ()
  (setq ARROW ARROW_T)
  (setq TXTBOX TXTBOX_T)
  (setq DIRECT DIRECT_T)
;  (setq AR_SIZE AR_SIZE_T)
;  (setq TX_SIZE TX_SIZE_T)
  (exit)
  (princ)
)
;;
;;
(defun dl_show_slide ( / AR TX DR)
  (cond
    ((= ARROW "ar_none") (setq AR "0_"))
    ((= ARROW "ar_tic") (setq AR "1_"))
    ((= ARROW "ar_arc1") (setq AR "2_"))
    ((= ARROW "ar_arc2") (setq AR "3_"))
    ((= ARROW "ar_mech") (setq AR "4_"))
    ((= ARROW "ar_dot") (setq AR "5_"))
  )
  (cond
    ((= TXTBOX "tx_none") (setq TX "0_"))
    ((= TXTBOX "tx_circ") (setq TX "1_"))
    ((= TXTBOX "tx_sqar") (setq TX "2_"))
    ((= TXTBOX "tx_dmnd") (setq TX "3_"))
    ((= TXTBOX "tx_hex") (setq TX "4_"))
    ((= TXTBOX "tx_elps") (setq TX "5_"))
  )
  (cond
    ((= DIRECT "from_feat") (setq DR "1"))
    ((= DIRECT "from_txt") (setq DR "2"))
  )
  (setq SLIDE (strcat "DLEADERS(" AR TX DR ")"))
  (start_image "image")
  (fill_image 0 0 X Y -2)
  (slide_image 0 0 X Y SLIDE)
  (end_image)
)
;;
;;      MAIN ROUTINE
;;
(defun C:DLD ( / ORX SNX SZE RAD PA PB PC MRK NONE)
  (cond
    ((= ARROW nil) (C:DL_SETUP))
    ((= TXTBOX nil) (C:DL_SETUP))
    ((= DIRECT nil) (C:DL_SETUP))
  )
  (if (= DIRECT "from_feat")
  
    (progn  (setvar "cmdecho" 0)
            (setq ORX (getvar "orthomode"))
            (setq SNX (getvar "snapmode"))
            (setq SZE (getvar "TEXTSIZE"))
            (setq RAD (+ SZE (/ SZE 4.0)))
            (setvar "snapmode" 0)
            (setvar "orthomode" 0)
            (setq PA (getpoint "\nStart of Leader < at Feature > : "))
            (setq PB (getpoint PA "\nEnd of Leader Leg : "))
            (command "line" PA PB "")
            (setvar "orthomode" 1)
            (setq PC (getpoint PB "\nEnd of Leader < at Text Location > : "))
            (command "line" PB PC "")
            (setq MRK (getstring "\nEnter Text < two characters only > : "))
            (cond
              ((= ARROW "ar_none") (setq NONE 1))
              ((= ARROW "ar_tic") (command "insert" "ar_tic" PA SZE SZE PB))
              ((= ARROW "ar_arc1") (command "insert" "ar_arc1" PA SZE SZE PB))
              ((= ARROW "ar_arc2") (command "insert" "ar_arc2" PA SZE SZE PB))
              ((= ARROW "ar_mech") (command "insert" "ar_mech" PA SZE SZE PB))
              ((= ARROW "ar_dot") (command "insert" "ar_dot" PA SZE SZE PB))
            )   
            (cond 
              ((= TXTBOX "tx_none") (draw_tx_none))
              ((= TXTBOX "tx_circ") (draw_tx_circ))
              ((= TXTBOX "tx_sqar") (draw_tx_sqar))
              ((= TXTBOX "tx_dmnd") (draw_tx_dmnd))
              ((= TXTBOX "tx_hex") (draw_tx_hex))
              ((= TXTBOX "tx_elps") (draw_tx_elps))
            )
            (command "text" "m" PC "" "0" MRK)
            (setvar "snapmode" SNX)
            (setvar "orthomode" ORX)
    )       
    (progn  (setvar "cmdecho" 0)
            (setq ORX (getvar "orthomode"))
            (setq SNX (getvar "snapmode"))
            (setq SZE (getvar "TEXTSIZE"))
            (setq RAD (+ SZE (/ SZE 4.0)))
            (setvar "snapmode" 0)
            (setvar "orthomode" 1)
            (setq PC (getpoint "\nStart of Leader < at Text Location > : "))
            (setq PB (getpoint PC "\nEnd of Leader Leg : "))
            (command "line" PC PB "")
            (setvar "orthomode" 0)
            (setq PA (getpoint PB "\n End of Leader < at Feature > : "))
            (command "line" PB PA "")
            (setq MRK (getstring "\nEnter Text < two characters only > : "))
            (cond
              ((= ARROW "ar_none") (setq NONE 1))
              ((= ARROW "ar_tic") (command "insert" "ar_tic" PA SZE SZE PB))
              ((= ARROW "ar_arc1") (command "insert" "ar_arc1" PA SZE SZE PB))
              ((= ARROW "ar_arc2") (command "insert" "ar_arc2" PA SZE SZE PB))
              ((= ARROW "ar_mech") (command "insert" "ar_mech" PA SZE SZE PB))
              ((= ARROW "ar_dot") (command "insert" "ar_dot" PA SZE SZE PB))
            )            
            (cond 
              ((= TXTBOX "tx_none") (draw_tx_none))
              ((= TXTBOX "tx_circ") (draw_tx_circ))
              ((= TXTBOX "tx_sqar") (draw_tx_sqar))
              ((= TXTBOX "tx_dmnd") (draw_tx_dmnd))
              ((= TXTBOX "tx_hex") (draw_tx_hex))
              ((= TXTBOX "tx_elps") (draw_tx_elps))
            )
            (command "text" "m" PC "" "0" MRK)
            (setvar "snapmode" SNX)
            (setvar "orthomode" ORX)
    )
  )
  (princ)
)
;;
;;      END MAIN ROUTINE
;;
(defun  draw_tx_none ()
  (command "circle" PC RAD)
  (command "trim" "l" "" PC "")
  (command "erase" "l" "")
)    
;;
;;
(defun draw_tx_circ ()
  (command "circle" PC RAD)
  (command "trim" "l" "" PC "")
)
;;
;;
(defun draw_tx_sqar ()
  (command "polygon" "4" PC "C" RAD)
  (command "trim" "l" "" PC "")
)
;;
;;
(defun draw_tx_dmnd ()
  (command "polygon" "4" PC "c" RAD)
  (command "rotate" "l" "" PC "45")
  (command "trim" "l" "" PC "")
)
;;
;;
(defun draw_tx_hex ()
  (command "polygon" "6" PC "c" RAD)
  (command "trim" "l" "" PC "")
)
;;
;;
(defun draw_tx_elps ( / EX EY EX1 EX2 EPNT1 EPNT2)
  (setq EX (car PC))
  (setq EY (car (cdr PC)))
  (setq EX1 (- EX (* SZE 1.5)))
  (setq EX2 (+ EX (* SZE 1.5)))
  (setq EPNT1 (list EX1 EY))
  (setq EPNT2 (list EX2 EY))
  (command "ellipse" EPNT1 EPNT2 SZE)
  (command "trim" "l" "" PC "")
)
;;
;;
 
