;|             ͻ
                            DEBUG.LSP             
                          Michael Weaver          
                         2175 George Road         
                     Fairbanks, Alaska 99712      
                   (907)488-3577 voice and fax    
                     Compuserve ID 71461,1775     
                          Fri 12-16-1994          
               ͼ

This routine can be used to debug lisp routines.
Place a call to the *break* function within the code being debugged.
Setq *test* to a non-nil value and then run the routine.  When the
call to *break* is reached the program will pause, displaying a user
specified prompt, and allow the user to find the values of variables
as they exist in the program at that time.

Example program to test.

  (defun c:testdebug( / b c)
   (*break* "Prior to first setq. ")
   (setq
    b 17
    c 25
   )
   (*break* "After first setq. ")
   (setq
    b (- b 5)
    c (/ c 5)
   )
   (*break* "After second setq. ")
   (princ "c:testdebug done\n")
   (princ)
  );					end c:testdebug


Note the call to the *break* function.

Running testdebug as defined above will allow the operator to
identify the value of each of the variables at the time of the call
to the *break* function.

  Example #1:
Command testdebug
*** Breakpoint <Prior to first setq.  > press enter to resume execution ***

b
nil

*** Breakpoint <Prior to first setq.  > press enter to resume execution ***

c
nil

<enter>
*** Exiting breakpoint - resuming program execution ***
*** Breakpoint <After first setq.  > press enter to resume execution ***

b
17

*** Breakpoint <After first setq.  > press enter to resume execution ***

c
25

<enter>
*** Exiting breakpoint - resuming program execution ***
*** Breakpoint <After second setq.  > press enter to resume execution ***

b
12

*** Breakpoint <After second setq.  > press enter to resume execution ***

c
5

<enter>
*** Exiting breakpoint - resuming program execution ***
Testdebug done

Another feature of this routine is that lisp statements may be
entered.  This allows the operator to not only find the value of
variables but to also alter the value of these same variables.

  Example #2:
Command testdebug
*** Breakpoint <Prior to first setq.  > press enter to resume execution ***

b
nil

*** Breakpoint <Prior to first setq.  > press enter to resume execution ***

c
nil

<enter>
*** Exiting breakpoint - resuming program execution ***
*** Breakpoint <After first setq.  > press enter to resume execution ***

b
17

*** Breakpoint <After first setq.  > press enter to resume execution ***

(setq b 20)
20

*** Breakpoint <After first setq.  > press enter to resume execution ***

c
25

*** Breakpoint <After first setq.  > press enter to resume execution ***

(setq c 20)
20

<enter>
*** Exiting breakpoint - resuming program execution ***
*** Breakpoint <After second setq.  > press enter to resume execution ***

b
15

*** Breakpoint <After second setq.  > press enter to resume execution ***

c
4

<enter>
*** Exiting breakpoint - resuming program execution ***
Testdebug done


This routine was developed from a message thread on Compuserve.
Some portions of the *break* function were introduced on that thread
by Tony Tanzillo.

|;

(defun *break*(;		break point for debugging
  msg;				message to print upon entering breakpoint
  /;				no formal arguments
  expr;				expression to eval
  getexpr;			local function
 );				end of local variable list

 (defun GetExpr (msg)
    (initget 128)
    (getint msg)
 )
 (if *test*
  (progn
   (princ (strcat
     "\n*** Breakpoint <"
     msg
     "> press enter to resume execution ***"
    )
   )
   (while (setq expr (GetExpr "\n>> "))
    (print (eval (read expr)))
    (princ)
   )
   (princ "\n*** Exiting breakpoint - resuming program execution ***\n")
  );					end progn
 );					end if *test*
);					end *break*

