;DUCT PROGRAM
(DEFUN LRG()
 (COMMAND "DIST" P1)(GETPOINT "\nENTER NEXT POINT:")
 (COMMAND)
 (SETQ P2 (GETVAR "LASTPOINT"))
 (SETQ ZD1 (+ (ANGLE P1 P2) 0.26179938))
 (SETQ ZD2 (- (ANGLE P1 P2) 0.26179938))
 (SETQ W2B (* WW 0.5))
 (SETQ WD (- W2B W2))
 (SETQ Z (+ (ANGLE P1 P2) 1.57079633))
 (SETQ P2A (POLAR P2 (+ Z 3.14159265) W2B))
 (SETQ P2B (POLAR P2A Z WW))
 (SETQ P1D (POLAR P1B ZD1 (/ WD (SIN 0.26179938))))
 (SETQ P1C (POLAR P1A ZD2 (/ WD (SIN 0.26179938))))
 (COMMAND "LINE" P1B P1D P1C P1A)
 (COMMAND"")
 (SETQ P1 (POLAR P1C Z W2B))
 (SETQ P1A P1C)
 (SETQ P1B P1D)
 (SETQ W2 W2B)
 (SETQ W WW))

(DEFUN SML()
 (COMMAND "DIST" P1)(GETPOINT "\nENTER NEXT POINT:")
 (COMMAND)
 (SETQ P2 (GETVAR "LASTPOINT"))
 (SETQ ZD1 (+ (ANGLE P1 P2) 0.26179938))
 (SETQ ZD2 (- (ANGLE P1 P2) 0.26179938))
 (SETQ W2B (* WW 0.5))
 (SETQ Z (+ (ANGLE P1 P2) 1.57079633))
 (SETQ WD (- W2 W2B))
 (SETQ P2A (POLAR P2 (+ Z 3.14159265) W2B))
 (SETQ P2B (POLAR P2A Z WW))
 (SETQ P1D (POLAR P1B ZD2 (/ WD (SIN 0.26179938))))
 (SETQ P1C (POLAR P1A ZD1 (/ WD (SIN 0.26179938))))
 (COMMAND "LINE" P1B P1D P1C P1A)
 (COMMAND "")
 (SETQ P1 (POLAR P1C Z W2B))
 (SETQ P1A P1C)
 (SETQ P1B P1D)
 (SETQ W2 W2B)
 (SETQ W WW))

(DEFUN WIDE()
 (SETQ Z (+ (ANGLE P1 P2) 1.57079633))
 (SETQ P2A (POLAR P2 (+ Z 3.14159265) W2))
 (SETQ P2B (POLAR P2A Z W))
 (COMMAND "LINE" P1A P2A)
 (COMMAND "")
 (COMMAND "LINE" P1B P2B P2A)
 (COMMAND "")
 (SETQ P1 P2)
 (SETQ P1A P2A)
 (SETQ P1B P2B)
 (SETVAR "BLIPMODE" 0)
 (SETQ WW (GETREAL "\nNEXT DUCT WIDTH:"))
 (IF(< WW W)(SML))
 (IF(> WW W)(LRG))
 (COMMAND "REDRAW"))

(DEFUN TURN()
 (COMMAND "DIST" P2)(GETPOINT "\nENTER NEXT POINT:")
 (COMMAND)
 (SETQ P3 (GETVAR "LASTPOINT"))
 (SETQ Z1 (ANGLE P2 P1))
 (SETQ Z1X (ANGLE P1 P2))
 (SETQ Z2 (ANGLE P2 P3))
 (SETQ Z2X (+ (* (Z1 Z2) 0.5) 3.14159265))
 (SETQ P2B (POLAR P2 Z2X (/ W2 (SIN (- Z2X Z1X)))))
 (COMMAND "LINE" P1B P2B)
 (COMMAND "")
 (SETQ P2A (POLAR P2 Z2X (* (/ W2 (SIN (- Z2X ZIX))) -1)))
 (COMMAND "LINE" P1A P2A)
 (COMMAND "")
 (SETQ D (/ W 8))
 (SETQ A (ANGTOS Z2X 1 1))
 (COMMAND "INSERT" "VAIN" P2 D "1" A)
 (SETQ P1 P2)
 (SETQ P1A P2A)
 (SETQ P1B P2B)
 (SETQ P2 P3))

(DEFUN C:DUCT()
 (SETQ W (GETREAL "\nENTER DUCT WIDTH:"))
 (SETQ W2 (* W 0.5))
 (SETQ P1 (GETPOINT "\nENTER BEGINNING OF CENTERLINE:"))
 (COMMAND "DIST" P1)(GETPOINT "\nENTER END OF CENTERLINE:")
 (COMMAND "")
 (SETQ P2 (GETVAR "LASTPOINT"))
 (SETQ Z (+ (ANGLE P1 P2) 1.57079633))
 (SETQ P1A (POLAR P1 (+ Z 3.14159265) W2))
 (SETQ P1B (POLAR P1A Z W))
 (SETQ L T)
 (WHILE L
  (SETQ TEST (GETSTRING "nIS DIRECTION <S>TRAIGHT OR <T>URN <Q>UIT"))
  (IF (EQUAL TEST "S")(WIDE))
  (IF (EQUAL TEST "T")(TURN))
  (IF (EQUAL TEST "Q")(SETQ L NIL)))
 (COMMAND "LINE" P1A P2A P2B P1B)
 (COMMAND "")
 (CLEAN ATOMLIST)
 (COMMAND "REDRAW")
)

;FLEXD PROGRAM
(DEFUN STRGT()
 (COMMAND "DIST" P1)(GETPOINT "\nENTER ENDPOINT OF FLEX DUCT:")
 (COMMAND)
 (SETQ P2 (GETVAR "LASTPOINT"))
 (SETQ Z (+ (ANGLE P1 P2) 1.57079633))
 (SETQ PX (POLAR P1 (ANGLE P1 P2) 9))
 (SETQ P1A (POLAR PX (+ Z 3.14159265)(* W 0.5)))
 (SETQ P1B (POLAR P1A Z W))
 (SETQ P1D (POLAR P1 Z (+ W2 7)))
 (SETQ P1C (POLAR P1 (+Z 3.1415926)(+ W2 7)))
 (SETQ P2B (POLAR P2 Z W2))
 (SETQ P2A (POLAR P2 (+ Z 3.1415926) W2))
 (COMMAND "LINE" P1D P1B P1A P1C)
 (COMMAND "")
 (COMMAND "LINE" P1A P2A)
 (COMMAND "")
 (COMMAND "LINE" P1B P2B)
 (COMMAND "")
 (SETQ P1 P2)
 (SETQ P1A P2A)
 (SETQ P1B P2B))

(DEFUN TURN()
 (COMMAND "DIST" P1)(GETPOINT "\nENTER TURNING POINT OF DUCT:")
 (COMMAND)
 (SETQ P2 (GETVAR "LASTPOINT"))
 (COMMAND "DIST" P2)(GETPOINT "\nENTER END OF FLEX DUCT:")
 (COMMAND)
 (SETQ P3 (GETVAR "LASTPOINT"))
 (SETQ Z (+ (ANGLE P1 P2) 1.57079633))
 (SETQ PX (POLAR P1 (ANGLE P1 P2) 9))
 (SETQ P1A (POLAR PX (+ Z 3.14159265)(* W 0.5)))
 (SETQ P1B (POLAR P1A Z W))
 (SETQ P1D (POLAR P1 Z (+ W2 7)))
 (SETQ P1C (POLAR P1 (+ Z 3.1415926)(+ W2 7)))
 (SETQ Z2 (+ (ANGLE P2 P3) 1.57079633))
 (SETQ P2B (POLAR P2 Z W2))
 (SETQ P2A (POLAR P2 (+ Z 3.1415926) W2))
 (SETQ P2AA (POLAR P2 (+ Z2 3.1415926) W2))
 (SETQ P2BB (POLAR P2 Z2 W2))
 (SETQ P3B (POLAR P3 Z2 W2))
 (SETQ P3A (POLAR P3 (+ Z2 3.1415926) W2))
 (COMMAND "LINE" P1C P1A P1B P1D)
 (COMMAND "")
 (COMMAND "LINE" P1A P2A)
 (COMMAND "")
 (COMMAND "LINE" P1B P2B)
 (COMMAND "")
 (COMMAND "LINE" P2AA P3A)
 (COMMAND "")
 (COMMAND "LINE" P2BB P3B)
 (COMMAND "")
 (SETQ D2 (DISTANCE P1 P2AA))
 (SETQ D1 (DISTANCE P1 P2BB))
 (IF (> D2 D1)(SETQ RB W)(SETQ RB (* 2 W)))
 (IF (> D2 D1)(SETQ RA (* W 2))(SETQ RA W))
 (COMMAND "FILLET" "R" RB)
 (COMMAND "FILLET" P2B P2BB)
 (COMMAND "FILLET" "R" RA)
 (COMMAND "FILLET" P2A P2AA)
 (COMMAND)
 (SETQ P1 P3)
 (SETQ P1A P3A)
 (SETQ P1B P3B)
)

(DEFUN C:FLEXD()
 (SETVAR "CMDECHO" 0)
 (SETQ W (GETREAL "\nPICK DUCT WIDTH:"))
 (SETQ W2 (* W 0.5))
 (SETQ P1 (GETPOINT "\nENTER BEGINNING OF CENTERLINE:"))
 (SETQ L T)
 (WHILE L
  (SETQ TEST (GETSTRING "nIS DIRECTION <S>TRA OR <T>URN OR <Q>UIT PROGRAM:"))
  (IF (EQUAL TEST "S")(STRGT))
  (IF (EQUAL TEST "T")(TURN))
  (IF (EQUAL TEST "Q")(SETQ L NIL)))
 (COMMAND "LINE" P1A P1B)
 (COMMAND "")
 (COMMAND "REDRAW")
 (COMMAND)
 (CLEAN ATOMLIST)
)