; CLOUD.LSP

; Draws a revision cloud as a polyline--works best by picking points
; in a counterclockwise direction--hit return or spacebar to close
; polyline--can use pedit later to give cloud width

; To make the bulges more pronounced, increase the value of the variable
; "BULGESIZ" to a larger number.


(DEFUN C:CLOUD (/ TE BULGSIZ PT1 PT2)
  (SETQ BULGESIZ  "135")
  (SETQ TE (GETVAR "TEXTEVAL"))
  (SETVAR "TEXTEVAL" 1)
  (SETQ PT1 (GETPOINT "\nStart Point: "))
  (SETQ PT2 (GETPOINT PT1 "\nNext Point: "))
  (COMMAND "PLINE" PT1 "W" "0" "0" "A" "A" BULGESIZ PT2)
  (WHILE PT1
    (SETQ PT1 (GETPOINT PT2 "\nNext Point <Return to Complete Cloud>: "))
    (IF PT1
      (COMMAND "A" BULGESIZ PT1)
      (COMMAND "CL")
    )
    (SETQ PT2 PT1)
  )
  (SETVAR "TEXTEVAL" TE)  
)
