(defun C:Cable (/ cwidth pt1 pt2 threshold ss segment oang inrad ofrad outrad lo1 lo2 ro1 ro2 eao ebo eb a dimpt xa rb ra)
 (setvar "cmdecho" 1)
 (if (not cwidth) (setq cwidth 0.0))
 (prompt (strcat "\nEnter cable width or diameter <" (rtos cwidth) ">: "))
 (setq tcwidth (getreal))
 (if tcwidth (setq cwidth tcwidth))
 (setq pt1 (getpoint "\nStart point... "))
 (if pt1 (setq pt2 (getpoint pt1 "\nTo point... ")))
 (setq threshold 1.5 segment 0 oang nil ofrad (getvar "FILLETRAD"))
 (if (>= cwidth threshold)
      (setq inrad 0.5 outrad (+ 0.5 cwidth))
      (setq inrad 0.06 outrad cwidth))
 (while pt2
  (setq a (angle pt1 pt2)
        lo1 (polar pt1 (+ a (/ pi 2.0)) (/ cwidth 2.0))
        lo2 (polar pt2 (+ a (/ pi 2.0)) (/ cwidth 2.0))
        ro1 (polar pt1 (- a (/ pi 2.0)) (/ cwidth 2.0))
        ro2 (polar pt2 (- a (/ pi 2.0)) (/ cwidth 2.0)))
 (command "line" pt1 pt2 "")
 (if (tblsearch "LAYER" "CL") (command "CHANGE" "LAST" "" "LA" "CL"))
 (if (> segment 0)
  (setq eao ea ebo eb)
  (setq dimpt (polar pt1 (+ a (/ pi 2.0)) (+ (/ cwidth 2.0) 1.0))))
 (command "line" lo1 lo2 "")
 (setq ea (entlast))
 (command "line" ro1 ro2 "")
 (setq eb (entlast))
 (if (and (> segment 0) (/= a oang) (/= pi (abs (- a oang))))
  (progn
   (setq xa (- oang a ))
   (if (or (<= xa (* -1.0 pi)) (and (> xa 0) (< xa pi)))
    (setq ra outrad
          rb inrad
          dimpt (polar pt1 (+ a (/ pi 2.0)) (+ (/ cwidth 2.0) 1.0)))
     (setq ra inrad
           rb outrad
           dimpt (polar pt1 (- a (/ pi 2.0)) (+ (/ cwidth 2.0) 1.0))))
    (setq ss (ssadd ea))
    (setq ss (ssadd eao ss))
    (setvar "FILLETRAD" ra)
    (command "fillet" ss)
    (setq ss (ssadd eb))
    (setq ss (ssadd ebo ss))
    (setvar "FILLETRAD" rb)
    (command "fillet" ss)))
 (command "DIM" "ALI" pt1 pt2 dimpt "" "EXIT")
 (if (tblsearch "LAYER" "DIM") (command "CHANGE" "LAST" "" "LA" "DIM"))
 (setq oang a pt1 pt2 pt2 (getpoint pt1 "\nTo point...") Segment (1+ segment)))
 (setvar "FILLETRAD" ofrad)
 (setvar "cmdecho" 1)
 (prin1))
