;;;    RT CADD INTERFACE 5.0e
;;;
;;;    This file is a freestanding freeware example module 
;;;    of the Real Time CADD Interface.  It may be distributed
;;;    freely in its entirety.  It may not be distributed in
;;;    partial form, nor may it be sold in whole or in part.
;;;    For 200+ additional Interface modules, please contact:
;;;    Richard Barton; Production Manager  CADD EDGE
;;;     voice: 801 375 9564
;;;       fax: 801 375 4532
;;;    cserve: 73752,607
;;;    1077 East 2500 North, Provo, Utah 84604
;;;
;;;
;;;  BALLOON generates a circled text descriptor with leader.
;;;  If the current balloon style has no height, a height is prompted for.
;;;  The user picks the leader end, then visually drags the balloon 
;;;  center to it's most appropriate spot.
;;;  Options:
;;;  At the "<Center of Balloon>" prompt, the user may:
;;;  press [F9] to toggle the snap mode of the balloon center;
;;;  press [R] to change the ratio of the balloon radius to text height;
;;;  press [T] to change the balloon text generation style;
;;;  press [L] to change the balloon generation layer; or
;;;  press [F] to toggle the fit text mode.
;;;    The fit text mode will vertically fit any oversized text.  
;;;    By default, text will be MIDDLE justified at the circle's 
;;;    center.  When fit text mode is on, any text extending beyond 
;;;    the edge of the circle will be changed to FIT justified and 
;;;    forced within the circle boundary.
;;;  When the current balloon text style has no height defined,
;;;  the user may change the current balloon text height by pressing
;;;  [T] at the "<Center of Balloon>" prompt followed by a return.
;;;  Any action, other than pressing an R,T,L,F,F8,F9 or picking a
;;;  point at the "<Center of Balloon>" prompt, will be ignored.
;;;
;;;
;;;  Default Settings
(setq bratio 1.0); default ratio of balloon radius to text height
(setq btstyle (getvar "textstyle")); default text style is current style
(setq fittext T); fit text vertically inside balloon if it is too large
(setq blayer (getvar "clayer")); default balloon creation layer is current layer
;;;
;;;
;;; Trailing zero truncator 
(defun gtos (ior / lo)
 (setq lo 0 ior (atof(rtos ior 2 8)))
 (while
  (and (< lo 8)(/=(atof(rtos ior 2 lo))ior))
  (setq lo (1+ lo)))
 (rtos ior 2 lo)
)
;;;
;;;
;;; Universal gettype with default generator
(defun get (getype var str / te)
 (setq getype (strcat "get" getype)
       te (eval var))
 (cond ((numberp te)(setq str (strcat str " <" (gtos te) ">: ")))
  (te (setq str (strcat str " <" te ">: ")))
  (t (setq str (strcat str ": "))))
 (if (= getype "getstring 1")
  (setq te (getstring 1 str))
  (setq te ((eval(read getype)) str)))
 (if (and te(/= te ""))(set var te))
 (eval var)
)
;;;
;;;
;;;  Current style text height retrieval
(defun chktexth (); Sets variable TEXTHITE to the current text height.
 (if              ; If the current text style has no height,
  (= 0            ; TEXTHITE is set to nil.
   (SETQ TEXTHITE
    (cdr
     (assoc 40
      (tblsearch "style"
       (getvar "textstyle")
  )))))
  (setq TEXTHITE NIL)
  TEXTHITE
)) 
;;;
;;;
;;;  Balloon Center Prompt Generation
(defun bcenter ()
 (prompt "\nRatio=")
 (princ (gtos bratio))
 (prompt "/Text style=")
 (princ (substr btstyle 1 8))
 (prompt "/Layer=")
 (princ (substr blayer 1 8))
 (prompt "/Fit text=")
 (princ (if fittext "On" "Off"))
 (prompt "/<Center of Balloon>: ")
)
;;; 
;;;
;;;  Moving Balloon Vector Generation  
(defun movedraw (p1 p2 x y x5 x8) 
 (grdraw p1 (polar p1 (angle p1 p2) (- (distance p1 p2) csize)) -1)
 (grdraw (list x (+ y csize)) (list (+ x x5) (+ y x8)) -1)
 (grdraw (list x (- y csize)) (list (- x x5) (- y x8)) -1)
 (grdraw (list (+ x x8) (+ y x5)) (list (+ x csize) y) -1)
 (grdraw (list (- x x8) (- y x5)) (list (- x csize) y) -1)
 (grdraw (list (+ x x8) (- y x5)) (list (+ x x5) (- y x8)) -1)
 (grdraw (list (- x x8) (+ y x5)) (list (- x x5) (+ y x8)) -1)
)
;;;
;;;
;;;  Additional Still Balloon Vector Generation
(defun stildraw (p1 p2 x y x5 x8)
 (grdraw (list x (- y csize)) (list (+ x x5) (- y x8)) -1)
 (grdraw (list x (+ y csize)) (list (- x x5) (+ y x8)) -1)
 (grdraw (list (+ x x8) (- y x5)) (list (+ x csize) y) -1)
 (grdraw (list (- x x8) (+ y x5)) (list (- x csize) y) -1)
 (grdraw (list (+ x x8) (+ y x5)) (list (+ x x5) (+ y x8)) -1)
 (grdraw (list (- x x8) (- y x5)) (list (- x x5) (- y x8)) -1)
)
;;;
;;;
;;;  Program Main
(defun c:balloon (/ grdata olddata still temp oldstyle oldlayer perpball)
 (setvar "cmdecho" 0)
 (setq oldstyle (getvar "textstyle")
       oldlayer (getvar "clayer"))   
 (command "layer" "m" blayer ""
          "style" btstyle "" "" "" "" "" "" "")
 (command)
 (if (chktexth)
  (setq th texthite)
  (get "dist" 'th 
   "\nNote: current balloon style has no height\nBalloon text height")
 )
 (setq leadend (getpoint "\nArrowhead tip: "))
 (bcenter) 
 (setq grdata (grread nil 5 1)
       olddata grdata
       still nil
       csize (* th bratio)
       mp5 (* csize 0.5)
       mp8 (* csize 0.866))
 (movedraw leadend (setq temp(cadr grdata))(car temp)(cadr temp) mp5 mp8)
 (while (/= (car grdata) 3)
  (cond
   ((= (car grdata) 5)
    (if (not (equal grdata olddata))
     (progn
      (movedraw leadend (setq temp(cadr grdata))(car temp)(cadr temp) mp5 mp8)
      (movedraw leadend (setq temp(cadr olddata))(car temp)(cadr temp) mp5 mp8)
      (if still
       (stildraw leadend temp (car temp) (cadr temp) mp5 mp8)
      )
      (setq olddata grdata
            grdata (grread nil 5 1)
            still nil)
     )
     (progn
      (if (not still)
       (stildraw leadend (setq temp(cadr grdata))(car temp)(cadr temp) mp5 mp8)
      )
      (setq still t
            grdata (grread nil 5 0))
   )))
   ((equal grdata '(2 15))
    (progn
     (if (= (getvar "orthomode") 1)
      (progn
       (setvar "orthomode" 0)
       (prompt "\nOrtho mode is off")
      )
      (progn
       (setvar "orthomode" 1)
       (prompt "\nOrtho mode is on")
     ))
     (bcenter)
     (setq grdata (grread nil 5 1))
   ))
   ((equal grdata '(2 2))
    (progn
     (if (= (getvar "snapmode") 1)
      (progn
       (setvar "snapmode" 0)
       (prompt "\nSnap mode is off")
      )
      (progn
       (setvar "snapmode" 1)
       (prompt "\nSnap mode is on")
     ))
     (bcenter)
     (setq grdata (grread nil 5 1))
   ))
   ((or(equal grdata '(2 102))(equal grdata '(2 70)))
    (progn
     (if fittext
      (progn
       (setq fittext nil)
       (prompt "\nOversized text will be allowed to extend beyond the circle edge.")
      )
      (progn
       (setq fittext t)
       (prompt "\nOversized text will be fit vertically inside the circle.")
     ))
     (bcenter)
     (setq grdata (grread nil 5 1))
   ))
   ((or(equal grdata '(2 108))(equal grdata '(2 76)))
    (progn
     (get "string" 'blayer "\nLayer that balloons will be generated on")
     (command "layer" "m" blayer "")
     (bcenter)
     (setq grdata (grread nil 5 1))
   ))
   ((or(equal grdata '(2 114))(equal grdata '(2 82)))
    (progn
     (get "real" 'bratio "\nRatio of Balloon Radius to Text Height")
     (movedraw leadend (setq temp(cadr olddata))(car temp)(cadr temp) mp5 mp8)
     (if still
      (stildraw leadend temp (car temp) (cadr temp) mp5 mp8)
     )
     (setq grdata (grread nil 5 1)
           olddata grdata
           still nil
           csize (* th bratio)
           mp5 (* csize 0.5)
           mp8 (* csize 0.866))
     (movedraw leadend (setq temp(cadr grdata))(car temp)(cadr temp) mp5 mp8)
     (bcenter)
     (setq grdata (grread nil 5 1))
   ))
   ((or(equal grdata '(2 116))(equal grdata '(2 84)))
    (progn
     (get "string" 'btstyle "\nText style used in balloon generation")
     (if (tblsearch "style" btstyle)
      (progn
       (setvar "textstyle" btstyle)
       (if (chktexth)
        (setq th texthite)
        (get "dist" 'th 
         "\nNote: current balloon style has no height\nBalloon text height")
       )
       (movedraw leadend (setq temp(cadr olddata))(car temp)(cadr temp) mp5 mp8)
       (if still
        (stildraw leadend temp (car temp) (cadr temp) mp5 mp8)
       )
       (setq grdata (grread nil 5 1)
             olddata grdata
             still nil
             csize (* th bratio)
             mp5 (* csize 0.5)
             mp8 (* csize 0.866))
       (movedraw leadend (setq temp(cadr grdata))(car temp)(cadr temp) mp5 mp8)
      ) 
      (progn
       (prompt "\nText style ")
       (princ btstyle)
       (prompt " does not exist.")
       (setq btstyle temp)
     ))
     (bcenter)
     (setq grdata (grread nil 5 1))
   ))
   (t
    (progn
     (prompt "\nKeys [R],[T],[L],[F],[F8],[F9] and screen pick points are")
     (prompt "\nthe only input accepted at the <Center of Balloon> prompt.")
     (bcenter)
     (setq grdata (grread nil 5 1))
   ))
  )
 )
 (movedraw leadend (setq temp(cadr olddata))(car temp)(cadr temp) mp5 mp8)
 (if still
  (stildraw leadend temp (car temp) (cadr temp) mp5 mp8)
 )
 (setq perpball
  (polar leadend
   (angle leadend temp) 
   (- (distance leadend temp) csize)
 ))
 (command "DIM1" "LEADER" leadend temp)
 (command)
 (command)
 (command "ERASE" "L" "")
 (command "line" leadend perpball "")
 (command "circle" temp perpball)
 (get "string 1" 'btext "\nBalloon text")
 (if 
  (and fittext
   (< 
    (* 1.6 csize) 
    (distance 
     (car
      (setq tb (textbox (list (cons 1 btext)(cons 40 th))))
     )
     (cadr tb)
  )))
  (progn
   (prompt "\nText is being fit inside circle")
   (setq tb(sqrt(-(*(* csize 0.8)(* csize 0.8))(*(* th 0.5)(* th 0.5)))))
   (if (< tb (* csize 0.3))(setq tb (* csize 0.3)))
   (command "text" "f" 
    (list(-(car temp)tb)(-(cadr temp)(* th 0.5))) 
    (list(+(car temp)tb)(-(cadr temp)(* th 0.5))) 
   )
   (if (not texthite) (command th))
   (command btext)
  )
  (progn
   (command "text" "m" temp)
   (if (not texthite) (command th))
   (command 0 btext)
 ))
 (command "layer" "m" oldlayer "")
 (setvar "textstyle" oldstyle)
 (prin1)
)
(c:balloon)
