; TIP1095.LSP: BLOCKARR.LSP   Change Arrowheads   (c)1995, Stephen R. Schneider

;This function rescales all arrow block to the scale specified. SRS 6-22-94
;
;
;C -------- Error Handling (ON) -----------------------------------------------
;C
;C
(defun SRSERR (S)                     ;C  If an error (such as CTRL-C) occurs
   ;C  while this command is active...
   (if (/= S "Function cancelled")
      (princ (strcat "\nError: " s))
   )                                   ;C
   (setvar "CMDECHO" OCE)              ;C  restore cmdecho
   (setq *error* OLDERR)               ;C  restore old *error* handler
   (princ)
);defun srserr
;
(defun C:BLOCKARR (/ SCALF SS1 COUNT EMAX EN ED ET NEW)
   (setq OLDERR *error*)
   (setq *error* SRSERR)
   (setq OCE (getvar "CMDECHO"))         ;  store present cmddia value
   (setvar "CMDECHO" 0)
   (setq SS1 (ssget "X" '((0 . "INSERT") (2 . "ARROW"))))                             ;get the selections
   (if (= SS1 nil)  
      (princ "No ARROW blocks present.........")
      (progn   ;otherwise    
         (while (not (setq SCALF (getreal "Enter x/y scale factor: "))))
         (setq COUNT 0)
         (setq EMAX (sslength SS1))
         (prompt "\nScaling 'ARROW' inserts to ")(princ  scalf)(princ "...")                       ;keep user informed
         (while (< COUNT EMAX)                           ;start program loop
            (setq EN (ssname SS1 COUNT)                   ;get an entity name
               ED (entget EN)                          ;entity data
               ET (cdr (assoc 0 ED))                           ;entity type
            );setq
            (if  (= et "INSERT")                          ;check for block inserts
               (progn
                  (setq NEW (abs (* (/ 1 (cdr (assoc 41 ED))) SCALF)))
                  (command "scale" EN "" (cdr (assoc 10 ED)) NEW) ;use  10 insertion point
               );progn
            );if
            (setq COUNT (1+ COUNT))
            (princ COUNT)(princ ", ")
         );while
      );progn
   );if
   (prompt "...Done!!!") 
   (princ)                                            ;finish cleanly
   ;C
   ;C -------- Error Handling (OFF) ----------------------------------------------
   ;C
   (setvar "cmdecho" OCE)              ;C  restore old cmdecho value
   (setq *error* OLDERR)               ;C  restore old *error* handler
   ;C
   ;C ------- End of Main Program ------------------------------------------------
   ;C
   (princ)
);defun
(princ); end blockarr.lsp
