(DEFUN C:RECT (/ pnt1 pnt2 pnt3 pnt4)
(setvar "blipmode" 1)
(setvar "cmdecho" 0)
	(graphscr)
	(prompt "Rectangle requires two opposing corner points")
	(terpri)
	(setq pnt1 (getpoint "First corner ? ")) (terpri)
	(setq pnt3 (getpoint pnt1 "Opposite corner ? ")) (terpri)
	(setq pnt2 (list (car pnt1)(cadr pnt3)))
	(setq pnt4 (list (car pnt3)(cadr pnt1)))
	(command "line" pnt1 pnt2 pnt3 pnt4 "c")
(setvar "blipmode" 0)
(setvar "cmdecho" 1)
)
(defun C:SL (/ LAYER)
(setvar "cmdecho" 0)
(SETQ LAYER
(CDR
(ASSOC 8
(ENTGET
(CAR
(ENTSEL "Select Reference Item: "
))))))
(command "layer" "set" layer "")
(setvar "cmdecho" 1)
)
(defun C:BALLOON()
(setvar "cmdecho" 0)
(setq sc1 (getvar "textsize"))
(setq pt1 (getpoint "\nEnter ARROW POINT location "))
(setq pt2 (getpoint pt1 "\nEnter BALLOON CENTER point"))
(setq angrad (angle pt1 pt2))
(setq angdeg (* angrad 57.29578))
(setq awscl sc1)
(setq pt3 (polar pt1 angrad awscl))
(command "line" pt3 pt2)
(command)
(command "insert" "*arwhd" pt1 awscl angdeg)
(command "change" "l" "" "l" (getvar "clayer"))
(setq bllnrad (* 1.5 sc1))
(setq cpt (polar pt2 angrad bllnrad))
(command "circle" cpt bllnrad)
(setq txtht sc1)
(setq txtloc (list(car cpt)(-(cadr cpt)(/ txtht 2.00))))
(setq blntxt (getstring "\nEnter Balloon TEXT "))
(command "text" "c" txtloc txtht "0" blntxt)
)
;  Program Sizer.lsp  Version 1.0
;  By Jim MCMillan.   86.July.31
;  Program automatically resizes a drawing to fit given area.
;
;
(DEFUN C:SIZER ()
(makeblock)
(resize)
(getblock)
(COMMAND "ZOOM" "A")
)

(defun makeblock ()
(setq ur (getvar "EXTMAX" ))
;  Get the most upper right point drawing uses.
(setvar "CMDECHO" 0)
(setvar "HIGHLIGHT" 0)
(command "BLOCK" "PLOT" "0,0" "W" "0,0" ur "" )
;  Makes a block of the drawing, and calls it PLOT.
)


(defun resize ()
(setq top-right (getvar "LIMMAX"))
(setq lm1 (car top-right))
;  Assign first atom of Limmax to lm1.
(setq lm2 (cadr top-right))
;  Assign last atom of Limmax to lm1.
(setq pt1 (getreal "Enter new length value for x >> "))
(setq pt2 (getreal "Enter new length value for y >> "))
(setq xscale (/ pt1 lm1))
;  Calculate new x scale factor.
(setq yscale (/ pt2 lm2 ))
;  Calculate new y scale factor.
(setq pt3 (list pt1 pt2))
;  Put the two reals into a list.
(setvar "CMDECHO" 0)
(command "LIMITS" "" pt3 )
)


(defun Getblock ()
(setvar "CMDECHO" 0)
(COMMAND "INSERT" "PLOT" "0,0" xscale yscale "" )
)
;Program complete.
