(defun getval (n e) (cdr (assoc n e)))

(defun parse_etxt ( / tht, tloc, trot, txtlen, si, numer, numer1,
                       denom, denom1, frac, den, num)
   (setq tht (cdr (assoc 40 en1)))     ;Get text height
   (setq tloc (cdr (assoc 10 en1)))    ;Get text location
   (setq trot (cdr (assoc 50 en1)))    ;Get text rotation
   (setq txtlen (strlen etxt))
   (setq si 1 slloc 0)
   (while (<= si txtlen)
     (progn
       (if (= "/" (substr etxt si 1))
          (setq slloc si)
       )
       (setq si (1+ si))
   ))
   (if (> slloc 0)
      (progn                           ;Calculate value of fraction
         (setq denom "" denom1 "" numer "" numer1 ""
               maskl 0 maskr 0 ctest (1+ ctest))
         (if (< slloc txtlen)
              (setq denom (substr etxt (1+ slloc) 1)))
         (if (< (1+ slloc) txtlen)
              (setq denom1 (substr etxt (+ slloc 2) 1)))
         (if (> slloc 1)
              (setq numer (substr etxt (1- slloc) 1)))
         (if (> slloc 2)
              (setq numer1 (substr etxt (- slloc 2) 1)))
         (setq num (atof numer))
         (if (and (>= numer1 "0")(<= numer1 "9"))
               (setq num (+ num (* 10 (atof numer1)))
                     maskl 1))
         (setq den (atof denom))
         (if (and (>= denom1 "0")(<= denom1 "9"))
               (setq den (+ (* 10 den) (atof denom1))
                     maskr 1))
         (setq frac (fix (+ 0.5 (* 64 (/ num den)))))
         (setq frac (+ frac 129))    ;1 = 1/64 = %%130
         (if (> slloc 3)
            (if (or (= (substr etxt (- slloc (+ 2 maskl)) 1) " ")
                    (= (substr etxt (- slloc (+ 2 maskl)) 1) "-"))
                    (setq maskl (1+ maskl))))
       (setq etxt (strcat (substr etxt 1 (- slloc (+ 2 maskl)))
               "%%" (itoa frac) (substr etxt (+ slloc 2 maskr))))
       (setq movdis (+ movdis tht))   ;Move text height distance
      )  ;progn
   )
)

(defun fract_text ( / justi, ctest, movvup)      ;Uses entity en1
    (setq etxt (cdr (assoc 1 en1)))
    (setq justi (cdr (assoc 72 en1)))
    (setq ctest 0 movdis 0)          ;Initialize
    (parse_etxt)                     ;1st try
    (if (> slloc 0) (parse_etxt))    ;2nd try
    (if (> slloc 0) (parse_etxt))
    (if (> slloc 0) (parse_etxt))
    (if (> slloc 0) (parse_etxt))
    (if (> slloc 0) (parse_etxt))    ;6th try
    (if (> trot 0.5) (setq movvup movdis movdis 0) (setq movvup 0))
    (if (> ctest 0)                  ;Only update entity if "/" found
       (progn
          (setq en1 (subst
                        (cons 7 "FROMAND")
                        (assoc 7 en1)
                        en1
                    )
                en1 (subst
                        (cons 1 etxt)
                        (assoc 1 en1)
                        en1
                    )
                en1 (subst
                         (cons 10 (list (+ (car tloc) movdis)
                                  (+ (cadr tloc) movvup) (cadr (cdr tloc))))
                         (assoc 10 en1)
                         en1
                    )
          )
          (entmod en1)               ;Modify entity
       )   ;prog
    )    ;if slloc > 0
)

(defun dmfracd( / n, plen)
  (command ".SETVAR" "cmdecho" 0)        ;Don't want to see commands for a while
  (setq rgmd (getvar "REGENMODE"))       ;Save REGENMODE
  (setvar "REGENMODE" 0)                 ;Prevent automatic drawing regens
  (setq styl (getvar "TEXTSTYLE"))       ;Save current Text Style
  (command ".style" "FROMAND" "FROMAND" 0 1 0 "n" "n" "n") ;Load FROMAND style
  (command ".style" styl "" "" "" "" "" "" "")  ;Reset text style
  (command ".SETVAR" "cmdecho" 1)        ;OK to see commands now
  (princ "\nSelect Dimensions to be converted to fractions : ")
  (setq ss (ssget))                      ;Select Objects
  (setq plen (sslength ss))              ;plen = number of items selected
  (setq n 0)                             ;Reset Index to 0
  (if (> plen 0)                         ;Do function only if items are selected
    (while (< n plen)                    ;Loop PLEN times
      (setq e1 (ssname ss n))            ;E1 = Entity name
      (setq en (entget e1))              ;EN = Entity
      (setq et (cdr (assoc 0 en)))       ;ET = Entity type
      (setq en1 en)
      (if (= et "TEXT") (fract_text))    ;Convert text string
      (if (= et "DIMENSION")             ;If dimension, explode, then convert
        (progn
           (setq e0 (entlast))           ;Find last entity in drawing database
           (setq en1 (entnext e0))       ;  so that entities added from
           (while (not (null en1))       ;  explode can be distinguished
              (setq e0 en1)
              (setq en1 (entnext e0))
           )
           (command "explode" (getval -1 en))
           (setq s0 (ssadd))      ;Create an empty selection set
           (while (entnext e0) (ssadd (setq e0 (entnext e0)) s0))
           (command "chprop" s0 "" "c" "bylayer" "lt" "bylayer"
                                      "la" (getval 8 en) "")
           (setq plen1 (sslength s0))
           (setq n1 0)
           (if (> plen1 0)       ;Change Text String as needed
              (while (< n1 plen1)
                 (progn
                   (setq e11 (ssname s0 n1))
                   (setq en1 (entget e11))
                   (setq et1 (cdr (assoc 0 en1)))
                   (if (= et1 "TEXT") (fract_text))
                   (setq n1 (1+ n1))
                 )    ;progn
              )    ;while
           )       ;if
      ))
      (setq n (1+ n))
    )   ;while
  )     ;if plen
  (setvar "REGENMODE" rgmd)              ;Restore drawing regen mode
  (print "DIMFRAC Complete ...")
  (princ)
)

(defun C:DIMFRACD ()          ;This allows a shorter ACAD.LSP load
   (dmfracd)                  ;  with an automatic program load when required
)

; Add the lines (defun C:DIMFRACD ()
;                    (if (not dmfracd)
;                        (progn (princ "LOADING DIMFRACD")
;                               (load "dimfracd") (dmfracd)
;               )))
;    to C::STARTUP area of ACAD.LSP
