; AutoLISP Supervisor (c)1986 ADSI Naperville Il.
; Vers 2.5 [rcb]
;
(setq Vlist 'atomlist)
(vmon)
(setq lisp-> (list '<-SYS 0))     ; set marker in atomlist
(setq sys*error* *error*)         ; save internal error procedure
;
; Misc Supervisor Variables
;
(setq funcname "ACAD")		; Default Function Name to EDIT
(setq notename "FUNCTS")        ; Default Note File Name
(setq loadname (strcat (getvar "DWGPREFIX")
                       (getvar "DWGNAME")))      ; Default Load File Name
(setq tempstr "temp")           ; Temp String Variable
(setq x 0) (setq y 0)           ; X and Y Locations for Screen Addressing
(setq system (list 'funcname 'notename 'loadname))  ; Set Default Save List
;
(defun *error*on () (setq *error* sys*error*))  ; Restore System Error Function
(defun *error*off () (defun *error* () ()))     ; Overide System Error Function
;
; Clear Screen Function : Uses ANSII.SYS
;
(defun clrscr () (textscr) (princ "\e[2J"))     ; print clear screen code
;
;
; Prinxy function : This function performs a (printc) at Currsor Address X Y
;
(defun prinxy (x y tempstr) 
   (princ (strcat "\e[" (itoa y) ";" (itoa x) "H"))   ; locate cursor
   (princ tempstr))                                   ; print data
;
; Getname : prompts user for a string using (msgstring) as a prompt
;           and xname as the default value to return if the operator
;           enters a <return>
;
(defun getname (xname msgstring) 
   (princ (strcat msgstring " <" xname "> : ")) ; prompt operator with default
   (setq tempstr (getstring))                   ; get string from operator
   (if (/= "" tempstr) (setq xname tempstr))    ; test for default
   (setq tempstr xname))                        ; return string
;
; EDIT Command : This command prompts the operator for a LISP file name
;                shells to the editor defined in ACAD.PGP to allow editing
;                of file, upon return from shell reloads LISP file for 
;                use or testing 
;
(defun C:EDIT () 
   (setq tempstr (strcat (setq funcname (getname funcname "File")) ".lsp"))
   (command "w" tempstr)                       ; shell to editor
   (prompt (strcat "loading " tempstr))
   (load funcname))                            ; reload function
;
; NOTES Command : This command prompts the operator for a NOTE file name
;                shells to the editor defined in ACAD.PGP to allow editing
;                of a NOTES file
;
(defun C:NOTES () 
   (setq notename (getname notename "Section"))  ; get filename
   (command "ws" notename))                      ; shell to editor
;
; GET Command : This procedure loads a LISP file
;
(defun C:GET () (load (getname loadname "Function")))
;
; STORE Command : This procedure parses the (System) save list and writes
;                 a LISP function that when reloaded will restore all atoms
;                 contained in the save list to there values as of the last
;                 execution of the STORE Command
;
(defun C:STORE () 
   (setq tempstr (strcat (setq loadname 
                 (getname loadname "Save File")) ".lsp"))
   (setq sfile (open tempstr "w"))        ; open drawing save file
   (princ "(setq system '" sfile) (princ system sfile)  ; save system list
   (princ (strcat ")" (chr 13)) sfile)
   (setq n 0)
   (while (< n (length system))   ; save all variables described in save list
       (princ "(setq " sfile) (princ (nth n system) sfile) (princ " " sfile)
       (princ "'" sfile) (prin1 (eval (nth n system)) sfile)
       (princ (strcat ")" (chr 13)) sfile)
       (setq n (1+ n)))
   (setq sfile (close sfile))   ; close file
   (setq tempstr "System Vars Saved"))   ; return finished prompt string 
;
; Savevar function : Allows variables to be added to the system save list
;                    from a LISP procedure
;
(defun savevar (tempstr)
(setq system (cons (read tempstr) system)))  ; add variable to save list
;
; ADDVAR Command : Allows variables to be added to the system save list
;                  by the operator from the command line
;
(defun C:ADDVAR ()
   (setq tempstr "none")
   (getname tempstr "Symbol to Add to Save Table ")
   (if (/= tempstr "none") (savevar tempstr))
   (setq tempstr (strcat tempstr " is Added to System Save List")))
;
; LISP Command : prints a formated atomlist to text screen 
;
(defun C:LISP ()
   (*error*off)
   (clrscr) (prinxy 1 1 "List of LISP ATOMs and Symbols ")
   (setq x 1) (setq y 3) (setq n 0) 
   (while (< n (length (eval Vlist))) 
      (if (and (> x 54) (< y 25)) (setq y (1+ y)))
      (setq x (if (> x 54) 1 (+ x 13)))
      (if (and (= x 1) (= y 25)) (print))
      (prinxy x y (nth n (eval Vlist))) 
      (setq n (1+ n)))
   (*error*on)
   (terpri))
;
; LSTATUS : LISP Status Report
; 
(defun C:LSTATUS ( / temp temptype )
   (*error*off)
   (clrscr) (prinxy 1 24 "LISP Status Report")
   (setq n 0) (terpri)
   (while (< n (length (eval Vlist))) 
      (setq temp (nth n (eval Vlist)))
      (setq temptype (type (eval temp))) 
      (if (and (/= temptype nil) (/= temptype 'SUBR))
         (progn (terpri) (terpri) (prinxy 1 24 temp) 
            (if (= temptype 'LIST)
               (if (= (type (car (eval temp))) 'PAGETB)
                  (progn (prinxy 14 24 " Paged Function")
                     (if (> (length (cdr (eval temp))) 1)
                        (prinxy 29 24 " - Paged In") 
                        (prinxy 29 24 " - Paged Out") )) 
                  (prinxy 14 24 " LIST or Function on Heap") )
               (progn (prinxy 15 24 temptype) (prinxy 20 24 " on Heap") ))))
      (setq n (1+ n)))
   (*error*on) (terpri)
)
;

; set start of user ATOMs marker
;
(setq Tempstr '<-USER-<)
;
; Return with prompt string
;
(prompt "(c)1986 ADSI - LISP Supervisor Vers 2.5 - ")
