VERSION 2.00
Begin Form fMain 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Create DBF"
   ClientHeight    =   4335
   ClientLeft      =   1485
   ClientTop       =   1650
   ClientWidth     =   6540
   Height          =   4740
   Left            =   1425
   LinkTopic       =   "Form1"
   ScaleHeight     =   4335
   ScaleWidth      =   6540
   Top             =   1305
   Width           =   6660
   Begin CommandButton Command2 
      Caption         =   "&Close"
      Height          =   375
      Left            =   1320
      TabIndex        =   16
      Top             =   3840
      Width           =   975
   End
   Begin CommandButton Command1 
      Caption         =   "&Ok"
      Height          =   375
      Left            =   240
      TabIndex        =   15
      Top             =   3840
      Width           =   975
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Table Structure"
      Height          =   3015
      Left            =   240
      TabIndex        =   2
      Top             =   720
      Width           =   6015
      Begin CommandButton Command5 
         Caption         =   "&Delete"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   375
         Left            =   2040
         TabIndex        =   20
         Top             =   2520
         Width           =   855
      End
      Begin CommandButton Command4 
         Caption         =   "&Update"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   375
         Left            =   1080
         TabIndex        =   18
         Top             =   2520
         Width           =   855
      End
      Begin CommandButton Command3 
         Caption         =   "&Add"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   17
         Top             =   2520
         Width           =   855
      End
      Begin TextBox ctrDec 
         Alignment       =   1  'Right Justify
         Height          =   375
         Left            =   5280
         MaxLength       =   3
         MultiLine       =   -1  'True
         TabIndex        =   13
         Text            =   "0"
         Top             =   2400
         Width           =   615
      End
      Begin TextBox ctrLength 
         Alignment       =   1  'Right Justify
         Height          =   375
         Left            =   3840
         MaxLength       =   3
         MultiLine       =   -1  'True
         TabIndex        =   12
         Text            =   "10"
         Top             =   2400
         Width           =   735
      End
      Begin Frame Frame2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Type"
         Height          =   1455
         Left            =   3840
         TabIndex        =   6
         Top             =   720
         Width           =   2055
         Begin OptionButton rdbType 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Memo"
            Height          =   255
            Index           =   4
            Left            =   480
            TabIndex        =   19
            Top             =   1080
            Width           =   975
         End
         Begin OptionButton rdbType 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Logical"
            Height          =   255
            Index           =   3
            Left            =   960
            TabIndex        =   10
            Top             =   720
            Width           =   975
         End
         Begin OptionButton rdbType 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Number"
            Height          =   255
            Index           =   2
            Left            =   960
            TabIndex        =   9
            Top             =   360
            Width           =   975
         End
         Begin OptionButton rdbType 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Date"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   8
            Top             =   720
            Width           =   735
         End
         Begin OptionButton rdbType 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Char"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   7
            Top             =   360
            Value           =   -1  'True
            Width           =   735
         End
      End
      Begin TextBox ctrFieldName 
         Height          =   375
         Left            =   3840
         MaxLength       =   10
         TabIndex        =   5
         Top             =   240
         Width           =   2055
      End
      Begin ListBox lstFields 
         Height          =   2175
         Left            =   120
         TabIndex        =   3
         TabStop         =   0   'False
         Top             =   360
         Width           =   2775
      End
      Begin Label Label4 
         Alignment       =   1  'Right Justify
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "Dec"
         Height          =   195
         Left            =   4800
         TabIndex        =   14
         Top             =   2400
         Width           =   360
      End
      Begin Label Label3 
         Alignment       =   1  'Right Justify
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "Length"
         Height          =   195
         Left            =   3120
         TabIndex        =   11
         Top             =   2400
         Width           =   600
      End
      Begin Label Label2 
         Alignment       =   1  'Right Justify
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Name"
         Height          =   255
         Left            =   3000
         TabIndex        =   4
         Top             =   240
         Width           =   735
      End
   End
   Begin TextBox ctrFileName 
      Height          =   375
      Left            =   1200
      TabIndex        =   1
      Top             =   240
      Width           =   5055
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Filename"
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   855
   End
End
Option Explicit

' declarations of DLL routines
Declare Function z1Init_Dbf Lib "z1_Dbf.dll" () As Integer
Declare Function z1Add_Dbf_Field Lib "z1_Dbf.dll" (ByVal hDbf As Integer, ByVal cFieldname As String, ByVal cType As String, ByVal length As Integer, ByVal dec As Integer) As Integer
Declare Function z1Create_Dbf Lib "z1_Dbf.dll" (ByVal hDbf As Integer, ByVal cFilename As String) As Integer

Sub Command1_Click ()
    Dim i As Integer
    Dim hDbf As Integer
    Dim cName As String
    Dim cType As String
    Dim nLength As Integer
    Dim nDec As Integer
    Dim x As Integer

    ' create the dbf now
    If ctrFilename = "" Then
        MsgBox "Invalid filename!", 16, "Error"
        Exit Sub
    End If

    hDbf = z1Init_Dbf()
    If hDbf = 0 Then
        MsgBox "Unable to initialise Z1_DBF.DLL", 16, "Error"
        Exit Sub
    End If
    
    ' go to the end of the list so we can then go back to the top
    lstFields.ListIndex = lstFields.ListCount - 1
    For i = 0 To lstFields.ListCount - 1
        ' set position is the same as click
        lstFields.ListIndex = i
        
        ' we should now have the fields setup correctly
        cName = ctrFieldName
        If rdbType(0) Then
            cType = "C"
        ElseIf rdbType(1) Then
            cType = "D"
        ElseIf rdbType(2) Then
            cType = "N"
        ElseIf rdbType(3) Then
            cType = "L"
        ElseIf rdbType(4) Then
            cType = "M"
        End If
        
        nLength = Val(ctrLength)
        nDec = Val(ctrDec)
        If z1Add_Dbf_Field(hDbf, cName, cType, nLength, nDec) = 0 Then
            MsgBox "Unable to add field " + Str(i)
            Exit Sub
        End If
    Next

    cName = ctrFilename + ".dbf"
    x = z1Create_Dbf(hDbf, cName)
    If x = 0 Then
        MsgBox "Unable to create DBF file: " & cName, 16, "Error"
    Else
        MsgBox "DBF file: " & cName & " created!", 0, "Make DBF"
    End If

End Sub

Sub Command2_Click ()
    Unload Me
End Sub

Sub Command3_Click ()
    Dim cField As String
    ' add a new field
    If ctrFieldName <> "" Then
        cField = ctrFieldName
        If rdbType(0) Then
            cField = cField + ", Char"
            cField = cField & ", " & ctrLength
        ElseIf rdbType(1) Then
            cField = cField + ", Date"
        ElseIf rdbType(2) Then
            cField = cField + ", Number"
            cField = cField & ", " & ctrLength + "." & ctrDec
        ElseIf rdbType(3) Then
            cField = cField + ", Logical"
        ElseIf rdbType(4) Then
            cField = cField + ", Memo"
        End If
        
        lstFields.AddItem cField
    
    End If
    
End Sub

Sub Command4_Click ()
    Dim cField As String
    
    If lstFields.ListIndex >= 0 Then
        ' update field
        If ctrFieldName <> "" Then
            cField = ctrFieldName
            If rdbType(0) Then
                cField = cField + ", Char"
                cField = cField & ", " & ctrLength
            ElseIf rdbType(1) Then
                cField = cField + ", Date"
            ElseIf rdbType(2) Then
                cField = cField + ", Number"
                cField = cField & ", " & ctrLength + "." & ctrDec
            ElseIf rdbType(3) Then
                cField = cField + ", Logical"
            ElseIf rdbType(4) Then
                cField = cField + ", Memo"
            End If
            
            lstFields.List(lstFields.ListIndex) = cField
        
        End If
    End If
    
End Sub

Sub Command5_Click ()
    If lstFields.ListCount > 0 And lstFields.ListIndex >= 0 Then
        lstFields.RemoveItem lstFields.ListIndex
    End If
End Sub

Sub ctrFieldName_KeyPress (KeyAscii As Integer)
    KeyAscii = Asc(UCase(Chr(KeyAscii)))
End Sub

Sub lstFields_Click ()
    Dim cText As String, cBit As String
    Dim i As Integer
    ' update fields based on current selection

    cText = lstFields.Text + ","
    i = InStr(cText, ",")
    If i > 0 Then
        cBit = Trim(Left(cText, i - 1))
        cText = Mid(cText, i + 1)
        ctrFieldName = cBit
        i = InStr(cText, ",")
        If i > 0 Then
            cBit = LTrim(Trim(Left(cText, i - 1)))
            cText = Mid(cText, i + 1)
            Select Case cBit
                Case "Char"
                    rdbType(0) = True
                Case "Date"
                    rdbType(1) = True
                Case "Number"
                    rdbType(2) = True
                Case "Logical"
                    rdbType(3) = True
                Case "Memo"
                    rdbType(4) = True
            End Select
            i = InStr(cText, ",")
            If i > 0 Then
                cBit = Trim(Left(cText, i - 1))
                cText = Mid(cText, i + 1)
                ctrLength = cBit
                If i > 0 Then
                    cBit = Trim(Left(cText, i - 1))
                    cText = Mid(cText, i + 1)
                    ctrDec = cBit
                End If
            End If
        End If
    End If

End Sub

Sub rdbType_Click (Index As Integer)

    Select Case Index
        Case 0
            ' length only
            ctrLength.Enabled = True
            ctrDec.Enabled = False
        Case 1
            ctrLength = 8
            ctrDec = 0
            ctrLength.Enabled = False
            ctrDec.Enabled = False
        Case 2
            ctrLength.Enabled = True
            ctrDec.Enabled = True
        Case 3
            ctrLength = 1
            ctrDec = 0
            ctrLength.Enabled = False
            ctrDec.Enabled = False
        Case 4
            ctrLength = 10
            ctrDec = 0
            ctrLength.Enabled = False
            ctrDec.Enabled = False
    End Select
End Sub

