VERSION 2.00
Begin Form frmGetSetDimen 
   Caption         =   "Get/Set Label Dimensions"
   ClientHeight    =   4065
   ClientLeft      =   525
   ClientTop       =   1350
   ClientWidth     =   5295
   Height          =   4755
   Left            =   465
   LinkTopic       =   "Form3"
   ScaleHeight     =   4065
   ScaleWidth      =   5295
   Top             =   720
   Width           =   5415
   Begin CommonDialog CMDialog1 
      CancelError     =   -1  'True
      DialogTitle     =   "Select Directory"
      Left            =   5040
      Top             =   0
   End
   Begin OptionButton optDown 
      Caption         =   "Down"
      Height          =   255
      Left            =   360
      TabIndex        =   20
      Top             =   3420
      Width           =   1785
   End
   Begin OptionButton optAcross 
      Caption         =   "Across"
      Height          =   285
      Left            =   360
      TabIndex        =   19
      Top             =   3090
      Width           =   1725
   End
   Begin TextBox txtVertGap 
      Height          =   285
      Left            =   3690
      TabIndex        =   7
      Top             =   2220
      Width           =   1185
   End
   Begin TextBox txtHeight 
      Height          =   285
      Left            =   960
      TabIndex        =   6
      Top             =   2220
      Width           =   1185
   End
   Begin TextBox txtHorzGap 
      Height          =   285
      Left            =   3690
      TabIndex        =   5
      Top             =   1770
      Width           =   1185
   End
   Begin TextBox txtWidth 
      Height          =   285
      Left            =   960
      TabIndex        =   4
      Top             =   1740
      Width           =   1185
   End
   Begin TextBox txtBottom 
      Height          =   285
      Left            =   3690
      TabIndex        =   3
      Top             =   930
      Width           =   1185
   End
   Begin TextBox txtTop 
      Height          =   285
      Left            =   930
      TabIndex        =   2
      Top             =   900
      Width           =   1185
   End
   Begin TextBox txtRight 
      Height          =   285
      Left            =   3690
      TabIndex        =   1
      Top             =   480
      Width           =   1185
   End
   Begin TextBox txtLeft 
      Height          =   285
      Left            =   930
      TabIndex        =   0
      Top             =   450
      Width           =   1185
   End
   Begin Shape Shape3 
      Height          =   825
      Left            =   300
      Top             =   3030
      Width           =   1995
   End
   Begin Label Label10 
      AutoSize        =   -1  'True
      Caption         =   "Direction:"
      FontBold        =   -1  'True
      FontItalic      =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   300
      TabIndex        =   18
      Top             =   2790
      Width           =   930
   End
   Begin Label Label9 
      AutoSize        =   -1  'True
      Caption         =   "Labels Dimensions:"
      FontBold        =   -1  'True
      FontItalic      =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   300
      TabIndex        =   17
      Top             =   1440
      Width           =   1740
   End
   Begin Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Printer Margins:"
      FontBold        =   -1  'True
      FontItalic      =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FF0000&
      Height          =   195
      Left            =   300
      TabIndex        =   16
      Top             =   120
      Width           =   1440
   End
   Begin Shape Shape2 
      Height          =   945
      Left            =   300
      Top             =   1680
      Width           =   4725
   End
   Begin Shape Shape1 
      Height          =   915
      Left            =   300
      Top             =   360
      Width           =   4695
   End
   Begin Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Vertical Gap:"
      Height          =   195
      Left            =   2520
      TabIndex        =   15
      Top             =   2280
      Width           =   1125
   End
   Begin Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Horizontal Gap:"
      Height          =   195
      Left            =   2340
      TabIndex        =   14
      Top             =   1800
      Width           =   1335
   End
   Begin Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Height:"
      Height          =   195
      Left            =   330
      TabIndex        =   13
      Top             =   2280
      Width           =   630
   End
   Begin Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Width:"
      Height          =   195
      Left            =   390
      TabIndex        =   12
      Top             =   1800
      Width           =   570
   End
   Begin Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Bottom:"
      Height          =   195
      Left            =   3000
      TabIndex        =   11
      Top             =   960
      Width           =   660
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Top:"
      Height          =   195
      Left            =   510
      TabIndex        =   10
      Top             =   930
      Width           =   405
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Right:"
      Height          =   195
      Left            =   3150
      TabIndex        =   9
      Top             =   540
      Width           =   525
   End
   Begin Label lblLeft 
      AutoSize        =   -1  'True
      Caption         =   "Left:"
      Height          =   195
      Left            =   510
      TabIndex        =   8
      Top             =   480
      Width           =   405
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuOpen 
         Caption         =   "&Open..."
      End
      Begin Menu mnuSave 
         Caption         =   "&Save"
      End
      Begin Menu sep1 
         Caption         =   "-"
      End
      Begin Menu mnuExit 
         Caption         =   "&Close"
      End
   End
End
Option Explicit

Sub cmdGetDimensions_Click ()
    
    Dim dimensions As LABEL_DIMENSIONS
    Dim saveErr As Integer
    Dim Filename As String
    Dim errcode As Integer

    cmdialog1.DialogTitle = "Select Report File"
    cmdialog1.Filename = ""
    cmdialog1.Filter = "Reports (*.rpt) | *.rpt "
    cmdialog1.FilterIndex = 1
    cmdialog1.Flags = OFN_PATHMUSTEXIST Or OFN_READONLY
    On Error Resume Next
        cmdialog1.Action = DLG_FILE_OPEN
        saveErr = Err
    On Error GoTo 0
    If saveErr <> 0 Then Exit Sub
    
    mousepointer = 11
    Filename = cmdialog1.Filename
    GetSetLabelDimensions Filename, dimensions, XTAL_GET_LABEL, errcode
    If (errcode <> 0) And (errcode <> XTAL_NO_LABELINFO) Then
       mousepointer = 0
       MsgBox "Error code:" & Str$(errcode)
       cmdialog1.Filename = ""
       Exit Sub
    End If
    
    If errcode = XTAL_NO_LABELINFO Then
       MsgBox "No label dimensions nor direction."
    End If
    txtLeft.Text = Format$(dimensions.leftmargin, "##0.00")
    txtRight.Text = Format$(dimensions.rightmargin, "##0.00")
    txtTop.Text = Format$(dimensions.topmargin, "##0.00")
    txtBottom.Text = Format$(dimensions.bottommargin, "##0.00")
    txtWidth.Text = Format$(dimensions.labelwidth, "##0.00")
    txtHeight.Text = Format$(dimensions.labelheight, "##0.00")
    txtHorzGap.Text = Format$(dimensions.horzgap, "##0.00")
    txtVertGap.Text = Format$(dimensions.vertgap, "##0.00")
    
    If dimensions.direction = 1 Then
       optAcross.Value = True
    Else
       optDown.Value = True
    End If
    mousepointer = 0

End Sub

Sub cmdSetDimensions_Click ()
    
    Dim dimensions As LABEL_DIMENSIONS
    Dim saveErr As Integer
    Dim Filename As String
    Dim errcode As Integer

    mousepointer = 11
    dimensions.leftmargin = Val(txtLeft.Text)
    dimensions.rightmargin = Val(txtRight.Text)
    dimensions.topmargin = Val(txtTop.Text)
    dimensions.bottommargin = Val(txtBottom.Text)
    dimensions.labelwidth = Val(txtWidth.Text)
    dimensions.labelheight = Val(txtHeight.Text)
    dimensions.horzgap = Val(txtHorzGap.Text)
    dimensions.vertgap = Val(txtVertGap.Text)
    If optAcross.Value Then
       dimensions.direction = 1
    Else
       dimensions.direction = 2
    End If

    Filename = cmdialog1.Filename
    GetSetLabelDimensions Filename, dimensions, XTAL_SET_LABEL, errcode
    mousepointer = 0
    If errcode <> 0 Then
       MsgBox "Error code:" & Str$(errcode)
       Exit Sub
    End If

End Sub

Sub mnuExit_Click ()
Unload Me

End Sub

Sub mnuFile_Click ()

mnuSave.Enabled = Len(Trim$(cmdialog1.Filename)) > 0


End Sub

Sub mnuOpen_Click ()
cmdGetDimensions_Click

End Sub

Sub mnuSave_Click ()
cmdSetDimensions_Click
End Sub

Sub SelectText (source As Control)
    source.SelStart = 0
    source.SelLength = Len(source.Text)
End Sub

Sub txtBottom_GotFocus ()
    SelectText txtBottom
End Sub

Sub txtHeight_GotFocus ()
    SelectText txtHeight
End Sub

Sub txtHorzGap_GotFocus ()
    SelectText txtHorzGap
End Sub

Sub txtLeft_GotFocus ()
    SelectText txtLeft
End Sub

Sub txtRight_GotFocus ()
   SelectText txtRight
End Sub

Sub txtTop_GotFocus ()
   SelectText txtTop
End Sub

Sub txtVertGap_GotFocus ()
   SelectText txtVertGap
End Sub

Sub txtWidth_GotFocus ()
   SelectText txtWidth
End Sub

