/*
Ŀ
 vxBase xbase for Visual Basic library                                    
 Copyright 1993 vxBase Systems                                            
Ĵ
 SYSTEM          VX    PROGRAM ID  VXB.H   CREATION DATE   09/24/91  
Ĵ
 PROGRAM TITLE    vxbase dynamic link lib header file                    
Ĵ
 REV  DATE  BY  DESCRIPTION                Written by T. Orletsky     
Ĵ
 001 920307 TO  add functions vxInit and vxDeallocate                  
 002 920313 TO  add function vxReplLogical                             
 003 920317 TO  add functions vxJoinNoAuto, vxDbfDate                  
 003 930504 TO  add functions vxPictureImport, vxIsPicture             

*/

/* ********************************************************* */
/*                 Function Prototypes                       */
/*                                                           */ 
/*      ensure that windows.h is included BEFORE vxb.h       */
/*      vxbase.lib must be included in your make             */
/*                                                           */ 
/* Functions NOT defined here that are described in the      */
/* vxbase manual are for Visual Basic only. They operate on  */
/* VB controls included in the Microsoft CDK VB API lib.     */ 
/*                                                           */ 
/* ********************************************************* */

   int    FAR  PASCAL vxAppendBlank (void);
   int    FAR  PASCAL vxAppendFrom  (char *);
   int    FAR  PASCAL vxAreaDbf     (char *);
   int    FAR  PASCAL vxAreaNtx     (char *);
   HANDLE FAR PASCAL  vxBlobRead    (char *);
   int    FAR PASCAL  vxBlobWrite   (HANDLE, char *);
   int    FAR  PASCAL vxBof         (void);
   int    FAR  PASCAL vxBottom      (void);
   void   FAR  PASCAL vxBrowse      (HWND, int, int, int, int, int, long, char *, long *);
   void   FAR  PASCAL vxBrowseCase  (int);
   void   FAR  PASCAL vxBrowsePos   (int, int, int, int);
   void   FAR  PASCAL vxBrowseSetup (int, int, int, int, char *, int, int, int, int, int, int); 
   long   FAR  PASCAL vxChar        (char *); 
   int    FAR  PASCAL vxClose       (void);
   int    FAR  PASCAL vxCloseAll    (void);
   int    FAR  PASCAL vxCloseNtx    (int);
   void   FAR  PASCAL vxCollate     (int *);
   int    FAR  PASCAL vxCopy        (char *);
   int    FAR  PASCAL vxCopyStruc   (char *);
   int    FAR  PASCAL vxCreateDbf   (char *, int, char *);
   int    FAR  PASCAL vxCreateNtx   (char *, char *);
   int    FAR  PASCAL vxCreateSubNtx(char *, char *, char *);
   int    FAR  PASCAL vxCtlBrowse   (HWND, int, int, int, long, HWND, char *);
   long   FAR  PASCAL vxCtlBrowseMsg(HWND, int, void *);
   int    FAR  PASCAL vxCtlFormat   (int, int, int);
   void   FAR  PASCAL vxCtlGraySet  (void);
   void   FAR  PASCAL vxCtlGrayReset(void);
   long   FAR  PASCAL vxDateFormat  (char *);
   long   FAR  PASCAL vxDateString  (char *, int);
   int    FAR  PASCAL vxDbfCurrent  (void);
   long   FAR  PASCAL vxDbfDate     (void);
   long   FAR  PASCAL vxDbfName     (void);
   int    FAR  PASCAL vxDeallocate  (void);
   int    FAR  PASCAL vxDecimals    (char *);
   int    FAR  PASCAL vxDeleted     (void);
   int    FAR  PASCAL vxDeleteRange (long, long);
   int    FAR  PASCAL vxDeleteRec   (void);
   long   FAR  PASCAL vxDescend     (char *);
   void   FAR  PASCAL vxDouble      (char *, double *);
   int    FAR  PASCAL vxEmpty       (char *);
   int    FAR  PASCAL vxEof         (void);
   int    FAR  PASCAL vxEval        (char *);
   int    FAR  PASCAL vxEvalDouble  (char *, double *);
   int    FAR  PASCAL vxEvalLogical (char *, char *);
   int    FAR  PASCAL vxEvalString  (char *, char *);
   void   FAR  PASCAL vxExactOff    (void);
   void   FAR  PASCAL vxExactOn     (void);
   long   FAR  PASCAL vxField       (char *); 
   int    FAR  PASCAL vxFieldCount  (void);
   long   FAR  PASCAL vxFieldName   (int);
   int    FAR  PASCAL vxFieldSize   (char *);
   long   FAR  PASCAL vxFieldTrim   (char *);
   long   FAR  PASCAL vxFieldType   (char *);
   int    FAR  PASCAL vxFile        (char *);
   void   FAR  PASCAL vxFilter      (char *);
   void   FAR  PASCAL vxFilterReset (void);
   void   FAR  PASCAL vxFormFrame   (HWND);
   int    FAR  PASCAL vxFound       (void);
   long   FAR  PASCAL vxGetVersion  (void);
   int    FAR  PASCAL vxGo          (long);
   void   FAR  PASCAL vxInit        (void);
   int    FAR  PASCAL vxInteger     (char *);
   int    FAR  PASCAL vxIsMemo      (char *);
   int    FAR  PASCAL vxIsPicture   (char *);
   int    FAR  PASCAL vxIsRecLocked (void);
   int    FAR  PASCAL vxIsSubNtx    (int);
   void   FAR  PASCAL vxJoin        (int, int, char *, int, char *);
   void   FAR  PASCAL vxJoinNoAuto  (void);
   void   FAR  PASCAL vxJoinReset   (void);
   long   FAR  PASCAL vxLocate      (char *, int);
   long   FAR  PASCAL vxLocateAgain (int);
   int    FAR  PASCAL vxLockDbf     (void);
   int    FAR  PASCAL vxLocked      (void);
   int    FAR  PASCAL vxLockRecord  (void);
   void   FAR  PASCAL vxLockRetry   (int, int);
   long   FAR  PASCAL vxLong        (char *);
   long   FAR  PASCAL vxMemCompact  (void);
   int    FAR  PASCAL vxMemoClear   (char *);
   void   FAR  PASCAL vxMemoEdit    (HWND, char *);
   void   FAR  PASCAL vxMemoPos     (int, int, int, int, char *);
   long   FAR  PASCAL vxMemoRead    (char *, int);
   int    FAR  PASCAL vxMemRealloc  (int, int, int);
   void   FAR  PASCAL vxMenuDeclare (int);
   void   FAR  PASCAL vxMenuItem    (int, int, char *, int);
   int    FAR  PASCAL vxNtxCurrent  (void);
   int    FAR  PASCAL vxNtxDeselect (void);
   long   FAR  PASCAL vxNtxExpr     (int);
   long   FAR  PASCAL vxNtxName     (int);
   long   FAR  PASCAL vxNtxRecNo    (void);
   long   FAR  PASCAL vxNtxSubExpr  (int);
   long   FAR  PASCAL vxNumRecs     (void);
   long   FAR  PASCAL vxNumRecsFilter(void);
   long   FAR  PASCAL vxNumRecsSub  (void);
   int    FAR  PASCAL vxPack        (HWND);
   int    FAR  PASCAL vxPictureImport (char *, char *);
   int    FAR  PASCAL vxPictureRead   (HWND, char *);
   long   FAR  PASCAL vxPrinterDefault(void);
   long   FAR  PASCAL vxPrinterEnum   (int);
   int    FAR  PASCAL vxPrinterSelect (char *);
   int    FAR  PASCAL vxRecall      (void);
   long   FAR  PASCAL vxRecNo       (void);
   int    FAR  PASCAL vxRecord      (char *);
   int    FAR  PASCAL vxRecSize     (void);
   int    FAR  PASCAL vxReindex     (void);
   void   FAR  PASCAL vxReplDate    (char *, char *);
   void   FAR  PASCAL vxReplDateString(char *, char *);
   void   FAR  PASCAL vxReplDouble  (char *, double *);
   void   FAR  PASCAL vxReplInteger (char *, int *);
   void   FAR  PASCAL vxReplLogical (char *, int);
   void   FAR  PASCAL vxReplLong    (char *, long *);
   int    FAR  PASCAL vxReplMemo    (char *, char *);
   void   FAR  PASCAL vxReplRecord  (char *);
   void   FAR  PASCAL vxReplString  (char *, char *);
   int    FAR  PASCAL vxSeek        (char *);
   int    FAR  PASCAL vxSeekFast    (char *);
   int    FAR  PASCAL vxSeekSoft    (char *);
   int    FAR  PASCAL vxSelectDbf   (int);
   int    FAR  PASCAL vxSelectNtx   (int);
   int    FAR  PASCAL vxSetAlias    (char *, int);
   void   FAR  PASCAL vxSetAnsi     (int);
   void   FAR  PASCAL vxSetCollate  (int);
   void   FAR  PASCAL vxSetDate     (int);
   void   FAR  PASCAL vxSetErrorCaption(char *);
   void   FAR  PASCAL vxSetErrorMethod (int);
   int    FAR  PASCAL vxSetHandles  (int);
   void   FAR  PASCAL vxSetLanguage (int);
   void   FAR  PASCAL vxSetLocks    (int);
   void   FAR  PASCAL vxSetMeters   (int);
   int    FAR  PASCAL vxSetRelation (int, char *);
   void   FAR  PASCAL vxSetSelect   (int);
   void   FAR  PASCAL vxSetString   (int);
   void   FAR  PASCAL vxSetupPrinter(HWND);
   int    FAR  PASCAL vxSkip        (long);
   void   FAR  PASCAL vxSum         (char *, double *);
   void   FAR  PASCAL vxTableDeclare(long, char *, char *, int, int, int);
   void   FAR  PASCAL vxTableField  (int, char *, char *, int );
   void   FAR  PASCAL vxTableFieldExt(int, char *, char *, int, int, int);
   void   FAR  PASCAL vxTableReset  (void);
   int    FAR  PASCAL vxTestNtx     (int);
   int    FAR  PASCAL vxTop         (void);
   int    FAR  PASCAL vxTrue        (char *);
   int    FAR  PASCAL vxUnlock      (void);
   int    FAR  PASCAL vxUseDbf      (char *);
   int    FAR  PASCAL vxUseDbfAgain (char *);
   int    FAR  PASCAL vxUseDbfEX    (char *);
   int    FAR  PASCAL vxUseDbfRO    (char *);
   int    FAR  PASCAL vxUseNtx      (char *);
   void   FAR  PASCAL vxWindowDereg (HWND);
   int    FAR  PASCAL vxWrite       (void);
   int    FAR  PASCAL vxWriteHdr    (void);
   int    FAR  PASCAL vxZap         (void);


/* ********************************************************* */
/*        c function prototypes to create 3d controls        */
/*        in dialog boxes. Adapted from Ray Donahue's        */
/*        three_d.dll                                        */
/*        DO NOT USE VB SPECIFIC vxCtlStyle/vxCtlLength      */
/* ********************************************************* */
   void   FAR PASCAL      Draw3dShadow   (HWND,WORD);
   void   FAR PASCAL      Draw3dBorder   (HWND,WORD,int,int);
   void   FAR PASCAL      Draw3dFrame    (HWND,int);
   HBRUSH FAR PASCAL      Control3dColor (HWND,WORD);

#define WM_3DPAINT      (WM_USER+100)
#define INSIDE_FRAME    0
#define OUTSIDE_FRAME   1
#define RAISED          0
#define RECESSED        1
#define CREASED         2
#define SHADOW          3


/* ********************************************************* */
/*        c specific functions not documented in             */
/*        vxbase manual                                      */
/* ********************************************************* */
   void   FAR  PASCAL vxbTrim       (char *, int);
   // right trim where char* is pointer to string
   // and int is the string length
   // (note: does not require 0 delimited string)

   void   FAR  PASCAL vxErrorMsg(int);
   // display a vxbase error message

   int    FAR  PASCAL vxChrToInt(char *, int);
   // convert string to integer where char * is
   // pointer to string and int is the string length
   // (note: does not require 0 delimited string)

   char * FAR PASCAL vxLongToChr(long, char *, int);
   // convert long to string whose length is int
   // returns pointer to same string as param 2

   char * FAR PASCAL vbFormatDate (char *, char *);
   // change xbase date string (CCYYMMDD) (1st param)
   // into format specified by 2nd param (e.g. "MM/DD/YY")



/* ********************************************************* */
/*      error structure if alternate error method is used    */
/* ********************************************************* */
typedef struct
   {
   int  ErrorNum;
   char ErrorMsg[80];
   int  DbfArea;
   int  NtxArea;
   char DbfName[80];
   char NtxName[80];
   char BadParm[80];
   }  VXERRORSTRUC;

typedef VXERRORSTRUC *PVXERROR;

int FAR PASCAL vxErrorTest(PVXERROR);

/* ********************************************* */
/* field structure for file create using vbCreate*/
/* ********************************************* */
typedef struct
   {
   char    name[11];
   char    type;
   int     width;
   int     decimals;
   int     internaluse;
   }  FIELD;


// function gets pointer to current field array
FIELD * FAR PASCAL  vbFldPtr (void);

  int   FAR PASCAL  vbCreate (char *, int, FIELD *);

// param 1 = file name
// param 2 = number of fields
// param 3 = FIELD structure defining the field
//           leave internaluse integer as zero

/* ******************* */
/* index key structure */
/* ******************* */
typedef struct
   {
   long  blockno;
   long  dbf_recno;
   char  key_size[512 - 3 * sizeof(long)];
   }  KEY;

/* **************************** */
/* undocumented index functions */
/* **************************** */

// position index pointer to first index rec in tree
   int    FAR PASCAL vbNtxTop     (int);
// param 1 = virtual index area (vxUseNtx area - 1)

// skip inside an index tree
   long   __export FAR PASCAL vbNtxSkip    (int, long);
// param 1 = virtual index area (vxUseNtx area - 1)
// param 2 = number of recs to skip (negative backwards)

// get a pointer to the current key structure
   KEY *  __export FAR PASCAL vbNtxKey     (int);
// param 1 = virtual index area (vxUseNtx area - 1)
// the result is defined as
//         KEY    *IndexKey;
// and the current dbf rec number can be extracted with
//   IndexKey  = vbNtxKey(IndexArea - 1);
//   CurrRecNo = IndexKey->dbf_recno;


/* ********************************************************* */
/*                    miscellaneous definitions              */
/* ********************************************************* */

/* ********************************************************* */
/*      browse return values                                 */
/* ********************************************************* */
#define BROWSE_CLOSED  -1L
#define BROWSE_EDIT    -2L
#define BROWSE_ADD     -3L
#define BROWSE_DELETE  -4L
#define BROWSE_ERROR   -5L
#define BROWSE_USER    -6L

/* ********************************************************* */
/*      menu types                                           */
/* ********************************************************* */
#define VX_SEPBAR   2
#define VX_MENUHEAD 1
#define VX_RETURN   0

/* ********************************************************* */
/*      date types                                           */
/* ********************************************************* */
#define VX_AMERICAN 0
#define VX_ANSI     1
#define VX_BRITISH  2
#define VX_FRENCH   3
#define VX_GERMAN   4
#define VX_ITALIAN  5
#define VX_DUTCH    6
#define VX_SPANISH  7

/* language types    */
/* (including above) */
/* ***************** */
#define VX_ENGLISH  0

/* ********************************************************* */
/*         color references are defined as 0x00bbggrr        */
/* ********************************************************* */
#define VX_RED        0x000000FF
#define VX_BLUE       0x00FF0000
#define VX_GRAY       0x00C0C0C0

/* ********************************************************* */
/*      vxTableField types                                   */
/* ********************************************************* */
#define VX_FIELD 0
#define VX_EXPR  1

/* ********************************************************* */
/*      vxBrowseCase types                                   */
/* ********************************************************* */
#define VX_UPPER 0
#define VX_LOWER 1

/* ********************************************************* */
/*      vxCtlFormat types (including VX_UPPER above)         */
/* ********************************************************* */
#define VX_CHAR       1
#define VX_ALPHA      2
#define VX_NUM        3
#define VX_DATE       4
#define VX_PASSWORD   5

/* ********************************************************* */
/*      vxSetString types                                    */
/* ********************************************************* */
#define VX_VBSTRING 0
#define VX_ASCIIZ   1

/* ********************************************************* */
/*      font weights for vxBrowseSetup                       */
/* ********************************************************* */
#define VX_DONTCARE      0
#define VX_THIN        100
#define VX_EXTRALIGHT  200
#define VX_LIGHT       300
#define VX_NORMAL      400
#define VX_MEDIUM      500
#define VX_SEMIBOLD    600
#define VX_BOLD        700
#define VX_EXTRABOLD   800
#define VX_HEAVY       900

/* ********************************************************* */
/*      vxCtlBrowse Messages                                 */
/* ********************************************************* */
#define VXB_REFRESH        0
#define VXB_FILTERDLG      1
#define VXB_FILTERPRG      2
#define VXB_GETCURRENTREC  3
#define VXB_GETTOPREC      4
#define VXB_STATS          5
#define VXB_CASE           6
#define VXB_SEARCHDLG      7
#define VXB_SEARCHPRG      8
#define VXB_SEARCHAGAIN    9
#define VXB_SEEK          10
#define VXB_CLOSE         11
#define VXB_QUICKDISPLAY  12

/* ********************************************************* */
/*                        End Header                         */
/* ********************************************************* */
