'INIMAINT.BAS: VBC Version

Sub ChangeFileList (filestr$)

    IniFileName$ = "VIRTEXT.INI"  'name of ini file
    AppName$ = "Display"          'Name of application or section heading
    KeyName$ = "File1"            'Keyword or variable name"
    DefaultStr$ = "NONE"
    Numeric% = 0                  'Tell it we are looking for a string
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

'***********************************************************
'   If NONE is returned the file does not exist - create it
'***********************************************************

    If ReturnStr$ = "NONE" Then
    SaveFileINIFile
    SaveOptions
    End If

'***********************************************************
'*  Get the files that are saved we'll move them down one
'***********************************************************

For X = 1 To 5

    Select Case X
    Case 1
    KeyName$ = "File1"         'Keyword or variable name"
    Case 2
    KeyName$ = "File2"         'Keyword or variable name"
    Case 3
    KeyName$ = "File3"         'Keyword or variable name"
    Case 4
    KeyName$ = "File4"         'Keyword or variable name"
    Case 5
    KeyName$ = "File5"         'Keyword or variable name"
    End Select


    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    Select Case X
    Case 1
    File2$ = ReturnStr$          'Keyword or variable name"
    Case 2
    File3$ = ReturnStr$          'Keyword or variable name"
    Case 3
    File4$ = ReturnStr$          'Keyword or variable name"
    Case 4
    File5$ = ReturnStr$          'Keyword or variable name"
    Case 5
    File6$ = ReturnStr$          'Keyword or variable name"
    End Select

    If Trim$(ReturnStr$) = Trim$(FullFilePath) Then Exit Sub

Next

' Save the file name that was just selected

For X = 1 To 5

    IniFileName$ = "VIRTEXT.INI"    'name of ini file
    AppName$ = "Display"           'Name of application or section heading

    Select Case X
    Case 1
    KeyName$ = "File1"             'Keyword or variable name"
    NewVal$ = FullFilePath
    Case 2
    KeyName$ = "File2"             'Keyword or variable name"
    NewVal$ = File2$
    Case 3
    KeyName$ = "File3"             'Keyword or variable name"
    NewVal$ = File3$
    Case 4
    KeyName$ = "File4"             'Keyword or variable name"
    NewVal$ = File4$
    Case 5
    KeyName$ = "File5"             'Keyword or variable name"
    NewVal$ = File5$
    End Select

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

    If Trim$(NewVal$) <> "" Then
    VirtualText.zBar1.Visible = True
    VirtualText.mnuFileList(X).Visible = True
    VirtualText.mnuFileList(X).Caption = "&" + Trim$(Str$(X)) + " " + NewVal$
    End If

Next

End Sub

Sub ReadIni (AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$)

' Read data from Private Profile (.ini) File

If Numeric% Then    'we are looking for integer input
    Numeric% = GetPrivateProfileInt(AppName$, KeyName$, nDefault, IniFileName$)
Else
    Dim RetStr As String * 255 'Create an empty string to be filled
    nSize% = 255               'uncertain - possibly length of fill string
    lenRetString% = GetPrivateProfileString(AppName$, KeyName$, DefaultStr$, RetStr$, nSize%, IniFileName$)
    ReturnStr$ = Left$(RetStr$, lenRetString%)

End If

End Sub

Sub ReadINIFile ()

    IniFileName$ = "VIRTEXT.INI"        'name of ini file
    AppName$ = "Display"         'Name of application or section heading
    KeyName$ = "File1"         'Keyword or variable name"
    DefaultStr$ = "NONE"
    Numeric% = 0   'Tell it we are looking for a string
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$
'***********************************************************
'   If NONE is returned the file does not exist - create it
'***********************************************************

    If ReturnStr$ = "NONE" Then
        ' Initial Default
        optPrinterFont = "Courier New"
        optPrinterFontSize = Val("8.25")
        optPrinterFontBold = False
        optPrinterFontItalic = False
    
        SaveFileINIFile
        SaveOptions
        SaveFormPosition
    End If

'***********************************************************
'*  Get the files that are saved
'***********************************************************

For X = 1 To 5

    Select Case X
    Case 1
    KeyName$ = "File1"         'Keyword or variable name"
    Case 2
    KeyName$ = "File2"         'Keyword or variable name"
    Case 3
    KeyName$ = "File3"         'Keyword or variable name"
    Case 4
    KeyName$ = "File4"         'Keyword or variable name"
    Case 5
    KeyName$ = "File5"         'Keyword or variable name"
    End Select


    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    If Trim$(ReturnStr$) <> "" Then
    VirtualText.zBar1.Visible = True
    VirtualText.mnuFileList(X).Visible = True
    VirtualText.mnuFileList(X).Caption = "&" + Trim$(Str$(X)) + " " + ReturnStr$
    End If
Next


'***********************************************************
'*  Get the other information about the display
'***********************************************************

'*******************************
'   Read the Background color
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "BackColor"       'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    For X = 1 To NumArrays
    VirtualText.TextArray(X).BackColor = Val(ReturnStr$)
    Next

'*******************************
'   Read the Foreground color
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "ForeColor"       'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    For X = 1 To NumArrays
    VirtualText.TextArray(X).ForeColor = Val(ReturnStr$)
    Next


'*******************************
'   Read the FontName Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "FontName"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    For X = 1 To NumArrays
    VirtualText.TextArray(X).FontName = ReturnStr$
    Next

'*******************************
'   Read the FontSize Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "FontSize"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    For X = 1 To NumArrays
    VirtualText.TextArray(X).FontSize = Val(ReturnStr$)
    Next

'*******************************
'   Read the FontBold Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "FontBold"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    For X = 1 To NumArrays

    If ReturnStr$ = "YES" Then
        VirtualText.TextArray(X).FontBold = True
    Else
        VirtualText.TextArray(X).FontBold = False
    End If
    Next

'*******************************
'   Read the FontItalic Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "FontItalic"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    For X = 1 To NumArrays

    If ReturnStr$ = "YES" Then
        VirtualText.TextArray(X).FontItalic = True
    Else
        VirtualText.TextArray(X).FontItalic = False
    End If
    Next

'*******************************
'   Read the Vertical Scroll Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "VerticalScroll"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    If ReturnStr$ = "YES" Then
    VirtualText.mnuShowVerticalScroll.Checked = True
    VirtualText.VScroll1.Visible = True
    Else
    VirtualText.mnuShowVerticalScroll.Checked = False
    VirtualText.VScroll1.Visible = False
    End If

'*******************************
'   Read the Horizontal Scroll Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "HorizontalScroll"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    If ReturnStr$ = "YES" Then
    VirtualText.mnuShowHorizontalScroll.Checked = True
    VirtualText.HScroll1.Visible = True
    Else
    VirtualText.mnuShowHorizontalScroll.Checked = False
    VirtualText.HScroll1.Visible = False
    End If

'*******************************
'   Read the Status Bar Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "StatusBar"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    If ReturnStr$ = "YES" Then
    VirtualText.mnuShowStatusBar.Checked = True
    VirtualText.Panel3D1.Visible = True
    Else
    VirtualText.mnuShowStatusBar.Checked = False
    VirtualText.Panel3D1.Visible = False
    End If

'*******************************
'   Read the View Mode Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "ViewMode"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    If ReturnStr$ = "Text" Then
    VirtualText.mnuTextMode.Checked = True
    VirtualText.mnuHexMode.Checked = False
    Else
    VirtualText.mnuTextMode.Checked = False
    VirtualText.mnuHexMode.Checked = True
    End If

'*******************************
'   Read the Expand Tabs Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "ExpandTabs"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    If ReturnStr$ = "YES" Then
    VirtualText.mnuExpandTabs.Checked = True
    VirtualText.mnuExpandTabs.Checked = False
    Else
    VirtualText.mnuExpandTabs.Checked = False
    VirtualText.mnuExpandTabs.Checked = True
    End If

'*******************************
'   Read the Form Position Top
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "FormTop"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    VirtualText.Top = Val(ReturnStr$)

'*******************************
'   Read the Form Position Left
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "FormLeft"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    VirtualText.Left = Val(ReturnStr$)

'*******************************
'   Read the Form Position Width
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "FormWidth"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

'   Forces a resize event do this later
    VirtualText.Width = Val(ReturnStr$)

'*******************************
'   Read the Form Position Height
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "FormHeight"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

'   Forces a resize event do this later
    VirtualText.Height = Val(ReturnStr$)

'*******************************
'   Read the Printer FontName Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "PrinterFontName"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$
 
    optPrinterFont = ReturnStr$

'*******************************
'   Read the Printer FontSize Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "PrinterFontSize"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    optPrinterFontSize = Val(ReturnStr$)

'*******************************
'   Read the Printer FontBold Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "PrinterFontBold"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    If ReturnStr$ = "YES" Then
        optPrinterFontBold = True
    Else
        optPrinterFontBold = False
    End If
    
'*******************************
'   Read the Printer FontItalic Setting
'*******************************
    DefaultStr$ = " "          'Default string (for String variables)
    Numeric% = 0   'Tell it we are looking for a string
    KeyName$ = "PrinterFontItalic"    'Keyword or variable name
    ReadIni AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$

    If ReturnStr$ = "YES" Then
        optPrinterFontItalic = True
    Else
        optPrinterFontItalic = False
    End If
    
End Sub

Sub SaveFileINIFile ()

' Save the file name that was just selected

For X = 1 To 5

    IniFileName$ = "VIRTEXT.INI"    'name of ini file
    AppName$ = "Display"           'Name of application or section heading
    Select Case X
    Case 1
    KeyName$ = "File1"             'Keyword or variable name"
    Case 2
    KeyName$ = "File2"             'Keyword or variable name"
    Case 3
    KeyName$ = "File3"             'Keyword or variable name"
    Case 4
    KeyName$ = "File4"             'Keyword or variable name"
    Case 5
    KeyName$ = "File5"             'Keyword or variable name"
    End Select

    If X = 1 Then
    NewVal$ = Trim$(FullFilePath)
    Else
    NewVal$ = ""
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

Next

End Sub

Sub SaveFormPosition ()

IniFileName$ = "VIRTEXT.INI" 'name of ini file
AppName$ = "Display"         'Name of application or section heading


'*******************************
'   Save the Form Position Top
'*******************************
    KeyName$ = "FormTop"    'Keyword or variable name

    NewVal$ = Str$(VirtualText.Top)

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Form Position Left
'*******************************
    KeyName$ = "FormLeft"    'Keyword or variable name

    NewVal$ = Str$(VirtualText.Left)

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Form Position Width
'*******************************
    KeyName$ = "FormWidth"    'Keyword or variable name

    NewVal$ = Str$(VirtualText.Width)

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Form Position Height
'*******************************
    KeyName$ = "FormHeight"    'Keyword or variable name

    NewVal$ = Str$(VirtualText.Height)

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

End Sub

Sub SaveIni (AppName$, IniFileName$, KeyName$, NewVal$)

' Update INI file

ResultCode% = WritePrivateProfileString(AppName$, KeyName$, NewVal$, IniFileName$)
If ResultCode% = 0 Then
    MsgBox "Error updating INI file!", 16, "ERROR!"
End If

End Sub

Sub SaveOptions ()

    IniFileName$ = "VIRTEXT.INI" 'name of ini file
    AppName$ = "Display"         'Name of application or section heading

'*******************************
'   Save the Background color
'*******************************
    KeyName$ = "BackColor"       'Keyword or variable name

    NewVal$ = Str$(VirtualText.TextArray(1).BackColor)  'if Numeric value convert it to string
    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Foreground color
'*******************************
    KeyName$ = "ForeColor"       'Keyword or variable name

    NewVal$ = Str$(VirtualText.TextArray(1).ForeColor)  'if Numeric value convert it to string
    SaveIni AppName$, IniFileName$, KeyName$, NewVal$


'*******************************
'   Save the FontName Setting
'*******************************
    KeyName$ = "FontName"    'Keyword or variable name

    NewVal$ = VirtualText.TextArray(1).FontName

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the FontSize Setting
'*******************************
    KeyName$ = "FontSize"    'Keyword or variable name

    NewVal$ = Str$(VirtualText.TextArray(1).FontSize)

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the FontBold Setting
'*******************************
    KeyName$ = "FontBold"    'Keyword or variable name

    If VirtualText.TextArray(1).FontBold = True Then
    NewVal$ = "YES"
    Else
    NewVal$ = "NO"
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the FontItalic Setting
'*******************************
    KeyName$ = "FontItalic"    'Keyword or variable name

    If VirtualText.TextArray(1).FontItalic = True Then
    NewVal$ = "YES"
    Else
    NewVal$ = "NO"
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Vertical Scroll Setting
'*******************************
    KeyName$ = "VerticalScroll"    'Keyword or variable name

    If VirtualText.mnuShowVerticalScroll.Checked = True Then
    NewVal$ = "YES"
    Else
    NewVal$ = "NO"
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Horizontal Scroll Setting
'*******************************
    KeyName$ = "HorizontalScroll"    'Keyword or variable name

    If VirtualText.mnuShowHorizontalScroll.Checked = True Then
    NewVal$ = "YES"
    Else
    NewVal$ = "NO"
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Status Bar Setting
'*******************************
    KeyName$ = "StatusBar"    'Keyword or variable name

    If VirtualText.mnuShowStatusBar.Checked = True Then
    NewVal$ = "YES"
    Else
    NewVal$ = "NO"
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the View Mode Setting
'*******************************
    KeyName$ = "ViewMode"    'Keyword or variable name

    If VirtualText.mnuTextMode.Checked = True Then
    NewVal$ = "Text"
    Else
    NewVal$ = "Hex"
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Expand Tabs Setting
'*******************************
    KeyName$ = "ExpandTabs"    'Keyword or variable name

    If VirtualText.mnuExpandTabs.Checked = True Then
    NewVal$ = "YES"
    Else
    NewVal$ = "NO"
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Printer FontName Setting
'*******************************
    KeyName$ = "PrinterFontName"    'Keyword or variable name

    NewVal$ = optPrinterFont

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the Printer FontSize Setting
'*******************************
    KeyName$ = "PrinterFontSize"    'Keyword or variable name
    
    NewVal$ = Str$(optPrinterFontSize)

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the FontBold Setting
'*******************************
    KeyName$ = "PrinterFontBold"    'Keyword or variable name
       
    If optPrinterFontBold = True Then
       NewVal$ = "YES"
    Else
       NewVal$ = "NO"
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$

'*******************************
'   Save the FontItalic Setting
'*******************************
    KeyName$ = "PrinterFontItalic"    'Keyword or variable name

    If optPrinterFontItalic = True Then
       NewVal$ = "YES"
    Else
       NewVal$ = "NO"
    End If

    SaveIni AppName$, IniFileName$, KeyName$, NewVal$
    
End Sub

