Option Explicit
'***************************************************************
'*   Name of File:      STATBAR.BAS                            *
'*   Author:            M. John Rodriguez                      *
'*   Date Created:      May 07, 1995                           *
'*   Last Modified:                                            *
'*   Current Version:   1.00.00                                *
'***************************************************************
'   Questions or Comments are welcome!
'   M. John Rodriguez
'     CIS ID: 100321,620
'   Internet: jrodrigu@cpd.hqusareur.army.mil
'           : 100321.620@compuserve.com
'
'   See the README.TXT file for more information or just look through the code!
'
Type RECT
    Left As Integer
    Top As Integer
    Right As Integer
    Bottom As Integer
End Type


Type uPanelDataType
    iLeft As Integer            'Left Position of the panel
    iTop As Integer             'Top position of the panel
    iWidth As Integer           'Width of the panel
    iHeight As Integer          'Height of the Panel
    iType As Integer            'Type of panel 0-Recessed, 1-Raised, 2-Flat: User Defined
    iFormat As Integer          'Format of the panel - Text, Date, Time, etc...: User Defined
    iTextFormat As Integer      'Format of Text in the panel VCENTER, CENTER, etc.: User Defined
End Type

Type cPanelType
    sCaption As String          'Caption contained in the panel
    PanelData As uPanelDataType 'Panel Information
    iFontBold As Integer        'Whether or not font is bold
    iFont3D As Integer          'Whether or not font is 3D
    sFontName As String         'Font Name - Defaults to statusbar setting
    sFontSize As String         'Font Size - Defaults to statusbar setting
    lFontColor As Long          'Font Color - Defaults to statusbar setting
End Type


'Constants for the DrawText API call
Global Const DT_LEFT = &H0
Global Const DT_CENTER = &H1
Global Const DT_RIGHT = &H2
Global Const DT_VCENTER = &H4
Global Const DT_SINGLELINE = &H20

'Types of panels
Global Const SBAR_PANEL_RECESSED = 0
Global Const SBAR_PANEL_RAISED = 1
Global Const SBAR_PANEL_FLAT = 2

'Format of the panels
Global Const SBAR_TEXT = 0            'Panel just contains text
Global Const SBAR_DATE = 1            'Panel contains the date
Global Const SBAR_TIME = 2            'Panel contains the time
Global Const SBAR_CAPSLOCK = 3        'Panel is a CAPLOCK toggle display
Global Const SBAR_NUMLOCK = 4         'Panel is a NUMLOCK toggle display
Global Const SBAR_SCROLL = 5          'Panel is a SCROLL LOCK toggle display
Global Const SBAR_COUNTER = 6         'Panel is a counter display

'Specific information for drawing the panels
Global Const SBAR_BORDERSIZE = 3      'Space between StatPanel and panels in pixels
Global Const SBAR_PANELGAP = 5        'Gap between panels
Global Const SBAR_TEXTGAP = 4         'Gap in between the text and the border in pixels

'Some colors
Global Const SBAR_WHITEBORDER = &HFFFFFF    'For 3D Effect - White Bar
Global Const SBAR_DGREYBORDER = &H808080    'For 3D Effect - Drk Grey Bar
Global Const SBAR_BACKGROUND = &HC0C0C0     'Color to paint the picture box
Global Const SBAR_FONTCOLOR = &H0           'Black forecolor to draw text

'Virtual Keys definitions for the GetKeyState API
Global Const KEY_NUMLOCK = &H90
Global Const KEY_SCROLL = &H91
Global Const KEY_CAPITAL = &H14     'Caplocks Key

Declare Function GetKeyState Lib "User" (ByVal nVirtKey As Integer) As Integer
Declare Function DrawText Lib "User" (ByVal hDC As Integer, ByVal lpStr As String, ByVal nCount As Integer, lpRect As RECT, ByVal wFormat As Integer) As Integer

Sub CreatePanels (uPanels() As cPanelType)

'Use this procedure to create the panels you want...
'Call it from the Form_Load() Event...
'For use in multiple forms, cut and paste this into the general declarations section of
'each form.  See the README.TXT file for more information.



Dim iMaxPanels%

iMaxPanels% = 7

ReDim uPanels(iMaxPanels%)

uPanels(1).PanelData.iType = SBAR_PANEL_RAISED
uPanels(1).PanelData.iFormat = SBAR_TEXT
'uPanels(1).sFontName =
'uPanels(1).sFontSize =
'uPanels(1).lFontColor =
'uPanels(1).iFont3D = False
'uPanels(1).iFontBold = False

'uPanels(2).PanelData.iType = SBAR_PANEL_RAISED
uPanels(2).PanelData.iFormat = SBAR_DATE
uPanels(2).sFontName = "Courier New"
'uPanels(2).sFontSize = "6.0"
'uPanels(2).lFontColor = &HFF
'uPanels(2).iFont3D = True
'uPanels(2).iFontBold = True

uPanels(3).PanelData.iType = SBAR_PANEL_RAISED
uPanels(3).PanelData.iFormat = SBAR_TIME
'uPanels(3).sFontName =
'uPanels(3).sFontSize =
uPanels(3).lFontColor = &HFF
'uPanels(3).iFont3D = True
'uPanels(3).iFontBold = False

uPanels(4).PanelData.iType = SBAR_PANEL_FLAT
uPanels(4).PanelData.iFormat = SBAR_CAPSLOCK
'uPanels(4).sFontName =
'uPanels(4).sFontSize =
uPanels(4).lFontColor = RGB(0, 0, 255)
'uPanels(4).iFont3D = False
uPanels(4).iFontBold = True

uPanels(5).PanelData.iType = SBAR_PANEL_FLAT
uPanels(5).PanelData.iFormat = SBAR_NUMLOCK
'uPanels(5).sFontName =
'uPanels(5).sFontSize =
'uPanels(5).lFontColor =
uPanels(5).iFont3D = True
uPanels(5).iFontBold = True

'uPanels(6).PanelData.iType = SBAR_PANEL_FLAT
uPanels(6).PanelData.iFormat = SBAR_SCROLL
'uPanels(6).sFontName =
'uPanels(6).sFontSize =
uPanels(6).lFontColor = RGB(0, 128, 0)
'uPanels(6).iFont3D = False
'uPanels(6).iFontBold = True

'uPanels(7).PanelData.iType = SBAR_PANEL_RAISED
uPanels(7).PanelData.iFormat = SBAR_COUNTER
'uPanels(7).sFontName =
uPanels(7).sFontSize = "9.6"
'uPanels(7).lFontColor =
'uPanels(7).iFont3D = False
'uPanels(7).iFontBold = True



End Sub

Sub DisplayStatusBar (cStatBar As Control, uPanels() As cPanelType)

'You call this from the PictureBox's Resize Event to redisplay the status bar after adjustments

Dim sOldFontName$, sOldFontSize$, iOldFontBold%
Dim iOldAutoRedraw%
Dim lColorLTBorder&, lColorRBBorder&
Dim iCnt%, sTest$, iNumTextPanels%
Dim iMaxPanels%, iPTextWidth%
Dim iPixelX%, iPixelY%, iLeftPos%
Dim iNewWidth%, iLeftOverSpace%

'Turn of the status timer for now...
cStatBar.Parent.StatTimer.Enabled = False

'Get Some screen Setting here
iPixelX% = Screen.TwipsPerPixelX
iPixelY% = Screen.TwipsPerPixelY

'save some settings from the status bar
sOldFontName$ = cStatBar.FontName
sOldFontSize$ = cStatBar.FontSize
iOldFontBold% = cStatBar.FontBold
iOldAutoRedraw% = cStatBar.AutoRedraw

'Clear the status bar
cStatBar.AutoRedraw = True
cStatBar.Cls

'Find out how many panels we got..
iMaxPanels% = UBound(uPanels)

'Calculate how much space we have to work with
iLeftOverSpace% = cStatBar.ScaleWidth - ((SBAR_BORDERSIZE * iPixelX% * 2) + ((iMaxPanels% - 1) * SBAR_PANELGAP * iPixelX%))

'Let's got through each panel
For iCnt% = 1 To iMaxPanels%
    'Clear the test variable
    sTest$ = ""
    'Now let's set up a test strings to format the panel widths
    Select Case uPanels(iCnt%).PanelData.iFormat
        Case SBAR_DATE        'Format for the Date Panel
            sTest$ = "XXX XXX XX, XXXX"
        Case SBAR_TIME        'Format for the Time Panel
            sTest$ = "XX:XX xx"
        Case SBAR_CAPSLOCK    'Format for the Capslock Panel
            sTest$ = "CAP"
        Case SBAR_NUMLOCK     'Format for the NumLock Panel
            sTest$ = "NUM"
        Case SBAR_SCROLL      'Format for the ScrollLock Panel
            sTest$ = "SCR"
        Case SBAR_COUNTER     'Format for the Counter type panel
            sTest$ = "XXXX"
        Case SBAR_TEXT        'Increment the number of text panels we have
            iNumTextPanels% = iNumTextPanels% + 1
    End Select
    'Do we have a test string?
    If sTest$ <> "" Then
        'Alright, now copy the font information to the StatPanel
        cStatBar.FontName = uPanels(iCnt%).sFontName
        cStatBar.FontSize = uPanels(iCnt%).sFontSize
        cStatBar.FontBold = uPanels(iCnt%).iFontBold
        'Let's get a width for the Label control plus the Text Gap
        iNewWidth% = cStatBar.TextWidth(sTest$) + (SBAR_TEXTGAP * iPixelX% * 2)
        'Set the width of the panel
        uPanels(iCnt%).PanelData.iWidth = iNewWidth%
        'Deduct the width from the left over spaces
        iLeftOverSpace% = iLeftOverSpace% - iNewWidth%
    End If
Next

'Now we are finished with our calculations, restore the settings back to the Status bar
cStatBar.FontName = sOldFontName$
cStatBar.FontSize = sOldFontSize$
cStatBar.FontBold = iOldFontBold%
cStatBar.AutoRedraw = iOldAutoRedraw%

'Calculate the space left over for all SBAR_TEXT types
iPTextWidth% = 0
If iNumTextPanels% > 0 Then
    If iLeftOverSpace% > 0 Then iPTextWidth% = iLeftOverSpace% \ iNumTextPanels%
End If

'OK, now set our starting position to place our panels.
iLeftPos% = SBAR_BORDERSIZE * iPixelX

For iCnt% = 1 To iMaxPanels%
    'If this panel is SBAR_TEXT then set the width from our calculations
    If uPanels(iCnt%).PanelData.iFormat = SBAR_TEXT Then uPanels(iCnt%).PanelData.iWidth = iPTextWidth%
    'If the control has any width...
    If uPanels(iCnt%).PanelData.iWidth > 0 Then
        'Set the panels left position to be drawn...
        uPanels(iCnt%).PanelData.iLeft = iLeftPos%
        'Now draw the panel
        DrawStatusPanel cStatBar, uPanels(iCnt%)
        'Increment to our next position
        iLeftPos% = iLeftPos% + uPanels(iCnt%).PanelData.iWidth + (SBAR_PANELGAP * iPixelX%)
    End If
Next

'Reactivate the timer...
cStatBar.Parent.StatTimer.Enabled = True

End Sub

Sub DrawStatusPanel (cStatBar As Control, uPanel As cPanelType)

'This draws the panel with the caption.

Dim pRect As RECT, tRect As RECT, offsetRect As RECT
Dim sOldFontName$, sOldFontSize$, iOldFontBold%
Dim iOldAutoRedraw%, iOldScaleMode%, iOldDrawWidth%
Dim iOldForeColor&
Dim lColorLTBorder&, lColorRBBorder&
Dim iPixelX%, iPixelY%
Dim iSuc%

'Get Some screen Setting here
iPixelX% = Screen.TwipsPerPixelX
iPixelY% = Screen.TwipsPerPixelY

'Ok, depending on the type of panel, set the border colors
If uPanel.PanelData.iType = SBAR_PANEL_FLAT Then
    lColorLTBorder& = cStatBar.BackColor
    lColorRBBorder& = cStatBar.BackColor
ElseIf uPanel.PanelData.iType = SBAR_PANEL_RAISED Then
    lColorLTBorder& = SBAR_WHITEBORDER
    lColorRBBorder& = SBAR_DGREYBORDER
Else
    lColorLTBorder& = SBAR_DGREYBORDER
    lColorRBBorder& = SBAR_WHITEBORDER
End If


'Save some of the
sOldFontName$ = cStatBar.FontName
sOldFontSize$ = cStatBar.FontSize
iOldFontBold% = cStatBar.FontBold
iOldAutoRedraw% = cStatBar.AutoRedraw
iOldScaleMode% = cStatBar.ScaleMode
iOldDrawWidth% = cStatBar.DrawWidth
iOldForeColor& = cStatBar.ForeColor

'Set some of the properties now...
cStatBar.AutoRedraw = True
cStatBar.DrawWidth = 1
cStatBar.ScaleMode = 1
cStatBar.ForeColor = SBAR_FONTCOLOR

'Calculate the drawing box rectangle
pRect.Left = uPanel.PanelData.iLeft
pRect.Top = uPanel.PanelData.iTop
pRect.Right = pRect.Left + uPanel.PanelData.iWidth
pRect.Bottom = pRect.Top + uPanel.PanelData.iHeight

'Clear the drawing region of where the panel will be placed
cStatBar.Line (pRect.Left, pRect.Top)-(pRect.Right, pRect.Bottom), cStatBar.BackColor, BF

'Now Draw the lines around the box area...
'Top
cStatBar.Line (pRect.Left, pRect.Top)-(pRect.Right, pRect.Top), lColorLTBorder&
'Left
cStatBar.Line (pRect.Left, pRect.Top)-(pRect.Left, pRect.Bottom), lColorLTBorder&
'Bottom
cStatBar.Line (pRect.Left, pRect.Bottom)-(pRect.Right, pRect.Bottom), lColorRBBorder&
'Right
cStatBar.Line (pRect.Right, pRect.Top)-(pRect.Right, pRect.Bottom), lColorRBBorder&

'Calculate the textbox rectangle - 1 pixel less than the rectangle..
tRect.Left = (pRect.Left + iPixelX%) \ iPixelX%
tRect.Top = (pRect.Top + iPixelY%) \ iPixelY%
tRect.Right = (pRect.Right - iPixelX%) \ iPixelX%
tRect.Bottom = (pRect.Bottom - iPixelY%) \ iPixelY%

'Change the scale mode one last time..
cStatBar.ScaleMode = 3
cStatBar.FontBold = uPanel.iFontBold
cStatBar.FontName = uPanel.sFontName
cStatBar.FontSize = uPanel.sFontSize

'Now if this is 3D
If uPanel.iFont3D Then
    'Set the offset by 1 pixel
    offsetRect.Left = tRect.Left + 1
    offsetRect.Top = tRect.Top + 1
    offsetRect.Right = tRect.Right + 1
    offsetRect.Bottom = tRect.Bottom + 1
    'Set the forecolor to white
    cStatBar.ForeColor = SBAR_WHITEBORDER
    'Draw the text
    iSuc% = DrawText(cStatBar.hDC, uPanel.sCaption, Len(uPanel.sCaption), offsetRect, uPanel.PanelData.iTextFormat)
End If

'Now draw the Caption...setting the ForeColor of the Status Bar
cStatBar.ForeColor = uPanel.lFontColor
'Draw the text
iSuc% = DrawText(cStatBar.hDC, uPanel.sCaption, Len(uPanel.sCaption), tRect, uPanel.PanelData.iTextFormat)

'And now reset the Status Bar Settings..
cStatBar.FontName = sOldFontName$
cStatBar.FontSize = sOldFontSize$
cStatBar.FontBold = iOldFontBold%
cStatBar.AutoRedraw = iOldAutoRedraw%
cStatBar.ScaleMode = iOldScaleMode%
cStatBar.DrawWidth = iOldDrawWidth%
cStatBar.ForeColor = iOldForeColor&

End Sub

Function InitializeStatusBar (fWin As Form, uPanels() As cPanelType) As Integer

'Use this procedure to initialize the Status bar.. call it from the Form_Load() Event
Dim iMaxHeight%, iCnt%
Dim iPixelX%, iPixelY%
Dim iMaxPanels%, iMaxPanelHeight%
Dim iAlignCenter%, iAlignLeft%, iAlignRight%

On Local Error Resume Next

'Get the screen settings..
iPixelX% = Screen.TwipsPerPixelX
iPixelY% = Screen.TwipsPerPixelY

'Find the number of panels to be passed
iMaxPanels% = UBound(uPanels)

'Do we have any panels?
If iMaxPanels% > 0 Then
    'Set up some basic settings for the format of panel text
    iAlignCenter% = DT_VCENTER Or DT_CENTER Or DT_SINGLELINE
    iAlignLeft% = DT_VCENTER Or DT_LEFT Or DT_SINGLELINE
    iAlignRight% = DT_VCENTER Or DT_RIGHT Or DT_SINGLELINE
    
    'Set the color of the background for the picture box
    fWin.StatPanel.BackColor = SBAR_BACKGROUND
    
    'Set the alignment of the picture box
    fWin.StatPanel.Align = 2
    
    'Set the max height to the tallest text +
    'the border above and below the panel + gap between border
    'and text and include the line around the picture control
    iMaxPanelHeight% = SetMaxHeight(fWin.StatPanel, uPanels())
    iMaxHeight% = iMaxPanelHeight% + (SBAR_BORDERSIZE * iPixelY% * 2) + (SBAR_TEXTGAP * iPixelY% * 2)

    'Now set the height of the Status Bar
    fWin.StatPanel.Height = iMaxHeight%
    'And reset the max panel height after adjusting to the new status bar height.
    iMaxPanelHeight% = fWin.StatPanel.ScaleHeight - (SBAR_BORDERSIZE * iPixelY% * 2)
    
    'Now go through each panel and set the height of each panel the same
    'As well as a few other things...
    For iCnt% = 1 To iMaxPanels%
        uPanels(iCnt%).PanelData.iTop = SBAR_BORDERSIZE * iPixelY%
        uPanels(iCnt%).PanelData.iHeight = iMaxPanelHeight%
        If uPanels(iCnt%).PanelData.iFormat = SBAR_TEXT Then
            uPanels(iCnt%).PanelData.iTextFormat = iAlignLeft%
        ElseIf uPanels(iCnt%).PanelData.iFormat = SBAR_COUNTER Then
            uPanels(iCnt%).PanelData.iTextFormat = iAlignRight%
        Else
            uPanels(iCnt%).PanelData.iTextFormat = iAlignCenter%
        End If
        If uPanels(iCnt%).sFontName = "" Then uPanels(iCnt%).sFontName = fWin.StatPanel.FontName
        If uPanels(iCnt%).sFontSize = "" Then uPanels(iCnt%).sFontSize = fWin.StatPanel.FontSize
    Next
    DisplayStatusBar fWin.StatPanel, uPanels()
Else
    fWin.StatPanel.Visible = False
End If

End Function

Function SetMaxHeight (cStatBar As Control, uPanels() As cPanelType) As Integer

'Function Calculates the MaxHeight based on the font name and font size

Dim iOldFontBold%, sOldFontName$, sOldFontSize$
Dim iMaxPanels%, iMaxHeight%, iCnt%, sTemp$, iTestHeight%

'Save the old settings
iOldFontBold% = cStatBar.FontBold
sOldFontName$ = cStatBar.FontName
sOldFontSize$ = cStatBar.FontSize

'Here we have a test sample
sTemp$ = "TEST"

'Get the number of panels
iMaxPanels% = UBound(uPanels)

'Go through each panel, checking for font information and then checking the
'height of the test string.  The font with the highest size will determine how
'large the status bar is in height.
For iCnt% = 1 To iMaxPanels%
    'Make sure we have font names to use
    If uPanels(iCnt%).sFontName = "" Then cStatBar.FontName = sOldFontName Else cStatBar.FontName = uPanels(iCnt%).sFontName
    If uPanels(iCnt%).sFontSize = "" Then cStatBar.FontSize = sOldFontSize Else cStatBar.FontSize = uPanels(iCnt%).sFontSize
    'Set the remaining settings
    cStatBar.FontBold = uPanels(iCnt%).iFontBold
    'Get the height
    iTestHeight% = cStatBar.TextHeight(sTemp$)
    'If it is higher than what we got, make it the new height
    If iTestHeight% > iMaxHeight% Then iMaxHeight% = iTestHeight%
Next iCnt%

'Return the old settings
cStatBar.FontBold = iOldFontBold%
cStatBar.FontName = sOldFontName$
cStatBar.FontSize = sOldFontSize$

'Return our maximum height
SetMaxHeight = iMaxHeight%

End Function

Sub UpdateKeyPanels (cStatBar As Control, uPanels() As cPanelType)


'This procedure can be called from the Form_KeyDown() event to better optimize
'the update of the toggle keys.   All you have to do is set the KeyPreview property
'of the form to True (except for MDI Forms.. you have to set it for each child)
'and then call this routine.


Dim iCnt%, iKeyState%, iNumPanels%

'Get the number of panels
iNumPanels% = UBound(uPanels)

'Go through each panel and place the appropriate information in it
For iCnt% = 1 To iNumPanels%
    Select Case uPanels(iCnt%).PanelData.iFormat
        Case SBAR_CAPSLOCK    'Check the toggle of the Caps Lock Key
            iKeyState% = GetKeyState(KEY_CAPITAL)
            If (iKeyState% And 1) = 1 Then UpdatePanel cStatBar, uPanels(iCnt%), "CAP" Else UpdatePanel cStatBar, uPanels(iCnt%), ""
        Case SBAR_NUMLOCK     'Check the toggle of the Num Lock Key
            iKeyState% = GetKeyState(KEY_NUMLOCK)
            If (iKeyState% And 1) = 1 Then UpdatePanel cStatBar, uPanels(iCnt%), "NUM" Else UpdatePanel cStatBar, uPanels(iCnt%), ""
        Case SBAR_SCROLL      'Check the toggle of the Scroll Lock key
            iKeyState% = GetKeyState(KEY_SCROLL)
            If (iKeyState% And 1) = 1 Then UpdatePanel cStatBar, uPanels(iCnt%), "SCR" Else UpdatePanel cStatBar, uPanels(iCnt%), ""
    End Select
Next

End Sub

Sub UpdatePanel (cStatBar As Control, uPanel As cPanelType, ByVal sNewCaption As String)

'All this panel does is check to see if you have a new caption.  If the caption is the
'same, then it does nothing since it isn't necessary.  If it does change, the caption
'panel is updates and then redrawn.

If sNewCaption <> uPanel.sCaption Then
    uPanel.sCaption = sNewCaption
    DrawStatusPanel cStatBar, uPanel
End If

End Sub

Sub UpdateStatusPanels (cStatBar As Control, uPanels() As cPanelType)

'You can call this one from the StatTimer_Timer() event to update all
'status panels (Date, Time, ToggleKeys).
'Toggle keys are a little slower but will work effectively if needed.


Dim iCnt%, iKeyState%, iNumPanels%

'Get the number of panels
iNumPanels% = UBound(uPanels)

'Go through each panel and place the appropriate information in it
For iCnt% = 1 To iNumPanels%
    Select Case uPanels(iCnt%).PanelData.iFormat
        Case SBAR_DATE        'Show today's date
            UpdatePanel cStatBar, uPanels(iCnt%), Format$(Now, "ddd mmm dd, yyyy")
        Case SBAR_TIME        'Show the Time
            UpdatePanel cStatBar, uPanels(iCnt%), Format$(Now, "hh:mm am/pm")
        Case SBAR_CAPSLOCK    'Check the toggle of the Caps Lock Key
            iKeyState% = GetKeyState(KEY_CAPITAL)
            If (iKeyState% And 1) = 1 Then UpdatePanel cStatBar, uPanels(iCnt%), "CAP" Else UpdatePanel cStatBar, uPanels(iCnt%), ""
        Case SBAR_NUMLOCK     'Check the toggle of the Num Lock Key
            iKeyState% = GetKeyState(KEY_NUMLOCK)
            If (iKeyState% And 1) = 1 Then UpdatePanel cStatBar, uPanels(iCnt%), "NUM" Else UpdatePanel cStatBar, uPanels(iCnt%), ""
        Case SBAR_SCROLL      'Check the toggle of the Scroll Lock key
            iKeyState% = GetKeyState(KEY_SCROLL)
            If (iKeyState% And 1) = 1 Then UpdatePanel cStatBar, uPanels(iCnt%), "SCR" Else UpdatePanel cStatBar, uPanels(iCnt%), ""
    End Select
Next


End Sub

Sub UpDateTimePanels (cStatBar As Control, uPanels() As cPanelType)

'All you have to do is call this procedure to update the time.  Call this from
'any Timer() event to update the panels.


Dim iCnt%, iNumPanels%

'Get the number of panels
iNumPanels% = UBound(uPanels)

'Go through each panel and place the appropriate information in it
For iCnt% = 1 To iNumPanels%
    Select Case uPanels(iCnt%).PanelData.iFormat
        Case SBAR_DATE        'Show today's date
            UpdatePanel cStatBar, uPanels(iCnt%), Format$(Now, "ddd mmm dd, yyyy")
        Case SBAR_TIME        'Show the Time
            UpdatePanel cStatBar, uPanels(iCnt%), Format$(Now, "hh:mm am/pm")
    End Select
Next

End Sub

