{
  Program: ToolTip
  Date: 15/10/1994
  Purpose: To create a custom control (vbx) for Visual Basic
}
Library ToolTip;
{$R ToolTip}
Uses WinTypes,WinProcs,BPVBApi;
{ Custom control data and structs }
Type PToolTip=^TToolTip;
     TToolTip=Record
     End;
Const 
{ Declare Property }
{ Declare Events }
      Params_Event_ToolTip:array[0..0]of word=(ET_SD);
      Event_ToolTip:TEVENTINFO=(
      npszName:NPnt(PChar('ToolTip'));
      cParms:1;
      cwParms:2;
      npParmTypes:NPnt(@Params_Event_ToolTip);
      npszParmProf:NPnt(PChar('CtlName as String'));
      fl:0);
{ Property List }
      PropListToolTip:array[0..20] of PPropInfo=(
      PPropInfo_Std_BACKCOLOR,
      PPropInfo_Std_CAPTION,
      PPropInfo_Std_CTLNAME,
      PPropInfo_Std_ENABLED,
      PPropInfo_Std_FONTBOLD,
      PPropInfo_Std_FONTITALIC,
      PPropInfo_Std_FONTNAME,
      PPropInfo_Std_FONTSIZE,
      PPropInfo_Std_FONTSTRIKE,
      PPropInfo_Std_FONTUNDER,
      PPropInfo_Std_FORECOLOR,
      PPropInfo_Std_HEIGHT,
      PPropInfo_Std_HWND,
      PPropInfo_Std_INDEX,
      PPropInfo_Std_LEFT,
      PPropInfo_Std_PARENT,
      PPropInfo_Std_TAG,
      PPropInfo_Std_TOP,
      PPropInfo_Std_VISIBLE,
      PPropInfo_Std_WIDTH,0);
{ Event List }
      EventListToolTip:array[0..3] of PEventInfo=(
      PEventInfo(@Event_ToolTip),
      PEventInfo_Std_CLICK,
      PEventInfo_Std_MOUSEMOVE,0);
{ Constans and Variables }
var lpfnWndProc,lpfnOldWndProc,NewProc:TFarProc;
    CtlName:hLstr;
    ActiveCtl,ToolTipWnd:hWnd;
    Buff:array [0..255] of Char;
    ToolTipCtl:hCtl;
function MainWndProc(Wnd:HWnd;Msg,WParam:Word;LParam:Longint):Longint; export;
var I:Integer;
begin
  case Msg of
   WM_SetCursor:
   if (VBGetMode=Mode_Run)and(ActiveCtl<>wParam) then
   begin
     SetWindowPos(ToolTipWnd,0,640,480,0,0,Swp_NoSize);
     ActiveCtl:=wParam;
     I:=GetWindowText(wParam,Buff,GetWindowTextLength(wParam)+1);
     CtlName:=VBCreateHlstr(@Buff,I);
     VBFireEvent(ToolTipCtl,0,@CtlName);
     VBDestroyHlstr(CtlName);
   end;
  end;
  MainWndProc:=CallWindowProc(lpfnOldWndProc,Wnd,Msg,wParam,lParam);
end;
{ Control Procedure }
{ This routine is called for all VB and Windows Messages }
function ToolTipCtlProc(Control:hCtl;Wnd:hWnd;Msg,wParam:Word;lParam:LongInt):LongInt; Export;
var RectWnd,RectCtl:TRect;
    GTE:LongInt;
    TP:TPaintStruct;
begin
  case Msg of
    WM_CREATE:
    begin
      ToolTipCtl:=Control;
      ToolTipWnd:=Wnd;
      NewProc:=MakeProcInstance(@MainWndProc,VBGetHInstance);
      lpfnOldWndProc:=TFarProc(GetWindowLong(GetParent(Wnd),GWL_WNDPROC));
      SetWindowLong(GetParent(Wnd),GWL_WNDPROC,LongInt(NewProc));
    end;
    WM_DESTROY:FreeProcInstance(NewProc);
    $C000:
    begin
      Buff[0]:=#0;
      GetWindowRect(ActiveCtl,RectCtl);
      GetWindowRect(GetParent(Wnd),RectWnd);
      GetWindowText(ToolTipWnd,Buff,GetWindowTextLength(ToolTipWnd)+1);
      BeginPaint(Wnd,TP);
      GTE:=GetTextExtent(TP.hDC,Buff,lStrLen(Buff));
      EndPaint(Wnd,TP);
      MoveWindow(Wnd,RectCtl.Left-RectWnd.Left-GetSystemMetrics(SM_CXBorder),
      RectCtl.Bottom-RectWnd.Top-GetSystemMetrics(SM_CYCaption),
      LoWord(GTE)+5,HiWord(GTE),True);
    end;
    VBM_SETPROPERTY:if wParam=1 then PostMessage(Wnd,$C000,0,0);
  end;    { End of case Msg }
  ToolTipCtlProc:=VBDefControlProc(Control,Wnd,Msg,wParam,lParam);
end; {End of Control function}
{ Model struct                               }
{ Define the control model                   }
{ (using the event and property structures). }
Const ModelToolTip:TModel=(
      UsVersion:VB_Version;       { VB version used by control }
      Fl:0 or MODEL_fFocusOk or MODEL_fMnemonic;
      CtlProc:TFarProc(@ToolTipCtlProc);
      FsClassStyle:0 or cs_HRedraw or cs_VRedraw;
      FlWndStyle:0 or ss_Center or ws_Border;
      CbCtlExtra:SizeOf(TToolTip);
      IdBmpPalette:8000;          { Bitmap ID for tool palette }
      DefCtlName:NPnt(PChar('ToolTip'));
      ClassName:NPnt(PChar('ToolTip'));
      ParentClassName:NPnt(PChar('Static'));
      PropList:Ofs(PropListToolTip);
      EventList:Ofs(EventListToolTip);
      NDefProp:0;                 { Index of default property }
      NDefEvent:0);               { Index of default event }
{ Register custom control.                     }
{ This routine is called by VB when the custom }
{ control DLL is loaded for use.               }
function VBInitCC(usVersion:Word;fRunTime:Boolean):Boolean; Export;
begin
  VBInitCC:=VBRegisterModel(hInstance,ModelToolTip);
end;
Exports
  VBInitCC       index 2,
  ToolTipCtlProc index 3;
Begin
End. { End of Custom Control }