
#include "windows.h"
#include "mmsystem.h"
#include "commdlg.h"
#include "vbapi.h"
#include "vbwave.h"

LONG _export FAR PASCAL WaveWndProc( HCTL hCtl, HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_CREATE:
      {
         WAVESTRUCT far *Wv = DEREF( hCtl );

         if( Wv )
         {
            Wv->WaveFile = (HSZ)NULL;              /*  Initialize variables  */
            Wv->Enable = 0;
            Wv->hWaveHeader = NULL;
            Wv->hWaveData = NULL;
            Wv->dwStart = 0L;
            Wv->dwEnd = 0L;
            Wv->dwSize = 0L;
            Wv->dwVolume = 0L;
            Wv->Loops = 0;
            Wv->dwPlayback = 0x00010000L;
            Wv->nSampPerSec = 0;
            Wv->nBytesPerSec = 0;
            Wv->Reverse = 0;
         }
         break;
      }

      case VBM_CREATED:                            /*  Hide icon if runtime  */
         if( VBGetMode() != MODE_DESIGN )
            SetWindowPos( hWnd, 0, 0, 0, 0, 0, SWP_NOMOVE );
         else
            SetWindowPos( hWnd, 0, 0, 0, 32, 32, SWP_NOMOVE | SWP_NOZORDER );
         break;

      case WM_PAINT:
      {
         PAINTSTRUCT ps;
         HICON hIcon;
         HDC hDC;
         WAVESTRUCT far *Wv = DEREF( hCtl );

         hDC = BeginPaint( hWnd, &ps );
         if( Wv )
         {
            if( VBGetMode() == MODE_DESIGN )
            {
               hIcon = LoadIcon( hmodDLL, "Icon" );
               if( hIcon )
               {
                  DrawIcon( hDC, 0, 0, hIcon );
                  DestroyIcon( hIcon );
               }
            }
         }
         EndPaint( hWnd, &ps );
         break;
      }

      case VBM_GETPROPERTY:
      {
         WAVESTRUCT far *Wv = DEREF( hCtl );

         switch( wParam )
         {
            case PROP_VERSION:
            {
               *(WORD far *)lParam = 100;
               return( FALSE );
            }

            case PROP_ENABLE:
            {
               *(WORD far *)lParam = Wv->Enable;
               return( FALSE );
            }

            case PROP_LOOP:                 /*  Get number of times to loop  */
            {
               *(WORD far *)lParam = Wv->Loops;
               return( FALSE );
            }

            case PROP_CHANNELS:
            {
               WAVEOUTCAPS wc;

               waveOutGetDevCaps( Wv->Device, &wc, sizeof(WAVEOUTCAPS) );
               *(WORD far *)lParam = wc.wChannels;
               return( FALSE );
            }

            case PROP_DEVICE:
            {
               *(WORD far *)lParam = Wv->Device;
               return( FALSE );
            }

            case PROP_END:
            {
               *(LONG far *)lParam = Wv->dwEnd;
               return( FALSE );
            }

            case PROP_START:
            {
               *(LONG far *)lParam = Wv->dwStart;
               return( FALSE );
            }

            case PROP_VOL:
            {
               DWORD dwVol;

               waveOutGetVolume( Wv->Device, &dwVol );
               *(WORD far *)lParam = LOWORD( dwVol );
               return( FALSE );
            }

            case PROP_PLAY:
            {
               if( VBGetMode() == MODE_DESIGN )
                  return( FALSE );

               if( ! OpenWaveFile( hCtl ) )
                  return( 32000 );

               if( ! PlayWaveFile( hCtl ) )
                  return( 32000 );

               CloseWaveFile( hCtl );
               return( FALSE );
            }

            case PROP_SIZE:
               *(LONG far *)lParam = Wv->dwSize;
               return( FALSE );

            case PROP_LVOL:
            {
               DWORD dwVol;

               waveOutGetVolume( Wv->Device, &dwVol );
               *(WORD far *)lParam = LOWORD( dwVol );
               return( FALSE );
            }

            case PROP_RVOL:
            {
               DWORD dwVol;

               waveOutGetVolume( Wv->Device, &dwVol );
               *(WORD far *)lParam = HIWORD( dwVol );
               return( FALSE );
            }

            case PROP_PLAYBACK:
            {
               DWORD dwPlay;

               waveOutGetPlaybackRate( Wv->Device, &dwPlay );
               *(WORD far *)lParam = HIWORD( dwPlay );
               return( FALSE );
            }

            case PROP_PITCH:
            {
               DWORD dwPitch;

               waveOutGetPitch( Wv->Device, &dwPitch );
               *(WORD far *)lParam = HIWORD( dwPitch );
               return( FALSE );
            }

            case PROP_VOLOK:
            {
               WAVEOUTCAPS Wo;

               waveOutGetDevCaps( Wv->Device, &Wo, sizeof(WAVEOUTCAPS) );
               if( Wo.dwSupport & WAVECAPS_VOLUME )
                  *(WORD far *)lParam = -1;
               else
                  *(WORD far *)lParam = 0;
               return( FALSE );
            }

            case PROP_PITCHOK:
            {
               WAVEOUTCAPS Wo;

               waveOutGetDevCaps( Wv->Device, &Wo, sizeof(WAVEOUTCAPS) );
               if( Wo.dwSupport & WAVECAPS_PITCH )
                  *(WORD far *)lParam = -1;
               else
                  *(WORD far *)lParam = 0;
               return( FALSE );
            }

            case PROP_PLAYRATEOK:
            {
               WAVEOUTCAPS Wo;

               waveOutGetDevCaps( Wv->Device, &Wo, sizeof(WAVEOUTCAPS) );
               if( Wo.dwSupport & WAVECAPS_PLAYBACKRATE )
                  *(WORD far *)lParam = -1;
               else
                  *(WORD far *)lParam = 0;
               return( FALSE );
            }

            case PROP_LRVOLUMEOK:
            {
               WAVEOUTCAPS Wo;

               waveOutGetDevCaps( Wv->Device, &Wo, sizeof(WAVEOUTCAPS) );
               if( Wo.dwSupport & WAVECAPS_LRVOLUME )
                  *(WORD far *)lParam = -1;
               else
                  *(WORD far *)lParam = 0;
               return( FALSE );
            }

            case PROP_ISSYNC:
            {
               WAVEOUTCAPS Wo;

               waveOutGetDevCaps( Wv->Device, &Wo, sizeof(WAVEOUTCAPS) );
               if( Wo.dwSupport & WAVECAPS_SYNC )
                  *(WORD far *)lParam = -1;
               else
                  *(WORD far *)lParam = 0;
               return( FALSE );
            }

            case PROP_SAMPPERSEC:
            {
               *(WORD far *)lParam = Wv->nSampPerSec;
               return( FALSE );
            }

            case PROP_REVERSE:
            {
               *(WORD far *)lParam = Wv->Reverse;
               return( FALSE );
            }
         }
         break;
      }

      case VBM_SETPROPERTY:
      {
         WAVESTRUCT far *Wv = DEREF( hCtl );

         switch( wParam )
         {
            case PROP_FILENAME:
            {
               if( ! OpenWaveFile( hCtl ) )
                  return( TRUE );

               CloseWaveFile( hCtl );
               return( FALSE );
            }

            case PROP_ENABLE:
               Wv->Enable = (BOOL)lParam;
               return( FALSE );

            case PROP_LOOP:
               Wv->Loops = LOWORD( lParam );
               return( FALSE );

            case PROP_DEVICE:
               Wv->Device = LOWORD( lParam );
               return( FALSE );

            case PROP_START:
               if( lParam > Wv->dwSize )
                  Wv->dwStart = Wv->dwSize;
               else
                  Wv->dwStart = lParam;
               break;

            case PROP_END:
               if( lParam > Wv->dwSize )
                  Wv->dwEnd = Wv->dwSize;
               else
                  Wv->dwEnd = lParam;
               return( FALSE );

            case PROP_VOL:
               Wv->dwVolume = MAKELONG( LOWORD( lParam ), LOWORD( lParam ) );
               waveOutSetVolume( Wv->Device,
                                 MAKELONG( LOWORD( Wv->dwVolume ), LOWORD( Wv->dwVolume ) ) );
               return( FALSE );

            case PROP_LVOL:
               Wv->dwVolume = ( Wv->dwVolume & 0xFFFF0000L ) + LOWORD( lParam );
               waveOutSetVolume( Wv->Device, Wv->dwVolume );
               return( FALSE );

            case PROP_RVOL:
               Wv->dwVolume = ( Wv->dwVolume & 0xFFFFL ) + ( lParam << 16 );
               waveOutSetVolume( Wv->Device, Wv->dwVolume );
               return( FALSE );

            case PROP_PLAYBACK:
               Wv->dwPlayback = lParam << 16;
               return( FALSE );

            case PROP_PITCH:
               Wv->dwPitch = lParam << 16;
               return( FALSE );

            case PROP_SAMPPERSEC:
               Wv->nSampPerSec = LOWORD( lParam );
               return( FALSE );

            case PROP_REVERSE:
               Wv->Reverse = (BOOL)lParam;
               return( FALSE );
         }
         break;
      }

      case VBM_INITPROPPOPUP:
      {
         switch( wParam )
         {
            case PROP_FILENAME:
            {
               FARPROC DlgProc;

               if( VBGetMode() == MODE_DESIGN )
               {
                  DlgCtl = hCtl;

                  return( CreateWindow( CLASSPOPUP, NULL, WS_POPUP, 0, 0, 0, 0,
                                        NULL, NULL, hmodDLL, NULL ) );
               }
               return( NULL );
            }
         }
         break;
      }
   }
   return( VBDefControlProc( hCtl, hWnd, msg, wParam, lParam ) );
}


LONG _export FAR PASCAL PopupWndProc( HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_SHOWWINDOW:
         if( wParam )
         {
            PostMessage( hWnd, WM_USER, 0, 0L );
            return( 0L );
         }
         break;

      case WM_USER:
      {
         OPENFILENAME Of;
         HSZ hsz;
         char str[ 128 ];

         lstrcpy( str, WaveWild );
         Of.lStructSize = sizeof(OPENFILENAME);
         Of.hwndOwner = hWnd;
         Of.hInstance = (HANDLE)NULL;
         Of.lpstrFilter = WaveMask;
         Of.lpstrCustomFilter = (LPSTR)NULL;
         Of.nMaxCustFilter = (DWORD)0;
         Of.nFilterIndex = (DWORD)0;
         Of.lpstrFile = str;
         Of.nMaxFile = (DWORD)128;
         Of.lpstrFileTitle = (LPSTR)NULL;
         Of.nMaxFileTitle = (DWORD)NULL;
         Of.lpstrInitialDir = (LPSTR)NULL;
         Of.lpstrTitle = WaveTitle;
         Of.Flags = (DWORD)NULL;
         Of.nFileOffset = 0;
         Of.nFileExtension = 0;
         Of.lpstrDefExt = (LPSTR)NULL;
         Of.lCustData = NULL;
         Of.lpfnHook = NULL;
         Of.lpTemplateName = (LPSTR)NULL;

         if( GetOpenFileName( &Of ) )
            VBSetControlProperty( DlgCtl, PROP_FILENAME, (LONG)(LPSTR)str );
         return( 0L );
      }
   }
   return( DefWindowProc( hWnd, msg, wParam, lParam ) );
}


BOOL OpenWaveFile( HCTL hCtl )
{
   WAVESTRUCT far *Wv = DEREF( hCtl );
   LPSTR lpWaveName;
   int fd, status;
   char str[ 6 ];
   DWORD Dsize;
   HWAVEOUT hWo;
   PCMWAVEFORMAT Pcm;
   LPWAVEHDR Wf;

   lpWaveName = VBDerefHsz( Wv->WaveFile );

   fd = _lopen( lpWaveName, READ_WRITE );                /*  Open .WAV file  */

   if( fd == -1 )                               /*  If it didn't open, quit  */
      return( TRUE );

   _lread( fd, str, 4 );                               /*  Read file ID tag  */

   str[ 4 ] = '\0';                                 /*  Add NULL terminator  */

   if( lstrcmp( str, "RIFF" ) )         /*  Make sure it's a 'RIFF' file...  */
   {
      _lclose( fd );                                       /*  If not, exit  */
      return( FALSE );
   }
                                                    /*  Get total file size  */
   _lread( fd, (LPSTR)&Dsize, sizeof(DWORD) );

   _lread( fd, str, 4 );                             /*  Read next file tag  */

   if( lstrcmp( str, "WAVE" ) )         /*  Make sure it's a 'WAVE' file...  */
   {
      _lclose( fd );                           /*  If not a Wave file, exit  */
      return( FALSE );
   }

   _lread( fd, str, 4 );               /*  Search for WAVEFORMAT header tag  */

   if( lstrcmp( str, "fmt " ) )                  /*  If this isn't it, exit  */
   {
      _lclose( fd );
      return( FALSE );
   }

                                           /*  Read PCMWAVEFORMAT structure  */
   _lread( fd, (LPSTR)&Dsize, sizeof(DWORD) );
   if( Dsize != sizeof(PCMWAVEFORMAT) )
   {
      _lclose( fd );                /*  If info in file isn't for structure  */
      return( FALSE );                             /*  then exit, of course  */
   }

   _lread( fd, (LPSTR)&Pcm, Dsize );          /*  Fill structure  */

   Wv->nSamplesPerSec = (WORD)Pcm.wf.nSamplesPerSec;
   Wv->nBytesPerSec = (WORD)Pcm.wf.nAvgBytesPerSec;

   _lread( fd, str, 4 );
   if( lstrcmp( str, "data" ) )               /*  Signals beginning of data  */
   {
      _lclose( fd );
      return( FALSE );
   }
                                                      /*  Read size of data  */
   _lread( fd, (LPSTR)&Dsize, sizeof(DWORD) );
   Wv->dwSize = Dsize;                            /*  Save data size for VB  */

   if( Wv->nSampPerSec == 0 )
      Pcm.wf.nSamplesPerSec = 11025;

   if( Wv->nSampPerSec == 1 )
      Pcm.wf.nSamplesPerSec = 22050;

   if( Wv->nSampPerSec == 2 )
      Pcm.wf.nSamplesPerSec = 44100;

   if( waveOutOpen( &hWo, 0, (PCMWAVEFORMAT far *)&Pcm, NULL, NULL,
                    WAVE_ALLOWSYNC ) )
   {
      _lclose( fd );
      return( FALSE );
   }
                                       /*  Allocate global space for header  */
   Wv->hWaveHeader = GlobalAlloc( GMEM_MOVEABLE | GMEM_DDESHARE, sizeof(WAVEHDR) );
   if( ! Wv->hWaveHeader )
   {
      _lclose( fd );
      return( NULL );
   }

   Wf = (LPWAVEHDR)GlobalLock( Wv->hWaveHeader );
   if( ! Wf )
   {
      GlobalFree( Wv->hWaveHeader );
      Wv->hWaveHeader = NULL;
      _lclose( fd );
      return( NULL );
   }
                                                /*  Allocate space for data  */
   Wv->hWaveData = GlobalAlloc( GMEM_MOVEABLE | GMEM_DDESHARE, Dsize );
   if( ! Wv->hWaveData )
   {
      GlobalUnlock( Wv->hWaveHeader );
      GlobalFree( Wv->hWaveHeader );
      Wv->hWaveHeader = NULL;
      _lclose( fd );
      return( NULL );
   }

   Wf->lpData = GlobalLock( Wv->hWaveData );
   if( ! Wf->lpData )
   {
      GlobalFree( Wv->hWaveData );
      Wv->hWaveData = NULL;
      GlobalUnlock( Wv->hWaveHeader );
      GlobalFree( Wv->hWaveHeader );
      Wv->hWaveHeader = NULL;
      _lclose( fd );
      return( NULL );
   }
                                             /*  Read data into data buffer  */
   _hread( fd, Wf->lpData, Dsize );

   Wf->dwBufferLength = Dsize;                        /*  Initialize header  */
   Wf->dwFlags = WHDR_BEGINLOOP | WHDR_ENDLOOP;
   Wf->dwLoops = (DWORD)Wv->Loops;
   Wv->hWave = hWo;                                      /*  Save ID handle  */

   Wv->dwSize = Dsize;

   GlobalUnlock( Wv->hWaveData );
   GlobalUnlock( Wv->hWaveHeader );
   _lclose( fd );

   return( TRUE );
}


BOOL CloseWaveFile( HCTL hCtl )
{
   WAVESTRUCT far *Wv = DEREF( hCtl );

   if( ! Wv->hWaveHeader && ! Wv->hWaveData )
      return( TRUE );

   if( Wv->hWaveHeader )
   {
      GlobalFree( Wv->hWaveHeader );
      Wv->hWaveHeader = NULL;
   }

   if( Wv->hWaveData )
   {
      GlobalFree( Wv->hWaveData );
      Wv->hWaveData = NULL;
   }

   waveOutClose( Wv->hWave );
   return( TRUE );
}


BOOL PlayWaveFile( HCTL hCtl )
{
   WAVESTRUCT far *Wv = DEREF( hCtl );
   int status;
   LPWAVEHDR Wf;
   LPSTR lpData;
   DWORD dwBufferLength, dwTemp;

   Wf = (LPWAVEHDR)GlobalLock( Wv->hWaveHeader );
   if( ! Wf )
      return( FALSE );

   Wf->lpData = GlobalLock( Wv->hWaveData );
   if( ! Wf->lpData )
   {
      GlobalUnlock( Wv->hWaveHeader );
      return( FALSE );
   }

   lpData = Wf->lpData;
   dwBufferLength = Wf->dwBufferLength;

   if( Wv->dwStart > Wv->dwEnd )
   {
      dwTemp = Wv->dwStart;
      Wv->dwStart = Wv->dwEnd;
      Wv->dwEnd = dwTemp;
   }

   waveOutSetVolume( Wv->Device, Wv->dwVolume );
   waveOutSetPlaybackRate( Wv->Device, Wv->dwPlayback );
   waveOutSetPitch( Wv->Device, Wv->dwPitch );

   Wf->lpData = Wf->lpData + Wv->dwStart;
   Wf->dwBufferLength = Wv->dwEnd - Wv->dwStart;

   status = waveOutPrepareHeader( Wv->hWave, Wf, sizeof(WAVEHDR) );
   if( status )
   {
      Wf->lpData = lpData;
      Wf->dwBufferLength = dwBufferLength;
      GlobalUnlock( Wv->hWaveHeader );
      GlobalUnlock( Wv->hWaveData );
      return( FALSE );
   }

   if( Wv->Reverse )
      ReverseData( Wv->hWaveData );

   status = waveOutWrite( Wv->hWave, Wf, sizeof(WAVEHDR) );

   if( Wv->Reverse )
      ReverseData( Wv->hWaveData );

   if( status )
   {
      Wf->lpData = lpData;
      Wf->dwBufferLength = dwBufferLength;
      GlobalUnlock( Wv->hWaveHeader );
      GlobalUnlock( Wv->hWaveData );
      return( FALSE );
   }

   status = waveOutUnprepareHeader( Wv->hWave, Wf, sizeof(WAVEHDR) );
   if( status )
   {
      Wf->lpData = lpData;
      Wf->dwBufferLength = dwBufferLength;
      GlobalUnlock( Wv->hWaveHeader );
      GlobalUnlock( Wv->hWaveData );
      return( FALSE );
   }

   Wf->lpData = lpData;
   Wf->dwBufferLength = dwBufferLength;

   GlobalUnlock( Wv->hWaveData );
   GlobalUnlock( Wv->hWaveHeader );

   return( TRUE );
}



void ReverseData( HANDLE hMem )
{
   BYTE far *lpData;
   DWORD Counter, dwHalf, dwLength;
   BYTE bTemp;

   lpData = GlobalLock( hMem );
   if( ! lpData )
      return;

   dwLength = GlobalSize( hMem ) - 32;
   dwHalf = ( dwLength ) / 2;
   for( Counter = 0; Counter < dwHalf; Counter++ )
   {
      bTemp = *( lpData + Counter );
      *( lpData + Counter ) = *( lpData + dwLength - Counter );
      *( lpData + dwLength - Counter ) = bTemp;
   }
   GlobalUnlock( hMem );
}

