VERSION 2.00
Begin Form frmVBNets 
   BackColor       =   &H00C0C0C0&
   Caption         =   "VB-Nets Sample"
   ClientHeight    =   3450
   ClientLeft      =   1335
   ClientTop       =   1950
   ClientWidth     =   6510
   Height          =   4140
   Icon            =   VB-NETS.FRX:0000
   Left            =   1275
   LinkTopic       =   "Form1"
   ScaleHeight     =   3450
   ScaleWidth      =   6510
   Top             =   1320
   Width           =   6630
   Begin CommandButton cmdSel 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Find Drive"
      Height          =   345
      Index           =   3
      Left            =   4830
      TabIndex        =   14
      Top             =   1590
      Width           =   1515
   End
   Begin CommandButton cmdSel 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Find &Service"
      Height          =   345
      Index           =   2
      Left            =   4830
      TabIndex        =   13
      Top             =   1200
      Width           =   1515
   End
   Begin CommandButton cmdSel 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Dismount"
      Height          =   345
      Index           =   1
      Left            =   4830
      TabIndex        =   12
      Top             =   810
      Width           =   1515
   End
   Begin CommandButton cmdSel 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Mount"
      Height          =   345
      Index           =   0
      Left            =   4830
      TabIndex        =   11
      Top             =   420
      Width           =   1515
   End
   Begin TextBox txtService 
      Height          =   285
      Index           =   3
      Left            =   1380
      TabIndex        =   6
      Top             =   1410
      Width           =   3045
   End
   Begin TextBox txtService 
      Height          =   285
      Index           =   2
      Left            =   1380
      TabIndex        =   5
      Top             =   1080
      Width           =   3045
   End
   Begin TextBox txtService 
      Height          =   285
      Index           =   1
      Left            =   1380
      TabIndex        =   4
      Top             =   750
      Width           =   3045
   End
   Begin TextBox txtService 
      Height          =   285
      Index           =   0
      Left            =   1380
      TabIndex        =   3
      Top             =   420
      Width           =   3045
   End
   Begin ListBox lstServices 
      Height          =   1200
      Left            =   150
      TabIndex        =   0
      TabStop         =   0   'False
      Top             =   2160
      Width           =   6195
   End
   Begin Label lblInstructions 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Check 'Help' for instructions on using the service buttons ..."
      Height          =   225
      Left            =   540
      TabIndex        =   2
      Top             =   90
      Width           =   5415
   End
   Begin Label lblService 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Password:"
      Height          =   195
      Index           =   3
      Left            =   180
      TabIndex        =   10
      Top             =   1470
      Width           =   1095
   End
   Begin Label lblService 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Service:"
      Height          =   195
      Index           =   2
      Left            =   180
      TabIndex        =   9
      Top             =   1140
      Width           =   1095
   End
   Begin Label lblService 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Server:"
      Height          =   195
      Index           =   1
      Left            =   180
      TabIndex        =   8
      Top             =   810
      Width           =   1095
   End
   Begin Label lblService 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Drive:"
      Height          =   195
      Index           =   0
      Left            =   180
      TabIndex        =   7
      Top             =   480
      Width           =   1095
   End
   Begin Label lblServiceList 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Mounted Network Services:"
      Height          =   225
      Left            =   180
      TabIndex        =   1
      Top             =   1890
      Width           =   2895
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileSel 
         Caption         =   "Network &User"
         Index           =   0
      End
      Begin Menu mnuFileSel 
         Caption         =   "Network &Type"
         Index           =   1
      End
      Begin Menu mnuFileSel 
         Caption         =   "-"
         Index           =   2
      End
      Begin Menu mnuFileSel 
         Caption         =   "E&xit"
         Index           =   3
      End
   End
   Begin Menu mnuHelp 
      Caption         =   "&Help"
      Begin Menu mnuHelpSel 
         Caption         =   "Using 'Mount"""
         Index           =   0
      End
      Begin Menu mnuHelpSel 
         Caption         =   "Using 'Dismount'"
         Index           =   1
      End
      Begin Menu mnuHelpSel 
         Caption         =   "Using 'Find Service'"
         Index           =   2
      End
      Begin Menu mnuHelpSel 
         Caption         =   "Using 'Find Drive'"
         Index           =   3
      End
      Begin Menu mnuHelpSel 
         Caption         =   "-"
         Index           =   4
      End
      Begin Menu mnuHelpSel 
         Caption         =   "&About"
         Index           =   5
      End
   End
End
Option Explicit

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

Dim ftCRLF           As String

Sub APP_ListServices ()

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

    Dim nLoopCtr            As Integer
    Dim tTempStr            As String

' Hide the list box to avoid flashing
    lstServices.Visible = False

' Clear the list box of all current entries
    Do While lstServices.ListCount > 0
        lstServices.RemoveItem 0
    Loop

' Load the list box with all mounted services
    For nLoopCtr = 4 To 26          ' For drives D: to Z:
        tTempStr = UT_NetGetServiceName(Chr$(64 + nLoopCtr))
        If Len(tTempStr) > 0 Then   ' The drive is mounted
            lstServices.AddItem Chr$(64 + nLoopCtr) & ":" & Chr$(9) & tTempStr
        End If
    Next nLoopCtr

' Now that we are done we can show the list box
    lstServices.Visible = True

End Sub

Sub cmdSel_Click (Index As Integer)

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.
    
    Dim tTempStr            As String
    Dim tService            As String
    Dim nResult             As Integer
    Dim nLoopCtr            As Integer

    Select Case Index
        Case 0              ' Mount
            If Len((txtService(0))) = 0 Or Len((txtService(1))) = 0 Or Len((txtService(2))) = 0 Then
                Call mnuHelpSel_Click(Index)        ' Call help because there are missing parameters
                Exit Sub
            End If
            tTempStr = UT_NetMount((txtService(0)), (txtService(1)), (txtService(2)), (txtService(3)))
            If Len(tTempStr) <> 0 Then
                MsgBox "Service mounted", MB_ICONINFORMATION, "Drive " & UCase$(Left$((txtService(0)), 1)) & ":"
                Call APP_ListServices               ' Refresh the services list
              Else
                tService = "\\" & (txtService(1)) & "\" & (txtService(2))
                MsgBox "Service NOT mounted", MB_ICONEXCLAMATION, "Service: " & tService
            End If
        
        Case 1              ' Dismount
            If Len((txtService(0))) = 0 Then
                Call mnuHelpSel_Click(Index)        ' Call help because there are missing parameters
                Exit Sub
            End If
            nResult = UT_NetDismount((txtService(0)), NET_OPENQUERY)
            If nResult = True Then
                MsgBox "Service dismounted", MB_ICONINFORMATION, "Drive " & UCase$(Left$((txtService(0)), 1)) & ":"
                Call APP_ListServices               ' Refresh the services list
              Else
                MsgBox "Service NOT dismounted", MB_ICONEXCLAMATION, "Drive " & UCase$(Left$((txtService(0)), 1)) & ":"
            End If
        
        Case 2              ' Find Service
            If Len((txtService(0))) = 0 Then
                Call mnuHelpSel_Click(Index)        ' Call help because there are missing parameters
                Exit Sub
            End If
            tTempStr = UT_NetGetServiceName((txtService(0)))            ' Get the service name
            If Len(tTempStr) <> 0 Then
                MsgBox "Service Name: " & tTempStr, MB_ICONINFORMATION, "Drive " & UCase$(Left$((txtService(0)), 1)) & ":"
              Else
                MsgBox "There is no service connected to this drive.", MB_ICONSTOP, "Drive " & UCase$(Left$((txtService(0)), 1)) & ":"
            End If
        
        Case 3              ' Find Drive
            If Len((txtService(1))) = 0 Or Len((txtService(2))) = 0 Then
                Call mnuHelpSel_Click(Index)        ' Call help because there are missing parameters
                Exit Sub
            End If
            tService = "\\" & (txtService(1)) & "\" & (txtService(2))   ' Build the service name we are looking for
            tTempStr = UT_NetGetServiceDrive(tService)                  ' Find the drive letter
            If Len(tTempStr) <> 0 Then
                MsgBox "Service is connected to drive " & UCase$(tTempStr), MB_ICONINFORMATION, "Service: " & tService
              Else
                MsgBox "This service is not mounted or connected to a local drive.", MB_ICONSTOP, "Service: " & tService
            End If
    
    End Select

End Sub

Sub Form_Load ()

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

    Dim tTempStr            As String
    
' Center the form on the screen
    UT_CenterScreen Me

' Setup form scope globals
    ftCRLF = Chr$(13) & Chr$(10)

' Load the services list box
    Call APP_ListServices

' Popup the About box dialog
    Call mnuHelpSel_Click(5)

End Sub

Sub mnuFileSel_Click (Index As Integer)

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

    Dim tTempStr            As String
    
    Select Case Index
        Case 0                  ' Network User
            tTempStr = UT_NetUserID()
            If Len(tTempStr) = 0 Then           ' Not logged in
                MsgBox "The user is not logged in to the network. It is also possible that this is a Windows for Workgroups machine using multiple network protocols. If Workgroups is not the first protocol, the user name may not be reported correctly.", MB_ICONINFORMATION, "Network User"
              Else                              ' User is logged in
                MsgBox "Logged in to the network as: " & Trim$(tTempStr), MB_ICONINFORMATION, "Network User"
            End If
            
        Case 1                  ' Network Type
            tTempStr = UT_GetNetworkType()
            If Len(tTempStr) = 0 Then           ' Unknown network type
                MsgBox "Unable to determine the network type for this system.", MB_ICONINFORMATION, "Network Type"
              Else
                MsgBox "The current network is " & Trim$(tTempStr), MB_ICONINFORMATION, "Network Type"
            End If
        Case 3                  ' Exit
            Unload frmVBNets
            End
    End Select

End Sub

Sub mnuHelpSel_Click (Index As Integer)

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

    Dim tTempStr            As String

    Select Case Index
        Case 0              ' Mount
            MsgBox "The mount option requires a drive letter, a server name, and a service. The password is optional.", MB_ICONINFORMATION, "Using 'Mount'"
        Case 1              ' Dismount
            MsgBox "The dismount option requires a drive letter.", MB_ICONINFORMATION, "Using 'Dismount'"
        Case 2              ' Find Service
            MsgBox "The find service option requires a drive letter.", MB_ICONINFORMATION, "Using 'Find Service'"
        Case 3              ' Find Drive
            MsgBox "The find drive option requires a server name and a service.", MB_ICONINFORMATION, "Using 'Find Drive'"
        Case 5              ' About
            tTempStr = "Copyright  1994 by Computer Technologies, Inc." & ftCRLF & "All rights reserved."
            tTempStr = tTempStr & ftCRLF & ftCRLF & "Version 1.1 - Released October 11, 1994."
            tTempStr = tTempStr & ftCRLF & ftCRLF & "This demo program and the associated code in CTI-NETS.BAS are the property of Computer Technologies, Inc. It is provided as a service for the personal use of the members of the MS-BASIC forum on CompuServe, and other interested Visual Basic developers."
            tTempStr = tTempStr & ftCRLF & ftCRLF & "Author:" & Chr$(9) & "Eric Brierley"
            tTempStr = tTempStr & ftCRLF & "CIS:" & Chr$(9) & "71163,2657"
            tTempStr = tTempStr & ftCRLF & "Phone:" & Chr$(9) & "1-704-634-1766"
            MsgBox tTempStr, MB_ICONINFORMATION, "About VB-NETS"
    End Select

End Sub

