#include "windows.h"
#include "shellapi.h"
#include "vbapi.h"

LONG FAR PASCAL _export MultSelWndProc( HCTL, HWND, USHORT, USHORT, LONG );

typedef struct {
   long cArgs;
   long hszItem;
   long index;
} LPPARAM;

typedef struct {
   HSZ hszPattern;
   HSZ hszPath;
   int Archive, ReadOnly, System, Extend;
   int CellWidth, Style, DragDrop;
} MSEL;

#define DEREF(hctl)  ((MSEL far *)VBDerefControl(hctl))

HANDLE hmodDLL;

PROPINFO piExtend =
{
   "ExtendedSel",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO piListCount =
{
   "ListCount",
   DT_SHORT | PF_fGetMsg | PF_fNoShow,
   0, 0, NULL, 0
};

PROPINFO piListIndex =
{
   "ListIndex",
   DT_SHORT | PF_fGetMsg | PF_fSetMsg | PF_fPropArray | PF_fNoShow,
   0, 0, NULL, 0
};

PROPINFO piList =
{
   "List",
   DT_HSZ | PF_fGetMsg | PF_fPropArray | PF_fNoShow,
   0, 0, NULL, 0
};

PROPINFO piPattern =
{
   "Pattern",
   DT_HSZ | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO piPath =
{
   "Path",
   DT_HSZ | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fNoShow,
   sizeof(HSZ), 0, NULL, 0
};

PROPINFO piArchive =
{
   "Archive",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO piReadOnly =
{
   "ReadOnly",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO piSystem =
{
   "System",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO piVersion =
{
   "Version",
   DT_SHORT | PF_fGetMsg,
   0, 0, NULL, 0
};

PROPINFO piDragDrop =
{
   "DragAccept",
   DT_BOOL | PF_fGetMsg | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   0, 0, NULL, 0
};

PROPINFO piCellWidth =
{
   "CellWidth",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

#define PROP_LISTCOUNT 23
#define PROP_LISTINDEX 24
#define PROP_LIST      25
#define PROP_PATTERN   26
#define PROP_ARCHIVE   27
#define PROP_READONLY  28
#define PROP_SYSTEM    29
#define PROP_PATH      30
#define PROP_VERSION   31
#define PROP_DRAGDROP  32
#define PROP_EXTEND    33
#define PROP_CELLWIDTH 34

PPROPINFO proplistMSel[] =
{
   PPROPINFO_STD_CTLNAME,
   PPROPINFO_STD_INDEX,
   PPROPINFO_STD_PARENT,
   PPROPINFO_STD_BACKCOLOR,
   PPROPINFO_STD_BORDERSTYLEON,
   PPROPINFO_STD_LEFT,
   PPROPINFO_STD_TOP,
   PPROPINFO_STD_WIDTH,
   PPROPINFO_STD_HEIGHT,
   PPROPINFO_STD_ENABLED,
   PPROPINFO_STD_VISIBLE,
   PPROPINFO_STD_FONTNAME,
   PPROPINFO_STD_FONTSIZE,
   PPROPINFO_STD_FONTBOLD,
   PPROPINFO_STD_FONTITALIC,
   PPROPINFO_STD_FONTSTRIKE,
   PPROPINFO_STD_FONTUNDER,
   PPROPINFO_STD_FORECOLOR,
   PPROPINFO_STD_DRAGMODE,
   PPROPINFO_STD_DRAGICON,
   PPROPINFO_STD_TABINDEX,
   PPROPINFO_STD_TABSTOP,
   PPROPINFO_STD_TAG,
   &piListCount,
   &piListIndex,
   &piList,
   &piPattern,
   &piArchive,
   &piReadOnly,
   &piSystem,
   &piPath,
   &piVersion,
   &piDragDrop,
   &piExtend,
   NULL
};

PPROPINFO proplistMCol[] =
{
   PPROPINFO_STD_CTLNAME,
   PPROPINFO_STD_INDEX,
   PPROPINFO_STD_PARENT,
   PPROPINFO_STD_BACKCOLOR,
   PPROPINFO_STD_BORDERSTYLEON,
   PPROPINFO_STD_LEFT,
   PPROPINFO_STD_TOP,
   PPROPINFO_STD_WIDTH,
   PPROPINFO_STD_HEIGHT,
   PPROPINFO_STD_ENABLED,
   PPROPINFO_STD_VISIBLE,
   PPROPINFO_STD_FONTNAME,
   PPROPINFO_STD_FONTSIZE,
   PPROPINFO_STD_FONTBOLD,
   PPROPINFO_STD_FONTITALIC,
   PPROPINFO_STD_FONTSTRIKE,
   PPROPINFO_STD_FONTUNDER,
   PPROPINFO_STD_FORECOLOR,
   PPROPINFO_STD_DRAGMODE,
   PPROPINFO_STD_DRAGICON,
   PPROPINFO_STD_TABINDEX,
   PPROPINFO_STD_TABSTOP,
   PPROPINFO_STD_TAG,
   &piListCount,
   &piListIndex,
   &piList,
   &piPattern,
   &piArchive,
   &piReadOnly,
   &piSystem,
   &piPath,
   &piVersion,
   &piDragDrop,
   &piExtend,
   &piCellWidth,
   NULL
};

PEVENTINFO eventlistMSel[] =
{
   PEVENTINFO_STD_CLICK,
   PEVENTINFO_STD_DRAGDROP,
   PEVENTINFO_STD_DRAGOVER,
   PEVENTINFO_STD_GOTFOCUS,
   PEVENTINFO_STD_LOSTFOCUS,
   PEVENTINFO_STD_KEYDOWN,
   PEVENTINFO_STD_KEYPRESS,
   PEVENTINFO_STD_KEYUP,
   NULL
};

MODEL modelMSel =
{
   VB_VERSION,
   MODEL_fFocusOk | MODEL_fArrows,
   (PCTLPROC)MultSelWndProc,
   NULL,
   WS_CHILD | LBS_MULTIPLESEL | LBS_SORT | LBS_NOTIFY | LBS_STANDARD | LBS_NOINTEGRALHEIGHT | LBS_EXTENDEDSEL,
   sizeof(MSEL),
   8000,
   "MFile",
   "MFile",
   "listbox",
   proplistMSel,
   eventlistMSel
};

MODEL modelMCol =
{
   VB_VERSION,
   MODEL_fFocusOk | MODEL_fArrows,
   (PCTLPROC)MultSelWndProc,
   NULL,
   WS_CHILD | LBS_MULTIPLESEL | LBS_SORT | LBS_NOTIFY | LBS_STANDARD | LBS_MULTICOLUMN | LBS_NOINTEGRALHEIGHT | LBS_EXTENDEDSEL,
   sizeof(MSEL),
   8010,
   "MCFile",
   "MCFile",
   "listbox",
   proplistMCol,
   eventlistMSel
};

BOOL FAR PASCAL LibMain( HANDLE hmod, HANDLE segDS, USHORT cbHeapSize )
{
   hmodDLL = hmod;
   UnlockData( 0 );
   return( TRUE );
}


BOOL FAR PASCAL _export VBINITCC( USHORT usVersion, BOOL fRunTime )
{
   if( ! VBRegisterModel( hmodDLL, &modelMSel ) )
      return( FALSE );

   return( VBRegisterModel( hmodDLL, &modelMCol ) );
}


LONG FAR PASCAL _export MultSelWndProc( HCTL hCtl, HWND hWnd, USHORT msg, USHORT wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_USER:
      {
         LPSTR lpStr;
         WORD Attr;
         HDC hDC;
         MSEL far *Ms = DEREF( hCtl );
         char str[ 128 ];

         SendMessage( hWnd, LB_RESETCONTENT, 0, NULL );

         hDC = GetDC( hWnd );
         SendMessage( GetParent( hWnd ), WM_CTLCOLOR, hDC, MAKELONG( hWnd, hWnd ) );
         ReleaseDC( hWnd, hDC );

         Attr = 0;
         if( Ms->Archive )
            Attr |= 0x20;
         if( Ms->ReadOnly )
            Attr |= 0x01;
         if( Ms->System )
            Attr |= 0x04;

         str[ 0 ] = '\0';
         if( Ms->hszPath )
         {
            lpStr = VBDerefHsz( Ms->hszPath );
            if( lpStr )
            {
               lstrcpy( str, lpStr );
               if( str[ 3 ] != '\0' )
                  lstrcat( str, "\\" );
            }
         }

         if( Ms->hszPattern )
         {
            lpStr = VBDerefHsz( Ms->hszPattern );
            if( lpStr )
            {
               if( lstrlen( lpStr ) )
               {
                  lstrcat( str, lpStr );
                  SendMessage( hWnd, LB_DIR, Attr, (LONG)str );
               }
               else
               {
                  lstrcat( str, "*.*" );
                  SendMessage( hWnd, LB_DIR, Attr, (LONG)(LPSTR)str );
               }
            }
            else
               SendMessage( hWnd, LB_DIR, Attr, (LONG)(LPSTR)"*.*" );
         }
         else
            SendMessage( hWnd, LB_DIR, Attr, (LONG)(LPSTR)"*.*" );

         break;
      }

      case WM_CREATE:
      {
         MSEL far *Ms = DEREF( hCtl );
         char str[ 40 ];

         if( ! Ms->CellWidth )
            Ms->CellWidth = 80;

         VBGetControlName( hCtl, str );

         if( str[ 1 ] == 'C' )
            Ms->Style = 1;
         else
            Ms->Style = 0;

         if( Ms->Style )
            SendMessage( hWnd, LB_SETCOLUMNWIDTH, Ms->CellWidth, NULL );

         PostMessage( hWnd, WM_USER, 0, NULL );

         if( VBGetMode() != MODE_DESIGN )
            DragAcceptFiles( hWnd, Ms->DragDrop );
         else
            Ms->DragDrop = 0;
         break;
      }

      case VBM_METHOD:
         if( wParam == METH_ADDITEM )
         {
            LPPARAM far *lpParams;

            lpParams = (LPPARAM far *)lParam;
            if( lpParams->cArgs < 2 )                                                             /*  If no string passed, exit  */
               return( TRUE );

            if( lpParams->cArgs == 3 )                                                               /*  If index was passed...  */
               SendMessage( hWnd, LB_INSERTSTRING, (int)lpParams->index, (LONG)VBLockHsz( (HSZ)lpParams->hszItem ) );
            else
               SendMessage( hWnd, LB_INSERTSTRING, 0, (LONG)VBLockHsz( (HSZ)lpParams->hszItem ) );

            VBUnlockHsz( (HSZ)lpParams->hszItem );
            return( FALSE );
         }

         if( wParam == METH_REMOVEITEM )
         {
            LPPARAM far *lpParams;

            lpParams = (LPPARAM far *)lParam;
            if( lpParams->cArgs < 2 )
               return( TRUE );

            SendMessage( hWnd, LB_DELETESTRING, (int)lpParams->hszItem, NULL );
            return( FALSE );
         }

         break;

      case VBM_GETPROPERTY:
         if( wParam == PROP_LISTCOUNT )
         {
            int far *item;

            item = (int far *)lParam;
            *item = SendMessage( hWnd, LB_GETCOUNT, 0, NULL );
            return( FALSE );
         }

         if( wParam == PROP_EXTEND )
         {
            MSEL far *Ms = DEREF( hCtl );

            *(WORD far *)lParam = Ms->Extend;
            return( FALSE );
         }

         if( wParam == PROP_LISTINDEX )
         {
            int far *item;
            LPDATASTRUCT lpDs = (LPDATASTRUCT)lParam;

            item = (int far *)lParam;
            *item = SendMessage( hWnd, LB_GETSEL, lpDs->index[ 0 ].data, NULL );
            if( *item )
               *item = -1;
            else
               *item = 0;

            return( FALSE );
         }

         if( wParam == PROP_LIST )
         {
            char str[ 256 ];
            LONG i;
            LPDATASTRUCT lpDs = (LPDATASTRUCT)lParam;

            i = lpDs->index[ 0 ].data;
            SendMessage( hWnd, LB_GETTEXT, (int)i, (LONG)(LPSTR)str );
            lpDs->data = (LONG)VBCreateHsz( (_segment)hCtl, str );
            return( FALSE );
         }

         if( wParam == PROP_ARCHIVE )
         {
            MSEL far *Ms = DEREF( hCtl );

            *(WORD far *)lParam = Ms->Archive;
            return( FALSE );
         }

         if( wParam == PROP_READONLY )
         {
            MSEL far *Ms = DEREF( hCtl );

            *(WORD far *)lParam = Ms->ReadOnly;
            return( FALSE );
         }

         if( wParam == PROP_SYSTEM )
         {
            MSEL far *Ms = DEREF( hCtl );

            *(WORD far *)lParam = Ms->System;
            return( FALSE );
         }

         if( wParam == PROP_CELLWIDTH )
         {
            MSEL far *Ms = DEREF( hCtl );

            if( ! Ms->Style )
               *(WORD far *)lParam = -1;
            else
               *(WORD far *)lParam = Ms->CellWidth;

            return( FALSE );
         }

         if( wParam == PROP_VERSION )
         {
            MSEL far *Ms = DEREF( hCtl );

            *(WORD far *)lParam = 101;
            return( FALSE );
         }

         if( wParam == PROP_DRAGDROP )
         {
            MSEL far *Ms = DEREF( hCtl );

            *(WORD far *)lParam = Ms->DragDrop;
            return( FALSE );
         }
         break;

      case VBM_SETPROPERTY:
         if( wParam == PROP_EXTEND )
         {
            MODEL far *lpModel;
            MSEL far *Ms = DEREF( hCtl );

            lpModel = VBGetControlModel( hCtl );

            Ms->Extend = LOWORD( lParam );

            if( Ms->Extend )
               lpModel->flWndStyle |= LBS_EXTENDEDSEL;
            else
               lpModel->flWndStyle &= ~LBS_EXTENDEDSEL;

            VBRecreateControlHwnd( hCtl );
            return( FALSE );
         }

         if( wParam == PROP_LISTINDEX )
         {
            LPDATASTRUCT lpDs = (LPDATASTRUCT)lParam;
            WORD lPm;

            lPm = LOWORD( lpDs->data );

            if( lpDs->index[ 0 ].data == -1 )
            {
               SendMessage( hWnd, LB_SETSEL, lPm, lpDs->index[ 0 ].data );
               return( FALSE );
            }
            SendMessage( hWnd, LB_SETSEL, lPm, (int)lpDs->index[ 0 ].data );

            InvalidateRect( hWnd, NULL, TRUE );
            return( FALSE );
         }

         if( wParam == PROP_PATTERN || wParam == PROP_PATH )
         {
            PostMessage( hWnd, WM_USER, 0, NULL );
            return( FALSE );
         }

         if( wParam == PROP_ARCHIVE || wParam == PROP_READONLY || wParam == PROP_SYSTEM )
         {
            MSEL far *Ms = DEREF( hCtl );
            int i;

            if( wParam == PROP_ARCHIVE )
               Ms->Archive = (BOOL)lParam;
            if( wParam == PROP_READONLY )
               Ms->ReadOnly = (BOOL)lParam;
            if( wParam == PROP_SYSTEM )
               Ms->System = (BOOL)lParam;

            PostMessage( hWnd, WM_USER, 0, NULL );
            return( FALSE );
         }

         if( wParam == PROP_DRAGDROP )
         {
            MSEL far *Ms = DEREF( hCtl );

            Ms->DragDrop = LOWORD( lParam );

            if( VBGetMode() != MODE_DESIGN )
               DragAcceptFiles( hWnd, Ms->DragDrop );

            return( FALSE );
         }

         if( wParam == PROP_CELLWIDTH )
         {
            MSEL far *Ms = DEREF( hCtl );

            if( ! Ms->Style )
               return( FALSE );

            Ms->CellWidth = LOWORD( lParam );
            SendMessage( hWnd, LB_SETCOLUMNWIDTH, LOWORD( lParam ), NULL );
            InvalidateRect( hWnd, NULL, FALSE );
            return( FALSE );
         }
         break;
   }
   return( VBDefControlProc( hCtl, hWnd, msg, wParam, lParam ) );
}

