'VBLM_RTS.BAS: 'VB Language Manager Runtime Language Switching Support Module
'this version is added to RSV projects created using BINARY format databases
'Copyright 1994-5 by WhippleWare

'==============================================================
'DECLARATIONS
'==============================================================

Option Explicit
DefInt A-Z

'tagVBLM_VS is the record type for the binary language database
Type tagVBLM_VS
    String As String
End Type

'=================================================================
'The VBLM_RTString function is the core of runtime switching (RTS)
'
'All translated strings and properties have been replaced with
'calls to VBLM_RTString
'
'The function is passed an index and returns a string
'The first call initializes the database
'you can also force reinitialization (ie change languages) by
'passing -1 as the Index argument value
'=================================================================
'=================================================================
'
Function VBLM_RTString (Index As Long) As String

'=================================================================
'=================================================================
'STOCK VB CONSTANTS USED FOR CLARITY
'THESE CAN BE DELETED IF THEY ARE ALREADY DECLARED IN THIS PROJECT
'WITH GLOBAL SCOPE

Const MB_STOP = 16
Const MB_ABORTRETRYIGNORE = 2
Const MB_ICONEXCLAMATION = 48
Const IDABORT = 3
Const IDRETRY = 4
Const IDIGNORE = 5

'=================================================================
' LOCAL DECLARATIONS
'=================================================================

'RTS_FILE is the name of the database file created by VBLM
'VBLM_RTString expects to find it in the application directory
'the default is "LANGUAGE.DAT", but this is a user-definable RTS Build Option
'the embedded 's are placeholders for VBLM to insert longer names
Const RTS_FILE = "LANGUAGE.DAT"'''''''''''''''''''''''''''''''''''''''

'=================================================================
'OPTIMIZATION METHOD (Binary version only)

'VBLM_RTString allows you to optimize its performance for either memory or speed.
'When optimized for speed (the default), it only goes to disk the first time
'it is called, and loads the entire language table into an array in memory.
'Subsequent calls are very fast, and since the Strings() array consists of
'user-defined types, it does not intrude on local string space.

'If your application has a very large language table, however, this method
'might cause memory problems.  If so, redefine the OPTIMIZATION constant below
'from OPTIMIZE_FOR_SPEED to OPTIMIZE_FOR_MEMORY.

'When optimized for memory, VBLM_RTString initializes by loading the Ptrs() array
'with each string's offset in the file, which are then used on subsequent calls
'to fetch strings "from disk."  I use the quotes here because if the host
'system is using a disk cache, which it probably is, fewer than 1 in 10 calls
'are apt to cause an actual read; the other 9 will be in the cache

    Const OPTIMIZE_FOR_MEMORY = 0
    Const OPTIMIZE_FOR_SPEED = 1
    Const OPTIMIZATION = OPTIMIZE_FOR_SPEED     'set this to your preference

'=================================================================

'REINIT_LDB is the Index value that forces reinitializtion
Const REINIT_LDB = -1

'=================================================================
' STATIC VARIABLES

'Handle is the database file handle
'It is also used as the initialization flag
    Static Handle As Integer

'Ptrs() hold string location data when optimized for memory
    Static Ptrs() As Long

'Strings() hold actual strings when optimized for speed
    Static Strings() As tagVBLM_VS

'=================================================================
' TRANSIENT VARIABLES USED ONLY ON FIRST CALL (INITIALIZATION)
'
'NumLanguages = number of languages in the database
    Dim NumLanguages As Integer

'NumStrings = number of entries in each language table
    Dim NumStrings As Long

'i = for-next counter variable
    Dim i As Long

'PreviousMousePointer = MousePointer Cache Variable
    Dim PreviousMousePointer As Integer

'SelectedLanguage = Language Selected by user or command line
    Dim SelectedLanguage As Integer

'FileName = Full path and filename of language database file
    Dim FileName As String

'Offsets() = location in file of beginning of each language table
    ReDim Offsets(0) As Long

'Languages() = Names of Languages in the the database
    ReDim Languages(0) As tagVBLM_VS

'=================================================================
' TRANSIENT VARIABLE USED ON ALL CALLS WHEN OPTIMIZED FOR MEMORY

'vsTmp = tmp var-length string data type, used to read from disk

    Dim vsTmp As tagVBLM_VS

'=================================================================
' EXECUTABLE CODE BEGINS HERE
'=================================================================
'INITIALIZATION CODE: EXECUTES ONLY ON FIRST CALL
'=================================================================

'Handle is used as the initialization flag

    If Handle = False Or Index = REINIT_LDB Then

'Default Error handling
        On Error GoTo RTS_Error

'cache the current cursor
        PreviousMousePointer = Screen.MousePointer

'open the database file (in a sub in case we need to call it again)
'Note: if we're here because user forced a reinit (ie Index=-1, Handle <>0)
'AND if optimization method = memory, then file is already open
        If Handle = False Or OPTIMIZATION = OPTIMIZE_FOR_SPEED Then
            GoSub OpenDataBaseFile
        End If

'get the number of languages and redim name and offset arrays
        Get #Handle, 1, NumLanguages
        ReDim Languages(NumLanguages), Offsets(NumLanguages)

'get the name and offset of each language table
'while iterating, check for a command line match, flag = "/L="
        For i = 1 To NumLanguages
            Get #Handle, , Languages(i)
            Get #Handle, , Offsets(i)
            If InStr(1, Command$, "/L=" & Languages(i).String, 1) Then SelectedLanguage = i
        Next

'if only one language, select it
        If NumLanguages = 1 Then SelectedLanguage = 1

'if language not yet selected, query the user
        If SelectedLanguage = False Then

'load the rts support form, and fill in the list of language choices
            Load frmVBLM_RTS
            For i = 1 To NumLanguages
                frmVBLM_RTS.lstLanguages.AddItem Languages(i).String
            Next

'center it on the screen, set an arrow cursor, show it modally
            frmVBLM_RTS.Move (Screen.Width - frmVBLM_RTS.Width) \ 2, (Screen.Height - frmVBLM_RTS.Height) \ 2
            Screen.MousePointer = 1
            frmVBLM_RTS.Show 1

'get the selected language and unload
            SelectedLanguage = frmVBLM_RTS.lstLanguages.ListIndex + 1
            Unload frmVBLM_RTS

        End If

'look busy
        Screen.MousePointer = 11

'get the number of strings in a language table
        Get #Handle, , NumStrings

'and, depending on optimization method, make room either for strings or pointers
        If OPTIMIZATION = OPTIMIZE_FOR_SPEED Then
            ReDim Strings(NumStrings)
        ElseIf OPTIMIZATION = OPTIMIZE_FOR_MEMORY Then ReDim Ptrs(NumStrings)
        End If

'seek to the beginning of the selected table
        Seek Handle, Offsets(SelectedLanguage)

'and for each string
'either retrieve its value into Strings() or its location into Ptrs()
        For i = 1 To NumStrings
            If OPTIMIZATION = OPTIMIZE_FOR_MEMORY Then Ptrs(i) = Seek(Handle)
            Get #Handle, , vsTmp
            If OPTIMIZATION = OPTIMIZE_FOR_SPEED Then Strings(i) = vsTmp
        Next

'if we've read and saved the strings, close the file
'otherwise we need to keep it open
        If OPTIMIZATION = OPTIMIZE_FOR_SPEED Then Close Handle

'restore the original cursor state
        Screen.MousePointer = PreviousMousePointer

'and bail if just here to reinit
        If Index = REINIT_LDB Then Exit Function

    End If

'=================================================================
' END OF INITIALIZATION CODE
' FOLLOWING CODE EXECUTES ON ALL CALLS TO RETURN THE STRING
'=================================================================

'only two likely errors, so deal with them as needed
    On Error Resume Next

    If OPTIMIZATION = OPTIMIZE_FOR_SPEED Then

'return string from array
        VBLM_RTString = Strings(Index).String

'possible error: index out of range; so indicate
        If Err = 9 Then VBLM_RTString = "Invalid Index"

    ElseIf OPTIMIZATION = OPTIMIZE_FOR_MEMORY Then

'read string from disk
        Get #Handle, Ptrs(Index), vsTmp

'possible error: bad file handle, because somebody's "Close" elsewhere closed our file
        If Err = 9 Then
            vsTmp.String = "Invalid Index"
        ElseIf Err = 52 Then
            Err = 0
            GoSub OpenDataBaseFile
            Get #Handle, Ptrs(Index), vsTmp
            If Err Then vsTmp.String = "Unable to retrieve string"
        End If

        VBLM_RTString = vsTmp.String

    End If

    Exit Function

'=================================================================
' END OF MAIN FUNCTION CODE
'=================================================================

'=================================================================
' opendatabasefile sub-procedure
'=================================================================

OpenDataBaseFile:

'grab a handle
    Handle = FreeFile

'if filename includes a directory spec, assume it's a full path
'otherwise look in application directory
    If InStr(RTS_FILE, "\") = False Then
        FileName = App.Path
        If Right$(FileName, 1) <> "\" Then FileName = FileName & "\"
        FileName = FileName & RTS_FILE
    Else FileName = RTS_FILE
    End If

'if file not found, terminate; you can gussy this up as desired
    If Dir$(FileName) = "" Then
        MsgBox "Fatal Error: Language database file " & FileName & " not found.", MB_STOP
        End
    End If

'open for binary
    Open FileName For Binary As Handle
    Return

'=================================================================
' default error handler
'=================================================================
RTS_Error:
    Select Case MsgBox(Error$ & "(Code" & Str$(Err), MB_ICONEXCLAMATION + MB_ABORTRETRYIGNORE, "VBLM_RTString()")
    Case IDABORT
        End
    Case IDRETRY
        Resume
    Case IDIGNORE
        Resume Next
    Case Else
    End Select

End Function

