'VBLM_RTA.BAS: VB Language Manager Runtime Language Switching Support Module
'This module is added to RSV projects built for ASCII format language databases
'Copyright 1994-5 by WhippleWare

'==============================================================
'DECLARATIONS
'==============================================================

Option Explicit
DefInt A-Z

'tagVBLM_VS is the record type for the language database
'although ASCII format databases do NOT use it for disk storage
'VBLM still uses a static array of type tagVBLM_VS for in-memory storage
'this keeps the strings out of the app's local string space
Type tagVBLM_VS
    String As String
End Type

'aliased API function
Declare Function GPPS Lib "Kernel" Alias "GetPrivateProfileString" (ByVal Section$, ByVal Key$, ByVal sDflt$, ByVal ReturnedString$, ByVal MaxSize%, ByVal File$) As Integer

'=================================================================
'The VBLM_RTString function is the core of runtime switching (RTS)
'
'All translated strings and properties have been replaced with
'calls to VBLM_RTString
'
'The function is passed an index and returns a string
'The first call initializes the database
'You can also force reinitialization (ie change languages) by passing
'a value of -1 as the Index argument
'=================================================================
'=================================================================
'
Function VBLM_RTString (Index As Long) As String

'=================================================================
'=================================================================
'STOCK VB CONSTANTS USED FOR CLARITY
'THESE CAN BE DELETED IF THEY ARE ALREADY DECLARED IN THIS PROJECT
'WITH GLOBAL SCOPE

Const MB_STOP = 16
Const MB_ABORTRETRYIGNORE = 2
Const MB_ICONEXCLAMATION = 48
Const IDABORT = 3
Const IDRETRY = 4
Const IDIGNORE = 5

'=================================================================
' LOCAL DECLARATIONS
'=================================================================

'RTS_FILE is the name of the database file created by VBLM
'VBLM_RTString expects to find it in the application directory
'the default is "LANGUAGE.DAT", but this is a user-definable RTS Build Option
'the embedded 's are placeholders for VBLM to insert longer names
Const RTS_FILE = "LANGUAGE.DAT"'''''''''''''''''''''''''''''''''''''''

'PS_SIZE is the string-length value needed for profile string function
Const PS_SIZE = 64

'REINIT_LDB is the Index value that forces reinitializtion
Const REINIT_LDB = -1

' STATIC VARIABLES
'Handle is the database file handle, also used as the initialization flag
    Static Handle As Integer

'Strings() will hold the strings we're going to fetch and use
    Static Strings() As tagVBLM_VS

'=================================================================
' TRANSIENT VARIABLES USED ONLY DURING INITIALIZATION

'KeyName = name of key for GetPrivateProfileString to fetch
    Dim KeyName As String

'KeyValue = string returned by GetPrivateProfileString
'nKeyValue = its value
    Dim KeyValue As String, nKeyValue As Long

'DefaultValue = value if key not found
    Dim DefaultValue As String
    DefaultValue = "???"

'NumLanguages = number of languages in the database
    Dim NumLanguages As Integer

'NumStrings = number of entries in each language table
    Dim NumStrings As Long

'i = for-next counter variable
    Dim i As Long

'cp = cursor position while parsing a string
    Dim cp As Integer

'sIndex = value of string index contained in string entry
    Dim sIndex As Long

'PreviousMousePointer = MousePointer Cache Variable
    Dim PreviousMousePointer As Integer

'SelectedLanguage = Language Selected by user or command line
    Dim SelectedLanguage As Integer

'FileName = Full path and filename of language database file
    Dim FileName As String

'Offsets() = location in file of beginning of each language table
    ReDim Offsets(0) As Long

'Languages() = Names of Languages in the the database
    ReDim Languages(0) As String

'sTmp = tmp string variable, used to read from disk
    Dim sTmp As String

'=================================================================
' EXECUTABLE CODE BEGINS HERE
'=================================================================
'INITIALIZATION CODE: EXECUTES ON FIRST CALL OR WHEN INDEX = REINIT_LDB
'=================================================================

'Handle is used as the initialization flag
    If Handle = False Or Index = REINIT_LDB Then

'Default Error handling
        On Error GoTo RTS_Error

'cache the current cursor
        PreviousMousePointer = Screen.MousePointer

'grab a file handle
        Handle = FreeFile

'look for file in application directory unless user has specified a directory
        If InStr(RTS_FILE, "\") = False Then
            FileName = App.Path
            If Right$(FileName, 1) <> "\" Then FileName = FileName & "\"
            FileName = FileName & RTS_FILE
        Else FileName = RTS_FILE
        End If

'if file not found, terminate; you can gussy this up as desired
        If Dir$(FileName) = "" Then
            MsgBox "Fatal Error: Language database file " & FileName & " not found.", MB_STOP
            End
        End If

'get the number of languages and redim name and offset arrays
        KeyName = "NumLanguages"
        GoSub GetLanguageProfileString
        If KeyValue <> DefaultValue Then NumLanguages = nKeyValue Else GoTo Fatal_RTS_Error
        ReDim Languages(NumLanguages), Offsets(NumLanguages)

'get the name and offset of each language table
'while iterating, check for a command line match, flag = "/L="
        For i = 1 To NumLanguages

'construct the language name key
            KeyName = "Language" & Format$(i)

'get the value
            GoSub GetLanguageProfileString

'and assign it if found, else bail
            If KeyValue <> DefaultValue Then Languages(i) = KeyValue Else GoTo Fatal_RTS_Error

'now ditto for the offset values (file location where languages start)
            KeyName = "Language" & Format$(i) & "Start"
            GoSub GetLanguageProfileString

'and assign it if found, else bail
            If KeyValue <> DefaultValue Then Offsets(i) = nKeyValue Else GoTo Fatal_RTS_Error

            If InStr(1, Command$, "/L=" & Languages(i), 1) Then SelectedLanguage = i
        Next

'if only one language in database, select it
        If NumLanguages = 1 Then SelectedLanguage = 1

'else if language not specified on command line, query the user
        If SelectedLanguage = False Then

'load the rts support form, and fill in the list of language choices
            Load frmVBLM_RTS
            For i = 1 To NumLanguages
                frmVBLM_RTS.lstLanguages.AddItem Languages(i)
            Next

'center it on the screen, set an arrow cursor, show it modally
            frmVBLM_RTS.Move (Screen.Width - frmVBLM_RTS.Width) \ 2, (Screen.Height - frmVBLM_RTS.Height) \ 2
            Screen.MousePointer = 1
            frmVBLM_RTS.Show 1

'get the selected language and unload
            SelectedLanguage = frmVBLM_RTS.lstLanguages.ListIndex + 1
            Unload frmVBLM_RTS

        End If

'look busy
        Screen.MousePointer = 11

'get the number of strings in a language table
        KeyName = "NumStrings"
        GoSub GetLanguageProfileString
        If KeyValue <> DefaultValue Then NumStrings = nKeyValue Else GoTo Fatal_RTS_Error

'make room for the strings
        ReDim Strings(NumStrings)

'open the file and seek to the beginning of the selected table
'Note: the following method for loading the strings is 2-3 times faster then
'Windows' GetPrivateProfileString () function

        Open FileName For Input As Handle
        Seek Handle, Offsets(SelectedLanguage)

'Offset will be correct unless user has edited & screwed up the file, so test it
'the line should be "[Name_of_Selected_Language]"
        Line Input #Handle, sTmp
        sTmp = Trim$(sTmp)

'if it isn't (strcomp returns a value when NOT a match), then
'read file from beginning until line is found
        If StrComp(sTmp, "[" & Languages(SelectedLanguage) & "]") Then
            Seek Handle, 1
            Do Until EOF(Handle)
                Line Input #Handle, sTmp
                sTmp = Trim$(sTmp)
                If StrComp(sTmp, "[" & Languages(SelectedLanguage) & "]") = False Then Exit Do
            Loop
            If EOF(Handle) Then GoTo Fatal_RTS_Error
        End If

'now retrieve each string
'vblm will have created a file with "s[value]="string""
'we will test the value and insert string in appropriate place
        For i = 1 To NumStrings
            Line Input #Handle, sTmp
            cp = InStr(sTmp, "=")
            If cp Then

'compute sIndex
                sIndex = Val(Mid$(sTmp, 2, cp - 1))

'ignore all to left of equal sign
                sTmp = Mid$(sTmp, cp + 1)
                
'trim quotes
                If Asc(sTmp) = 34 Then sTmp = Mid$(sTmp, 2)
                If Asc(Right$(sTmp, 1)) = 34 Then sTmp = Left$(sTmp, Len(sTmp) - 1)

                Strings(sIndex).String = sTmp

            Else GoTo Fatal_RTS_Error
            End If
        Next

'close the file and restore the original cursor state
        Close Handle
        Screen.MousePointer = PreviousMousePointer

'and bail if just here to reinit
        If Index = REINIT_LDB Then Exit Function

    End If

'=================================================================
' END OF INITIALIZATION CODE
' FOLLOWING CODE EXECUTES ON ALL CALLS TO RETURN THE STRING
'=================================================================

'only one likely error, so deal with it as needed
    On Error Resume Next

'return string from array
    VBLM_RTString = Strings(Index).String

'possible error: index out of range; so indicate
    If Err = 9 Then VBLM_RTString = "Invalid Index"

    Exit Function

'=================================================================
' END OF MAIN FUNCTION CODE
'=================================================================

'=================================================================
' Get Profile Strings sub-procedure
'=================================================================
GetLanguageProfileString:
    KeyValue = Space$(PS_SIZE)
    cp = GPPS("VBLM", KeyName, DefaultValue, KeyValue, PS_SIZE, FileName)
    If cp Then
        KeyValue = Left$(KeyValue, cp)
        nKeyValue = Val(KeyValue)
    End If
    Return
    
'=================================================================
' fatal error handler (database file missing critical info)
'=================================================================
Fatal_RTS_Error:
    MsgBox "Fatal Error: Language database file " & FileName & " is missing critical information.", MB_STOP
    End

'=================================================================
' default error handler
'=================================================================
RTS_Error:
    Select Case MsgBox(Error$ & "(Code" & Str$(Err), MB_ICONEXCLAMATION + MB_ABORTRETRYIGNORE, "VBLM_RTString()")
    Case IDABORT
        End
    Case IDRETRY
        Resume
    Case IDIGNORE
        Resume Next
    Case Else
    End Select

End Function

