'---------------------------------------------------------------------------
' DOS Interrupt Demo Program, Copyright (c) 1994 Karl E. Peterson
' Redistributed by permission.
'
' Requires: VBInt.DLL, VBRun300.DLL
'
' This program may be distributed freely on the condition that it is
' distributed in full, and unmodified, and that no fee is charged for such
' distribution with the exception of reasonable media and shipping charges.
' Any or all portions of the source code may be incorporated into your own
' programs, and those programs may be distributed without payment of
' royalties on the condition that such programs differ substantially from
' this demonstration program.
'
' This program is distributed AS IS.  The author acknowledges absolutely
' no liability for its use or misuse.  The sole purpose of this program is to
' demonstrate some of the powerful capabilities of VBInt.DLL, written and
' copyrighted by Rick Esterling.  Calling DOS interrupts from Windows is
' fairly "non-standard" behavior.  Users of this program acknowledge that
' they are doing so at their OWN RISK.
'
' This demonstration program was created and distributed by:
'   Karl E. Peterson
'   Regional Transportation Council
'   1351 Officers' Row
'   Vancouver, Washington 98661
'   CompuServe: 72302,3707
'
' Your comments or questions are invited!
'---------------------------------------------------------------------------

DefInt A-Z
Option Explicit

Function ByteHi% (WordIn%)
  If WordIn < 0 Then
    ByteHi = (WordIn + &H10000) \ &H100
  Else
    ByteHi = WordIn \ &H100
  End If
End Function

Function ByteLo% (WordIn%)
  ByteLo = WordIn And 255
End Function

Function ByteSwap (WordIn%) As Integer
  
  Dim ByteHi%, ByteLo%, High&

  If WordIn < 0 Then
    ByteHi = (WordIn + 65536) \ 256
  Else
    ByteHi = WordIn \ 256
  End If
  ByteLo = WordIn And 255

  High& = ByteLo * 256&
  If High& > 32767 Then
    ByteLo = High& - 65536
  Else
    ByteLo = High&
  End If
  ByteSwap = ByteLo + ByteHi

End Function

Function FmtDirEntry$ (f As FileDataType)

  Dim t$, fde$, at$
  t$ = Chr$(9)
  at$ = String$(4, "-")
  
  If f.Attr And attrDirectory Then
    fde$ = RTrim$(f.FileName) + t$
    fde$ = fde$ + "[Sub-Dir]" + t$
  Else
    fde$ = LCase$(RTrim$(f.FileName)) + t$
    fde$ = fde$ + Format$(f.Size, "#,##0") + t$
  End If

  fde$ = fde$ + Format$(f.sDate, "short date") + t$
  fde$ = fde$ + LCase$(Format$(f.sDate, "medium time")) + t$
  
  If f.Attr And attrReadOnly Then
    Mid$(at$, 1, 1) = "r"
  End If
  If f.Attr And attrHidden Then
    Mid$(at$, 2, 1) = "h"
  End If
  If f.Attr And attrSystem Then
    Mid$(at$, 3, 1) = "s"
  End If
  If f.Attr And attrArchived Then
    Mid$(at$, 4, 1) = "a"
  End If
  fde$ = fde$ + at$
  
  FmtDirEntry$ = fde$

End Function

Function GetWinDir$ ()
  Dim Buffer$, Ret%
  Buffer = String$(144, 0)
  Ret% = GetWindowsDirectory(Buffer, Len(Buffer))
  GetWinDir$ = Left$(Buffer, Ret)
End Function

Function GetWinVersion ()
  
  ' Initialize some vars
      Dim vernum&, vermaj%, vermin%
      Dim verDos%, verWin%

  ' Get system version info
      vernum& = GetVersion&()

  ' Get Dos Version (what the hell, it's there)
      verDos = CInt(vernum& / &H10000)
      vermaj = verDos / 256
      vermin = verDos And &HFF
      verDos = vermaj * 100 + vermin

  ' Get Windows Version
      verWin = CInt(vernum& And &HFFFF&)
      vermaj = verWin And &HFF
      vermin = CInt(verWin / 256)
      verWin = vermaj * 100 + vermin

  GetWinVersion = verWin
End Function

Function HexFmt2$ (ValIn%)
  If ValIn >= 0 And ValIn <= &HFF Then
    HexFmt2$ = Right$("00" + Hex$(ValIn), 2)
  End If
End Function

Function HexFmt4$ (ValIn%)
    HexFmt4$ = Right$("0000" + Hex$(ValIn), 4)
End Function

Function WinIsNT () As Integer
  Dim Ret%
  Ret = GetWinFlags()
  If Ret And WF_WINNT Then
    WinIsNT = True
  Else
    WinIsNT = False
  End If
End Function

Function WordCombine% (ByteHi%, ByteLo%)
  Dim High&
  High& = ByteHi
  High& = High& * 256
  If High& > 32767 Then
    ByteHi = High& - 65536
  Else
    ByteHi = High&
  End If
  WordCombine = ByteHi + ByteLo
End Function

Function WordHi% (LongIn&)
  If LongIn < 0 Then
    WordHi = LongIn \ &H10000 - 1
  Else
    WordHi = LongIn \ &H10000
  End If
End Function

Function WordLo% (LongIn&)
  If (LongIn And &HFFFF&) > &H7FFF Then
    WordLo = (LongIn And &HFFFF&) - &H10000
  Else
    WordLo = LongIn And &HFFFF&
  End If
End Function

Sub WordSplit (WordIn%, ByteHi%, ByteLo%)
  If WordIn < 0 Then
    ByteHi = (WordIn + 2 ^ 16) \ 256
  Else
    ByteHi = WordIn \ 256
  End If
  ByteLo = WordIn And 255
End Sub

