VERSION 2.00
Begin Form Form1 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Text-Alignment"
   ClientHeight    =   3975
   ClientLeft      =   1140
   ClientTop       =   1545
   ClientWidth     =   3615
   Height          =   4380
   Left            =   1080
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3975
   ScaleWidth      =   3615
   Top             =   1200
   Width           =   3735
   Begin TextBox Text1 
      Height          =   3015
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   120
      Width           =   3375
   End
   Begin Frame Frame1 
      Caption         =   "Alignment"
      Height          =   615
      Left            =   120
      TabIndex        =   1
      Top             =   3240
      Width           =   3375
      Begin OptionButton optAlign 
         Caption         =   "&Right"
         Height          =   255
         Index           =   2
         Left            =   2280
         TabIndex        =   4
         Top             =   240
         Width           =   975
      End
      Begin OptionButton optAlign 
         Caption         =   "&Center"
         Height          =   255
         Index           =   1
         Left            =   1080
         TabIndex        =   3
         Top             =   240
         Width           =   1095
      End
      Begin OptionButton optAlign 
         Caption         =   "&Left"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   2
         Top             =   240
         Width           =   855
      End
   End
End
Option Explicit

Sub Form_Load ()
    Dim buff As String

    'Center form on screen
    Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2

    'Put sample text in text box
    buff = "This demo shows how you can change the alignment of a multi-line text box"
    buff = buff & " at run time. Normally, this property can only be set at design-time."
    buff = buff & Chr$(13) & Chr$(10) & Chr$(13) & Chr$(10)
    buff = buff & "This is accomplished by calling VB-ASM's vbRecreateCtrl routine to"
    buff = buff & " change the control's default alignment and then recreating the text"
    buff = buff & " box with the new defaults." & Chr$(13) & Chr$(10)
    Text1 = buff

    'Start with left-alignment
    optAlign(0) = True

    'Since the text box was not yet visible, it was created
    'with the visible style bit set to false
    Text1.Visible = True

End Sub

Sub optAlign_Click (Index As Integer)
    Dim i As Long, tmpBuffer As String

    'Recreating the text box control will lose any text
    'it contains so preserve the control's text
    tmpBuffer = Text1

    'Clear existing alignment style bits
    i = SetStyleBits(Text1, ES_LEFT Or ES_CENTER Or ES_RIGHT, False)

    'Now set new alignment style bit
    Select Case Index
        Case 0
            i = ES_LEFT
        Case 1
            i = ES_CENTER
        Case 2
            i = ES_RIGHT
    End Select
    i = SetStyleBits(Text1, i, True)

    'Restore control's text
    Text1 = tmpBuffer

End Sub

Function SetStyleBits (Ctrl As Control, Bits As Long, SetMode As Integer) As Integer
    Dim ModelInfo As MODEL, Pointer As Long, oldWndStyle As Long

    'Get a pointer to the control's MODEL structure
    Pointer = vbGetCtrlModel(Ctrl)

    'Copy MODEL structure to our own variable
    Call vbGetData(Pointer, ModelInfo, Len(ModelInfo))

    'Preserve the control's default window style flags
    oldWndStyle = ModelInfo.flWndStyle

    'Modify the specified bits of the control's window style
    If SetMode Then
        'Set specified bit(s)
        ModelInfo.flWndStyle = ModelInfo.flWndStyle Or Bits
    Else
        'Clear specified bit(s)
        ModelInfo.flWndStyle = ModelInfo.flWndStyle And (Not Bits)
    End If

    'Copy our variable back to the MODEL structure
    Call vbSetData(Pointer, ModelInfo, Len(ModelInfo))

    'Now recreate control using new style
    SetStyleBits = vbRecreateCtrl(Ctrl)

    'Restore control's default window style
    ModelInfo.flWndStyle = oldWndStyle
    Call vbSetData(Pointer, ModelInfo, Len(ModelInfo))

End Function

