' UppLow.bas - Force Upper or Lower Case in a Text Box
' 95/03/02 Copyright 1995, Larry Rebich, The Bridge, Inc.

    Option Explicit
    DefInt A-Z
    
    Declare Function GetWindowLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Long
    Declare Function SetWindowLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal dwNewLong As Long) As Long

Function ForceUpperOrLowerCase (TheControl As Control, SetUpper As Integer) As Integer
' If SetUpper is true then set to upper case, else lower case
' Returns True if successful
    Const GWL_Style = (-16)
    Const ES_UPPERCASE = &H8&
    Const ES_LOWERCASE = &H10&
    Dim Rtn As Long
    Dim Style As Long
    Style = GetWindowLong(TheControl.hWnd, GWL_Style)
    If SetUpper Then                    'upper?
        Style = Style Or ES_UPPERCASE   'yes, set upper
    Else
        Style = Style Or ES_LOWERCASE   'no, set lower
    End If
    Rtn = SetWindowLong(TheControl.hWnd, GWL_Style, Style)  'do it
    If Rtn <> 0 Then                    'if not zero then was successful
        ForceUpperOrLowerCase = True
    End If
End Function

