VERSION 2.00
Begin Form Form1 
   Caption         =   "Text File Conversion To VB Help Message Subroutine"
   ClientHeight    =   5415
   ClientLeft      =   1185
   ClientTop       =   1200
   ClientWidth     =   7470
   Height          =   6075
   Icon            =   TXTCON4A.FRX:0000
   Left            =   1140
   LinkTopic       =   "Form1"
   ScaleHeight     =   5415
   ScaleWidth      =   7470
   Top             =   585
   Width           =   7560
   Begin CommandButton Command3 
      Caption         =   "&OK"
      Height          =   375
      Left            =   4800
      TabIndex        =   5
      Top             =   4800
      Width           =   1095
   End
   Begin CommandButton Command5 
      Caption         =   "&Save"
      Height          =   375
      Left            =   1920
      TabIndex        =   3
      Top             =   4800
      Width           =   1095
   End
   Begin TextBox Text1 
      BackColor       =   &H00FFFFFF&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   9
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   4095
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   2
      Top             =   480
      Width           =   6975
   End
   Begin CommandButton Command2 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   3360
      TabIndex        =   1
      Top             =   4800
      Width           =   1095
   End
   Begin CommandButton Command1 
      Caption         =   "&Open"
      Height          =   375
      Left            =   480
      TabIndex        =   0
      Top             =   4800
      Width           =   1095
   End
   Begin CommonDialog CMDialog1 
      Left            =   6720
      Top             =   4800
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Converted Text File Information:"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   240
      Left            =   360
      TabIndex        =   4
      Top             =   120
      Visible         =   0   'False
      Width           =   3300
   End
   Begin Menu menuNone 
      Caption         =   "&Help"
      Begin Menu menuHelp 
         Caption         =   "&TextConv Help"
      End
      Begin Menu menuAbout 
         Caption         =   "&About Text Convert"
      End
   End
End
' == Form: Form1 ================================================
'
' TEXTCONV.EXE
'
' Application to convert an ASCII text file to a a Visual Basic
' Subroutine, which can be used as a "help" message routine.
'
' Written by Jerry Rivers. Last modified: 01/17/95
'
' TextConv reads each line of the input ASCII text file and
' creates VB-compilable lines of code that can be fed to a
' MsgBox control.  This is done by concatenating each line of
' the text file into one long string called Msg$
'
' The user is given the option of naming the Subroutine and
' the Text Box the help message will be listed to.
'
' TextConv sends its "output" to the Windows clipboard.  To
' use the converted text file (i.e. the help Subroutine),
' just paste the routine into the General Declarations section
' of the Form it will be called from or paste into a Module.
'
' Open Button:
'     Utilizes Common Dialog File Open to read the input ASCII
'     text file. Each line is then scanned and concatenated
'     into the Msg$ string.  Where there are quote marks (")
'     in the text file, they are converted into two quote
'     marks (""), so as to be compilable by VB
'
' Save Button:
'     The user can name the help Subroutine and the Text Box
'     control to receive the output.  Defaults are "HelpMsg"
'     and Text1.
'
' ===============================================================

Dim Out$                ' Contains data read from input text
                        ' file and converted to MsgBox format
Dim Text1Save$          ' Temp save of Text1.Text info

' Open Command Button
'
Sub Command1_Click ()
   Dim OpenName$

   Label1.Caption = "Converted Text File Information"
   Label1.Visible = True
   NL$ = Chr$(13) + Chr$(10)
   Q$ = Chr$(34)

   CMdialog1.Action = 1            '
   CMdialog1.CancelError = False
   OpenName$ = CMdialog1.Filename
   If OpenName$ = "" Then Exit Sub   ' User didn't select a file

   ' Initialize the output string
   Out$ = "   NL$ = chr$(13) + chr$(10)" + NL$

   On Error GoTo GotError

   MousePointer = 11
   DoEvents
   Open OpenName$ For Input As #1

   Do While Not EOF(1) And I < 2000
      DoEvents
      Line Input #1, Dat$
      NewStr$ = Dat$
      ReplaceString NewStr$, Q$, NewStr$, Q$ + Q$
      Out$ = Out$ + "   Msg$ = Msg$ + " & Q$ & NewStr$ & Q$ & " + NL$" + NL$
   Loop
   Close #1
   MousePointer = 0
   Text1.Text = Out$

   ' Put text file info on clipboard for retrieval by Form2
   ' which finishes the conversion by putting on the Sub
   ' header End Sub and other requirements of the help message
   ' routine
   Clipboard.SetText Out$

   ' Turn on Save button now
   Command5.Enabled = True
 Exit Sub

GotError:
   Close #1
   MsgBox ("Could not open File = " + OpenName$ + " -- Error = " + Error$(Err))
   On Error GoTo 0
   Exit Sub
End Sub

' Exit Command Button
'
Sub Command2_Click ()
    End
End Sub

' OK Command Button for Help
'
Sub Command3_Click ()
   Command1.Visible = True
   Command2.Visible = True
   Command5.Visible = True
   Command3.Visible = False

   If Text1Save <> "" Then
      Label1.Visible = True
   Else
      Label1.Visible = False
   End If

   Label1.Caption = "Converted Text File Information"
   Text1.Text = Text1Save$
End Sub

' Save Command button
'
' Transfers control to Form2, which gathers info from the
' user for the name of the Help Message subroutine and the
' name of the Text Box the help should be displayed in
'
Sub Command5_Click ()

   Form2.Show
   Form2.SetFocus

End Sub

Sub Form_Load ()

   ' Center form on screen
   Form1.Left = (Screen.Width - Form1.Width) / 2
   Form1.Top = (Screen.Height - Form1.Height) / 2

   ' turn off Save button until Open executed
   Command5.Enabled = False

   Command1.Visible = True
   Command2.Visible = True
   Command5.Visible = True
   Command3.Visible = False

    CMdialog1.Filter = "Input Text Files|*.txt; *.hlp; *.dat|All Files|*.*"

    CMdialog1.DefaultExt = "txt"

End Sub

Sub menuAbout_Click ()
   Form1.Hide
   AboutForm.Show modal
   Form1.Show
End Sub

Sub menuHelp_Click ()

   ' Save Text1 contents in case user has already opened a
   ' file, otherwise, Help will overwrite the text
   Text1Save$ = Text1.Text

   Command1.Visible = False
   Command2.Visible = False
   Command5.Visible = False
   Command3.Visible = True

   Label1.Caption = "TextConv Help"
   Label1.Visible = True

   Call TextConvHelp
   
End Sub

' Used to find quote marks (") in an imput string and replace
' them with double quotes (""), so that the string is recognized
' by VB and compiles without a syntax error
'
Sub ReplaceString (ByVal StringIn$, TestString$, StringOut$, Replace$)

   StringOut = ""
   Start = 1
   Found = InStr(Start, StringIn$, TestString$)

   If Found = 0 Then
      StringOut$ = StringIn$
      Exit Sub
   End If

   Do
      StringOut$ = StringOut$ + Mid$(StringIn$, Start, Found - Start)
      StringOut$ = StringOut$ + Replace$
      Start = Found + 1
      Found = InStr(Start, StringIn$, TestString$)
   Loop Until Found = 0

' Tack on whatever is left of StringIn after last quote found
   LenStr = Len(StringIn$)
   If Start < LenStr Then
      StringOut$ = StringOut + Mid$(StringIn$, Start, 9999)
   End If

End Sub

Sub TextConvHelp ()
   NL$ = Chr$(13) + Chr$(10)
   Msg$ = Msg$ + "  TEXTCONV HELP" + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "      TextConv is a utility which converts an ASCII text file to a a Visual" + NL$
   Msg$ = Msg$ + "  Basic Subroutine, which can be used as a ""help"" message routine.  The" + NL$
   Msg$ = Msg$ + "  input text file can be created in any text editor, such as the DOS" + NL$
   Msg$ = Msg$ + "  Edit or Windows NotePad.  But, each line MUST end with a carriage" + NL$
   Msg$ = Msg$ + "  return (the normal way editors are used).  If you use NotePad, be sure" + NL$
   Msg$ = Msg$ + "  to turn word wrap ""off""" + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "      TextConv reads each line of the input ASCII text file and creates" + NL$
   Msg$ = Msg$ + "  VB-compilable lines of code that can be fed to a Text Box control." + NL$
   Msg$ = Msg$ + "  This is done by concatenating each line of the text file into one long" + NL$
   Msg$ = Msg$ + "  string (TextConv uses Msg$)" + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "      You are given the option of naming the Subroutine and the Text Box the" + NL$
   Msg$ = Msg$ + "  help message will be listed to.  Defaults are: HelpMsg for the Sub and" + NL$
   Msg$ = Msg$ + "  Text1 for the Text Box control." + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "      TextConv ""saves"" its ""output"" to the Windows clipboard.  To use the" + NL$
   Msg$ = Msg$ + "  converted text file (i.e. the help Subroutine), just paste the routine" + NL$
   Msg$ = Msg$ + "  into the General Declarations section of the Form it will be called from" + NL$
   Msg$ = Msg$ + "  or paste into a Module." + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "  OPEN BUTTON:" + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "      TextConv uses Common Dialog File Open to read the input ASCII text" + NL$
   Msg$ = Msg$ + "  file.  Each line is then scanned and concatenated into the Msg$ string." + NL$
   Msg$ = Msg$ + "  Where there are quote marks ("") in the text file, they are converted into" + NL$
   Msg$ = Msg$ + "  double quote marks (""""), so as to be compilable by VB." + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "  SAVE BUTTON:" + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "      You can name the help Subroutine and the Text Box control to receive" + NL$
   Msg$ = Msg$ + "  the output or click on OK to accept the defaults (HelpMsg for the Sub and" + NL$
   Msg$ = Msg$ + "  Text1 for the Text Box.  After placing the completed help suboutine on the" + NL$
   Msg$ = Msg$ + "  clipboard, TextConv puts up a MsgBox reminding you how to retrieve the" + NL$
   Msg$ = Msg$ + "  data and ends." + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "  CANCEL BUTTON:" + NL$
   Msg$ = Msg$ + "" + NL$
   Msg$ = Msg$ + "      Quits TextConv without saving any data to the clipboard.  If you have" + NL$
   Msg$ = Msg$ + "  already opened a text file but have not ""saved"" it, it will be lost and" + NL$
   Msg$ = Msg$ + "  you will have to re-run TextConv if you still want to create a help" + NL$
   Msg$ = Msg$ + "  subroutine." + NL$
   Text1.Text = Msg$
End Sub

