Option Explicit
'
' This module contains the routines to track the instances
' of each type of form.
'


Type NextForm_Type
     Formclass  As Integer
     Index As Integer
     Tag As String
End Type

Type FormDetailsType
     Index As Integer
     Formclass As Integer
     Deleted As Integer
End Type

Dim FormDetails() As FormDetailsType

Function Countforms (Class As Integer) As Integer
   Dim X As Integer
   Dim Count As Integer
   For X = 0 To Forms.Count - 1
     If Len(Forms(X).Tag) = 6 Then
	If Val(Right(Forms(X).Tag, 3)) = Class Then Count = Count + 1
     End If
   Next
   Countforms = Count
End Function

Sub DeleteForm (F As Form)
  Dim X As Integer
  For X = 0 To UBound(FormDetails)
    If FormDetails(X).Formclass = GetFormClass(F) Then
       If FormDetails(X).Index = GetFormIndex(F) Then
	  FormDetails(X).Deleted = True
	  Exit For
       End If
     End If
   Next
End Sub

Function GetFormClass (F As Form) As Integer
    If Len(Trim(F.Tag)) = 6 Then GetFormClass = Val(Right(F.Tag, 3))
End Function

Function GetFormIndex (F As Form) As Integer
    If Len(Trim(F.Tag)) = 6 Then GetFormIndex = Val(Left(F.Tag, 3))
End Function

Sub Init_FormDetails ()
   ReDim FormDetails(0)
End Sub

Sub Nextform (F() As Form, NF As NextForm_Type)
    Dim I As Integer, X  As Integer
    Dim ArrayCount As Integer

    ArrayCount = UBound(FormDetails)
    ' Cycle throught the document array. If one of the
    ' documents has been deleted, then return that
    ' index.
    For I = 1 To ArrayCount
     If FormDetails(I).Formclass = NF.Formclass Then
      If FormDetails(I).Deleted Then
	NF.Index = I
	NF.Tag = Format$(I, "000") & Format$(NF.Formclass, "000")
	FormDetails(I).Deleted = False
	FormDetails(I).Formclass = NF.Formclass
	Exit Sub
      End If
     End If
    Next

    ' If none of the elements in the document array have
    ' been deleted, then increment the document and the
    ' state arrays by one and return the index to the
    ' new element.
    ReDim Preserve FormDetails(ArrayCount + 1)
    For I = 1 To ArrayCount
       If FormDetails(I).Formclass = NF.Formclass Then X = X + 1
    Next
    X = X + 1
    ReDim Preserve F(X)
    FormDetails(I).Formclass = NF.Formclass
    FormDetails(I).Index = X
    NF.Index = X
    NF.Tag = Format$(I, "000") & Format$(NF.Formclass, "000")
End Sub

