Option Explicit

Const COLOR_WHITE = &HFFFFFF
Const COLOR_DARKGREY = &H808080

'
' Assume the Scalemode of the form is PIXEL
'
Sub Frame (fTop As Integer, fLeft As Integer, fHeight As Integer, fWidth As Integer, fCaption As Control)
    Dim fBottom As Integer
    Dim fRight As Integer
    Dim F As Form
    Set F = fCaption.Parent
    fBottom = fTop + fHeight
    fRight = fLeft + fWidth
    F.Line (fLeft + 1, fTop + 1)-(fRight, fBottom), COLOR_WHITE, B
    F.Line (fLeft, fTop)-(fRight - 1, fBottom - 1), COLOR_DARKGREY, B
    F.Line (fLeft, fBottom)-(fRight, fBottom), COLOR_WHITE
    F.Line (fRight, fTop)-(fRight, fBottom), COLOR_WHITE
    fCaption.ZOrder
End Sub

'
' Inset a control on a form
'
Sub Indent (C As Control)
    Dim SM As Integer
    Dim F As Form
    Set F = C.Parent
    SM = F.ScaleMode
    F.ScaleMode = 3
    F.Line (C.Left - 1, C.Top - 1)-(C.Left - 1, C.Top + C.Height + 1), COLOR_DARKGREY
    F.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left - 1, C.Top - 1), COLOR_DARKGREY
    F.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), COLOR_WHITE
    F.Line (C.Left - 1, C.Top + C.Height + 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), COLOR_WHITE
    F.ScaleMode = SM
End Sub

'
' Use this where the Control "C" is contained within "Container"
'
Sub IndentControl (C As Control, Container As Control)
    Container.Line (C.Left - 1, C.Top - 1)-(C.Left - 1, C.Top + C.Height + 1), COLOR_DARKGREY
    Container.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left - 1, C.Top - 1), COLOR_DARKGREY
    Container.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), COLOR_WHITE
    Container.Line (C.Left - 1, C.Top + C.Height + 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), COLOR_WHITE
End Sub

Sub IndentLabel (C As Control, Parent As Integer)
    Dim X As Integer
    Dim F As Form
    Dim PB As Control   ' Probably a PictureBox
    Dim Is_A_Form As Integer
    If C.Parent.hWnd = Parent Then Is_A_Form = True
    C.BorderStyle = 0
    Set F = C.Parent
    If Is_A_Form Then
       F.Line (C.Left - 1, C.Top - 1)-(C.Left - 1, C.Top - 1 + C.Height), COLOR_DARKGREY
       F.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left - 1, C.Top - 1), COLOR_DARKGREY
       F.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left + C.Width + 1, C.Top - 1 + C.Height), COLOR_WHITE
       F.Line (C.Left - 1, C.Top - 1 + C.Height)-(C.Left + C.Width + 1, C.Top - 1 + C.Height), COLOR_WHITE
    Else
       On Local Error Resume Next ' Controls may not have a hwnd property
       For X = 0 To F.Controls.Count - 1
         If F.Controls(X).hWnd = Parent Then
           Set PB = F.Controls(X)
           Exit For
         End If
       Next
       PB.Line (C.Left - 1, C.Top)-(C.Left - 1, C.Top + C.Height + 1), COLOR_DARKGREY
       PB.Line (C.Left + C.Width + 1, C.Top)-(C.Left - 1, C.Top), COLOR_DARKGREY
       PB.Line (C.Left + C.Width + 1, C.Top)-(C.Left + C.Width + 1, C.Top + C.Height + 1), COLOR_WHITE
       PB.Line (C.Left - 1, C.Top + C.Height + 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), COLOR_WHITE
    End If
End Sub

'
' Give the statusbar a 3d look
'
Sub RaiseBar (P As PictureBox)
    If P.Align = 1 Then P.Line (0, 0)-(P.ScaleWidth - 1, P.ScaleHeight - 1), 0&, B
    P.Line (1, P.ScaleHeight - 2)-(P.ScaleWidth - 1, P.ScaleHeight - 2), COLOR_DARKGREY, B
    P.Line (1, 0)-(P.ScaleWidth - 1, 0), COLOR_WHITE
    P.Line (1, 1)-(1, P.ScaleHeight - 1), COLOR_WHITE
End Sub

'
' Give a form a 3d look
'
Sub Raiseform (F As Form)
    Dim SM As Integer
    Dim SH As Single
    Dim SW As Single
    Dim X As Integer
    Dim y As Integer
    SM = F.ScaleMode
    F.ScaleMode = 3
    SW = F.ScaleWidth
    SH = F.ScaleHeight
    If F.BorderStyle Then
       F.Line (X, y)-(SW - 1, SH - 1), COLOR_DARKGREY, B
    Else
       F.Line (0, 0)-(SW - 1, SH - 1), 0&, B
       X = 1
       y = 1
       F.Line (X, y)-(SW - 2, SH - 2), COLOR_DARKGREY, B
    End If
    F.Line (X, y)-(SW - 1, y), COLOR_WHITE
    F.Line (X, y)-(X, SH - 1), COLOR_WHITE
    F.ScaleMode = SM
End Sub

