'
'  This is a subset of WIN30API.TXT
'
Option Explicit

Type PointAPI
    x As Integer
    y As Integer
End Type

Type Rect
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type


Declare Function Winhelp Lib "User" (ByVal hWnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, dwData As Any) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lplFileName As String) As Integer
Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function getDC Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function SaveDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function RestoreDC Lib "GDI" (ByVal hDC As Integer, ByVal nSavedDC As Integer) As Integer
Declare Function ReleaseDc Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer
Declare Function GetTopWindow Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function Getparent Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function ExtFloodFill Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal crColor As Long, ByVal wFillType As Integer) As Integer
Declare Function MoveTo Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer) As Long
Declare Function LineTo Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function CreatePen Lib "GDI" (ByVal nPenStyle As Integer, ByVal nWidth As Integer, ByVal crColor As Long) As Integer
Declare Function ReleaseDc Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer
Declare Function GetStockObject Lib "GDI" (ByVal nIndex As Integer) As Integer
Declare Function sendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
Declare Function GetTickCount Lib "User" () As Long
Declare Sub GetCursorPos Lib "User" (lpPoint As PointAPI)
Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, lpRect As Rect)
Declare Sub OffsetRect Lib "User" (lpRect As Rect, ByVal x As Integer, ByVal y As Integer)
Declare Sub InflateRect Lib "User" (lpRect As Rect, ByVal x As Integer, ByVal y As Integer)
Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal x As Integer, ByVal y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)

Global Const WM_COMMAND = &H111

' WindowState
Global Const NORMAL = 0    ' 0 - Normal
Global Const MINIMIZED = 1 ' 1 - Minimized
Global Const MAXIMIZED = 2 ' 2 - Maximized


' Key State Masks for Mouse Messages
Global Const MK_LBUTTON = &H1
Global Const MK_RBUTTON = &H2
Global Const MK_SHIFT = &H4
Global Const MK_CONTROL = &H8
Global Const MK_MBUTTON = &H10


Global Const KEY_NUMLOCK = &H90
Global Const KEY_CAPITAL = &H14

' Arrange Method
' for MDI Forms
Global Const CASCADE = 0
Global Const TILE_HORIZONTAL = 1
Global Const TILE_VERTICAL = 2
Global Const ARRANGE_ICONS = 3


Global Const COLOR_SCROLLBAR = 0
Global Const COLOR_BACKGROUND = 1
Global Const COLOR_ACTIVECAPTION = 2
Global Const COLOR_INACTIVECAPTION = 3
Global Const COLOR_MENU = 4
Global Const COLOR_WINDOW = 5
Global Const COLOR_WINDOWFRAME = 6
Global Const COLOR_MENUTEXT = 7
Global Const COLOR_WINDOWTEXT = 8
Global Const COLOR_CAPTIONTEXT = 9
Global Const COLOR_ACTIVEBORDER = 10
Global Const COLOR_INACTIVEBORDER = 11
Global Const COLOR_APPWORKSPACE = 12
Global Const COLOR_HIGHLIGHT = 13
Global Const COLOR_HIGHLIGHTTEXT = 14
Global Const COLOR_BTNFACE = 15
Global Const COLOR_BTNSHADOW = 16
Global Const COLOR_GRAYTEXT = 17
Global Const COLOR_BTNTEXT = 18
Global Const COLOR_ENDCOLORS = COLOR_BTNTEXT
Global Const COLOR_BTNHIGHLIGHT = 20

Declare Function SetWindowlong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal dwNewLong As Long) As Long
Declare Function GetWindowWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Integer
Declare Function SetWindowWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal wNewWord As Integer) As Integer
Declare Function SetfocusAPI Lib "User" Alias "SetFocus" (ByVal hWnd As Integer) As Integer
Declare Function GetFocus Lib "User" () As Integer
Declare Function GetActiveWindow Lib "User" () As Integer
Declare Function GetKeyState Lib "User" (ByVal nVirtKey As Integer) As Integer
Declare Function GetAsyncKeyState Lib "User" (ByVal vKey As Integer) As Integer
'Declare Function WindowFromPoint Lib "User" (ByVal ptScreen As Any) As Integer
Declare Function WindowfromPoint Lib "User" (ByVal pty As Integer, ByVal ptx As Integer) As Integer
Declare Function Lstrcpy Lib "kernel" (p1 As Any, p2 As Any) As Long
Declare Function ShowWindow Lib "User" (ByVal hWnd As Integer, ByVal nCmdShow As Integer) As Integer
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Sub SetSysColors Lib "User" (ByVal nChanges As Integer, lpSysColor As Integer, lpColorValues As Long)
Declare Function CreateCompatibleDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function CreateCompatibleBitmap Lib "GDI" (ByVal hDC As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer) As Integer
Declare Function CreateBitmap Lib "GDI" (ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal nPlanes As Integer, ByVal nBitCount As Integer, ByVal lpBits As Any) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function PatBlt Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal dwRop As Long) As Integer
Declare Function SetBkColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function SetTextColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function DeleteDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function GetWindowDC Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function FrameRect Lib "User" (ByVal hDC As Integer, lpRect As Rect, ByVal hBrush As Integer) As Integer
Declare Sub ClientToScreen Lib "User" (ByVal hWnd As Integer, lpPoint As PointAPI)
Declare Sub ScreenToClient Lib "User" (ByVal hWnd As Integer, lpPoint As PointAPI)
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer


'  Ternary raster operations
Global Const SRCCOPY = &HCC0020 ' (DWORD) dest = source
Global Const SRCPAINT = &HEE0086        ' (DWORD) dest = source OR dest
Global Const SRCAND = &H8800C6  ' (DWORD) dest = source AND dest
Global Const SRCINVERT = &H660046       ' (DWORD) dest = source XOR dest
Global Const SRCERASE = &H440328        ' (DWORD) dest = source AND (NOT dest )
Global Const NOTSRCCOPY = &H330008      ' (DWORD) dest = (NOT source)
Global Const NOTSRCERASE = &H1100A6     ' (DWORD) dest = (NOT src) AND (NOT dest)
Global Const MERGECOPY = &HC000CA       ' (DWORD) dest = (source AND pattern)
Global Const MERGEPAINT = &HBB0226      ' (DWORD) dest = (NOT source) OR dest
Global Const PATCOPY = &HF00021 ' (DWORD) dest = pattern
Global Const PATPAINT = &HFB0A09        ' (DWORD) dest = DPSnoo
Global Const PATINVERT = &H5A0049       ' (DWORD) dest = pattern XOR dest
Global Const DSTINVERT = &H550009       ' (DWORD) dest = (NOT dest)
Global Const BLACKNESS = &H42&  ' (DWORD) dest = BLACK
Global Const WHITENESS = &HFF0062       ' (DWORD) dest = WHITE

' ShowWindow() Commands
Global Const SW_HIDE = 0
Global Const SW_SHOWNORMAL = 1
Global Const SW_NORMAL = 1
Global Const SW_SHOWMINIMIZED = 2
Global Const SW_SHOWMAXIMIZED = 3
Global Const SW_MAXIMIZE = 3
Global Const SW_SHOWNOACTIVATE = 4
Global Const SW_SHOW = 5
Global Const SW_MINIMIZE = 6
Global Const SW_SHOWMINNOACTIVE = 7
Global Const SW_SHOWNA = 8
Global Const SW_RESTORE = 9

' SetWindowPos Flags
Global Const SWP_NOSIZE = &H1
Global Const SWP_NOMOVE = &H2
Global Const SWP_NOZORDER = &H4
Global Const SWP_NOREDRAW = &H8
Global Const SWP_NOACTIVATE = &H10
Global Const SWP_DRAWFRAME = &H20
Global Const SWP_SHOWWINDOW = &H40
Global Const SWP_HIDEWINDOW = &H80
Global Const SWP_NOCOPYBITS = &H100
Global Const SWP_NOREPOSITION = &H200

' SetWindowPos() hwndInsertAfter values
Global Const HWND_TOP = 0
Global Const HWND_BOTTOM = 1
Global Const HWND_TOPMOST = -1
Global Const HWND_NOTOPMOST = -2


' GetSystemMetrics() codes
Global Const SM_CXSCREEN = 0
Global Const SM_CYSCREEN = 1
Global Const SM_CXVSCROLL = 2
Global Const SM_CYHSCROLL = 3
Global Const SM_CYCAPTION = 4
Global Const SM_CXBORDER = 5
Global Const SM_CYBORDER = 6
Global Const SM_CXDLGFRAME = 7
Global Const SM_CYDLGFRAME = 8
Global Const SM_CYVTHUMB = 9
Global Const SM_CXHTHUMB = 10
Global Const SM_CXICON = 11
Global Const SM_CYICON = 12
Global Const SM_CXCURSOR = 13
Global Const SM_CYCURSOR = 14
Global Const SM_CYMENU = 15
Global Const SM_CXFULLSCREEN = 16
Global Const SM_CYFULLSCREEN = 17
Global Const SM_CYKANJIWINDOW = 18
Global Const SM_MOUSEPRESENT = 19
Global Const SM_CYVSCROLL = 20
Global Const SM_CXHSCROLL = 21
Global Const SM_DEBUG = 22
Global Const SM_SWAPBUTTON = 23
Global Const SM_RESERVED1 = 24
Global Const SM_RESERVED2 = 25
Global Const SM_RESERVED3 = 26
Global Const SM_RESERVED4 = 27
Global Const SM_CXMIN = 28
Global Const SM_CYMIN = 29
Global Const SM_CXSIZE = 30
Global Const SM_CYSIZE = 31
Global Const SM_CXFRAME = 32
Global Const SM_CYFRAME = 33
Global Const SM_CXMINTRACK = 34
Global Const SM_CYMINTRACK = 35
Global Const SM_CMETRICS = 36


' MessageBox() Flags
Global Const MB_OK = &H0
Global Const MB_OKCANCEL = &H1
Global Const MB_ABORTRETRYIGNORE = &H2
Global Const MB_YESNOCANCEL = &H3
Global Const MB_YESNO = &H4
Global Const MB_RETRYCANCEL = &H5

Global Const MB_ICONHAND = &H10
Global Const MB_ICONQUESTION = &H20
Global Const MB_ICONEXCLAMATION = &H30
Global Const MB_ICONASTERISK = &H40

Global Const MB_ICONINFORMATION = MB_ICONASTERISK
Global Const MB_ICONSTOP = MB_ICONHAND

Global Const MB_DEFBUTTON1 = &H0
Global Const MB_DEFBUTTON2 = &H100
Global Const MB_DEFBUTTON3 = &H200

Global Const MB_APPLMODAL = &H0
Global Const MB_SYSTEMMODAL = &H1000
Global Const MB_TASKMODAL = &H2000

Global Const MB_NOFOCUS = &H8000

Global Const MB_TYPEMASK = &HF
Global Const MB_ICONMASK = &HF0
Global Const MB_DEFMASK = &HF00
Global Const MB_MODEMASK = &H3000
Global Const MB_MISCMASK = &HC000



' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

Global Const WM_USER = &H400


' Edit Control Messages
Global Const EM_GETSEL = WM_USER + 0
Global Const EM_SETSEL = WM_USER + 1
Global Const EM_GETRECT = WM_USER + 2
Global Const EM_SETRECT = WM_USER + 3
Global Const EM_SETRECTNP = WM_USER + 4
Global Const EM_SCROLL = WM_USER + 5
Global Const EM_LINESCROLL = WM_USER + 6
Global Const EM_GETMODIFY = WM_USER + 8
Global Const EM_SETMODIFY = WM_USER + 9
Global Const EM_GETLINECOUNT = WM_USER + 10
Global Const EM_LINEINDEX = WM_USER + 11
Global Const EM_SETHANDLE = WM_USER + 12
Global Const EM_GETHANDLE = WM_USER + 13
Global Const EM_GETTHUMB = WM_USER + 14
Global Const EM_LINELENGTH = WM_USER + 17
Global Const EM_REPLACESEL = WM_USER + 18
Global Const EM_SETFONT = WM_USER + 19
Global Const EM_GETLINE = WM_USER + 20
Global Const EM_LIMITTEXT = WM_USER + 21
Global Const EM_CANUNDO = WM_USER + 22
Global Const EM_UNDO = WM_USER + 23
Global Const EM_FMTLINES = WM_USER + 24
Global Const EM_LINEFROMCHAR = WM_USER + 25
Global Const EM_SETWORDBREAK = WM_USER + 26
Global Const EM_SETTABSTOPS = WM_USER + 27
Global Const EM_SETPASSWORDCHAR = WM_USER + 28
Global Const EM_EMPTYUNDOBUFFER = WM_USER + 29
Global Const EM_MSGMAX = WM_USER + 30

Declare Function IsClipboardFormatAvailable Lib "User" (ByVal wFormat As Integer) As Integer

' Predefined Clipboard Formats
Global Const CF_TEXT = 1
Global Const CF_BITMAP = 2
Global Const CF_METAFILEPICT = 3
Global Const CF_SYLK = 4
Global Const CF_DIF = 5
Global Const CF_TIFF = 6
Global Const CF_OEMTEXT = 7
Global Const CF_DIB = 8
Global Const CF_PALETTE = 9

Global Const CF_OWNERDISPLAY = &H80
Global Const CF_DSPTEXT = &H81
Global Const CF_DSPBITMAP = &H82
Global Const CF_DSPMETAFILEPICT = &H83


Global Const WM_CUT = &H300
Global Const WM_COPY = &H301
Global Const WM_PASTE = &H302
Global Const WM_CLEAR = &H303
Global Const WM_UNDO = &H304
Global Const WM_RENDERFORMAT = &H305
Global Const WM_RENDERALLFORMATS = &H306
Global Const WM_DESTROYCLIPBOARD = &H307
Global Const WM_DRAWCLIPBOARD = &H308
Global Const WM_PAINTCLIPBOARD = &H309
Global Const WM_VSCROLLCLIPBOARD = &H30A
Global Const WM_SIZECLIPBOARD = &H30B
Global Const WM_ASKCBFORMATNAME = &H30C
Global Const WM_CHANGECBCHAIN = &H30D
Global Const WM_HSCROLLCLIPBOARD = &H30E
Global Const WM_QUERYNEWPALETTE = &H30F
Global Const WM_PALETTEISCHANGING = &H310
Global Const WM_PALETTECHANGED = &H311

Global Const WM_SETTEXT = &HC
Global Const WM_GETTEXT = &HD

Global Const GWW_HWNDPARENT = (-8)
Global Const EM_SETREADONLY = (WM_USER + 31)

' Window Styles
Global Const WS_OVERLAPPED = &H0&
Global Const WS_POPUP = &H80000000
Global Const WS_CHILD = &H40000000
Global Const WS_MINIMIZE = &H20000000
Global Const WS_VISIBLE = &H10000000
Global Const WS_DISABLED = &H8000000
Global Const WS_CLIPSIBLINGS = &H4000000
Global Const WS_CLIPCHILDREN = &H2000000
Global Const WS_MAXIMIZE = &H1000000
Global Const WS_CAPTION = &HC00000      '  WS_BORDER Or WS_DLGFRAME
Global Const WS_BORDER = &H800000
Global Const WS_DLGFRAME = &H400000
Global Const WS_VSCROLL = &H200000
Global Const WS_HSCROLL = &H100000
Global Const WS_SYSMENU = &H80000
Global Const WS_THICKFRAME = &H40000
Global Const WS_GROUP = &H20000
Global Const WS_TABSTOP = &H10000

Global Const WS_MINIMIZEBOX = &H20000
Global Const WS_MAXIMIZEBOX = &H10000

Global Const WS_TILED = WS_OVERLAPPED
Global Const WS_ICONIC = WS_MINIMIZE
Global Const WS_SIZEBOX = WS_THICKFRAME

' Edit Control Styles
Global Const ES_LEFT = &H0&
Global Const ES_CENTER = &H1&
Global Const ES_RIGHT = &H2&
Global Const ES_MULTILINE = &H4&
Global Const ES_UPPERCASE = &H8&
Global Const ES_LOWERCASE = &H10&
Global Const ES_PASSWORD = &H20&
Global Const ES_AUTOVSCROLL = &H40&
Global Const ES_AUTOHSCROLL = &H80&
Global Const ES_NOHIDESEL = &H100&
Global Const ES_OEMCONVERT = &H400&


Declare Sub hmemcpy Lib "Kernel" (lpDest As Any, lpSource As Any, ByVal dwBytes As Long)
Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer

Global Const GMEM_MOVEABLE = &H2
Global Const GMEM_ZEROINIT = &H40
Global Const GHND = (GMEM_MOVEABLE Or GMEM_ZEROINIT)

' Commands to pass WinHelp()
Global Const HELP_CONTEXT = &H1 '  Display topic in ulTopic
Global Const HELP_QUIT = &H2    '  Terminate help
Global Const HELP_INDEX = &H3   '  Display index
Global Const HELP_HELPONHELP = &H4      '  Display help on using help
Global Const HELP_SETINDEX = &H5        '  Set the current Index for multi index help
Global Const HELP_KEY = &H101           '  Display topic for keyword in offabData
Global Const HELP_MULTIKEY = &H201
Global Const HELP_PARTIALKEY = &H105 ' Display topic found in keyword list
Global Const HELP_CONTENTS = &H3     ' Display Help for a particular topic

Sub gethilobyte (wParam As Integer, LOBYTE As Integer, HIBYTE As Integer)
      ' This is the LOBYTE of the wParam:
      LOBYTE = wParam And &HFF&
      ' This is the HIBYTE of the wParam:
      HIBYTE = wParam \ &H100 And &HFF&
End Sub

Sub gethiloword (lParam As Long, LOWORD As Long, HIWORD As Long)
      ' This is the LOWORD of the lParam:
      LOWORD = lParam And &HFFFF&
      ' LOWORD now equals 65,535 or &HFFFF
      ' This is the HIWORD of the lParam:
      HIWORD = lParam \ &H10000 And &HFFFF&
      ' HIWORD now equals 30,583 or &H7777
End Sub

Function MemAddr (S1 As String) As Long
     MemAddr = Lstrcpy(ByVal S1, ByVal S1)
End Function

